/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.spi.register.DataChangeEvent;
import org.apache.dolphinscheduler.spi.register.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterRegistryDataListener
implements SubscribeListener {
    private static final Logger logger = LoggerFactory.getLogger(MasterRegistryDataListener.class);
    private MasterRegistryClient masterRegistryClient = (MasterRegistryClient)SpringApplicationContext.getBean(MasterRegistryClient.class);

    public void notify(String path, String data, DataChangeEvent event) {
        if (path.startsWith("/nodes/master/")) {
            this.handleMasterEvent(event, path);
        } else if (path.startsWith("/nodes/worker/")) {
            this.handleWorkerEvent(event, path);
        }
    }

    public void handleMasterEvent(DataChangeEvent event, String path) {
        switch (event) {
            case ADD: {
                logger.info("master node added : {}", (Object)path);
                break;
            }
            case REMOVE: {
                this.masterRegistryClient.removeNodePath(path, NodeType.MASTER, true);
                break;
            }
        }
    }

    public void handleWorkerEvent(DataChangeEvent event, String path) {
        switch (event) {
            case ADD: {
                logger.info("worker node added : {}", (Object)path);
                break;
            }
            case REMOVE: {
                logger.info("worker node deleted : {}", (Object)path);
                this.masterRegistryClient.removeNodePath(path, NodeType.WORKER, true);
                break;
            }
        }
    }
}

