/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.registry;

import java.util.Set;
import org.apache.dolphinscheduler.common.utils.HeartBeat;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(HeartBeatTask.class);
    private Set<String> heartBeatPaths;
    private RegistryClient registryClient;
    private WorkerManagerThread workerManagerThread;
    private String serverType;
    private HeartBeat heartBeat;

    public HeartBeatTask(long startupTime, double maxCpuloadAvg, double reservedMemory, Set<String> heartBeatPaths, String serverType, RegistryClient registryClient) {
        this.heartBeatPaths = heartBeatPaths;
        this.registryClient = registryClient;
        this.serverType = serverType;
        this.heartBeat = new HeartBeat(startupTime, maxCpuloadAvg, reservedMemory);
    }

    public HeartBeatTask(long startupTime, double maxCpuloadAvg, double reservedMemory, int hostWeight, Set<String> heartBeatPaths, String serverType, RegistryClient registryClient, int workerThreadCount, WorkerManagerThread workerManagerThread) {
        this.heartBeatPaths = heartBeatPaths;
        this.registryClient = registryClient;
        this.workerManagerThread = workerManagerThread;
        this.serverType = serverType;
        this.heartBeat = new HeartBeat(startupTime, maxCpuloadAvg, reservedMemory, hostWeight, workerThreadCount);
    }

    public String getHeartBeatInfo() {
        return this.heartBeat.encodeHeartBeat();
    }

    @Override
    public void run() {
        try {
            for (String heartBeatPath : this.heartBeatPaths) {
                if (!this.registryClient.checkIsDeadServer(heartBeatPath, this.serverType)) continue;
                this.registryClient.getStoppable().stop("i was judged to death, release resources and stop myself");
                return;
            }
            if (this.workerManagerThread != null) {
                this.heartBeat.setWorkerWaitingTaskCount(this.workerManagerThread.getThreadPoolQueueSize());
            }
            for (String heartBeatPath : this.heartBeatPaths) {
                this.registryClient.update(heartBeatPath, this.heartBeat.encodeHeartBeat());
            }
        }
        catch (Throwable ex) {
            this.logger.error("error write heartbeat info", ex);
        }
    }
}

