/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.service.queue.MasterPriorityQueue;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerNodeManager
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ServerNodeManager.class);
    private final Lock masterLock = new ReentrantLock();
    private final Lock workerGroupLock = new ReentrantLock();
    private final Lock workerNodeInfoLock = new ReentrantLock();
    private final ConcurrentHashMap<String, Set<String>> workerGroupNodes = new ConcurrentHashMap();
    private final Set<String> masterNodes = new HashSet<String>();
    private final Map<String, String> workerNodeInfo = new HashMap<String, String>();
    private ScheduledExecutorService executorService;
    @Autowired
    private RegistryClient registryClient;
    private static final int WORKER_LISTENER_CHECK_LENGTH = 5;
    @Autowired
    private WorkerGroupMapper workerGroupMapper;
    private MasterPriorityQueue masterPriorityQueue = new MasterPriorityQueue();
    @Autowired
    private AlertDao alertDao;
    public static volatile List<Integer> SLOT_LIST = new ArrayList<Integer>();
    public static volatile Integer MASTER_SIZE = 0;

    public static Integer getSlot() {
        if (SLOT_LIST.size() > 0) {
            return SLOT_LIST.get(0);
        }
        return 0;
    }

    public void afterPropertiesSet() throws Exception {
        this.load();
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ServerNodeManagerExecutor"));
        this.executorService.scheduleWithFixedDelay(new WorkerNodeInfoAndGroupDbSyncTask(), 0L, 10L, TimeUnit.SECONDS);
        this.registryClient.subscribe("/nodes/master", (SubscribeListener)new MasterDataListener());
        this.registryClient.subscribe("/nodes/worker", (SubscribeListener)new WorkerDataListener());
    }

    public void load() {
        this.updateMasterNodes();
        Collection workerGroups = this.registryClient.getWorkerGroupDirectly();
        for (String workerGroup : workerGroups) {
            this.syncWorkerGroupNodes(workerGroup, this.registryClient.getWorkerGroupNodesDirectly(workerGroup));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMasterNodes() {
        SLOT_LIST.clear();
        this.masterNodes.clear();
        String nodeLock = "/lock/masters";
        try {
            this.registryClient.getLock(nodeLock);
            Collection currentNodes = this.registryClient.getMasterNodesDirectly();
            List masterNodes = this.registryClient.getServerList(NodeType.MASTER);
            this.syncMasterNodes(currentNodes, masterNodes);
        }
        catch (Exception e) {
            this.logger.error("update master nodes error", (Throwable)e);
        }
        finally {
            this.registryClient.releaseLock(nodeLock);
        }
    }

    public Set<String> getMasterNodes() {
        this.masterLock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.masterNodes);
            return set;
        }
        finally {
            this.masterLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMasterNodes(Collection<String> nodes, List<Server> masterNodes) {
        this.masterLock.lock();
        try {
            this.masterNodes.addAll(nodes);
            this.masterPriorityQueue.clear();
            this.masterPriorityQueue.putList(masterNodes);
            int index = this.masterPriorityQueue.getIndex(NetUtils.getHost());
            if (index >= 0) {
                MASTER_SIZE = nodes.size();
                SLOT_LIST.add(this.masterPriorityQueue.getIndex(NetUtils.getHost()));
            }
            this.logger.info("update master nodes, master size: {}, slot: {}", (Object)MASTER_SIZE, (Object)SLOT_LIST.toString());
        }
        finally {
            this.masterLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWorkerGroupNodes(String workerGroup, Collection<String> nodes) {
        this.workerGroupLock.lock();
        try {
            workerGroup = workerGroup.toLowerCase();
            Set workerNodes = this.workerGroupNodes.getOrDefault(workerGroup, new HashSet());
            workerNodes.clear();
            workerNodes.addAll(nodes);
            this.workerGroupNodes.put(workerGroup, workerNodes);
        }
        finally {
            this.workerGroupLock.unlock();
        }
    }

    public Map<String, Set<String>> getWorkerGroupNodes() {
        return Collections.unmodifiableMap(this.workerGroupNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWorkerGroupNodes(String workerGroup) {
        this.workerGroupLock.lock();
        try {
            Set<String> nodes;
            if (StringUtils.isEmpty((String)workerGroup)) {
                workerGroup = "default";
            }
            if (CollectionUtils.isNotEmpty(nodes = this.workerGroupNodes.get(workerGroup = workerGroup.toLowerCase()))) {
                Set<String> set = Collections.unmodifiableSet(nodes);
                return set;
            }
            Set<String> set = nodes;
            return set;
        }
        finally {
            this.workerGroupLock.unlock();
        }
    }

    public Map<String, String> getWorkerNodeInfo() {
        return Collections.unmodifiableMap(this.workerNodeInfo);
    }

    public String getWorkerNodeInfo(String workerNode) {
        this.workerNodeInfoLock.lock();
        try {
            String string = this.workerNodeInfo.getOrDefault(workerNode, null);
            return string;
        }
        finally {
            this.workerNodeInfoLock.unlock();
        }
    }

    private void syncAllWorkerNodeInfo(Map<String, String> newWorkerNodeInfo) {
        this.workerNodeInfoLock.lock();
        try {
            this.workerNodeInfo.clear();
            this.workerNodeInfo.putAll(newWorkerNodeInfo);
        }
        finally {
            this.workerNodeInfoLock.unlock();
        }
    }

    private void syncSingleWorkerNodeInfo(String node, String info) {
        this.workerNodeInfoLock.lock();
        try {
            this.workerNodeInfo.put(node, info);
        }
        finally {
            this.workerNodeInfoLock.unlock();
        }
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdownNow();
    }

    class MasterDataListener
    implements SubscribeListener {
        MasterDataListener() {
        }

        public void notify(Event event) {
            String path = event.path();
            Event.Type type = event.type();
            if (ServerNodeManager.this.registryClient.isMasterPath(path)) {
                try {
                    if (type.equals((Object)Event.Type.ADD)) {
                        ServerNodeManager.this.logger.info("master node : {} added.", (Object)path);
                        ServerNodeManager.this.updateMasterNodes();
                    }
                    if (type.equals((Object)Event.Type.REMOVE)) {
                        ServerNodeManager.this.logger.info("master node : {} down.", (Object)path);
                        ServerNodeManager.this.updateMasterNodes();
                        ServerNodeManager.this.alertDao.sendServerStopedAlert(1, path, "MASTER");
                    }
                }
                catch (Exception ex) {
                    ServerNodeManager.this.logger.error("MasterNodeListener capture data change and get data failed.", (Throwable)ex);
                }
            }
        }
    }

    class WorkerDataListener
    implements SubscribeListener {
        WorkerDataListener() {
        }

        public void notify(Event event) {
            String path = event.path();
            Event.Type type = event.type();
            String data = event.data();
            if (ServerNodeManager.this.registryClient.isWorkerPath(path)) {
                try {
                    if (type == Event.Type.ADD) {
                        ServerNodeManager.this.logger.info("worker group node : {} added.", (Object)path);
                        String group = this.parseGroup(path);
                        Collection currentNodes = ServerNodeManager.this.registryClient.getWorkerGroupNodesDirectly(group);
                        ServerNodeManager.this.logger.info("currentNodes : {}", (Object)currentNodes);
                        ServerNodeManager.this.syncWorkerGroupNodes(group, currentNodes);
                    } else if (type == Event.Type.REMOVE) {
                        ServerNodeManager.this.logger.info("worker group node : {} down.", (Object)path);
                        String group = this.parseGroup(path);
                        Collection currentNodes = ServerNodeManager.this.registryClient.getWorkerGroupNodesDirectly(group);
                        ServerNodeManager.this.syncWorkerGroupNodes(group, currentNodes);
                        ServerNodeManager.this.alertDao.sendServerStopedAlert(1, path, "WORKER");
                    } else if (type == Event.Type.UPDATE) {
                        ServerNodeManager.this.logger.debug("worker group node : {} update, data: {}", (Object)path, (Object)data);
                        String group = this.parseGroup(path);
                        Collection currentNodes = ServerNodeManager.this.registryClient.getWorkerGroupNodesDirectly(group);
                        ServerNodeManager.this.syncWorkerGroupNodes(group, currentNodes);
                        String node = this.parseNode(path);
                        ServerNodeManager.this.syncSingleWorkerNodeInfo(node, data);
                    }
                }
                catch (IllegalArgumentException ex) {
                    ServerNodeManager.this.logger.warn(ex.getMessage());
                }
                catch (Exception ex) {
                    ServerNodeManager.this.logger.error("WorkerGroupListener capture data change and get data failed", (Throwable)ex);
                }
            }
        }

        private String parseGroup(String path) {
            String[] parts = path.split("/");
            if (parts.length < 5) {
                throw new IllegalArgumentException(String.format("worker group path : %s is not valid, ignore", path));
            }
            return parts[parts.length - 2];
        }

        private String parseNode(String path) {
            String[] parts = path.split("/");
            if (parts.length < 5) {
                throw new IllegalArgumentException(String.format("worker group path : %s is not valid, ignore", path));
            }
            return parts[parts.length - 1];
        }
    }

    class WorkerNodeInfoAndGroupDbSyncTask
    implements Runnable {
        WorkerNodeInfoAndGroupDbSyncTask() {
        }

        @Override
        public void run() {
            Map newWorkerNodeInfo = ServerNodeManager.this.registryClient.getServerMaps(NodeType.WORKER, true);
            ServerNodeManager.this.syncAllWorkerNodeInfo(newWorkerNodeInfo);
            List workerGroupList = ServerNodeManager.this.workerGroupMapper.queryAllWorkerGroup();
            if (CollectionUtils.isNotEmpty((Collection)workerGroupList)) {
                for (WorkerGroup wg : workerGroupList) {
                    String[] addrs;
                    String workerGroup = wg.getName();
                    HashSet<String> nodes = new HashSet<String>();
                    for (String addr : addrs = wg.getAddrList().split(",")) {
                        if (!newWorkerNodeInfo.containsKey(addr)) continue;
                        nodes.add(addr);
                    }
                    if (nodes.isEmpty()) continue;
                    ServerNodeManager.this.syncWorkerGroupNodes(workerGroup, nodes);
                }
            }
        }
    }
}

