/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.plugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.apache.dolphinscheduler.spi.task.TaskChannel;
import org.apache.dolphinscheduler.spi.task.TaskChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskPluginManager.class);
    private final Map<String, TaskChannel> taskChannelMap = new ConcurrentHashMap<String, TaskChannel>();
    private final PluginDao pluginDao;

    public TaskPluginManager(PluginDao pluginDao) {
        this.pluginDao = pluginDao;
    }

    private void loadTaskChannel(TaskChannelFactory taskChannelFactory) {
        TaskChannel taskChannel = taskChannelFactory.create();
        this.taskChannelMap.put(taskChannelFactory.getName(), taskChannel);
    }

    public Map<String, TaskChannel> getTaskChannelMap() {
        return Collections.unmodifiableMap(this.taskChannelMap);
    }

    @PostConstruct
    public void installPlugin() {
        HashSet names = new HashSet();
        ServiceLoader.load(TaskChannelFactory.class).forEach(factory -> {
            String name = factory.getName();
            logger.info("Registering task plugin: {}", (Object)name);
            if (!names.add(name)) {
                throw new IllegalStateException(String.format("Duplicate task plugins named '%s'", name));
            }
            this.loadTaskChannel((TaskChannelFactory)factory);
            logger.info("Registered task plugin: {}", (Object)name);
            List params = factory.getParams();
            String paramsJson = PluginParamsTransfer.transferParamsToJson((List)params);
            PluginDefine pluginDefine = new PluginDefine(name, PluginType.TASK.getDesc(), paramsJson);
            int count = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            if (count <= 0) {
                throw new RuntimeException("Failed to update task plugin: " + name);
            }
        });
        this.taskChannelMap.put(TaskType.WATERDROP.getDesc(), this.taskChannelMap.get(TaskType.SHELL.getDesc()));
    }
}

