/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.SqoopJobType;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.datax.DataxParameters;
import org.apache.dolphinscheduler.common.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.common.task.sql.SqlParameters;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceMysqlParameter;
import org.apache.dolphinscheduler.common.task.sqoop.targets.TargetMysqlParameter;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.TaskParametersUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.server.builder.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.apache.dolphinscheduler.spi.task.request.DataxTaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.request.ProcedureTaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.request.SQLTaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.request.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.request.UdfFuncRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskProcessor
implements ITaskProcessor {
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("TaskLogLogger", this.getClass()));
    protected boolean killed = false;
    protected boolean paused = false;
    protected boolean timeout = false;
    protected TaskInstance taskInstance = null;
    protected ProcessInstance processInstance;
    protected ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);

    protected abstract boolean pauseTask();

    protected abstract boolean killTask();

    protected abstract boolean taskTimeout();

    @Override
    public void run() {
    }

    @Override
    public boolean action(TaskAction taskAction) {
        switch (taskAction) {
            case STOP: {
                return this.stop();
            }
            case PAUSE: {
                return this.pause();
            }
            case TIMEOUT: {
                return this.timeout();
            }
        }
        this.logger.error("unknown task action: {}", (Object)taskAction.toString());
        return false;
    }

    protected boolean timeout() {
        if (this.timeout) {
            return true;
        }
        this.timeout = this.taskTimeout();
        return this.timeout;
    }

    protected boolean pause() {
        if (this.paused) {
            return true;
        }
        this.paused = this.pauseTask();
        return this.paused;
    }

    protected boolean stop() {
        if (this.killed) {
            return true;
        }
        this.killed = this.killTask();
        return this.killed;
    }

    @Override
    public String getType() {
        return null;
    }

    protected TaskExecutionContext getTaskExecutionContext(TaskInstance taskInstance) {
        this.processService.setTaskInstanceDetail(taskInstance);
        int userId = taskInstance.getProcessDefine() == null ? 0 : taskInstance.getProcessDefine().getUserId();
        Tenant tenant = this.processService.getTenantForProcess(taskInstance.getProcessInstance().getTenantId(), userId);
        if (this.verifyTenantIsNull(tenant, taskInstance)) {
            this.processService.changeTaskState(taskInstance, ExecutionStatus.FAILURE, taskInstance.getStartTime(), taskInstance.getHost(), null, null, taskInstance.getId());
            return null;
        }
        String userQueue = this.processService.queryUserQueueByProcessInstanceId(taskInstance.getProcessInstanceId());
        taskInstance.getProcessInstance().setQueue(StringUtils.isEmpty((String)userQueue) ? tenant.getQueue() : userQueue);
        taskInstance.getProcessInstance().setTenantCode(tenant.getTenantCode());
        taskInstance.setResources(this.getResourceFullNames(taskInstance));
        SQLTaskExecutionContext sqlTaskExecutionContext = new SQLTaskExecutionContext();
        DataxTaskExecutionContext dataxTaskExecutionContext = new DataxTaskExecutionContext();
        ProcedureTaskExecutionContext procedureTaskExecutionContext = new ProcedureTaskExecutionContext();
        SqoopTaskExecutionContext sqoopTaskExecutionContext = new SqoopTaskExecutionContext();
        if (TaskType.SQL.getDesc().equalsIgnoreCase(taskInstance.getTaskType())) {
            this.setSQLTaskRelation(sqlTaskExecutionContext, taskInstance);
        }
        if (TaskType.DATAX.getDesc().equalsIgnoreCase(taskInstance.getTaskType())) {
            this.setDataxTaskRelation(dataxTaskExecutionContext, taskInstance);
        }
        if (TaskType.PROCEDURE.getDesc().equalsIgnoreCase(taskInstance.getTaskType())) {
            this.setProcedureTaskRelation(procedureTaskExecutionContext, taskInstance);
        }
        if (TaskType.SQOOP.getDesc().equalsIgnoreCase(taskInstance.getTaskType())) {
            this.setSqoopTaskRelation(sqoopTaskExecutionContext, taskInstance);
        }
        return TaskExecutionContextBuilder.get().buildTaskInstanceRelatedInfo(taskInstance).buildTaskDefinitionRelatedInfo(taskInstance.getTaskDefine()).buildProcessInstanceRelatedInfo(taskInstance.getProcessInstance()).buildProcessDefinitionRelatedInfo(taskInstance.getProcessDefine()).buildSQLTaskRelatedInfo(sqlTaskExecutionContext).buildDataxTaskRelatedInfo(dataxTaskExecutionContext).buildProcedureTaskRelatedInfo(procedureTaskExecutionContext).buildSqoopTaskRelatedInfo(sqoopTaskExecutionContext).create();
    }

    private void setProcedureTaskRelation(ProcedureTaskExecutionContext procedureTaskExecutionContext, TaskInstance taskInstance) {
        ProcedureParameters procedureParameters = (ProcedureParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), ProcedureParameters.class);
        int datasourceId = procedureParameters.getDatasource();
        DataSource datasource = this.processService.findDataSourceById(datasourceId);
        procedureTaskExecutionContext.setConnectionParams(datasource.getConnectionParams());
    }

    protected void setDataxTaskRelation(DataxTaskExecutionContext dataxTaskExecutionContext, TaskInstance taskInstance) {
        DataxParameters dataxParameters = (DataxParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), DataxParameters.class);
        DataSource dbSource = this.processService.findDataSourceById(dataxParameters.getDataSource());
        DataSource dbTarget = this.processService.findDataSourceById(dataxParameters.getDataTarget());
        if (dbSource != null) {
            dataxTaskExecutionContext.setDataSourceId(dataxParameters.getDataSource());
            dataxTaskExecutionContext.setSourcetype(dbSource.getType().getCode());
            dataxTaskExecutionContext.setSourceConnectionParams(dbSource.getConnectionParams());
        }
        if (dbTarget != null) {
            dataxTaskExecutionContext.setDataTargetId(dataxParameters.getDataTarget());
            dataxTaskExecutionContext.setTargetType(dbTarget.getType().getCode());
            dataxTaskExecutionContext.setTargetConnectionParams(dbTarget.getConnectionParams());
        }
    }

    private void setSqoopTaskRelation(SqoopTaskExecutionContext sqoopTaskExecutionContext, TaskInstance taskInstance) {
        SqoopParameters sqoopParameters = (SqoopParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), SqoopParameters.class);
        if (sqoopParameters.getJobType().equals(SqoopJobType.TEMPLATE.getDescp())) {
            SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceMysqlParameter.class);
            TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetMysqlParameter.class);
            DataSource dataSource = this.processService.findDataSourceById(sourceMysqlParameter.getSrcDatasource());
            DataSource dataTarget = this.processService.findDataSourceById(targetMysqlParameter.getTargetDatasource());
            if (dataSource != null) {
                sqoopTaskExecutionContext.setDataSourceId(dataSource.getId());
                sqoopTaskExecutionContext.setSourcetype(dataSource.getType().getCode());
                sqoopTaskExecutionContext.setSourceConnectionParams(dataSource.getConnectionParams());
            }
            if (dataTarget != null) {
                sqoopTaskExecutionContext.setDataTargetId(dataTarget.getId());
                sqoopTaskExecutionContext.setTargetType(dataTarget.getType().getCode());
                sqoopTaskExecutionContext.setTargetConnectionParams(dataTarget.getConnectionParams());
            }
        }
    }

    private void setSQLTaskRelation(SQLTaskExecutionContext sqlTaskExecutionContext, TaskInstance taskInstance) {
        boolean udfTypeFlag;
        SqlParameters sqlParameters = (SqlParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), SqlParameters.class);
        int datasourceId = sqlParameters.getDatasource();
        DataSource datasource = this.processService.findDataSourceById(datasourceId);
        sqlTaskExecutionContext.setConnectionParams(datasource.getConnectionParams());
        sqlTaskExecutionContext.setDefaultFS(HadoopUtils.getInstance().getDefaultFS());
        boolean bl = udfTypeFlag = Enums.getIfPresent(UdfType.class, (String)Strings.nullToEmpty((String)sqlParameters.getType())).isPresent() && !StringUtils.isEmpty((String)sqlParameters.getUdfs());
        if (udfTypeFlag) {
            String[] udfFunIds = sqlParameters.getUdfs().split(",");
            int[] udfFunIdsArray = new int[udfFunIds.length];
            for (int i = 0; i < udfFunIds.length; ++i) {
                udfFunIdsArray[i] = Integer.parseInt(udfFunIds[i]);
            }
            List udfFuncList = this.processService.queryUdfFunListByIds(udfFunIdsArray);
            HashMap<UdfFuncRequest, String> udfFuncRequestMap = new HashMap<UdfFuncRequest, String>();
            for (UdfFunc udfFunc : udfFuncList) {
                UdfFuncRequest udfFuncRequest = (UdfFuncRequest)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)udfFunc), UdfFuncRequest.class);
                String tenantCode = this.processService.queryTenantCodeByResName(udfFunc.getResourceName(), ResourceType.UDF);
                udfFuncRequestMap.put(udfFuncRequest, tenantCode);
            }
            sqlTaskExecutionContext.setUdfFuncTenantCodeMap(udfFuncRequestMap);
        }
    }

    protected boolean verifyTenantIsNull(Tenant tenant, TaskInstance taskInstance) {
        if (tenant == null) {
            this.logger.error("tenant not exists,process instance id : {},task instance id : {}", (Object)taskInstance.getProcessInstance().getId(), (Object)taskInstance.getId());
            return true;
        }
        return false;
    }

    protected Map<String, String> getResourceFullNames(TaskInstance taskInstance) {
        List projectResourceFiles;
        HashMap<String, String> resourcesMap = new HashMap<String, String>();
        AbstractParameters baseParam = TaskParametersUtils.getParameters((String)taskInstance.getTaskType(), (String)taskInstance.getTaskParams());
        if (baseParam != null && CollectionUtils.isNotEmpty((Collection)(projectResourceFiles = baseParam.getResourceFilesList()))) {
            Stream<Integer> resourceIdStream;
            Set<Integer> resourceIdsSet;
            Set<ResourceInfo> oldVersionResources = projectResourceFiles.stream().filter(t -> t.getId() == 0).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(oldVersionResources)) {
                oldVersionResources.forEach(t -> resourcesMap.put(t.getRes(), this.processService.queryTenantCodeByResName(t.getRes(), ResourceType.FILE)));
            }
            if (CollectionUtils.isNotEmpty(resourceIdsSet = (resourceIdStream = projectResourceFiles.stream().map(ResourceInfo::getId)).collect(Collectors.toSet()))) {
                Integer[] resourceIds = resourceIdsSet.toArray(new Integer[resourceIdsSet.size()]);
                List resources = this.processService.listResourceByIds(resourceIds);
                resources.forEach(t -> resourcesMap.put(t.getFullName(), this.processService.queryTenantCodeByResName(t.getFullName(), ResourceType.FILE)));
            }
        }
        return resourcesMap;
    }
}

