/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.dolphinscheduler.server.log.TaskLogDiscriminator;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private LogUtils() throws IllegalStateException {
        throw new IllegalStateException("Utility class");
    }

    public static String getTaskLogPath(Long processDefineCode, int processDefineVersion, int processInstanceId, int taskInstanceId) {
        return Optional.of(LoggerFactory.getILoggerFactory()).map(e -> (AppenderAttachable)e.getLogger("ROOT")).map(e -> (SiftingAppender)e.getAppender("TASKLOGFILE")).map(e -> (TaskLogDiscriminator)e.getDiscriminator()).map(TaskLogDiscriminator::getLogBase).map(e -> Paths.get(e, new String[0]).toAbsolutePath().resolve(processDefineCode + "_" + processDefineVersion).resolve(String.valueOf(processInstanceId)).resolve(taskInstanceId + ".log")).map(Path::toString).orElse("");
    }

    public static String getTaskLogPath(TaskExecutionContext taskExecutionContext) {
        return LogUtils.getTaskLogPath(taskExecutionContext.getProcessDefineCode(), taskExecutionContext.getProcessDefineVersion(), taskExecutionContext.getProcessInstanceId(), taskExecutionContext.getTaskInstanceId());
    }
}

