/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.processor.CacheProcessor;
import org.apache.dolphinscheduler.server.master.processor.StateEventProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskAckProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskKillResponseProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskResponseProcessor;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.server.master.runner.EventExecuteService;
import org.apache.dolphinscheduler.server.master.runner.FailoverExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.MasterSchedulerService;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutors;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.event.EventListener;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@ComponentScan(value={"org.apache.dolphinscheduler"}, excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"org.apache.dolphinscheduler.server.worker.*", "org.apache.dolphinscheduler.server.monitor.*", "org.apache.dolphinscheduler.server.log.*", "org.apache.dolphinscheduler.alert.*"})})
@EnableTransactionManagement
@EnableCaching
public class MasterServer
implements IStoppable {
    private static final Logger logger = LoggerFactory.getLogger(MasterServer.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private SpringApplicationContext springApplicationContext;
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private MasterSchedulerService masterSchedulerService;
    @Autowired
    private EventExecuteService eventExecuteService;
    @Autowired
    private FailoverExecuteThread failoverExecuteThread;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps = new ConcurrentHashMap();

    public static void main(String[] args) {
        Thread.currentThread().setName("Master-Server");
        new SpringApplicationBuilder(new Class[]{MasterServer.class}).web(WebApplicationType.NONE).run(args);
    }

    @EventListener
    public void run(ApplicationReadyEvent ignored) {
        PropertyUtils.setValue((String)"spring.datasource.driver-class-name", (String)this.driverClassName);
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.masterConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        TaskAckProcessor ackProcessor = new TaskAckProcessor();
        ackProcessor.init(this.processInstanceExecMaps);
        TaskResponseProcessor taskResponseProcessor = new TaskResponseProcessor();
        taskResponseProcessor.init(this.processInstanceExecMaps);
        TaskKillResponseProcessor taskKillResponseProcessor = new TaskKillResponseProcessor();
        taskKillResponseProcessor.init(this.processInstanceExecMaps);
        StateEventProcessor stateEventProcessor = new StateEventProcessor();
        stateEventProcessor.init(this.processInstanceExecMaps);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RESPONSE, (NettyRequestProcessor)taskResponseProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_ACK, (NettyRequestProcessor)ackProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_RESPONSE, (NettyRequestProcessor)taskKillResponseProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.STATE_EVENT_REQUEST, (NettyRequestProcessor)stateEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.CACHE_EXPIRE, (NettyRequestProcessor)new CacheProcessor());
        this.nettyRemotingServer.start();
        this.masterRegistryClient.init(this.processInstanceExecMaps);
        this.masterRegistryClient.setRegistryStoppable(this);
        this.masterRegistryClient.start();
        this.eventExecuteService.init(this.processInstanceExecMaps);
        this.eventExecuteService.start();
        this.masterSchedulerService.init(this.processInstanceExecMaps);
        this.masterSchedulerService.start();
        this.failoverExecuteThread.start();
        try {
            logger.info("start Quartz server...");
            QuartzExecutors.getInstance().start();
        }
        catch (Exception e) {
            try {
                QuartzExecutors.getInstance().shutdown();
            }
            catch (SchedulerException e1) {
                logger.error("QuartzExecutors shutdown failed : " + e1.getMessage(), (Throwable)e1);
            }
            logger.error("start Quartz failed", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Stopper.isRunning()) {
                this.close("shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        try {
            if (Stopper.isStopped()) {
                return;
            }
            logger.info("master server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception ", (Throwable)e);
            }
            this.masterSchedulerService.close();
            this.nettyRemotingServer.close();
            this.masterRegistryClient.closeRegistry();
            try {
                QuartzExecutors.getInstance().shutdown();
                logger.info("Quartz service stopped");
            }
            catch (Exception e) {
                logger.warn("Quartz service stopped exception:{}", (Object)e.getMessage());
            }
            this.springApplicationContext.close();
            logger.info("springApplicationContext close");
        }
        catch (Exception e) {
            logger.error("master server stop exception ", (Throwable)e);
        }
        finally {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception ", (Throwable)e);
            }
            System.exit(1);
        }
    }

    public void stop(String cause) {
        this.close(cause);
    }
}

