/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.AbstractSelector;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;

public class RandomSelector
extends AbstractSelector<HostWorker> {
    @Override
    public HostWorker doSelect(Collection<HostWorker> source) {
        ArrayList<HostWorker> hosts = new ArrayList<HostWorker>(source);
        int size = hosts.size();
        int[] weights = new int[size];
        int totalWeight = 0;
        int index = 0;
        for (HostWorker host : hosts) {
            totalWeight += host.getHostWeight();
            weights[index] = host.getHostWeight();
            ++index;
        }
        if (totalWeight > 0) {
            int offset = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < size; ++i) {
                if ((offset -= weights[i]) >= 0) continue;
                return (HostWorker)((Object)hosts.get(i));
            }
        }
        return (HostWorker)((Object)hosts.get(ThreadLocalRandom.current().nextInt(size)));
    }
}

