/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterExecService {
    private static final Logger logger = LoggerFactory.getLogger(MasterExecService.class);
    private final ThreadPoolExecutor execService;
    private final ListeningExecutorService listeningExecutorService;
    private final ConcurrentHashMap<Integer, WorkflowExecuteThread> startProcessFailedMap;
    private final ConcurrentHashMap<Integer, WorkflowExecuteThread> filterMap = new ConcurrentHashMap();

    public MasterExecService(ConcurrentHashMap<Integer, WorkflowExecuteThread> startProcessFailedMap, ThreadPoolExecutor execService) {
        this.startProcessFailedMap = startProcessFailedMap;
        this.execService = execService;
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)this.execService);
    }

    public void execute(final WorkflowExecuteThread workflowExecuteThread) {
        if (workflowExecuteThread == null || workflowExecuteThread.getProcessInstance() == null || workflowExecuteThread.isStart() || this.filterMap.containsKey(workflowExecuteThread.getProcessInstance().getId())) {
            return;
        }
        final Integer processInstanceId = workflowExecuteThread.getProcessInstance().getId();
        this.filterMap.put(processInstanceId, workflowExecuteThread);
        ListenableFuture future = this.listeningExecutorService.submit((Runnable)workflowExecuteThread);
        FutureCallback futureCallback = new FutureCallback(){

            public void onSuccess(Object o) {
                if (!workflowExecuteThread.isStart()) {
                    MasterExecService.this.startProcessFailedMap.putIfAbsent(processInstanceId, workflowExecuteThread);
                } else {
                    MasterExecService.this.startProcessFailedMap.remove(processInstanceId);
                }
                MasterExecService.this.filterMap.remove(processInstanceId);
            }

            public void onFailure(Throwable throwable) {
                logger.error("handle events {} failed", (Object)processInstanceId, (Object)throwable);
                if (!workflowExecuteThread.isStart()) {
                    MasterExecService.this.startProcessFailedMap.putIfAbsent(processInstanceId, workflowExecuteThread);
                } else {
                    MasterExecService.this.startProcessFailedMap.remove(processInstanceId);
                }
                MasterExecService.this.filterMap.remove(processInstanceId);
            }
        };
        Futures.addCallback((ListenableFuture)future, (FutureCallback)futureCallback, (Executor)this.listeningExecutorService);
    }

    public void shutdown() {
        this.execService.shutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.execService.awaitTermination(timeout, unit);
    }
}

