/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import java.util.Set;
import org.apache.dolphinscheduler.common.Constants;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"worker.properties"})
public class WorkerConfig {
    @Value(value="${worker.listen.port:1234}")
    private int listenPort;
    @Value(value="${worker.exec.threads:100}")
    private int workerExecThreads;
    @Value(value="${worker.heartbeat.interval:10}")
    private int workerHeartbeatInterval;
    @Value(value="${worker.host.weight:100}")
    private int hostWeight;
    @Value(value="${worker.tenant.auto.create:false}")
    private boolean workerTenantAutoCreate;
    @Value(value="${worker.max.cpuload.avg:-1}")
    private int workerMaxCpuloadAvg;
    @Value(value="${worker.reserved.memory:0.3}")
    private double workerReservedMemory;
    @Value(value="#{'${worker.groups:default}'.split(',')}")
    private Set<String> workerGroups;
    @Value(value="${alert.listen.host:localhost}")
    private String alertListenHost;
    @Value(value="${task.plugin.dir:}")
    private String taskPluginDir;
    @Value(value="${maven.local.repository:}")
    private String mavenLocalRepository;
    @Value(value="${task.plugin.binding:}")
    private String taskPluginBinding;
    @Value(value="${worker.retry.report.task.statues.interval:10}")
    private int retryReportTaskStatusInterval;

    public int getRetryReportTaskStatusInterval() {
        return this.retryReportTaskStatusInterval;
    }

    public void setRetryReportTaskStatusInterval(int retryReportTaskStatusInterval) {
        this.retryReportTaskStatusInterval = retryReportTaskStatusInterval;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public Set<String> getWorkerGroups() {
        return this.workerGroups;
    }

    public void setWorkerGroups(Set<String> workerGroups) {
        this.workerGroups = workerGroups;
    }

    public int getWorkerExecThreads() {
        return this.workerExecThreads;
    }

    public void setWorkerExecThreads(int workerExecThreads) {
        this.workerExecThreads = workerExecThreads;
    }

    public int getWorkerHeartbeatInterval() {
        return this.workerHeartbeatInterval;
    }

    public void setWorkerHeartbeatInterval(int workerHeartbeatInterval) {
        this.workerHeartbeatInterval = workerHeartbeatInterval;
    }

    public boolean getWorkerTenantAutoCreate() {
        return this.workerTenantAutoCreate;
    }

    public void setWorkerTenantAutoCreate(boolean workerTenantAutoCreate) {
        this.workerTenantAutoCreate = workerTenantAutoCreate;
    }

    public double getWorkerReservedMemory() {
        return this.workerReservedMemory;
    }

    public void setWorkerReservedMemory(double workerReservedMemory) {
        this.workerReservedMemory = workerReservedMemory;
    }

    public int getWorkerMaxCpuloadAvg() {
        if (this.workerMaxCpuloadAvg == -1) {
            return Constants.DEFAULT_WORKER_CPU_LOAD;
        }
        return this.workerMaxCpuloadAvg;
    }

    public void setWorkerMaxCpuloadAvg(int workerMaxCpuloadAvg) {
        this.workerMaxCpuloadAvg = workerMaxCpuloadAvg;
    }

    public int getHostWeight() {
        return this.hostWeight;
    }

    public void setHostWeight(int hostWeight) {
        this.hostWeight = hostWeight;
    }

    public String getAlertListenHost() {
        return this.alertListenHost;
    }

    public void setAlertListenHost(String alertListenHost) {
        this.alertListenHost = alertListenHost;
    }

    public String getTaskPluginDir() {
        return this.taskPluginDir;
    }

    public void setTaskPluginDir(String taskPluginDir) {
        this.taskPluginDir = taskPluginDir;
    }

    public String getMavenLocalRepository() {
        return this.mavenLocalRepository;
    }

    public void setMavenLocalRepository(String mavenLocalRepository) {
        this.mavenLocalRepository = mavenLocalRepository;
    }

    public String getTaskPluginBinding() {
        return this.taskPluginBinding;
    }

    public void setTaskPluginBinding(String taskPluginBinding) {
        this.taskPluginBinding = taskPluginBinding;
    }
}

