/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskKillAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.cache.ResponceCache;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.apache.dolphinscheduler.spi.task.TaskExecutionContextCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskKillAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskKillAckProcessor.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_KILL_RESPONSE_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskKillAckCommand taskKillAckCommand = (TaskKillAckCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskKillAckCommand.class);
        if (taskKillAckCommand == null) {
            this.logger.warn("Cannot parse command, command type: {}", (Object)command.getType());
            return;
        }
        this.logger.info("received kill ack command : {}", (Object)taskKillAckCommand);
        if (taskKillAckCommand.getStatus() == ExecutionStatus.SUCCESS.getCode()) {
            ResponceCache.get().removeKillResponseCache(taskKillAckCommand.getTaskInstanceId());
            TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskKillAckCommand.getTaskInstanceId());
            this.logger.info("removeKillResponseCache: task instance id:{}", (Object)taskKillAckCommand.getTaskInstanceId());
            TaskCallbackService.remove(taskKillAckCommand.getTaskInstanceId());
            this.logger.info("remove REMOTE_CHANNELS, task instance id:{}", (Object)taskKillAckCommand.getTaskInstanceId());
        }
    }
}

