/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Pattern MACPATTERN = Pattern.compile("-[+|-]-\\s(\\d+)");
    private static final Pattern WINDOWSATTERN = Pattern.compile("\\w+\\((\\d+)\\)");

    public static void cancelApplication(List<String> appIds, Logger logger, String tenantCode, String executePath) {
        if (appIds == null || appIds.isEmpty()) {
            return;
        }
        for (String appId : appIds) {
            try {
                ExecutionStatus applicationStatus = HadoopUtils.getInstance().getApplicationStatus(appId);
                if (applicationStatus.typeIsFinished()) continue;
                String commandFile = String.format("%s/%s.kill", executePath, appId);
                String cmd = ProcessUtils.getKerberosInitCommand() + "yarn application -kill " + appId;
                ProcessUtils.execYarnKillCommand(logger, tenantCode, appId, commandFile, cmd);
            }
            catch (Exception e) {
                logger.error("Get yarn application app id [{}}] status failed", (Object)appId, (Object)e);
            }
        }
    }

    static String getKerberosInitCommand() {
        logger.info("get kerberos init command");
        StringBuilder kerberosCommandBuilder = new StringBuilder();
        boolean hadoopKerberosState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (boolean)false);
        if (hadoopKerberosState) {
            kerberosCommandBuilder.append("export KRB5_CONFIG=").append(PropertyUtils.getString((String)"java.security.krb5.conf.path")).append("\n\n").append(String.format("kinit -k -t %s %s || true", PropertyUtils.getString((String)"login.user.keytab.path"), PropertyUtils.getString((String)"login.user.keytab.username"))).append("\n\n");
            logger.info("kerberos init command: {}", (Object)kerberosCommandBuilder);
        }
        return kerberosCommandBuilder.toString();
    }

    private static void execYarnKillCommand(Logger logger, String tenantCode, String appId, String commandFile, String cmd) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("#!/bin/sh\n");
            sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
            sb.append("cd $BASEDIR\n");
            if (CommonUtils.getSystemEnvPath() != null) {
                sb.append("source ").append(CommonUtils.getSystemEnvPath()).append("\n");
            }
            sb.append("\n\n");
            sb.append(cmd);
            File f = new File(commandFile);
            if (!f.exists()) {
                FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
            }
            String runCmd = String.format("%s %s", "sh", commandFile);
            runCmd = OSUtils.getSudoCmd((String)tenantCode, (String)runCmd);
            logger.info("kill cmd:{}", (Object)runCmd);
            OSUtils.exeCmd((String)runCmd);
        }
        catch (Exception e) {
            logger.error(String.format("Kill yarn application app id [%s] failed: [%s]", appId, e.getMessage()));
        }
    }

    public static String getPidsStr(int processId) throws Exception {
        String pids;
        List<String> pidList = new ArrayList<String>();
        Matcher mat = null;
        if (SystemUtils.IS_OS_MAC) {
            pids = OSUtils.exeCmd((String)String.format("%s -sp %d", "pstree", processId));
            if (null != pids) {
                mat = MACPATTERN.matcher(pids);
            }
        } else {
            pids = OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId));
            mat = WINDOWSATTERN.matcher(pids);
        }
        if (null != mat) {
            while (mat.find()) {
                pidList.add(mat.group(1));
            }
        }
        if (CommonUtils.isSudoEnable() && !pidList.isEmpty()) {
            pidList = pidList.subList(1, pidList.size());
        }
        return String.join((CharSequence)" ", pidList).trim();
    }

    public static List<String> killYarnJob(TaskExecutionContext taskExecutionContext) {
        try {
            String log;
            Thread.sleep(1000L);
            try (LogClientService logClient = new LogClientService();){
                Host host = Host.of((String)taskExecutionContext.getHost());
                log = logClient.viewLog(host.getIp(), host.getPort(), taskExecutionContext.getLogPath());
            }
            if (!StringUtils.isEmpty((String)log)) {
                if (StringUtils.isEmpty((String)taskExecutionContext.getExecutePath())) {
                    taskExecutionContext.setExecutePath(org.apache.dolphinscheduler.common.utils.FileUtils.getProcessExecDir((long)taskExecutionContext.getProjectCode(), (long)taskExecutionContext.getProcessDefineCode(), (int)taskExecutionContext.getProcessDefineVersion(), (int)taskExecutionContext.getProcessInstanceId(), (int)taskExecutionContext.getTaskInstanceId()));
                }
                org.apache.dolphinscheduler.common.utils.FileUtils.createWorkDirIfAbsent((String)taskExecutionContext.getExecutePath());
                List appIds = LoggerUtils.getAppIds((String)log, (Logger)logger);
                if (CollectionUtils.isNotEmpty((Collection)appIds)) {
                    ProcessUtils.cancelApplication(appIds, logger, taskExecutionContext.getTenantCode(), taskExecutionContext.getExecutePath());
                    return appIds;
                }
            }
        }
        catch (Exception e) {
            logger.error("kill yarn job failure", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

