/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveDataConverter
extends MessageConverter {
    private final Pattern pwdPattern = Pattern.compile("(?<=((?i)password((\":\")|(=')))).*?(?=((\")|(')))");

    public String convert(ILoggingEvent event) {
        String requestLogMsg = event.getFormattedMessage();
        return this.convertMsg(requestLogMsg);
    }

    private String convertMsg(String oriLogMsg) {
        String tempLogMsg = oriLogMsg;
        if (!Strings.isNullOrEmpty((String)tempLogMsg)) {
            tempLogMsg = SensitiveDataConverter.passwordHandler(this.pwdPattern, tempLogMsg);
        }
        return tempLogMsg;
    }

    static String passwordHandler(Pattern pwdPattern, String logMsg) {
        Matcher matcher = pwdPattern.matcher(logMsg);
        StringBuffer sb = new StringBuffer(logMsg.length());
        while (matcher.find()) {
            String password = matcher.group();
            String maskPassword = Strings.repeat((String)"*", (int)password.length());
            matcher.appendReplacement(sb, maskPassword);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

