/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cronutils.model.Cron;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ResourceType;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.model.DateInterval;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.subprocess.SubProcessParameters;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.CycleDependency;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.ProcessData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int[] stateArray = new int[]{ExecutionStatus.SUBMITTED_SUCCESS.ordinal(), ExecutionStatus.RUNNING_EXEUTION.ordinal(), ExecutionStatus.READY_PAUSE.ordinal(), ExecutionStatus.READY_STOP.ordinal()};
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private ProcessInstanceMapMapper processInstanceMapMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectMapper projectMapper;

    @Transactional(rollbackFor={Exception.class})
    public ProcessInstance handleCommand(Logger logger, String host, int validThreadNum, Command command) {
        ProcessInstance processInstance = this.constructProcessInstance(command, host);
        if (processInstance == null) {
            logger.error("scan command, command parameter is error: {}", (Object)command);
            this.moveToErrorCommand(command, "process instance is null");
            return null;
        }
        if (!this.checkThreadNum(command, validThreadNum)) {
            logger.info("there is not enough thread for this command: {}", (Object)command);
            return this.setWaitingThreadProcess(command, processInstance);
        }
        processInstance.setCommandType(command.getCommandType());
        processInstance.addHistoryCmd(command.getCommandType());
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.delCommandByid(command.getId());
        return processInstance;
    }

    @Transactional(rollbackFor={Exception.class})
    public void moveToErrorCommand(Command command, String message) {
        ErrorCommand errorCommand = new ErrorCommand(command, message);
        this.errorCommandMapper.insert((Object)errorCommand);
        this.delCommandByid(command.getId());
    }

    private ProcessInstance setWaitingThreadProcess(Command command, ProcessInstance processInstance) {
        processInstance.setState(ExecutionStatus.WAITTING_THREAD);
        if (command.getCommandType() != CommandType.RECOVER_WAITTING_THREAD) {
            processInstance.addHistoryCmd(command.getCommandType());
        }
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.createRecoveryWaitingThreadCommand(command, processInstance);
        return null;
    }

    private boolean checkThreadNum(Command command, int validThreadNum) {
        int commandThreadCount = this.workProcessThreadNumCount(command.getProcessDefinitionId());
        return validThreadNum >= commandThreadCount;
    }

    public int createCommand(Command command) {
        int result = 0;
        if (command != null) {
            result = this.commandMapper.insert((Object)command);
        }
        return result;
    }

    public Command findOneCommand() {
        return this.commandMapper.getOneToRun();
    }

    public Boolean verifyIsNeedCreateCommand(Command command) {
        Boolean isNeedCreate = true;
        HashMap<CommandType, Integer> cmdTypeMap = new HashMap<CommandType, Integer>();
        cmdTypeMap.put(CommandType.REPEAT_RUNNING, 1);
        cmdTypeMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, 1);
        cmdTypeMap.put(CommandType.START_FAILURE_TASK_PROCESS, 1);
        CommandType commandType = command.getCommandType();
        if (cmdTypeMap.containsKey(commandType)) {
            JSONObject cmdParamObj = (JSONObject)JSON.parse((String)command.getCommandParam());
            int processInstanceId = cmdParamObj.getInteger("ProcessInstanceId");
            List commands = this.commandMapper.selectList(null);
            for (Command tmpCommand : commands) {
                JSONObject tempObj;
                if (!cmdTypeMap.containsKey(tmpCommand.getCommandType()) || (tempObj = (JSONObject)JSON.parse((String)tmpCommand.getCommandParam())) == null || processInstanceId != tempObj.getInteger("ProcessInstanceId")) continue;
                isNeedCreate = false;
                break;
            }
        }
        return isNeedCreate;
    }

    public ProcessInstance findProcessInstanceDetailById(int processId) {
        return this.processInstanceMapper.queryDetailById(processId);
    }

    public List<TaskNode> getTaskNodeListByDefinitionId(Integer defineId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)defineId);
        if (processDefinition == null) {
            this.logger.info("process define not exists");
            return null;
        }
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        if (null == processData) {
            this.logger.error("process data is null");
            return new ArrayList<TaskNode>();
        }
        return processData.getTasks();
    }

    public ProcessInstance findProcessInstanceById(int processId) {
        return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(processId));
    }

    public ProcessDefinition findProcessDefineById(int processDefinitionId) {
        return (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(processDefinitionId));
    }

    public int deleteWorkProcessInstanceById(int processInstanceId) {
        return this.processInstanceMapper.deleteById((Serializable)Integer.valueOf(processInstanceId));
    }

    public int deleteAllSubWorkProcessByParentId(int processInstanceId) {
        List subProcessIdList = this.processInstanceMapMapper.querySubIdListByParentId(processInstanceId);
        for (Integer subId : subProcessIdList) {
            this.deleteAllSubWorkProcessByParentId(subId);
            this.deleteWorkProcessMapByParentId(subId);
            this.removeTaskLogFile(subId);
            this.deleteWorkProcessInstanceById(subId);
        }
        return 1;
    }

    public void removeTaskLogFile(Integer processInstanceId) {
        LogClientService logClient = new LogClientService();
        List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstanceId);
        if (CollectionUtils.isEmpty(taskInstanceList)) {
            return;
        }
        for (TaskInstance taskInstance : taskInstanceList) {
            String taskLogPath = taskInstance.getLogPath();
            if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) continue;
            int port = 50051;
            String ip = "";
            try {
                ip = Host.of((String)taskInstance.getHost()).getIp();
            }
            catch (Exception e) {
                ip = taskInstance.getHost();
            }
            logClient.removeTaskLog(ip, port, taskLogPath);
        }
    }

    private Integer workProcessThreadNumCount(Integer processDefinitionId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        this.recurseFindSubProcessId(processDefinitionId, ids);
        return ids.size() + 1;
    }

    public void recurseFindSubProcessId(int parentId, List<Integer> ids) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(parentId));
        String processDefinitionJson = processDefinition.getProcessDefinitionJson();
        ProcessData processData = (ProcessData)JSONUtils.parseObject((String)processDefinitionJson, ProcessData.class);
        List taskNodeList = processData.getTasks();
        if (taskNodeList != null && taskNodeList.size() > 0) {
            for (TaskNode taskNode : taskNodeList) {
                String parameter = taskNode.getParams();
                JSONObject parameterJson = JSONObject.parseObject((String)parameter);
                if (parameterJson.getInteger("processDefinitionId") == null) continue;
                SubProcessParameters subProcessParam = (SubProcessParameters)JSON.parseObject((String)parameter, SubProcessParameters.class);
                ids.add(subProcessParam.getProcessDefinitionId());
                this.recurseFindSubProcessId(subProcessParam.getProcessDefinitionId(), ids);
            }
        }
    }

    public void createRecoveryWaitingThreadCommand(Command originCommand, ProcessInstance processInstance) {
        if (processInstance.getIsSubProcess() == Flag.YES) {
            if (originCommand != null) {
                this.commandMapper.deleteById((Serializable)Integer.valueOf(originCommand.getId()));
            }
            return;
        }
        HashMap<String, String> cmdParam = new HashMap<String, String>();
        cmdParam.put("WaittingThreadInstanceId", String.valueOf(processInstance.getId()));
        if (originCommand == null) {
            Command command = new Command(CommandType.RECOVER_WAITTING_THREAD, processInstance.getTaskDependType(), processInstance.getFailureStrategy(), processInstance.getExecutorId(), processInstance.getProcessDefinitionId(), JSONUtils.toJson(cmdParam), processInstance.getWarningType(), processInstance.getWarningGroupId().intValue(), processInstance.getScheduleTime(), processInstance.getProcessInstancePriority());
            this.saveCommand(command);
            return;
        }
        if (originCommand.getCommandType() == CommandType.RECOVER_WAITTING_THREAD) {
            originCommand.setUpdateTime(new Date());
            this.saveCommand(originCommand);
        } else {
            this.commandMapper.deleteById((Serializable)Integer.valueOf(originCommand.getId()));
            originCommand.setId(0);
            originCommand.setCommandType(CommandType.RECOVER_WAITTING_THREAD);
            originCommand.setUpdateTime(new Date());
            originCommand.setCommandParam(JSONUtils.toJson(cmdParam));
            originCommand.setProcessInstancePriority(processInstance.getProcessInstancePriority());
            this.saveCommand(originCommand);
        }
    }

    private Date getScheduleTime(Command command, Map<String, String> cmdParam) {
        Date scheduleTime = command.getScheduleTime();
        if (scheduleTime == null && cmdParam != null && cmdParam.containsKey("complementStartDate")) {
            scheduleTime = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
        }
        return scheduleTime;
    }

    private ProcessInstance generateNewProcessInstance(ProcessDefinition processDefinition, Command command, Map<String, String> cmdParam) {
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        processInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
        processInstance.setRecovery(Flag.NO);
        processInstance.setStartTime(new Date());
        processInstance.setRunTimes(1);
        processInstance.setMaxTryTimes(0);
        processInstance.setProcessDefinitionId(command.getProcessDefinitionId());
        processInstance.setCommandParam(command.getCommandParam());
        processInstance.setCommandType(command.getCommandType());
        processInstance.setIsSubProcess(Flag.NO);
        processInstance.setTaskDependType(command.getTaskDependType());
        processInstance.setFailureStrategy(command.getFailureStrategy());
        processInstance.setExecutorId(command.getExecutorId());
        WarningType warningType = command.getWarningType() == null ? WarningType.NONE : command.getWarningType();
        processInstance.setWarningType(warningType);
        Integer warningGroupId = command.getWarningGroupId() == null ? 0 : command.getWarningGroupId();
        processInstance.setWarningGroupId(warningGroupId);
        Date scheduleTime = this.getScheduleTime(command, cmdParam);
        if (scheduleTime != null) {
            processInstance.setScheduleTime(scheduleTime);
        }
        processInstance.setCommandStartTime(command.getStartTime());
        processInstance.setLocations(processDefinition.getLocations());
        processInstance.setConnects(processDefinition.getConnects());
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)this.getCommandTypeIfComplement(processInstance, command), (Date)processInstance.getScheduleTime()));
        processInstance.setProcessInstanceJson(processDefinition.getProcessDefinitionJson());
        processInstance.setProcessInstancePriority(command.getProcessInstancePriority());
        String workerGroup = StringUtils.isBlank((String)command.getWorkerGroup()) ? "default" : command.getWorkerGroup();
        processInstance.setWorkerGroup(workerGroup);
        processInstance.setTimeout(processDefinition.getTimeout());
        processInstance.setTenantId(processDefinition.getTenantId());
        return processInstance;
    }

    public Tenant getTenantForProcess(int tenantId, int userId) {
        Tenant tenant = null;
        if (tenantId >= 0) {
            tenant = this.tenantMapper.queryById(tenantId);
        }
        if (userId == 0) {
            return null;
        }
        if (tenant == null) {
            User user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
            tenant = this.tenantMapper.queryById(user.getTenantId());
        }
        return tenant;
    }

    private Boolean checkCmdParam(Command command, Map<String, String> cmdParam) {
        if (!(command.getTaskDependType() != TaskDependType.TASK_ONLY && command.getTaskDependType() != TaskDependType.TASK_PRE || cmdParam != null && cmdParam.containsKey("StartNodeNameList") && !cmdParam.get("StartNodeNameList").isEmpty())) {
            this.logger.error("command node depend type is {}, but start nodes is null ", (Object)command.getTaskDependType());
            return false;
        }
        return true;
    }

    private ProcessInstance constructProcessInstance(Command command, String host) {
        ProcessInstance processInstance = null;
        CommandType commandType = command.getCommandType();
        Map cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        ProcessDefinition processDefinition = null;
        if (command.getProcessDefinitionId() != 0 && (processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(command.getProcessDefinitionId()))) == null) {
            this.logger.error("cannot find the work process define! define id : {}", (Object)command.getProcessDefinitionId());
            return null;
        }
        if (cmdParam != null) {
            String pId;
            Integer processInstanceId = 0;
            if (cmdParam.containsKey("ProcessInstanceId")) {
                String processId = (String)cmdParam.get("ProcessInstanceId");
                processInstanceId = Integer.parseInt(processId);
                if (processInstanceId == 0) {
                    this.logger.error("command parameter is error, [ ProcessInstanceId ] is 0");
                    return null;
                }
            } else if (cmdParam.containsKey("processInstanceId")) {
                pId = (String)cmdParam.get("processInstanceId");
                processInstanceId = Integer.parseInt(pId);
            } else if (cmdParam.containsKey("WaittingThreadInstanceId")) {
                pId = (String)cmdParam.get("WaittingThreadInstanceId");
                processInstanceId = Integer.parseInt(pId);
            }
            processInstance = processInstanceId == 0 ? this.generateNewProcessInstance(processDefinition, command, cmdParam) : this.findProcessInstanceDetailById(processInstanceId);
            processDefinition = (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(processInstance.getProcessDefinitionId()));
            processInstance.setProcessDefinition(processDefinition);
            if (processInstance.getCommandParam() != null) {
                Map processCmdParam = JSONUtils.toMap((String)processInstance.getCommandParam());
                for (Map.Entry entry : processCmdParam.entrySet()) {
                    if (cmdParam.containsKey(entry.getKey())) continue;
                    cmdParam.put(entry.getKey(), entry.getValue());
                }
            }
            if (cmdParam.containsKey("processInstanceId")) {
                processInstance.setCommandParam(command.getCommandParam());
            }
        } else {
            processInstance = this.generateNewProcessInstance(processDefinition, command, cmdParam);
        }
        if (!this.checkCmdParam(command, cmdParam).booleanValue()) {
            this.logger.error("command parameter check failed!");
            return null;
        }
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setHost(host);
        ExecutionStatus runStatus = ExecutionStatus.RUNNING_EXEUTION;
        int runTime = processInstance.getRunTimes();
        switch (commandType) {
            case START_PROCESS: {
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                List<Integer> failedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.FAILURE);
                List<Integer> toleranceList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.NEED_FAULT_TOLERANCE);
                List<Integer> killedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                cmdParam.remove("StartNodeIdList");
                failedList.addAll(killedList);
                failedList.addAll(toleranceList);
                for (Integer taskId : failedList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(failedList)));
                processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case START_CURRENT_TASK_PROCESS: {
                break;
            }
            case RECOVER_WAITTING_THREAD: {
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                cmdParam.remove("StartNodeIdList");
                List<Integer> suspendedNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.PAUSE);
                List<Integer> stopNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                suspendedNodeList.addAll(stopNodeList);
                for (Integer taskId : suspendedNodeList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(suspendedNodeList)));
                processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                processInstance.setRecovery(Flag.YES);
                runStatus = processInstance.getState();
                break;
            }
            case COMPLEMENT_DATA: {
                List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : taskInstanceList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                this.initComplementDataParam(processDefinition, processInstance, cmdParam);
                break;
            }
            case REPEAT_RUNNING: {
                if (cmdParam.containsKey("StartNodeIdList")) {
                    cmdParam.remove("StartNodeIdList");
                    processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
                }
                List<TaskInstance> validTaskList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : validTaskList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                processInstance.setStartTime(new Date());
                processInstance.setEndTime(null);
                processInstance.setRunTimes(runTime + 1);
                this.initComplementDataParam(processDefinition, processInstance, cmdParam);
                break;
            }
            case SCHEDULER: {
                break;
            }
        }
        processInstance.setState(runStatus);
        return processInstance;
    }

    private CommandType getCommandTypeIfComplement(ProcessInstance processInstance, Command command) {
        if (CommandType.COMPLEMENT_DATA == processInstance.getCmdTypeIfComplement()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return command.getCommandType();
    }

    private void initComplementDataParam(ProcessDefinition processDefinition, ProcessInstance processInstance, Map<String, String> cmdParam) {
        if (!processInstance.isComplementData()) {
            return;
        }
        Date startComplementTime = DateUtils.parse((String)cmdParam.get("complementStartDate"), (String)"yyyy-MM-dd HH:mm:ss");
        if (Flag.NO == processInstance.getIsSubProcess()) {
            processInstance.setScheduleTime(startComplementTime);
        }
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)processInstance.getScheduleTime()));
    }

    public ProcessInstance setSubProcessParam(ProcessInstance subProcessInstance) {
        ProcessInstanceMap processInstanceMap;
        String parentInstanceId;
        String cmdParam = subProcessInstance.getCommandParam();
        if (StringUtils.isEmpty((CharSequence)cmdParam)) {
            return subProcessInstance;
        }
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap.containsKey("processInstanceId") && "0".equals(paramMap.get("processInstanceId"))) {
            paramMap.remove("processInstanceId");
            paramMap.put("processInstanceId", String.valueOf(subProcessInstance.getId()));
            subProcessInstance.setCommandParam(JSONUtils.toJson((Object)paramMap));
            subProcessInstance.setIsSubProcess(Flag.YES);
            this.saveProcessInstance(subProcessInstance);
        }
        if (StringUtils.isNotEmpty((CharSequence)(parentInstanceId = (String)paramMap.get("parentProcessInstanceId")))) {
            ProcessInstance parentInstance = this.findProcessInstanceDetailById(Integer.parseInt(parentInstanceId));
            if (parentInstance != null) {
                subProcessInstance.setGlobalParams(this.joinGlobalParams(parentInstance.getGlobalParams(), subProcessInstance.getGlobalParams()));
                this.saveProcessInstance(subProcessInstance);
            } else {
                this.logger.error("sub process command params error, cannot find parent instance: {} ", (Object)cmdParam);
            }
        }
        if ((processInstanceMap = (ProcessInstanceMap)JSONUtils.parseObject((String)cmdParam, ProcessInstanceMap.class)) == null || processInstanceMap.getParentProcessInstanceId() == 0) {
            return subProcessInstance;
        }
        processInstanceMap.setProcessInstanceId(subProcessInstance.getId());
        this.updateWorkProcessInstanceMap(processInstanceMap);
        return subProcessInstance;
    }

    private String joinGlobalParams(String parentGlobalParams, String subGlobalParams) {
        List parentPropertyList = JSONUtils.toList((String)parentGlobalParams, Property.class);
        List subPropertyList = JSONUtils.toList((String)subGlobalParams, Property.class);
        Map<String, String> subMap = subPropertyList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        for (Property parent : parentPropertyList) {
            if (subMap.containsKey(parent.getProp())) continue;
            subPropertyList.add(parent);
        }
        return JSONUtils.toJson((Object)subPropertyList);
    }

    private void initTaskInstance(TaskInstance taskInstance) {
        if (!taskInstance.isSubProcess() && (taskInstance.getState().typeIsCancel() || taskInstance.getState().typeIsFailure())) {
            taskInstance.setFlag(Flag.NO);
            this.updateTaskInstance(taskInstance);
            return;
        }
        taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
        this.updateTaskInstance(taskInstance);
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskInstance submitTask(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceDetailById(taskInstance.getProcessInstanceId());
        this.logger.info("start submit task : {}, instance id:{}, state: {}", new Object[]{taskInstance.getName(), taskInstance.getProcessInstanceId(), processInstance.getState()});
        TaskInstance task = this.submitTaskInstanceToDB(taskInstance, processInstance);
        if (task == null) {
            this.logger.error("end submit task to db error, task name:{}, process id:{} state: {} ", new Object[]{taskInstance.getName(), taskInstance.getProcessInstance(), processInstance.getState()});
            return task;
        }
        if (!task.getState().typeIsFinished()) {
            this.createSubWorkProcessCommand(processInstance, task);
        }
        this.logger.info("end submit task to db successfully:{} state:{} complete, instance id:{} state: {}  ", new Object[]{taskInstance.getName(), task.getState(), processInstance.getId(), processInstance.getState()});
        return task;
    }

    private ProcessInstanceMap setProcessInstanceMap(ProcessInstance parentInstance, TaskInstance parentTask) {
        ProcessInstanceMap processMap = this.findWorkProcessMapByParent(parentInstance.getId(), parentTask.getId());
        if (processMap != null) {
            return processMap;
        }
        if ((parentInstance.getCommandType() == CommandType.REPEAT_RUNNING || parentInstance.isComplementData()) && (processMap = this.findPreviousTaskProcessMap(parentInstance, parentTask)) != null) {
            processMap.setParentTaskInstanceId(parentTask.getId());
            this.updateWorkProcessInstanceMap(processMap);
            return processMap;
        }
        processMap = new ProcessInstanceMap();
        processMap.setParentProcessInstanceId(parentInstance.getId());
        processMap.setParentTaskInstanceId(parentTask.getId());
        this.createWorkProcessInstanceMap(processMap);
        return processMap;
    }

    private ProcessInstanceMap findPreviousTaskProcessMap(ProcessInstance parentProcessInstance, TaskInstance parentTask) {
        Integer preTaskId = 0;
        List<TaskInstance> preTaskList = this.findPreviousTaskListByWorkProcessId(parentProcessInstance.getId());
        for (TaskInstance task : preTaskList) {
            if (!task.getName().equals(parentTask.getName())) continue;
            preTaskId = task.getId();
            ProcessInstanceMap map = this.findWorkProcessMapByParent(parentProcessInstance.getId(), preTaskId);
            if (map == null) continue;
            return map;
        }
        this.logger.info("sub process instance is not found,parent task:{},parent instance:{}", (Object)parentTask.getId(), (Object)parentProcessInstance.getId());
        return null;
    }

    private void createSubWorkProcessCommand(ProcessInstance parentProcessInstance, TaskInstance task) {
        String fatherHistoryCommand;
        CommandType fatherType;
        if (!task.isSubProcess()) {
            return;
        }
        ProcessInstanceMap instanceMap = this.setProcessInstanceMap(parentProcessInstance, task);
        TaskNode taskNode = (TaskNode)JSONUtils.parseObject((String)task.getTaskJson(), TaskNode.class);
        Map subProcessParam = JSONUtils.toMap((String)taskNode.getParams());
        Integer childDefineId = Integer.parseInt((String)subProcessParam.get("processDefinitionId"));
        ProcessInstance childInstance = this.findSubProcessInstance(parentProcessInstance.getId(), task.getId());
        CommandType commandType = fatherType = parentProcessInstance.getCommandType();
        if (childInstance == null && ((fatherHistoryCommand = parentProcessInstance.getHistoryCmd()).startsWith(CommandType.SCHEDULER.toString()) || fatherHistoryCommand.startsWith(CommandType.COMPLEMENT_DATA.toString()))) {
            commandType = CommandType.valueOf((String)fatherHistoryCommand.split(",")[0]);
        }
        if (childInstance != null) {
            childInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
            this.updateProcessInstance(childInstance);
        }
        String processMapStr = JSONUtils.toJson((Object)instanceMap);
        Map cmdParam = JSONUtils.toMap((String)processMapStr);
        if (commandType == CommandType.COMPLEMENT_DATA || childInstance != null && childInstance.isComplementData()) {
            Map parentParam = JSONUtils.toMap((String)parentProcessInstance.getCommandParam());
            String endTime = (String)parentParam.get("complementEndDate");
            String startTime = (String)parentParam.get("complementStartDate");
            cmdParam.put("complementEndDate", endTime);
            cmdParam.put("complementStartDate", startTime);
            processMapStr = JSONUtils.toJson((Object)cmdParam);
        }
        this.updateSubProcessDefinitionByParent(parentProcessInstance, childDefineId);
        Command command = new Command();
        command.setWarningType(parentProcessInstance.getWarningType());
        command.setWarningGroupId(parentProcessInstance.getWarningGroupId());
        command.setFailureStrategy(parentProcessInstance.getFailureStrategy());
        command.setProcessDefinitionId(childDefineId.intValue());
        command.setScheduleTime(parentProcessInstance.getScheduleTime());
        command.setExecutorId(parentProcessInstance.getExecutorId());
        command.setCommandParam(processMapStr);
        command.setCommandType(commandType);
        command.setProcessInstancePriority(parentProcessInstance.getProcessInstancePriority());
        command.setWorkerGroup(parentProcessInstance.getWorkerGroup());
        this.createCommand(command);
        this.logger.info("sub process command created: {} ", (Object)command.toString());
    }

    private void updateSubProcessDefinitionByParent(ProcessInstance parentProcessInstance, int childDefinitionId) {
        ProcessDefinition fatherDefinition = this.findProcessDefineById(parentProcessInstance.getProcessDefinitionId());
        ProcessDefinition childDefinition = this.findProcessDefineById(childDefinitionId);
        if (childDefinition != null && fatherDefinition != null) {
            childDefinition.setReceivers(fatherDefinition.getReceivers());
            childDefinition.setReceiversCc(fatherDefinition.getReceiversCc());
            this.processDefineMapper.updateById((Object)childDefinition);
        }
    }

    public TaskInstance submitTaskInstanceToDB(TaskInstance taskInstance, ProcessInstance processInstance) {
        ExecutionStatus processInstanceState = processInstance.getState();
        if (taskInstance.getState().typeIsFailure()) {
            if (taskInstance.isSubProcess()) {
                taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
            } else if (processInstanceState != ExecutionStatus.READY_STOP && processInstanceState != ExecutionStatus.READY_PAUSE) {
                taskInstance.setFlag(Flag.NO);
                this.updateTaskInstance(taskInstance);
                if (taskInstance.getState() != ExecutionStatus.NEED_FAULT_TOLERANCE) {
                    taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
                }
                taskInstance.setEndTime(null);
                taskInstance.setStartTime(new Date());
                taskInstance.setFlag(Flag.YES);
                taskInstance.setHost(null);
                taskInstance.setId(0);
            }
        }
        taskInstance.setExecutorId(processInstance.getExecutorId());
        taskInstance.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        taskInstance.setState(this.getSubmitTaskState(taskInstance, processInstanceState));
        taskInstance.setSubmitTime(new Date());
        boolean saveResult = this.saveTaskInstance(taskInstance);
        if (!saveResult) {
            return null;
        }
        return taskInstance;
    }

    public String taskZkInfo(TaskInstance taskInstance) {
        String taskWorkerGroup = this.getTaskWorkerGroup(taskInstance);
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        if (processInstance == null) {
            this.logger.error("process instance is null. please check the task info, task id: " + taskInstance.getId());
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(processInstance.getProcessInstancePriority().ordinal()).append("_").append(taskInstance.getProcessInstanceId()).append("_").append(taskInstance.getTaskInstancePriority().ordinal()).append("_").append(taskInstance.getId()).append("_").append(taskInstance.getWorkerGroup());
        return sb.toString();
    }

    public ExecutionStatus getSubmitTaskState(TaskInstance taskInstance, ExecutionStatus processInstanceState) {
        ExecutionStatus state = taskInstance.getState();
        if (state == ExecutionStatus.RUNNING_EXEUTION || state == ExecutionStatus.KILL || this.checkTaskExistsInTaskQueue(taskInstance)) {
            return state;
        }
        state = processInstanceState == ExecutionStatus.READY_PAUSE ? ExecutionStatus.PAUSE : (processInstanceState == ExecutionStatus.READY_STOP || !this.checkProcessStrategy(taskInstance) ? ExecutionStatus.KILL : ExecutionStatus.SUBMITTED_SUCCESS);
        return state;
    }

    private boolean checkProcessStrategy(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        FailureStrategy failureStrategy = processInstance.getFailureStrategy();
        if (failureStrategy == FailureStrategy.CONTINUE) {
            return true;
        }
        List<TaskInstance> taskInstances = this.findValidTaskListByProcessId(taskInstance.getProcessInstanceId());
        for (TaskInstance task : taskInstances) {
            if (task.getState() != ExecutionStatus.FAILURE) continue;
            return false;
        }
        return true;
    }

    public boolean checkTaskExistsInTaskQueue(TaskInstance taskInstance) {
        if (taskInstance.isSubProcess()) {
            return false;
        }
        String taskZkInfo = this.taskZkInfo(taskInstance);
        return false;
    }

    public void createProcessInstance(ProcessInstance processInstance) {
        if (processInstance != null) {
            this.processInstanceMapper.insert((Object)processInstance);
        }
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        if (processInstance == null) {
            this.logger.error("save error, process instance is null!");
            return;
        }
        if (processInstance.getId() != 0) {
            this.processInstanceMapper.updateById((Object)processInstance);
        } else {
            this.createProcessInstance(processInstance);
        }
    }

    public int saveCommand(Command command) {
        if (command.getId() != 0) {
            return this.commandMapper.updateById((Object)command);
        }
        return this.commandMapper.insert((Object)command);
    }

    public boolean saveTaskInstance(TaskInstance taskInstance) {
        if (taskInstance.getId() != 0) {
            return this.updateTaskInstance(taskInstance);
        }
        return this.createTaskInstance(taskInstance);
    }

    public boolean createTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.insert((Object)taskInstance);
        return count > 0;
    }

    public boolean updateTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.updateById((Object)taskInstance);
        return count > 0;
    }

    public void delCommandByid(int id) {
        this.commandMapper.deleteById((Serializable)Integer.valueOf(id));
    }

    public TaskInstance findTaskInstanceById(Integer taskId) {
        return (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskId);
    }

    public TaskInstance getTaskInstanceDetailByTaskId(int taskInstId) {
        TaskInstance taskInstance = this.findTaskInstanceById(taskInstId);
        if (taskInstance == null) {
            return taskInstance;
        }
        ProcessInstance processInstance = this.findProcessInstanceDetailById(taskInstance.getProcessInstanceId());
        ProcessDefinition processDefine = this.findProcessDefineById(taskInstance.getProcessDefinitionId());
        taskInstance.setProcessInstance(processInstance);
        taskInstance.setProcessDefine(processDefine);
        return taskInstance;
    }

    public List<Integer> findTaskIdByInstanceState(int instanceId, ExecutionStatus state) {
        return this.taskInstanceMapper.queryTaskByProcessIdAndState(Integer.valueOf(instanceId), Integer.valueOf(state.ordinal()));
    }

    public List<TaskInstance> findValidTaskListByProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.YES);
    }

    public List<TaskInstance> findPreviousTaskListByWorkProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.NO);
    }

    public int updateWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        return this.processInstanceMapMapper.updateById((Object)processInstanceMap);
    }

    public int createWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        Integer count = 0;
        if (processInstanceMap != null) {
            return this.processInstanceMapMapper.insert((Object)processInstanceMap);
        }
        return count;
    }

    public ProcessInstanceMap findWorkProcessMapByParent(Integer parentWorkProcessId, Integer parentTaskId) {
        return this.processInstanceMapMapper.queryByParentId(parentWorkProcessId.intValue(), parentTaskId.intValue());
    }

    public int deleteWorkProcessMapByParentId(int parentWorkProcessId) {
        return this.processInstanceMapMapper.deleteByParentProcessId(parentWorkProcessId);
    }

    public ProcessInstance findSubProcessInstance(Integer parentProcessId, Integer parentTaskId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryByParentId(parentProcessId.intValue(), parentTaskId.intValue());
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getProcessInstanceId());
        return processInstance;
    }

    public ProcessInstance findParentProcessInstance(Integer subProcessId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(subProcessId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        return processInstance;
    }

    public void changeTaskState(ExecutionStatus state, Date startTime, String host, String executePath, String logPath, int taskInstId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstId));
        taskInstance.setState(state);
        taskInstance.setStartTime(startTime);
        taskInstance.setHost(host);
        taskInstance.setExecutePath(executePath);
        taskInstance.setLogPath(logPath);
        this.saveTaskInstance(taskInstance);
    }

    public int updateProcessInstance(ProcessInstance processInstance) {
        return this.processInstanceMapper.updateById((Object)processInstance);
    }

    public int updateProcessInstance(Integer processInstanceId, String processJson, String globalParams, Date scheduleTime, Flag flag, String locations, String connects) {
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance != null) {
            processInstance.setProcessInstanceJson(processJson);
            processInstance.setGlobalParams(globalParams);
            processInstance.setScheduleTime(scheduleTime);
            processInstance.setLocations(locations);
            processInstance.setConnects(connects);
            return this.processInstanceMapper.updateById((Object)processInstance);
        }
        return 0;
    }

    public void changeTaskState(ExecutionStatus state, Date endTime, int processId, String appIds, int taskInstId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstId));
        taskInstance.setPid(processId);
        taskInstance.setAppLink(appIds);
        taskInstance.setState(state);
        taskInstance.setEndTime(endTime);
        this.saveTaskInstance(taskInstance);
    }

    public List<String> convertIntListToString(List<Integer> intList) {
        if (intList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(intList.size());
        for (Integer intVar : intList) {
            result.add(String.valueOf(intVar));
        }
        return result;
    }

    public void updatePidByTaskInstId(int taskInstId, int pid, String appLinks) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstId));
        taskInstance.setPid(pid);
        taskInstance.setAppLink(appLinks);
        this.saveTaskInstance(taskInstance);
    }

    public Schedule querySchedule(int id) {
        return (Schedule)this.scheduleMapper.selectById((Serializable)Integer.valueOf(id));
    }

    public List<Schedule> queryReleaseSchedulerListByProcessDefinitionId(int processDefinitionId) {
        return this.scheduleMapper.queryReleaseSchedulerListByProcessDefinitionId(processDefinitionId);
    }

    public List<ProcessInstance> queryNeedFailoverProcessInstances(String host) {
        return this.processInstanceMapper.queryByHostAndStatus(host, this.stateArray);
    }

    @Transactional(rollbackFor={Exception.class})
    public void processNeedFailoverProcessInstances(ProcessInstance processInstance) {
        processInstance.setHost("NULL");
        this.processInstanceMapper.updateById((Object)processInstance);
        Command cmd = new Command();
        cmd.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        cmd.setCommandParam(String.format("{\"%s\":%d}", "ProcessInstanceId", processInstance.getId()));
        cmd.setExecutorId(processInstance.getExecutorId());
        cmd.setCommandType(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS);
        this.createCommand(cmd);
    }

    public List<TaskInstance> queryNeedFailoverTaskInstances(String host) {
        return this.taskInstanceMapper.queryByHostAndStatus(host, this.stateArray);
    }

    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    public int updateProcessInstanceState(Integer processInstanceId, ExecutionStatus executionStatus) {
        ProcessInstance instance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)processInstanceId);
        instance.setState(executionStatus);
        return this.processInstanceMapper.updateById((Object)instance);
    }

    public ProcessInstance findProcessInstanceByTaskId(int taskId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskId));
        if (taskInstance != null) {
            return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstance.getProcessInstanceId()));
        }
        return null;
    }

    public List<UdfFunc> queryUdfFunListByids(int[] ids) {
        return this.udfFuncMapper.queryUdfByIdStr(ids, null);
    }

    public String queryTenantCodeByResName(String resName, ResourceType resourceType) {
        String fullName = resName.startsWith("/") ? resName : String.format("/%s", resName);
        return this.resourceMapper.queryTenantCodeByResourceName(fullName, resourceType.ordinal());
    }

    public List<Schedule> selectAllByProcessDefineId(int[] ids) {
        return this.scheduleMapper.selectAllByProcessDefineArray(ids);
    }

    public CycleDependency getCycleDependency(int masterId, int processDefinitionId, Date scheduledFireTime) throws Exception {
        List<CycleDependency> list = this.getCycleDependencies(masterId, new int[]{processDefinitionId}, scheduledFireTime);
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<CycleDependency> getCycleDependencies(int masterId, int[] ids, Date scheduledFireTime) throws Exception {
        ArrayList<CycleDependency> cycleDependencyList = new ArrayList<CycleDependency>();
        if (ArrayUtils.isEmpty((int[])ids)) {
            this.logger.warn("ids[] is empty!is invalid!");
            return cycleDependencyList;
        }
        if (scheduledFireTime == null) {
            this.logger.warn("scheduledFireTime is null!is invalid!");
            return cycleDependencyList;
        }
        String strCrontab = "";
        List<Schedule> schedules = this.selectAllByProcessDefineId(ids);
        block6: for (Schedule depSchedule : schedules) {
            strCrontab = depSchedule.getCrontab();
            CronExpression depCronExpression = CronUtils.parse2CronExpression(strCrontab);
            Cron depCron = CronUtils.parse2Cron(strCrontab);
            CycleEnum cycleEnum = CronUtils.getMiniCycle(depCron);
            if (cycleEnum == null) {
                this.logger.error("{} is not valid", (Object)strCrontab);
                continue;
            }
            Calendar calendar = Calendar.getInstance();
            switch (cycleEnum) {
                case HOUR: {
                    calendar.add(10, -25);
                    break;
                }
                case DAY: {
                    calendar.add(5, -32);
                    break;
                }
                case WEEK: {
                    calendar.add(5, -32);
                    break;
                }
                case MONTH: {
                    calendar.add(2, -13);
                    break;
                }
                default: {
                    this.logger.warn("Dependent process definition's  cycleEnum is {},not support!!", (Object)cycleEnum.name());
                    continue block6;
                }
            }
            Date start = calendar.getTime();
            List<Date> list = depSchedule.getProcessDefinitionId() == masterId ? CronUtils.getSelfFireDateList(start, scheduledFireTime, depCronExpression) : CronUtils.getFireDateList(start, scheduledFireTime, depCronExpression);
            if (list.size() < 1) continue;
            start = list.get(list.size() - 1);
            CycleDependency dependency = new CycleDependency(depSchedule.getProcessDefinitionId(), start, CronUtils.getExpirationTime(start, cycleEnum), cycleEnum);
            cycleDependencyList.add(dependency);
        }
        return cycleDependencyList;
    }

    public ProcessInstance findLastSchedulerProcessInterval(int definitionId, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastSchedulerProcess(definitionId, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    public ProcessInstance findLastManualProcessInterval(int definitionId, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastManualProcess(definitionId, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    public ProcessInstance findLastRunningProcess(int definitionId, Date startTime, Date endTime) {
        return this.processInstanceMapper.queryLastRunningProcess(definitionId, startTime, endTime, this.stateArray);
    }

    public String queryUserQueueByProcessInstanceId(int processInstanceId) {
        String queue = "";
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(processInstanceId));
        if (processInstance == null) {
            return queue;
        }
        User executor = (User)this.userMapper.selectById((Serializable)Integer.valueOf(processInstance.getExecutorId()));
        if (executor != null) {
            queue = executor.getQueue();
        }
        return queue;
    }

    public String getTaskWorkerGroup(TaskInstance taskInstance) {
        String workerGroup = taskInstance.getWorkerGroup();
        if (StringUtils.isNotBlank((String)workerGroup)) {
            return workerGroup;
        }
        int processInstanceId = taskInstance.getProcessInstanceId();
        ProcessInstance processInstance = this.findProcessInstanceById(processInstanceId);
        if (processInstance != null) {
            return processInstance.getWorkerGroup();
        }
        this.logger.info("task : {} will use default worker group", (Object)taskInstance.getId());
        return "default";
    }

    public List<Project> getProjectListHavePerm(int userId) {
        ArrayList<Project> createProjects = this.projectMapper.queryProjectCreatedByUser(userId);
        List authedProjects = this.projectMapper.queryAuthedProjectListByUserId(userId);
        if (createProjects == null) {
            createProjects = new ArrayList<Project>();
        }
        if (authedProjects != null) {
            createProjects.addAll(authedProjects);
        }
        return createProjects;
    }

    public List<Integer> getProjectIdListHavePerm(int userId) {
        ArrayList<Integer> projectIdList = new ArrayList<Integer>();
        for (Project project : this.getProjectListHavePerm(userId)) {
            projectIdList.add(project.getId());
        }
        return projectIdList;
    }

    public <T> List<T> listUnauthorized(int userId, T[] needChecks, AuthorizationType authorizationType) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (!ArrayUtils.isEmpty((Object[])needChecks)) {
            HashSet<T> originResSet = new HashSet<T>(Arrays.asList(needChecks));
            switch (authorizationType) {
                case RESOURCE_FILE_ID: {
                    Set authorizedResourceFiles = this.resourceMapper.listAuthorizedResourceById(userId, (Object[])needChecks).stream().map(t -> t.getId()).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResourceFiles);
                    break;
                }
                case RESOURCE_FILE_NAME: {
                    Set authorizedResources = this.resourceMapper.listAuthorizedResource(userId, (Object[])needChecks).stream().map(t -> t.getFullName()).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResources);
                    break;
                }
                case UDF_FILE: {
                    Set authorizedUdfFiles = this.resourceMapper.listAuthorizedResourceById(userId, (Object[])needChecks).stream().map(t -> t.getId()).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedUdfFiles);
                    break;
                }
                case DATASOURCE: {
                    Set authorizedDatasources = this.dataSourceMapper.listAuthorizedDataSource(userId, (Object[])needChecks).stream().map(t -> t.getId()).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedDatasources);
                    break;
                }
                case UDF: {
                    Set authorizedUdfs = this.udfFuncMapper.listAuthorizedUdfFunc(userId, (Object[])needChecks).stream().map(t -> t.getId()).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedUdfs);
                }
            }
            resultList.addAll(originResSet);
        }
        return resultList;
    }

    public User getUserById(int userId) {
        return (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
    }

    public Resource getResourceById(int resoruceId) {
        return (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resoruceId));
    }

    public List<Resource> listResourceByIds(Integer[] resIds) {
        return this.resourceMapper.listResourceByIds(resIds);
    }

    public String formatTaskAppId(TaskInstance taskInstance) {
        ProcessDefinition definition = this.findProcessDefineById(taskInstance.getProcessDefinitionId());
        ProcessInstance processInstanceById = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        if (definition == null || processInstanceById == null) {
            return "";
        }
        return String.format("%s_%s_%s", definition.getId(), processInstanceById.getId(), taskInstance.getId());
    }
}

