/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutors;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProcessScheduleJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(ProcessScheduleJob.class);

    public ProcessService getProcessService() {
        return SpringApplicationContext.getBean(ProcessService.class);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Assert.notNull((Object)this.getProcessService(), (String)"please call init() method first");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        int projectId = dataMap.getInt("projectId");
        int scheduleId = dataMap.getInt("scheduleId");
        Date scheduledFireTime = context.getScheduledFireTime();
        Date fireTime = context.getFireTime();
        logger.info("scheduled fire time :{}, fire time :{}, process id :{}", new Object[]{scheduledFireTime, fireTime, scheduleId});
        Schedule schedule = this.getProcessService().querySchedule(scheduleId);
        if (schedule == null) {
            logger.warn("process schedule does not exist in db\uff0cdelete schedule job in quartz, projectId:{}, scheduleId:{}", (Object)projectId, (Object)scheduleId);
            this.deleteJob(projectId, scheduleId);
            return;
        }
        ProcessDefinition processDefinition = this.getProcessService().findProcessDefineById(schedule.getProcessDefinitionId());
        ReleaseState releaseState = processDefinition.getReleaseState();
        if (processDefinition == null || releaseState == ReleaseState.OFFLINE) {
            logger.warn("process definition does not exist in db or offline\uff0cneed not to create command, projectId:{}, processId:{}", (Object)projectId, (Object)scheduleId);
            return;
        }
        Command command = new Command();
        command.setCommandType(CommandType.SCHEDULER);
        command.setExecutorId(schedule.getUserId());
        command.setFailureStrategy(schedule.getFailureStrategy());
        command.setProcessDefinitionId(schedule.getProcessDefinitionId());
        command.setScheduleTime(scheduledFireTime);
        command.setStartTime(fireTime);
        command.setWarningGroupId(Integer.valueOf(schedule.getWarningGroupId()));
        String workerGroup = StringUtils.isEmpty((Object)schedule.getWorkerGroup()) ? "default" : schedule.getWorkerGroup();
        command.setWorkerGroup(workerGroup);
        command.setWarningType(schedule.getWarningType());
        command.setProcessInstancePriority(schedule.getProcessInstancePriority());
        this.getProcessService().createCommand(command);
    }

    private void deleteJob(int projectId, int scheduleId) {
        String jobName = QuartzExecutors.buildJobName(scheduleId);
        String jobGroupName = QuartzExecutors.buildJobGroupName(projectId);
        QuartzExecutors.getInstance().deleteJob(jobName, jobGroupName);
    }
}

