/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKServer {
    private static final Logger logger = LoggerFactory.getLogger(ZKServer.class);
    private static volatile PublicZooKeeperServerMain zkServer = null;
    public static final int DEFAULT_ZK_TEST_PORT = 2181;
    private static String dataDir = null;
    private static final AtomicBoolean isStarted = new AtomicBoolean(false);

    public static void main(String[] args) {
        if (!ZKServer.isStarted()) {
            ZKServer.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    ZKServer.stop();
                }
            }));
        } else {
            logger.info("zk server aleady started");
        }
    }

    public static void start() {
        try {
            ZKServer.startLocalZkServer(2181);
        }
        catch (Exception e) {
            logger.error("Failed to start ZK: " + e);
        }
    }

    public static boolean isStarted() {
        return isStarted.get();
    }

    public static void startLocalZkServer(int port) {
        String zkDataDir = System.getProperty("user.dir") + "/zookeeper_data";
        logger.info("zk server starting, data dir path:{}", (Object)zkDataDir);
        ZKServer.startLocalZkServer(port, zkDataDir, 3000, "60");
    }

    private static synchronized void startLocalZkServer(int port, String dataDirPath, int tickTime, String maxClientCnxns) {
        if (zkServer != null) {
            throw new RuntimeException("Zookeeper server is already started!");
        }
        zkServer = new PublicZooKeeperServerMain();
        logger.info("Zookeeper data path : {} ", (Object)dataDirPath);
        dataDir = dataDirPath;
        String[] args = new String[]{Integer.toString(port), dataDirPath, Integer.toString(tickTime), maxClientCnxns};
        try {
            logger.info("Zookeeper server started ");
            isStarted.compareAndSet(false, true);
            zkServer.initializeAndRun(args);
        }
        catch (QuorumPeerConfig.ConfigException e) {
            logger.warn("Caught exception while starting ZK", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("Caught exception while starting ZK", (Throwable)e);
        }
    }

    public static void stop() {
        try {
            ZKServer.stopLocalZkServer(true);
            logger.info("zk server stopped");
        }
        catch (Exception e) {
            logger.error("Failed to stop ZK ", (Throwable)e);
        }
    }

    private static synchronized void stopLocalZkServer(boolean deleteDataDir) {
        if (zkServer != null) {
            try {
                zkServer.shutdown();
                zkServer = null;
                if (deleteDataDir) {
                    FileUtils.deleteDirectory((File)new File(dataDir));
                }
                isStarted.compareAndSet(true, false);
            }
            catch (Exception e) {
                logger.warn("Caught exception while stopping ZK server", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    static class PublicZooKeeperServerMain
    extends ZooKeeperServerMain {
        PublicZooKeeperServerMain() {
        }

        public void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
            super.initializeAndRun(args);
        }

        public void shutdown() {
            super.shutdown();
        }
    }
}

