/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.queue;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;

public class PeerTaskInstancePriorityQueue
implements TaskPriorityQueue<TaskInstance> {
    private static final Integer QUEUE_MAX_SIZE = 3000;
    private PriorityQueue<TaskInstance> queue = new PriorityQueue<TaskInstance>(QUEUE_MAX_SIZE, new TaskInfoComparator());

    @Override
    public void put(TaskInstance taskInstance) throws Exception {
        this.queue.add(taskInstance);
    }

    @Override
    public TaskInstance take() throws Exception {
        return this.queue.poll();
    }

    public TaskInstance peek() throws Exception {
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public boolean contains(TaskInstance taskInstance) {
        return this.queue.contains(taskInstance);
    }

    public boolean remove(TaskInstance taskInstance) throws Exception {
        return this.queue.remove(taskInstance);
    }

    public Iterator iterator() {
        return this.queue.iterator();
    }

    private class TaskInfoComparator
    implements Comparator<TaskInstance> {
        private TaskInfoComparator() {
        }

        @Override
        public int compare(TaskInstance o1, TaskInstance o2) {
            return o1.getTaskInstancePriority().compareTo((Enum)o2.getTaskInstancePriority());
        }
    }
}

