/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.queue;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;
import org.springframework.stereotype.Service;

@Service
public class TaskPriorityQueueImpl
implements TaskPriorityQueue<String> {
    private static final Integer QUEUE_MAX_SIZE = 3000;
    private PriorityBlockingQueue<String> queue = new PriorityBlockingQueue<String>(QUEUE_MAX_SIZE, new TaskInfoComparator());

    @Override
    public void put(String taskPriorityInfo) throws Exception {
        this.queue.put(taskPriorityInfo);
    }

    @Override
    public String take() throws Exception {
        return this.queue.take();
    }

    @Override
    public int size() throws Exception {
        return this.queue.size();
    }

    private class TaskInfoComparator
    implements Comparator<String> {
        private TaskInfoComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            String[] s2Array;
            String s1 = o1;
            String s2 = o2;
            String[] s1Array = s1.split("_");
            if (s1Array.length > Constants.TASK_INFO_LENGTH) {
                s1 = s1.substring(0, s1.lastIndexOf("_"));
            }
            if ((s2Array = s2.split("_")).length > Constants.TASK_INFO_LENGTH) {
                s2 = s2.substring(0, s2.lastIndexOf("_"));
            }
            return s1.compareTo(s2);
        }
    }
}

