/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.ResInfo;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.service.zk.ZookeeperCachedOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractZKClient
extends ZookeeperCachedOperator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractZKClient.class);

    public void removeDeadServerByHost(String host, String serverType) throws Exception {
        List<String> deadServers = super.getChildrenKeys(this.getDeadZNodeParentPath());
        for (String serverPath : deadServers) {
            if (!serverPath.startsWith(serverType + "_" + host)) continue;
            String server = this.getDeadZNodeParentPath() + "/" + serverPath;
            super.remove(server);
            logger.info("{} server {} deleted from zk dead server path success", (Object)serverType, (Object)host);
        }
    }

    public void handleDeadServer(String zNode, ZKNodeType zkNodeType, String opType) throws Exception {
        String deadServerPath;
        String type;
        String host = this.getHostByEventDataPath(zNode);
        String string = type = zkNodeType == ZKNodeType.MASTER ? "master" : "worker";
        if (opType.equals("delete")) {
            this.removeDeadServerByHost(host, type);
        } else if (opType.equals("add") && !super.isExisted(deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + host)) {
            super.persist(deadServerPath, type + "_" + host);
            logger.info("{} server dead , and {} added to zk dead server path success", (Object)zkNodeType.toString(), (Object)zNode);
        }
    }

    public int getActiveMasterNum() {
        List<Object> childrenList = new ArrayList();
        try {
            if (super.isExisted(this.getZNodeParentPath(ZKNodeType.MASTER))) {
                childrenList = super.getChildrenKeys(this.getZNodeParentPath(ZKNodeType.MASTER));
            }
        }
        catch (Exception e) {
            logger.error("getActiveMasterNum error", (Throwable)e);
        }
        return childrenList.size();
    }

    public String getZookeeperQuorum() {
        return this.getZookeeperConfig().getServerList();
    }

    public List<Server> getServersList(ZKNodeType zkNodeType) {
        Map<String, String> masterMap = this.getServerMaps(zkNodeType);
        String parentPath = this.getZNodeParentPath(zkNodeType);
        ArrayList<Server> masterServers = new ArrayList<Server>();
        for (Map.Entry<String, String> entry : masterMap.entrySet()) {
            Server masterServer = ResInfo.parseHeartbeatForZKInfo((String)entry.getValue());
            if (masterServer == null) continue;
            String key = entry.getKey();
            masterServer.setZkDirectory(parentPath + "/" + key);
            String[] hostAndPort = key.split(":");
            String[] hosts = hostAndPort[0].split("/");
            masterServer.setHost(hosts[hosts.length - 1]);
            masterServer.setPort(Integer.parseInt(hostAndPort[1]));
            masterServers.add(masterServer);
        }
        return masterServers;
    }

    public Map<String, String> getServerMaps(ZKNodeType zkNodeType) {
        HashMap<String, String> masterMap = new HashMap<String, String>();
        try {
            String path = this.getZNodeParentPath(zkNodeType);
            List<String> serverList = super.getChildrenKeys(path);
            if (zkNodeType == ZKNodeType.WORKER) {
                ArrayList<String> workerList = new ArrayList<String>();
                for (String group : serverList) {
                    List<String> groupServers = super.getChildrenKeys(path + "/" + group);
                    for (String groupServer : groupServers) {
                        workerList.add(group + "/" + groupServer);
                    }
                }
                serverList = workerList;
            }
            for (String server : serverList) {
                masterMap.putIfAbsent(server, super.get(path + "/" + server));
            }
        }
        catch (Exception e) {
            logger.error("get server list failed", (Throwable)e);
        }
        return masterMap;
    }

    public boolean checkZKNodeExists(String host, ZKNodeType zkNodeType) {
        String path = this.getZNodeParentPath(zkNodeType);
        if (StringUtils.isEmpty((CharSequence)path)) {
            logger.error("check zk node exists error, host:{}, zk node type:{}", (Object)host, (Object)zkNodeType.toString());
            return false;
        }
        Map<String, String> serverMaps = this.getServerMaps(zkNodeType);
        for (String hostKey : serverMaps.keySet()) {
            if (!hostKey.contains(host)) continue;
            return true;
        }
        return false;
    }

    protected String getWorkerZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/nodes/worker";
    }

    protected String getMasterZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/nodes/master";
    }

    public String getMasterLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/masters";
    }

    public String getZNodeParentPath(ZKNodeType zkNodeType) {
        String path = "";
        switch (zkNodeType) {
            case MASTER: {
                return this.getMasterZNodeParentPath();
            }
            case WORKER: {
                return this.getWorkerZNodeParentPath();
            }
            case DEAD_SERVER: {
                return this.getDeadZNodeParentPath();
            }
        }
        return path;
    }

    protected String getDeadZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/dead-servers";
    }

    public String getMasterStartUpLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/startup-masters";
    }

    public String getMasterFailoverLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/masters";
    }

    public String getWorkerFailoverLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/workers";
    }

    public void releaseMutex(InterProcessMutex mutex) {
        if (mutex != null) {
            try {
                mutex.release();
            }
            catch (Exception e) {
                if (e.getMessage().equals("instance must be started before calling this method")) {
                    logger.warn("lock release");
                }
                logger.error("lock release failed", (Throwable)e);
            }
        }
    }

    protected void initSystemZNode() {
        try {
            this.persist(this.getMasterZNodeParentPath(), "");
            this.persist(this.getWorkerZNodeParentPath(), "");
            this.persist(this.getDeadZNodeParentPath(), "");
            logger.info("initialize server nodes success.");
        }
        catch (Exception e) {
            logger.error("init system znode failed", (Throwable)e);
        }
    }

    protected String getHostByEventDataPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            logger.error("empty path!");
            return "";
        }
        String[] pathArray = path.split("/");
        if (pathArray.length < 1) {
            logger.error("parse ip error: {}", (Object)path);
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public String toString() {
        return "AbstractZKClient{zkClient=" + this.zkClient + ", deadServerZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.DEAD_SERVER) + '\'' + ", masterZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.MASTER) + '\'' + ", workerZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.WORKER) + '\'' + '}';
    }
}

