/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.service.quartz.cron.CycleLinks;

public abstract class AbstractCycle {
    protected Cron cron;
    protected CronField minField;
    protected CronField hourField;
    protected CronField dayOfMonthField;
    protected CronField dayOfWeekField;
    protected CronField monthField;
    protected CronField yearField;

    public CycleLinks addCycle(AbstractCycle cycle) {
        return new CycleLinks(this.cron).addCycle(this).addCycle(cycle);
    }

    public AbstractCycle(Cron cron) {
        if (cron == null) {
            throw new IllegalArgumentException("cron must not be null!");
        }
        this.cron = cron;
        this.minField = cron.retrieve(CronFieldName.MINUTE);
        this.hourField = cron.retrieve(CronFieldName.HOUR);
        this.dayOfMonthField = cron.retrieve(CronFieldName.DAY_OF_MONTH);
        this.dayOfWeekField = cron.retrieve(CronFieldName.DAY_OF_WEEK);
        this.monthField = cron.retrieve(CronFieldName.MONTH);
        this.yearField = cron.retrieve(CronFieldName.YEAR);
    }

    protected boolean minFiledIsSetAll() {
        FieldExpression minFieldExpression = this.minField.getExpression();
        return minFieldExpression instanceof Every || minFieldExpression instanceof Always || minFieldExpression instanceof Between || minFieldExpression instanceof And || minFieldExpression instanceof On;
    }

    protected boolean minFiledIsEvery() {
        FieldExpression minFieldExpression = this.minField.getExpression();
        return minFieldExpression instanceof Every || minFieldExpression instanceof Always;
    }

    protected boolean hourFiledIsSetAll() {
        FieldExpression hourFieldExpression = this.hourField.getExpression();
        return hourFieldExpression instanceof Every || hourFieldExpression instanceof Always || hourFieldExpression instanceof Between || hourFieldExpression instanceof And || hourFieldExpression instanceof On;
    }

    protected boolean hourFiledIsEvery() {
        FieldExpression hourFieldExpression = this.hourField.getExpression();
        return hourFieldExpression instanceof Every || hourFieldExpression instanceof Always;
    }

    protected boolean dayOfMonthFieldIsSetAll() {
        return this.dayOfMonthField.getExpression() instanceof Every || this.dayOfMonthField.getExpression() instanceof Always || this.dayOfMonthField.getExpression() instanceof Between || this.dayOfMonthField.getExpression() instanceof And || this.dayOfMonthField.getExpression() instanceof On;
    }

    protected boolean dayOfMonthFieldIsEvery() {
        return this.dayOfMonthField.getExpression() instanceof Every || this.dayOfMonthField.getExpression() instanceof Always;
    }

    protected boolean monthFieldIsSetAll() {
        FieldExpression monthFieldExpression = this.monthField.getExpression();
        return monthFieldExpression instanceof Every || monthFieldExpression instanceof Always || monthFieldExpression instanceof Between || monthFieldExpression instanceof And || monthFieldExpression instanceof On;
    }

    protected boolean monthFieldIsEvery() {
        FieldExpression monthFieldExpression = this.monthField.getExpression();
        return monthFieldExpression instanceof Every || monthFieldExpression instanceof Always;
    }

    protected boolean dayofWeekFieldIsSetAll() {
        FieldExpression dayOfWeekFieldExpression = this.dayOfWeekField.getExpression();
        return dayOfWeekFieldExpression instanceof Every || dayOfWeekFieldExpression instanceof Always || dayOfWeekFieldExpression instanceof Between || dayOfWeekFieldExpression instanceof And || dayOfWeekFieldExpression instanceof On;
    }

    protected boolean dayofWeekFieldIsEvery() {
        FieldExpression dayOfWeekFieldExpression = this.dayOfWeekField.getExpression();
        return dayOfWeekFieldExpression instanceof Every || dayOfWeekFieldExpression instanceof Always;
    }

    protected abstract CycleEnum getCycle();

    protected abstract CycleEnum getMiniCycle();
}

