/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.service.quartz.cron.CycleFactory;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtils {
    private static final Logger logger = LoggerFactory.getLogger(CronUtils.class);
    private static final CronParser QUARTZ_CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));

    private CronUtils() {
        throw new IllegalStateException("CronUtils class");
    }

    public static Cron parse2Cron(String cronExpression) {
        return QUARTZ_CRON_PARSER.parse(cronExpression);
    }

    public static CronExpression parse2CronExpression(String cronExpression) throws ParseException {
        return new CronExpression(cronExpression);
    }

    public static CycleEnum getMaxCycle(Cron cron) {
        return CycleFactory.min(cron).addCycle(CycleFactory.hour(cron)).addCycle(CycleFactory.day(cron)).addCycle(CycleFactory.week(cron)).addCycle(CycleFactory.month(cron)).getCycle();
    }

    public static CycleEnum getMiniCycle(Cron cron) {
        return CycleFactory.min(cron).addCycle(CycleFactory.hour(cron)).addCycle(CycleFactory.day(cron)).addCycle(CycleFactory.week(cron)).addCycle(CycleFactory.month(cron)).getMiniCycle();
    }

    public static CycleEnum getMaxCycle(String crontab) {
        return CronUtils.getMaxCycle(CronUtils.parse2Cron(crontab));
    }

    public static List<Date> getFireDateList(Date startTime, Date endTime, CronExpression cronExpression) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (Stopper.isRunning() && !(startTime = cronExpression.getNextValidTimeAfter(startTime)).after(endTime)) {
            dateList.add(startTime);
        }
        return dateList;
    }

    public static List<Date> getSelfFireDateList(Date startTime, Date endTime, CronExpression cronExpression, int fireTimes) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (fireTimes > 0 && !(startTime = cronExpression.getNextValidTimeAfter(startTime)).after(endTime) && !startTime.equals(endTime)) {
            dateList.add(startTime);
            --fireTimes;
        }
        return dateList;
    }

    public static List<Date> getSelfFireDateList(Date startTime, Date endTime, CronExpression cronExpression) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (Stopper.isRunning() && !(startTime = cronExpression.getNextValidTimeAfter(startTime)).after(endTime) && !startTime.equals(endTime)) {
            dateList.add(startTime);
        }
        return dateList;
    }

    public static List<Date> getSelfFireDateList(Date startTime, Date endTime, String cron) {
        CronExpression cronExpression = null;
        try {
            cronExpression = CronUtils.parse2CronExpression(cron);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        return CronUtils.getSelfFireDateList(startTime, endTime, cronExpression);
    }

    public static Date getExpirationTime(Date startTime, CycleEnum cycleEnum) {
        Date maxExpirationTime = null;
        Date startTimeMax = null;
        try {
            startTimeMax = CronUtils.getEndTime(startTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            switch (cycleEnum) {
                case HOUR: {
                    calendar.add(10, 1);
                    break;
                }
                case DAY: {
                    calendar.add(5, 1);
                    break;
                }
                case WEEK: {
                    calendar.add(5, 1);
                    break;
                }
                case MONTH: {
                    calendar.add(5, 1);
                    break;
                }
                default: {
                    logger.error("Dependent process definition's  cycleEnum is {},not support!!", (Object)cycleEnum);
                }
            }
            maxExpirationTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return DateUtils.compare((Date)startTimeMax, maxExpirationTime) ? maxExpirationTime : startTimeMax;
    }

    private static Date getEndTime(Date date) {
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(date);
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        end.set(14, 999);
        return end.getTime();
    }
}

