/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.permission;

import java.util.List;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;

public class PermissionCheck<T> {
    private Logger logger;
    private AuthorizationType authorizationType;
    private ProcessService processService;
    private T[] needChecks;
    private List<ResourceInfo> resourceList;
    private int userId;

    public PermissionCheck(AuthorizationType authorizationType, ProcessService processService) {
        this.authorizationType = authorizationType;
        this.processService = processService;
    }

    public PermissionCheck(AuthorizationType authorizationType, ProcessService processService, T[] needChecks, int userId) {
        this.authorizationType = authorizationType;
        this.processService = processService;
        this.needChecks = needChecks;
        this.userId = userId;
    }

    public PermissionCheck(AuthorizationType authorizationType, ProcessService processService, T[] needChecks, int userId, Logger logger) {
        this.authorizationType = authorizationType;
        this.processService = processService;
        this.needChecks = needChecks;
        this.userId = userId;
        this.logger = logger;
    }

    public PermissionCheck(AuthorizationType authorizationType, ProcessService processService, List<ResourceInfo> resourceList, int userId, Logger logger) {
        this.authorizationType = authorizationType;
        this.processService = processService;
        this.resourceList = resourceList;
        this.userId = userId;
        this.logger = logger;
    }

    public AuthorizationType getAuthorizationType() {
        return this.authorizationType;
    }

    public void setAuthorizationType(AuthorizationType authorizationType) {
        this.authorizationType = authorizationType;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public T[] getNeedChecks() {
        return this.needChecks;
    }

    public void setNeedChecks(T[] needChecks) {
        this.needChecks = needChecks;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public List<ResourceInfo> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(List<ResourceInfo> resourceList) {
        this.resourceList = resourceList;
    }

    public boolean hasPermission() {
        try {
            this.checkPermission();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void checkPermission() throws Exception {
        if (this.needChecks.length > 0) {
            List<T> unauthorizedList;
            User user = this.processService.getUserById(this.userId);
            if (user == null) {
                this.logger.error("user id {} didn't exist", (Object)this.userId);
                throw new RuntimeException(String.format("user %s didn't exist", this.userId));
            }
            if (user.getUserType() != UserType.ADMIN_USER && CollectionUtils.isNotEmpty(unauthorizedList = this.processService.listUnauthorized(this.userId, this.needChecks, this.authorizationType))) {
                this.logger.error("user {} didn't has permission of {}: {}", new Object[]{user.getUserName(), this.authorizationType.getDescp(), unauthorizedList});
                throw new RuntimeException(String.format("user %s didn't has permission of %s %s", user.getUserName(), this.authorizationType.getDescp(), unauthorizedList.get(0)));
            }
        }
    }
}

