/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.dolphinscheduler.service.zk.AbstractListener;
import org.apache.dolphinscheduler.service.zk.ZookeeperOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperCachedOperator
extends ZookeeperOperator {
    private final Logger logger = LoggerFactory.getLogger(ZookeeperCachedOperator.class);
    private TreeCache treeCache;
    private List<AbstractListener> listenerList = new CopyOnWriteArrayList<AbstractListener>();

    @Override
    public void registerListener(AbstractListener abstractListener) {
        this.logger.info("register zookeeper listener: {}", (Object)abstractListener.getClass().getName());
        this.listenerList.add(abstractListener);
        this.listenerList.sort(AbstractListener::compareTo);
    }

    @Override
    protected void treeCacheStart() {
        this.treeCache = new TreeCache(this.zkClient, this.getZookeeperConfig().getDsRoot() + "/nodes");
        this.logger.info("add listener to zk path: {}", (Object)this.getZookeeperConfig().getDsRoot());
        try {
            this.treeCache.start();
        }
        catch (Exception e) {
            this.logger.error("add listener to zk path: {} failed", (Object)this.getZookeeperConfig().getDsRoot());
            throw new RuntimeException(e);
        }
        this.treeCache.getListenable().addListener((client, event) -> {
            for (AbstractListener abstractListener : this.listenerList) {
                this.logger.debug("zookeeperListener:{} triggered", (Object)abstractListener.getClass().getName());
                abstractListener.childEvent(client, event);
            }
        });
    }

    @Override
    public void close() {
        this.treeCache.close();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.close();
    }
}

