/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.dolphinscheduler.common.utils.Preconditions;
import org.apache.dolphinscheduler.service.zk.AbstractListener;
import org.apache.dolphinscheduler.service.zk.DefaultEnsembleProvider;
import org.apache.dolphinscheduler.service.zk.ZookeeperConfig;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperOperator
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ZookeeperOperator.class);
    @Autowired
    private ZookeeperConfig zookeeperConfig;
    protected CuratorFramework zkClient;

    public void afterPropertiesSet() {
        this.zkClient = this.buildClient();
        this.initStateListener();
        this.treeCacheStart();
    }

    protected void registerListener(AbstractListener abstractListener) {
    }

    protected void treeCacheStart() {
    }

    public void initStateListener() {
        Preconditions.checkNotNull((Object)this.zkClient);
        this.zkClient.getConnectionStateListenable().addListener((client, newState) -> {
            if (newState == ConnectionState.LOST) {
                this.logger.error("connection lost from zookeeper");
            } else if (newState == ConnectionState.RECONNECTED) {
                this.logger.info("reconnected to zookeeper");
            } else if (newState == ConnectionState.SUSPENDED) {
                this.logger.warn("connection SUSPENDED to zookeeper");
            }
        });
    }

    private CuratorFramework buildClient() {
        this.logger.info("zookeeper registry center init, server lists is: {}.", (Object)this.zookeeperConfig.getServerList());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().ensembleProvider((EnsembleProvider)new DefaultEnsembleProvider((String)Preconditions.checkNotNull((Object)this.zookeeperConfig.getServerList(), (String)"zookeeper quorum can't be null"))).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.zookeeperConfig.getBaseSleepTimeMs(), this.zookeeperConfig.getMaxRetries(), this.zookeeperConfig.getMaxSleepMs()));
        if (0 != this.zookeeperConfig.getSessionTimeoutMs()) {
            builder.sessionTimeoutMs(this.zookeeperConfig.getSessionTimeoutMs());
        }
        if (0 != this.zookeeperConfig.getConnectionTimeoutMs()) {
            builder.connectionTimeoutMs(this.zookeeperConfig.getConnectionTimeoutMs());
        }
        if (StringUtils.isNotBlank((String)this.zookeeperConfig.getDigest())) {
            builder.authorization("digest", this.zookeeperConfig.getDigest().getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.zkClient = builder.build();
        this.zkClient.start();
        try {
            this.zkClient.blockUntilConnected();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this.zkClient;
    }

    public String get(String key) {
        try {
            return new String((byte[])this.zkClient.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            this.logger.error("get key : {}", (Object)key, (Object)ex);
            return null;
        }
    }

    public List<String> getChildrenKeys(String key) {
        try {
            return (List)this.zkClient.getChildren().forPath(key);
        }
        catch (KeeperException.NoNodeException ex) {
            return new ArrayList<String>();
        }
        catch (InterruptedException ex) {
            this.logger.error("getChildrenKeys key : {} InterruptedException", (Object)key);
            throw new IllegalStateException(ex);
        }
        catch (Exception ex) {
            this.logger.error("getChildrenKeys key : {}", (Object)key, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean isExisted(String key) {
        try {
            return this.zkClient.checkExists().forPath(key) != null;
        }
        catch (Exception ex) {
            this.logger.error("isExisted key : {}", (Object)key, (Object)ex);
            return false;
        }
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            this.logger.error("persist key : {} , value : {}", new Object[]{key, value, ex});
        }
    }

    public void update(String key, String value) {
        try {
            ((CuratorTransactionBridge)((CuratorTransactionBridge)this.zkClient.inTransaction().check().forPath(key)).and().setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))).and().commit();
        }
        catch (Exception ex) {
            this.logger.error("update key : {} , value : {}", new Object[]{key, value, ex});
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.update(key, value);
            } else {
                ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception ex) {
            this.logger.error("persistEphemeral key : {} , value : {}", new Object[]{key, value, ex});
        }
    }

    public void remove(String key) {
        try {
            if (this.isExisted(key)) {
                this.zkClient.delete().deletingChildrenIfNeeded().forPath(key);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception ex) {
            this.logger.error("remove key : {}", (Object)key, (Object)ex);
        }
    }

    public CuratorFramework getZkClient() {
        return this.zkClient;
    }

    public ZookeeperConfig getZookeeperConfig() {
        return this.zookeeperConfig;
    }

    public void close() {
        CloseableUtils.closeQuietly((Closeable)this.zkClient);
    }
}

