/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.utils.PropertyUtils;
import org.apache.dolphinscheduler.service.quartz.DruidConnectionProvider;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.SimpleThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzExecutors {
    private static final Logger logger = LoggerFactory.getLogger(QuartzExecutors.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static Scheduler scheduler;
    private static volatile QuartzExecutors INSTANCE;
    private static Configuration conf;

    private QuartzExecutors() {
        try {
            conf = new PropertiesConfiguration("quartz.properties");
        }
        catch (ConfigurationException e) {
            logger.warn("not loaded quartz configuration file, will used default value", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuartzExecutors getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<QuartzExecutors> clazz = QuartzExecutors.class;
        synchronized (QuartzExecutors.class) {
            if (INSTANCE != null) return INSTANCE;
            QuartzExecutors quartzExecutors = new QuartzExecutors();
            quartzExecutors.init();
            INSTANCE = quartzExecutors;
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void init() {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            Properties properties = new Properties();
            String dataSourceDriverClass = PropertyUtils.getString((String)"spring.datasource.driver-class-name");
            if (dataSourceDriverClass.equals("org.postgresql.Driver")) {
                properties.setProperty("org.quartz.jobStore.driverDelegateClass", conf.getString("org.quartz.jobStore.driverDelegateClass", PostgreSQLDelegate.class.getName()));
            } else {
                properties.setProperty("org.quartz.jobStore.driverDelegateClass", conf.getString("org.quartz.jobStore.driverDelegateClass", StdJDBCDelegate.class.getName()));
            }
            properties.setProperty("org.quartz.scheduler.instanceName", conf.getString("org.quartz.scheduler.instanceName", "DolphinScheduler"));
            properties.setProperty("org.quartz.scheduler.instanceId", conf.getString("org.quartz.scheduler.instanceId", "AUTO"));
            properties.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", conf.getString("org.quartz.scheduler.makeSchedulerThreadDaemon", "true"));
            properties.setProperty("org.quartz.jobStore.useProperties", conf.getString("org.quartz.jobStore.useProperties", "false"));
            properties.setProperty("org.quartz.threadPool.class", conf.getString("org.quartz.threadPool.class", SimpleThreadPool.class.getName()));
            properties.setProperty("org.quartz.threadPool.makeThreadsDaemons", conf.getString("org.quartz.threadPool.makeThreadsDaemons", "true"));
            properties.setProperty("org.quartz.threadPool.threadCount", conf.getString("org.quartz.threadPool.threadCount", "25"));
            properties.setProperty("org.quartz.threadPool.threadPriority", conf.getString("org.quartz.threadPool.threadPriority", "5"));
            properties.setProperty("org.quartz.jobStore.class", conf.getString("org.quartz.jobStore.class", JobStoreTX.class.getName()));
            properties.setProperty("org.quartz.jobStore.tablePrefix", conf.getString("org.quartz.jobStore.tablePrefix", "QRTZ_"));
            properties.setProperty("org.quartz.jobStore.isClustered", conf.getString("org.quartz.jobStore.isClustered", "true"));
            properties.setProperty("org.quartz.jobStore.misfireThreshold", conf.getString("org.quartz.jobStore.misfireThreshold", "60000"));
            properties.setProperty("org.quartz.jobStore.clusterCheckinInterval", conf.getString("org.quartz.jobStore.clusterCheckinInterval", "5000"));
            properties.setProperty("org.quartz.jobStore.acquireTriggersWithinLock", conf.getString("org.quartz.jobStore.acquireTriggersWithinLock", "true"));
            properties.setProperty("org.quartz.jobStore.dataSource", conf.getString("org.quartz.jobStore.dataSource", "myDs"));
            properties.setProperty("org.quartz.dataSource.myDs.connectionProvider.class", conf.getString("org.quartz.dataSource.myDs.connectionProvider.class", DruidConnectionProvider.class.getName()));
            schedulerFactory.initialize(properties);
            scheduler = schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws SchedulerException {
        if (!scheduler.isStarted()) {
            scheduler.start();
            logger.info("Quartz service started");
        }
    }

    public void shutdown() throws SchedulerException {
        if (!scheduler.isShutdown()) {
            scheduler.shutdown();
            logger.info("Quartz service stopped, and halt all tasks");
        }
    }

    public void addJob(Class<? extends Job> clazz, String jobName, String jobGroupName, Date startDate, Date endDate, String cronExpression, Map<String, Object> jobDataMap) {
        this.lock.writeLock().lock();
        try {
            JobDetail jobDetail;
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (scheduler.checkExists(jobKey)) {
                jobDetail = scheduler.getJobDetail(jobKey);
                if (jobDataMap != null) {
                    jobDetail.getJobDataMap().putAll(jobDataMap);
                }
            } else {
                jobDetail = JobBuilder.newJob(clazz).withIdentity(jobKey).build();
                if (jobDataMap != null) {
                    jobDetail.getJobDataMap().putAll(jobDataMap);
                }
                scheduler.addJob(jobDetail, false, true);
                logger.info("Add job, job name: {}, group name: {}", (Object)jobName, (Object)jobGroupName);
            }
            TriggerKey triggerKey = new TriggerKey(jobName, jobGroupName);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(startDate).endAt(endDate).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing()).forJob(jobDetail).build();
            if (scheduler.checkExists(triggerKey)) {
                CronTrigger oldCronTrigger = (CronTrigger)scheduler.getTrigger(triggerKey);
                String oldCronExpression = oldCronTrigger.getCronExpression();
                if (!StringUtils.equalsIgnoreCase((String)cronExpression, (String)oldCronExpression)) {
                    scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
                    logger.info("reschedule job trigger, triggerName: {}, triggerGroupName: {}, cronExpression: {}, startDate: {}, endDate: {}", new Object[]{jobName, jobGroupName, cronExpression, startDate, endDate});
                }
            } else {
                scheduler.scheduleJob((Trigger)cronTrigger);
                logger.info("schedule job trigger, triggerName: {}, triggerGroupName: {}, cronExpression: {}, startDate: {}, endDate: {}", new Object[]{jobName, jobGroupName, cronExpression, startDate, endDate});
            }
        }
        catch (Exception e) {
            logger.error("add job failed", (Throwable)e);
            throw new RuntimeException("add job failed", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteJob(String jobName, String jobGroupName) {
        this.lock.writeLock().lock();
        try {
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (scheduler.checkExists(jobKey)) {
                logger.info("try to delete job, job name: {}, job group name: {},", (Object)jobName, (Object)jobGroupName);
                boolean bl = scheduler.deleteJob(jobKey);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SchedulerException e) {
            logger.error("delete job : {} failed", (Object)jobName, (Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAllJobs(String jobGroupName) {
        this.lock.writeLock().lock();
        try {
            logger.info("try to delete all jobs in job group: {}", (Object)jobGroupName);
            ArrayList jobKeys = new ArrayList();
            jobKeys.addAll(scheduler.getJobKeys(GroupMatcher.groupEndsWith((String)jobGroupName)));
            boolean bl = scheduler.deleteJobs(jobKeys);
            return bl;
        }
        catch (SchedulerException e) {
            logger.error("delete all jobs in job group: {} failed", (Object)jobGroupName, (Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return false;
    }

    public static String buildJobName(int processId) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("job").append("_").append(processId);
        return sb.toString();
    }

    public static String buildJobGroupName(int projectId) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("jobgroup").append("_").append(projectId);
        return sb.toString();
    }

    public static Map<String, Object> buildDataMap(int projectId, int scheduleId, Schedule schedule) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        dataMap.put("projectId", projectId);
        dataMap.put("scheduleId", scheduleId);
        dataMap.put("schedule", JSONUtils.toJson((Object)schedule));
        return dataMap;
    }

    static {
        INSTANCE = null;
    }
}

