/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.ResInfo;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.service.zk.RegisterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractZKClient
extends RegisterOperator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractZKClient.class);

    public int getActiveMasterNum() {
        List<Object> childrenList = new ArrayList();
        try {
            if (super.isExisted(this.getZNodeParentPath(ZKNodeType.MASTER))) {
                childrenList = super.getChildrenKeys(this.getZNodeParentPath(ZKNodeType.MASTER));
            }
        }
        catch (Exception e) {
            logger.error("getActiveMasterNum error", (Throwable)e);
        }
        return childrenList.size();
    }

    public String getZookeeperQuorum() {
        return this.getZookeeperConfig().getServerList();
    }

    public List<Server> getServerList(ZKNodeType zkNodeType) {
        Map<String, String> serverMaps = this.getServerMaps(zkNodeType);
        String parentPath = this.getZNodeParentPath(zkNodeType);
        ArrayList<Server> serverList = new ArrayList<Server>();
        for (Map.Entry<String, String> entry : serverMaps.entrySet()) {
            Server server = ResInfo.parseHeartbeatForZKInfo((String)entry.getValue());
            if (server == null) continue;
            String key = entry.getKey();
            server.setZkDirectory(parentPath + "/" + key);
            String[] hostAndPort = key.split(":");
            String[] hosts = hostAndPort[0].split("/");
            server.setHost(hosts[hosts.length - 1]);
            server.setPort(Integer.parseInt(hostAndPort[1]));
            serverList.add(server);
        }
        return serverList;
    }

    public List<String> getServerZkNodes(ZKNodeType zkNodeType) {
        String path = this.getZNodeParentPath(zkNodeType);
        List<String> serverList = super.getChildrenKeys(path);
        if (zkNodeType == ZKNodeType.WORKER) {
            ArrayList<String> workerList = new ArrayList<String>();
            for (String group : serverList) {
                List<String> groupServers = super.getChildrenKeys(path + "/" + group);
                for (String groupServer : groupServers) {
                    workerList.add(group + "/" + groupServer);
                }
            }
            serverList = workerList;
        }
        return serverList;
    }

    public Map<String, String> getServerMaps(ZKNodeType zkNodeType, boolean hostOnly) {
        HashMap<String, String> serverMap = new HashMap<String, String>();
        try {
            String path = this.getZNodeParentPath(zkNodeType);
            List<String> serverList = this.getServerZkNodes(zkNodeType);
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext()) {
                String server;
                String host = server = iterator.next();
                if (zkNodeType == ZKNodeType.WORKER && hostOnly) {
                    host = server.split("/")[1];
                }
                serverMap.putIfAbsent(host, super.get(path + "/" + server));
            }
        }
        catch (Exception e) {
            logger.error("get server list failed", (Throwable)e);
        }
        return serverMap;
    }

    public Map<String, String> getServerMaps(ZKNodeType zkNodeType) {
        return this.getServerMaps(zkNodeType, false);
    }

    public Set<String> getServerNodeSet(ZKNodeType zkNodeType, boolean hostOnly) {
        HashSet<String> serverSet = new HashSet<String>();
        try {
            List<String> serverList = this.getServerZkNodes(zkNodeType);
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext()) {
                String server;
                String host = server = iterator.next();
                if (zkNodeType == ZKNodeType.WORKER && hostOnly) {
                    host = server.split("/")[1];
                }
                serverSet.add(host);
            }
        }
        catch (Exception e) {
            logger.error("get server node set failed", (Throwable)e);
        }
        return serverSet;
    }

    public List<String> getServerNodeList(ZKNodeType zkNodeType, boolean hostOnly) {
        Set<String> serverSet = this.getServerNodeSet(zkNodeType, hostOnly);
        ArrayList<String> serverList = new ArrayList<String>(serverSet);
        Collections.sort(serverList);
        return serverList;
    }

    public boolean checkZKNodeExists(String host, ZKNodeType zkNodeType) {
        String path = this.getZNodeParentPath(zkNodeType);
        if (StringUtils.isEmpty((CharSequence)path)) {
            logger.error("check zk node exists error, host:{}, zk node type:{}", (Object)host, (Object)zkNodeType);
            return false;
        }
        Map<String, String> serverMaps = this.getServerMaps(zkNodeType, true);
        for (String hostKey : serverMaps.keySet()) {
            if (!hostKey.contains(host)) continue;
            return true;
        }
        return false;
    }

    protected String getWorkerZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/nodes/worker";
    }

    protected String getMasterZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/nodes/master";
    }

    public String getMasterLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/masters";
    }

    public String getZNodeParentPath(ZKNodeType zkNodeType) {
        String path = "";
        switch (zkNodeType) {
            case MASTER: {
                return this.getMasterZNodeParentPath();
            }
            case WORKER: {
                return this.getWorkerZNodeParentPath();
            }
            case DEAD_SERVER: {
                return this.getDeadZNodeParentPath();
            }
        }
        return path;
    }

    public String getMasterStartUpLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/startup-masters";
    }

    public String getMasterFailoverLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/masters";
    }

    public String getWorkerFailoverLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/workers";
    }

    public void releaseMutex(InterProcessMutex mutex) {
        if (mutex != null) {
            try {
                mutex.release();
            }
            catch (Exception e) {
                if ("instance must be started before calling this method".equals(e.getMessage())) {
                    logger.warn("lock release");
                }
                logger.error("lock release failed", (Throwable)e);
            }
        }
    }

    protected void initSystemZNode() {
        try {
            this.persist(this.getMasterZNodeParentPath(), "");
            this.persist(this.getWorkerZNodeParentPath(), "");
            this.persist(this.getDeadZNodeParentPath(), "");
            logger.info("initialize server nodes success.");
        }
        catch (Exception e) {
            logger.error("init system znode failed", (Throwable)e);
        }
    }

    public String toString() {
        return "AbstractZKClient{zkClient=" + this.getZkClient() + ", deadServerZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.DEAD_SERVER) + '\'' + ", masterZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.MASTER) + '\'' + ", workerZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.WORKER) + '\'' + '}';
    }
}

