/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import java.util.List;
import java.util.Set;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.service.zk.ZookeeperCachedOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RegisterOperator
extends ZookeeperCachedOperator {
    private final Logger logger = LoggerFactory.getLogger(RegisterOperator.class);

    protected String getDeadZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/dead-servers";
    }

    public void removeDeadServerByHost(String host, String serverType) throws Exception {
        List<String> deadServers = super.getChildrenKeys(this.getDeadZNodeParentPath());
        for (String serverPath : deadServers) {
            if (!serverPath.startsWith(serverType + "_" + host)) continue;
            String server = this.getDeadZNodeParentPath() + "/" + serverPath;
            super.remove(server);
            this.logger.info("{} server {} deleted from zk dead server path success", (Object)serverType, (Object)host);
        }
    }

    protected String getHostByEventDataPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            this.logger.error("empty path!");
            return "";
        }
        String[] pathArray = path.split("/");
        if (pathArray.length < 1) {
            this.logger.error("parse ip error: {}", (Object)path);
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public void handleDeadServer(String zNode, ZKNodeType zkNodeType, String opType) throws Exception {
        String deadServerPath;
        String type;
        String host = this.getHostByEventDataPath(zNode);
        String string = type = zkNodeType == ZKNodeType.MASTER ? "master" : "worker";
        if (opType.equals("delete")) {
            this.removeDeadServerByHost(host, type);
        } else if (opType.equals("add") && !super.isExisted(deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + host)) {
            super.persist(deadServerPath, type + "_" + host);
            this.logger.info("{} server dead , and {} added to zk dead server path success", (Object)zkNodeType, (Object)zNode);
        }
    }

    public void handleDeadServer(Set<String> zNodeSet, ZKNodeType zkNodeType, String opType) throws Exception {
        String type = zkNodeType == ZKNodeType.MASTER ? "master" : "worker";
        for (String zNode : zNodeSet) {
            String deadServerPath;
            String host = this.getHostByEventDataPath(zNode);
            if (opType.equals("delete")) {
                this.removeDeadServerByHost(host, type);
                continue;
            }
            if (!opType.equals("add") || super.isExisted(deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + host)) continue;
            super.persist(deadServerPath, type + "_" + host);
            this.logger.info("{} server dead , and {} added to zk dead server path success", (Object)zkNodeType, (Object)zNode);
        }
    }
}

