/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.zk;

import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:zookeeper.properties"})
public class ZookeeperConfig {
    @Value(value="${zookeeper.quorum}")
    private String serverList;
    @Value(value="${zookeeper.retry.base.sleep:100}")
    private int baseSleepTimeMs;
    @Value(value="${zookeeper.retry.max.sleep:30000}")
    private int maxSleepMs;
    @Value(value="${zookeeper.retry.maxtime:10}")
    private int maxRetries;
    @Value(value="${zookeeper.session.timeout:60000}")
    private int sessionTimeoutMs;
    @Value(value="${zookeeper.connection.timeout:30000}")
    private int connectionTimeoutMs;
    @Value(value="${zookeeper.connection.digest: }")
    private String digest;
    @Value(value="${zookeeper.dolphinscheduler.root:/dolphinscheduler}")
    private String dsRoot;
    @Value(value="${zookeeper.max.wait.time:10000}")
    private int maxWaitTime;

    public String getServerList() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("zookeeper.quorum"))) {
            return System.getProperty("zookeeper.quorum");
        }
        return this.serverList;
    }

    public void setServerList(String serverList) {
        this.serverList = serverList;
    }

    public int getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    public void setBaseSleepTimeMs(int baseSleepTimeMs) {
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    public int getMaxSleepMs() {
        return this.maxSleepMs;
    }

    public void setMaxSleepMs(int maxSleepMs) {
        this.maxSleepMs = maxSleepMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDsRoot() {
        return this.dsRoot;
    }

    public void setDsRoot(String dsRoot) {
        this.dsRoot = dsRoot;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }
}

