/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.HeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.service.registry.RegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryClient
extends RegistryCenter {
    private static final Logger logger = LoggerFactory.getLogger(RegistryClient.class);
    private static RegistryClient registryClient = new RegistryClient();

    private RegistryClient() {
    }

    public static RegistryClient getInstance() {
        return registryClient;
    }

    public int getActiveMasterNum() {
        List<Object> childrenList = new ArrayList();
        try {
            if (this.isExisted(this.getNodeParentPath(NodeType.MASTER))) {
                childrenList = this.getChildrenKeys(this.getNodeParentPath(NodeType.MASTER));
            }
        }
        catch (Exception e) {
            logger.error("getActiveMasterNum error", (Throwable)e);
        }
        return childrenList.size();
    }

    public List<Server> getServerList(NodeType nodeType) {
        Map<String, String> serverMaps = this.getServerMaps(nodeType);
        String parentPath = this.getNodeParentPath(nodeType);
        ArrayList<Server> serverList = new ArrayList<Server>();
        for (Map.Entry<String, String> entry : serverMaps.entrySet()) {
            HeartBeat heartBeat = HeartBeat.decodeHeartBeat((String)entry.getValue());
            if (heartBeat == null) continue;
            Server server = new Server();
            server.setResInfo(JSONUtils.toJsonString((Object)heartBeat));
            server.setCreateTime(new Date(heartBeat.getStartupTime()));
            server.setLastHeartbeatTime(new Date(heartBeat.getReportTime()));
            server.setId(heartBeat.getProcessId());
            String key = entry.getKey();
            server.setZkDirectory(parentPath + "/" + key);
            String[] hostAndPort = key.split(":");
            String[] hosts = hostAndPort[0].split("/");
            server.setHost(hosts[hosts.length - 1]);
            server.setPort(Integer.parseInt(hostAndPort[1]));
            serverList.add(server);
        }
        return serverList;
    }

    public List<String> getServerNodes(NodeType nodeType) {
        String path = this.getNodeParentPath(nodeType);
        List<String> serverList = this.getChildrenKeys(path);
        if (nodeType == NodeType.WORKER) {
            ArrayList<String> workerList = new ArrayList<String>();
            for (String group : serverList) {
                List<String> groupServers = this.getChildrenKeys(path + "/" + group);
                for (String groupServer : groupServers) {
                    workerList.add(group + "/" + groupServer);
                }
            }
            serverList = workerList;
        }
        return serverList;
    }

    public Map<String, String> getServerMaps(NodeType nodeType, boolean hostOnly) {
        HashMap<String, String> serverMap = new HashMap<String, String>();
        try {
            String path = this.getNodeParentPath(nodeType);
            List<String> serverList = this.getServerNodes(nodeType);
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext()) {
                String server;
                String host = server = iterator.next();
                if (nodeType == NodeType.WORKER && hostOnly) {
                    host = server.split("/")[1];
                }
                serverMap.putIfAbsent(host, this.get(path + "/" + server));
            }
        }
        catch (Exception e) {
            logger.error("get server list failed", (Throwable)e);
        }
        return serverMap;
    }

    public Map<String, String> getServerMaps(NodeType nodeType) {
        return this.getServerMaps(nodeType, false);
    }

    public Set<String> getServerNodeSet(NodeType nodeType, boolean hostOnly) {
        HashSet<String> serverSet = new HashSet<String>();
        try {
            List<String> serverList = this.getServerNodes(nodeType);
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext()) {
                String server;
                String host = server = iterator.next();
                if (nodeType == NodeType.WORKER && hostOnly) {
                    host = server.split("/")[1];
                }
                serverSet.add(host);
            }
        }
        catch (Exception e) {
            logger.error("get server node set failed", (Throwable)e);
        }
        return serverSet;
    }

    public List<String> getServerNodeList(NodeType nodeType, boolean hostOnly) {
        Set<String> serverSet = this.getServerNodeSet(nodeType, hostOnly);
        ArrayList<String> serverList = new ArrayList<String>(serverSet);
        Collections.sort(serverList);
        return serverList;
    }

    public boolean checkNodeExists(String host, NodeType nodeType) {
        String path = this.getNodeParentPath(nodeType);
        if (StringUtils.isEmpty((String)path)) {
            logger.error("check zk node exists error, host:{}, zk node type:{}", (Object)host, (Object)nodeType);
            return false;
        }
        Map<String, String> serverMaps = this.getServerMaps(nodeType, true);
        for (String hostKey : serverMaps.keySet()) {
            if (!hostKey.contains(host)) continue;
            return true;
        }
        return false;
    }

    protected String getWorkerNodeParentPath() {
        return "/nodes/worker";
    }

    protected String getMasterNodeParentPath() {
        return "/nodes/master";
    }

    protected String getDeadNodeParentPath() {
        return "/dead-servers";
    }

    public String getMasterLockPath() {
        return "/lock/masters";
    }

    public String getNodeParentPath(NodeType nodeType) {
        String path = "";
        switch (nodeType) {
            case MASTER: {
                return this.getMasterNodeParentPath();
            }
            case WORKER: {
                return this.getWorkerNodeParentPath();
            }
            case DEAD_SERVER: {
                return this.getDeadNodeParentPath();
            }
        }
        return path;
    }

    public String getMasterStartUpLockPath() {
        return "/lock/failover/startup-masters";
    }

    public String getMasterFailoverLockPath() {
        return "/lock/failover/masters";
    }

    public String getWorkerFailoverLockPath() {
        return "/lock/failover/workers";
    }

    public void handleDeadServer(String node, NodeType nodeType, String opType) throws Exception {
        String deadServerPath;
        String type;
        String host = this.getHostByEventDataPath(node);
        String string = type = nodeType == NodeType.MASTER ? "master" : "worker";
        if (opType.equals("delete")) {
            this.removeDeadServerByHost(host, type);
        } else if (opType.equals("add") && !this.isExisted(deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + host)) {
            this.persist(deadServerPath, type + "_" + host);
            logger.info("{} server dead , and {} added to zk dead server path success", (Object)nodeType, (Object)node);
        }
    }

    public boolean checkIsDeadServer(String node, String serverType) throws Exception {
        String[] zNodesPath = node.split("\\/");
        String ipSeqNo = zNodesPath[zNodesPath.length - 1];
        String deadServerPath = this.getDeadZNodeParentPath() + "/" + serverType + "_" + ipSeqNo;
        return !this.isExisted(node) || this.isExisted(deadServerPath);
    }

    public Set<String> getMasterNodesDirectly() {
        List<String> masters = this.getChildrenKeys("/nodes/master");
        return new HashSet<String>(masters);
    }

    public Set<String> getWorkerNodesDirectly() {
        List<String> workers = this.getChildrenKeys("/nodes/worker");
        return new HashSet<String>(workers);
    }

    public Set<String> getWorkerGroupDirectly() {
        List<String> workers = this.getChildrenKeys("/nodes/worker");
        return new HashSet<String>(workers);
    }

    public Set<String> getWorkerGroupNodesDirectly(String workerGroup) {
        List<String> workers = this.getChildrenKeys(this.getWorkerGroupPath(workerGroup));
        return new HashSet<String>(workers);
    }

    public void handleDeadServer(Set<String> nodeSet, NodeType nodeType, String opType) throws Exception {
        String type = nodeType == NodeType.MASTER ? "master" : "worker";
        for (String node : nodeSet) {
            String deadServerPath;
            String host = this.getHostByEventDataPath(node);
            if (opType.equals("delete")) {
                this.removeDeadServerByHost(host, type);
                continue;
            }
            if (!opType.equals("add") || this.isExisted(deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + host)) continue;
            this.persist(deadServerPath, type + "_" + host);
            logger.info("{} server dead , and {} added to registry dead server path success", (Object)nodeType, (Object)node);
        }
    }

    public String getHostByEventDataPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            logger.error("empty path!");
            return "";
        }
        String[] pathArray = path.split("/");
        if (pathArray.length < 1) {
            logger.error("parse ip error: {}", (Object)path);
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public void removeDeadServerByHost(String host, String serverType) {
        List<String> deadServers = this.getChildrenKeys(this.getDeadZNodeParentPath());
        for (String serverPath : deadServers) {
            if (!serverPath.startsWith(serverType + "_" + host)) continue;
            String server = this.getDeadZNodeParentPath() + "/" + serverPath;
            this.remove(server);
            logger.info("{} server {} deleted from zk dead server path success", (Object)serverType, (Object)host);
        }
    }
}

