/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.queue;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.service.exceptions.TaskPriorityQueueException;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;

public class PeerTaskInstancePriorityQueue
implements TaskPriorityQueue<TaskInstance> {
    private static final Integer QUEUE_MAX_SIZE = 3000;
    private PriorityQueue<TaskInstance> queue = new PriorityQueue<TaskInstance>(QUEUE_MAX_SIZE, new TaskInfoComparator());
    private final ReentrantLock lock = new ReentrantLock(true);

    @Override
    public void put(TaskInstance taskInstance) throws TaskPriorityQueueException {
        this.queue.add(taskInstance);
    }

    @Override
    public TaskInstance take() throws TaskPriorityQueueException {
        return this.queue.poll();
    }

    @Override
    public TaskInstance poll(long timeout, TimeUnit unit) throws TaskPriorityQueueException {
        throw new TaskPriorityQueueException("This operation is not currently supported and suggest to use PriorityBlockingQueue if you want\uff01");
    }

    public TaskInstance peek() {
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public boolean contains(TaskInstance taskInstance) {
        return this.contains(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
    }

    public boolean contains(long taskCode, int taskVersion) {
        for (TaskInstance taskInstance : this.queue) {
            if (taskCode != taskInstance.getTaskCode() || taskVersion != taskInstance.getTaskDefinitionVersion()) continue;
            return true;
        }
        return false;
    }

    public boolean remove(TaskInstance taskInstance) {
        return this.queue.remove(taskInstance);
    }

    public Iterator<TaskInstance> iterator() {
        return this.queue.iterator();
    }

    private class TaskInfoComparator
    implements Comparator<TaskInstance> {
        private TaskInfoComparator() {
        }

        @Override
        public int compare(TaskInstance o1, TaskInstance o2) {
            return o1.getTaskInstancePriority().compareTo((Enum)o2.getTaskInstancePriority());
        }
    }
}

