/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Direct;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.DateInterval;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.task.subprocess.SubProcessParameters;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.TaskParametersUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.exceptions.ServiceException;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int[] stateArray = new int[]{ExecutionStatus.SUBMITTED_SUCCESS.ordinal(), ExecutionStatus.RUNNING_EXECUTION.ordinal(), ExecutionStatus.DELAY_EXECUTION.ordinal(), ExecutionStatus.READY_PAUSE.ordinal(), ExecutionStatus.READY_STOP.ordinal()};
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessDefinitionLogMapper processDefineLogMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private ProcessInstanceMapMapper processInstanceMapMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;
    @Autowired
    private EnvironmentMapper environmentMapper;

    @Transactional
    public ProcessInstance handleCommand(Logger logger, String host, Command command, HashMap<String, ProcessDefinition> processDefinitionCacheMaps) {
        ProcessInstance processInstance = this.constructProcessInstance(command, host, processDefinitionCacheMaps);
        if (processInstance == null) {
            logger.error("scan command, command parameter is error: {}", (Object)command);
            this.moveToErrorCommand(command, "process instance is null");
            return null;
        }
        processInstance.setCommandType(command.getCommandType());
        processInstance.addHistoryCmd(command.getCommandType());
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.deleteCommandWithCheck(command.getId());
        return processInstance;
    }

    public void moveToErrorCommand(Command command, String message) {
        ErrorCommand errorCommand = new ErrorCommand(command, message);
        this.errorCommandMapper.insert((Object)errorCommand);
        this.commandMapper.deleteById((Serializable)Integer.valueOf(command.getId()));
    }

    private ProcessInstance setWaitingThreadProcess(Command command, ProcessInstance processInstance) {
        processInstance.setState(ExecutionStatus.WAITING_THREAD);
        if (command.getCommandType() != CommandType.RECOVER_WAITING_THREAD) {
            processInstance.addHistoryCmd(command.getCommandType());
        }
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.createRecoveryWaitingThreadCommand(command, processInstance);
        return null;
    }

    public int createCommand(Command command) {
        int result = 0;
        if (command != null) {
            result = this.commandMapper.insert((Object)command);
        }
        return result;
    }

    public List<Command> findCommandPage(int pageSize, int pageNumber) {
        return this.commandMapper.queryCommandPage(pageSize, pageNumber * pageSize);
    }

    public boolean verifyIsNeedCreateCommand(Command command) {
        boolean isNeedCreate = true;
        EnumMap<CommandType, Integer> cmdTypeMap = new EnumMap<CommandType, Integer>(CommandType.class);
        cmdTypeMap.put(CommandType.REPEAT_RUNNING, 1);
        cmdTypeMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, 1);
        cmdTypeMap.put(CommandType.START_FAILURE_TASK_PROCESS, 1);
        CommandType commandType = command.getCommandType();
        if (cmdTypeMap.containsKey(commandType)) {
            ObjectNode cmdParamObj = JSONUtils.parseObject((String)command.getCommandParam());
            int processInstanceId = cmdParamObj.path("ProcessInstanceId").asInt();
            List commands = this.commandMapper.selectList(null);
            for (Command tmpCommand : commands) {
                ObjectNode tempObj;
                if (!cmdTypeMap.containsKey(tmpCommand.getCommandType()) || (tempObj = JSONUtils.parseObject((String)tmpCommand.getCommandParam())) == null || processInstanceId != tempObj.path("ProcessInstanceId").asInt()) continue;
                isNeedCreate = false;
                break;
            }
        }
        return isNeedCreate;
    }

    public ProcessInstance findProcessInstanceDetailById(int processId) {
        return this.processInstanceMapper.queryDetailById(processId);
    }

    public List<TaskDefinition> getTaskNodeListByDefinition(long defineCode) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(defineCode);
        if (processDefinition == null) {
            this.logger.error("process define not exists");
            return Lists.newArrayList();
        }
        List processTaskRelations = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinition.getCode(), processDefinition.getVersion());
        HashSet<TaskDefinition> taskDefinitionSet = new HashSet<TaskDefinition>();
        for (ProcessTaskRelationLog processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPostTaskCode() <= 0L) continue;
            taskDefinitionSet.add(new TaskDefinition(processTaskRelation.getPostTaskCode(), processTaskRelation.getPostTaskVersion()));
        }
        if (taskDefinitionSet.isEmpty()) {
            return Lists.newArrayList();
        }
        List taskDefinitionLogs = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitionSet);
        return Lists.newArrayList((Iterable)taskDefinitionLogs);
    }

    public ProcessInstance findProcessInstanceById(int processId) {
        return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(processId));
    }

    public ProcessDefinition findProcessDefineById(int processDefinitionId) {
        return (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(processDefinitionId));
    }

    public ProcessDefinition findProcessDefinition(Long processDefinitionCode, int version) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processDefinitionCode.longValue());
        if ((processDefinition == null || processDefinition.getVersion() != version) && (processDefinition = this.processDefineLogMapper.queryByDefinitionCodeAndVersion(processDefinitionCode.longValue(), version)) != null) {
            processDefinition.setId(0);
        }
        return processDefinition;
    }

    public ProcessDefinition findProcessDefinitionByCode(Long processDefinitionCode) {
        return this.processDefineMapper.queryByCode(processDefinitionCode.longValue());
    }

    public int deleteWorkProcessInstanceById(int processInstanceId) {
        return this.processInstanceMapper.deleteById((Serializable)Integer.valueOf(processInstanceId));
    }

    public int deleteAllSubWorkProcessByParentId(int processInstanceId) {
        List subProcessIdList = this.processInstanceMapMapper.querySubIdListByParentId(processInstanceId);
        for (Integer subId : subProcessIdList) {
            this.deleteAllSubWorkProcessByParentId(subId);
            this.deleteWorkProcessMapByParentId(subId);
            this.removeTaskLogFile(subId);
            this.deleteWorkProcessInstanceById(subId);
        }
        return 1;
    }

    public void removeTaskLogFile(Integer processInstanceId) {
        List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstanceId);
        if (CollectionUtils.isEmpty(taskInstanceList)) {
            return;
        }
        try (LogClientService logClient = new LogClientService();){
            for (TaskInstance taskInstance : taskInstanceList) {
                String taskLogPath = taskInstance.getLogPath();
                if (StringUtils.isEmpty((String)taskInstance.getHost())) continue;
                int port = 50051;
                String ip = "";
                try {
                    ip = Host.of((String)taskInstance.getHost()).getIp();
                }
                catch (Exception e) {
                    ip = taskInstance.getHost();
                }
                logClient.removeTaskLog(ip, port, taskLogPath);
            }
        }
    }

    public void recurseFindSubProcess(long parentCode, List<Long> ids) {
        List<TaskDefinition> taskNodeList = this.getTaskNodeListByDefinition(parentCode);
        if (taskNodeList != null && !taskNodeList.isEmpty()) {
            for (TaskDefinition taskNode : taskNodeList) {
                String parameter = taskNode.getTaskParams();
                ObjectNode parameterJson = JSONUtils.parseObject((String)parameter);
                if (parameterJson.get("processDefinitionCode") == null) continue;
                SubProcessParameters subProcessParam = (SubProcessParameters)JSONUtils.parseObject((String)parameter, SubProcessParameters.class);
                ids.add(subProcessParam.getProcessDefinitionCode());
                this.recurseFindSubProcess(subProcessParam.getProcessDefinitionCode(), ids);
            }
        }
    }

    public void createRecoveryWaitingThreadCommand(Command originCommand, ProcessInstance processInstance) {
        if (processInstance.getIsSubProcess() == Flag.YES) {
            if (originCommand != null) {
                this.commandMapper.deleteById((Serializable)Integer.valueOf(originCommand.getId()));
            }
            return;
        }
        HashMap<String, String> cmdParam = new HashMap<String, String>();
        cmdParam.put("WaitingThreadInstanceId", String.valueOf(processInstance.getId()));
        if (originCommand == null) {
            Command command = new Command(CommandType.RECOVER_WAITING_THREAD, processInstance.getTaskDependType(), processInstance.getFailureStrategy(), processInstance.getExecutorId(), processInstance.getProcessDefinition().getCode(), JSONUtils.toJsonString(cmdParam), processInstance.getWarningType(), processInstance.getWarningGroupId().intValue(), processInstance.getScheduleTime(), processInstance.getWorkerGroup(), processInstance.getEnvironmentCode(), processInstance.getProcessInstancePriority(), processInstance.getDryRun(), processInstance.getId(), processInstance.getProcessDefinitionVersion());
            this.saveCommand(command);
            return;
        }
        if (originCommand.getCommandType() == CommandType.RECOVER_WAITING_THREAD) {
            originCommand.setUpdateTime(new Date());
            this.saveCommand(originCommand);
        } else {
            this.commandMapper.deleteById((Serializable)Integer.valueOf(originCommand.getId()));
            originCommand.setId(0);
            originCommand.setCommandType(CommandType.RECOVER_WAITING_THREAD);
            originCommand.setUpdateTime(new Date());
            originCommand.setCommandParam(JSONUtils.toJsonString(cmdParam));
            originCommand.setProcessInstancePriority(processInstance.getProcessInstancePriority());
            this.saveCommand(originCommand);
        }
    }

    private Date getScheduleTime(Command command, Map<String, String> cmdParam) {
        Date scheduleTime = command.getScheduleTime();
        if (scheduleTime == null && cmdParam != null && cmdParam.containsKey("complementStartDate")) {
            List<Schedule> schedules;
            Date end;
            Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
            List<Date> complementDateList = CronUtils.getSelfFireDateList(start, end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate")), schedules = this.queryReleaseSchedulerListByProcessDefinitionCode(command.getProcessDefinitionCode()));
            if (complementDateList.size() > 0) {
                scheduleTime = complementDateList.get(0);
            } else {
                this.logger.error("set scheduler time error: complement date list is empty, command: {}", (Object)command.toString());
            }
        }
        return scheduleTime;
    }

    private ProcessInstance generateNewProcessInstance(ProcessDefinition processDefinition, Command command, Map<String, String> cmdParam) {
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        processInstance.setProcessDefinitionCode(Long.valueOf(processDefinition.getCode()));
        processInstance.setProcessDefinitionVersion(processDefinition.getVersion());
        processInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        processInstance.setRecovery(Flag.NO);
        processInstance.setStartTime(new Date());
        processInstance.setRunTimes(1);
        processInstance.setMaxTryTimes(0);
        processInstance.setCommandParam(command.getCommandParam());
        processInstance.setCommandType(command.getCommandType());
        processInstance.setIsSubProcess(Flag.NO);
        processInstance.setTaskDependType(command.getTaskDependType());
        processInstance.setFailureStrategy(command.getFailureStrategy());
        processInstance.setExecutorId(command.getExecutorId());
        WarningType warningType = command.getWarningType() == null ? WarningType.NONE : command.getWarningType();
        processInstance.setWarningType(warningType);
        Integer warningGroupId = command.getWarningGroupId() == null ? 0 : command.getWarningGroupId();
        processInstance.setWarningGroupId(warningGroupId);
        processInstance.setDryRun(command.getDryRun());
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setCommandStartTime(command.getStartTime());
        processInstance.setLocations(processDefinition.getLocations());
        this.setGlobalParamIfCommanded(processDefinition, cmdParam);
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)this.getCommandTypeIfComplement(processInstance, command), (Date)processInstance.getScheduleTime()));
        processInstance.setProcessInstancePriority(command.getProcessInstancePriority());
        String workerGroup = StringUtils.isBlank((String)command.getWorkerGroup()) ? "default" : command.getWorkerGroup();
        processInstance.setWorkerGroup(workerGroup);
        processInstance.setEnvironmentCode(Long.valueOf(Objects.isNull(command.getEnvironmentCode()) ? -1L : command.getEnvironmentCode()));
        processInstance.setTimeout(processDefinition.getTimeout());
        processInstance.setTenantId(processDefinition.getTenantId());
        return processInstance;
    }

    private void setGlobalParamIfCommanded(ProcessDefinition processDefinition, Map<String, String> cmdParam) {
        Map startParamMap = new HashMap();
        if (cmdParam != null && cmdParam.containsKey("StartParams")) {
            String startParamJson = cmdParam.get("StartParams");
            startParamMap = JSONUtils.toMap((String)startParamJson);
        }
        Map fatherParamMap = new HashMap();
        if (cmdParam != null && cmdParam.containsKey("fatherParams")) {
            String fatherParamJson = cmdParam.get("fatherParams");
            fatherParamMap = JSONUtils.toMap((String)fatherParamJson);
        }
        startParamMap.putAll(fatherParamMap);
        if (startParamMap.size() > 0 && processDefinition.getGlobalParamMap() != null) {
            for (Map.Entry entry : processDefinition.getGlobalParamMap().entrySet()) {
                String val = (String)startParamMap.get(entry.getKey());
                if (val == null) continue;
                entry.setValue(val);
            }
        }
    }

    public Tenant getTenantForProcess(int tenantId, int userId) {
        Tenant tenant = null;
        if (tenantId >= 0) {
            tenant = this.tenantMapper.queryById(tenantId);
        }
        if (userId == 0) {
            return null;
        }
        if (tenant == null) {
            User user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
            tenant = this.tenantMapper.queryById(user.getTenantId());
        }
        return tenant;
    }

    public Environment findEnvironmentByCode(Long environmentCode) {
        Environment environment = null;
        if (environmentCode >= 0L) {
            environment = this.environmentMapper.queryByEnvironmentCode(environmentCode);
        }
        return environment;
    }

    private Boolean checkCmdParam(Command command, Map<String, String> cmdParam) {
        if (!(command.getTaskDependType() != TaskDependType.TASK_ONLY && command.getTaskDependType() != TaskDependType.TASK_PRE || cmdParam != null && cmdParam.containsKey("StartNodeList") && !cmdParam.get("StartNodeList").isEmpty())) {
            this.logger.error("command node depend type is {}, but start nodes is null ", (Object)command.getTaskDependType());
            return false;
        }
        return true;
    }

    private ProcessInstance constructProcessInstance(Command command, String host, HashMap<String, ProcessDefinition> processDefinitionCacheMaps) {
        ProcessInstance processInstance;
        ProcessDefinition processDefinition;
        CommandType commandType = command.getCommandType();
        String key = String.format("%d-%d", command.getProcessDefinitionCode(), command.getProcessDefinitionVersion());
        if (processDefinitionCacheMaps.containsKey(key)) {
            processDefinition = processDefinitionCacheMaps.get(key);
        } else {
            processDefinition = this.findProcessDefinition(command.getProcessDefinitionCode(), command.getProcessDefinitionVersion());
            if (processDefinition != null) {
                processDefinitionCacheMaps.put(key, processDefinition);
            }
        }
        if (processDefinition == null) {
            this.logger.error("cannot find the work process define! define code : {}", (Object)command.getProcessDefinitionCode());
            return null;
        }
        Map cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        int processInstanceId = command.getProcessInstanceId();
        if (processInstanceId == 0) {
            processInstance = this.generateNewProcessInstance(processDefinition, command, cmdParam);
        } else {
            processInstance = this.findProcessInstanceDetailById(processInstanceId);
            if (processInstance == null) {
                return processInstance;
            }
        }
        if (cmdParam != null) {
            CommandType commandTypeIfComplement = this.getCommandTypeIfComplement(processInstance, command);
            if (commandTypeIfComplement == CommandType.REPEAT_RUNNING) {
                this.setGlobalParamIfCommanded(processDefinition, cmdParam);
            }
            processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)commandTypeIfComplement, (Date)processInstance.getScheduleTime()));
            processInstance.setProcessDefinition(processDefinition);
        }
        if (processInstance.getCommandParam() != null) {
            Map processCmdParam = JSONUtils.toMap((String)processInstance.getCommandParam());
            for (Map.Entry entry : processCmdParam.entrySet()) {
                if (cmdParam.containsKey(entry.getKey())) continue;
                cmdParam.put(entry.getKey(), entry.getValue());
            }
        }
        if (cmdParam != null && cmdParam.containsKey("processInstanceId")) {
            processInstance.setCommandParam(command.getCommandParam());
        }
        if (Boolean.FALSE.equals(this.checkCmdParam(command, cmdParam))) {
            this.logger.error("command parameter check failed!");
            return null;
        }
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setHost(host);
        ExecutionStatus runStatus = ExecutionStatus.RUNNING_EXECUTION;
        int runTime = processInstance.getRunTimes();
        switch (commandType) {
            case START_PROCESS: {
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                List<Integer> failedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.FAILURE);
                List<Integer> toleranceList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.NEED_FAULT_TOLERANCE);
                List<Integer> killedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                cmdParam.remove("StartNodeIdList");
                failedList.addAll(killedList);
                failedList.addAll(toleranceList);
                for (Integer taskId : failedList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(failedList)));
                processInstance.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case START_CURRENT_TASK_PROCESS: {
                break;
            }
            case RECOVER_WAITING_THREAD: {
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                cmdParam.remove("StartNodeIdList");
                List<Integer> suspendedNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.PAUSE);
                List<Integer> stopNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                suspendedNodeList.addAll(stopNodeList);
                for (Integer taskId : suspendedNodeList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(suspendedNodeList)));
                processInstance.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                processInstance.setRecovery(Flag.YES);
                runStatus = processInstance.getState();
                break;
            }
            case COMPLEMENT_DATA: {
                if (processInstance.getId() == 0) break;
                List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : taskInstanceList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                break;
            }
            case REPEAT_RUNNING: {
                if (cmdParam.containsKey("StartNodeIdList")) {
                    cmdParam.remove("StartNodeIdList");
                    processInstance.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
                }
                List<TaskInstance> validTaskList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : validTaskList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                processInstance.setStartTime(new Date());
                processInstance.setEndTime(null);
                processInstance.setRunTimes(runTime + 1);
                this.initComplementDataParam(processDefinition, processInstance, cmdParam);
                break;
            }
            case SCHEDULER: {
                break;
            }
        }
        processInstance.setState(runStatus);
        return processInstance;
    }

    private ProcessDefinition getProcessDefinitionByCommand(long processDefinitionCode, Map<String, String> cmdParam) {
        if (cmdParam != null) {
            int processInstanceId = 0;
            if (cmdParam.containsKey("ProcessInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("ProcessInstanceId"));
            } else if (cmdParam.containsKey("processInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("processInstanceId"));
            } else if (cmdParam.containsKey("WaitingThreadInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("WaitingThreadInstanceId"));
            }
            if (processInstanceId != 0) {
                ProcessInstance processInstance = this.findProcessInstanceDetailById(processInstanceId);
                if (processInstance == null) {
                    return null;
                }
                return this.processDefineLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
            }
        }
        return this.processDefineMapper.queryByCode(processDefinitionCode);
    }

    private CommandType getCommandTypeIfComplement(ProcessInstance processInstance, Command command) {
        if (CommandType.COMPLEMENT_DATA == processInstance.getCmdTypeIfComplement()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return command.getCommandType();
    }

    private void initComplementDataParam(ProcessDefinition processDefinition, ProcessInstance processInstance, Map<String, String> cmdParam) {
        List<Schedule> listSchedules;
        Date end;
        if (!processInstance.isComplementData()) {
            return;
        }
        Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
        List<Date> complementDate = CronUtils.getSelfFireDateList(start, end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate")), listSchedules = this.queryReleaseSchedulerListByProcessDefinitionCode(processInstance.getProcessDefinitionCode()));
        if (complementDate.size() > 0 && Flag.NO == processInstance.getIsSubProcess()) {
            processInstance.setScheduleTime(complementDate.get(0));
        }
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)processInstance.getScheduleTime()));
    }

    public void setSubProcessParam(ProcessInstance subProcessInstance) {
        ProcessInstanceMap processInstanceMap;
        String parentInstanceId;
        String cmdParam = subProcessInstance.getCommandParam();
        if (StringUtils.isEmpty((String)cmdParam)) {
            return;
        }
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap.containsKey("processInstanceId") && "0".equals(paramMap.get("processInstanceId"))) {
            paramMap.remove("processInstanceId");
            paramMap.put("processInstanceId", String.valueOf(subProcessInstance.getId()));
            subProcessInstance.setCommandParam(JSONUtils.toJsonString((Object)paramMap));
            subProcessInstance.setIsSubProcess(Flag.YES);
            this.saveProcessInstance(subProcessInstance);
        }
        if (StringUtils.isNotEmpty((String)(parentInstanceId = (String)paramMap.get("parentProcessInstanceId")))) {
            ProcessInstance parentInstance = this.findProcessInstanceDetailById(Integer.parseInt(parentInstanceId));
            if (parentInstance != null) {
                subProcessInstance.setGlobalParams(this.joinGlobalParams(parentInstance.getGlobalParams(), subProcessInstance.getGlobalParams()));
                this.saveProcessInstance(subProcessInstance);
            } else {
                this.logger.error("sub process command params error, cannot find parent instance: {} ", (Object)cmdParam);
            }
        }
        if ((processInstanceMap = (ProcessInstanceMap)JSONUtils.parseObject((String)cmdParam, ProcessInstanceMap.class)) == null || processInstanceMap.getParentProcessInstanceId() == 0) {
            return;
        }
        processInstanceMap.setProcessInstanceId(subProcessInstance.getId());
        this.updateWorkProcessInstanceMap(processInstanceMap);
    }

    private String joinGlobalParams(String parentGlobalParams, String subGlobalParams) {
        List parentPropertyList = JSONUtils.toList((String)parentGlobalParams, Property.class);
        List subPropertyList = JSONUtils.toList((String)subGlobalParams, Property.class);
        Map<String, String> subMap = subPropertyList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        for (Property parent : parentPropertyList) {
            if (subMap.containsKey(parent.getProp())) continue;
            subPropertyList.add(parent);
        }
        return JSONUtils.toJsonString((Object)subPropertyList);
    }

    private void initTaskInstance(TaskInstance taskInstance) {
        if (!taskInstance.isSubProcess() && (taskInstance.getState().typeIsCancel() || taskInstance.getState().typeIsFailure())) {
            taskInstance.setFlag(Flag.NO);
            this.updateTaskInstance(taskInstance);
            return;
        }
        taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
        this.updateTaskInstance(taskInstance);
    }

    public TaskInstance submitTask(TaskInstance taskInstance, int commitRetryTimes, int commitInterval) {
        boolean submitDB = false;
        TaskInstance task = null;
        for (int retryTimes = 1; retryTimes <= commitRetryTimes; ++retryTimes) {
            try {
                if (!submitDB && (task = this.submitTask(taskInstance)) != null && task.getId() != 0) {
                    submitDB = true;
                    break;
                }
                if (!submitDB) {
                    this.logger.error("task commit to db failed , taskId {} has already retry {} times, please check the database", (Object)taskInstance.getId(), (Object)retryTimes);
                }
                Thread.sleep(commitInterval);
                continue;
            }
            catch (Exception e) {
                this.logger.error("task commit to mysql failed", (Throwable)e);
            }
        }
        return task;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskInstance submitTask(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceDetailById(taskInstance.getProcessInstanceId());
        this.logger.info("start submit task : {}, instance id:{}, state: {}", new Object[]{taskInstance.getName(), taskInstance.getProcessInstanceId(), processInstance.getState()});
        TaskInstance task = this.submitTaskInstanceToDB(taskInstance, processInstance);
        if (task == null) {
            this.logger.error("end submit task to db error, task name:{}, process id:{} state: {} ", new Object[]{taskInstance.getName(), taskInstance.getProcessInstance(), processInstance.getState()});
            return task;
        }
        if (!task.getState().typeIsFinished()) {
            this.createSubWorkProcess(processInstance, task);
        }
        this.logger.info("end submit task to db successfully:{} {} state:{} complete, instance id:{} state: {}  ", new Object[]{taskInstance.getId(), taskInstance.getName(), task.getState(), processInstance.getId(), processInstance.getState()});
        return task;
    }

    private ProcessInstanceMap setProcessInstanceMap(ProcessInstance parentInstance, TaskInstance parentTask) {
        ProcessInstanceMap processMap = this.findWorkProcessMapByParent(parentInstance.getId(), parentTask.getId());
        if (processMap != null) {
            return processMap;
        }
        if (parentInstance.getCommandType() == CommandType.REPEAT_RUNNING && (processMap = this.findPreviousTaskProcessMap(parentInstance, parentTask)) != null) {
            processMap.setParentTaskInstanceId(parentTask.getId());
            this.updateWorkProcessInstanceMap(processMap);
            return processMap;
        }
        processMap = new ProcessInstanceMap();
        processMap.setParentProcessInstanceId(parentInstance.getId());
        processMap.setParentTaskInstanceId(parentTask.getId());
        this.createWorkProcessInstanceMap(processMap);
        return processMap;
    }

    private ProcessInstanceMap findPreviousTaskProcessMap(ProcessInstance parentProcessInstance, TaskInstance parentTask) {
        Integer preTaskId = 0;
        List<TaskInstance> preTaskList = this.findPreviousTaskListByWorkProcessId(parentProcessInstance.getId());
        for (TaskInstance task : preTaskList) {
            if (!task.getName().equals(parentTask.getName())) continue;
            preTaskId = task.getId();
            ProcessInstanceMap map = this.findWorkProcessMapByParent(parentProcessInstance.getId(), preTaskId);
            if (map == null) continue;
            return map;
        }
        this.logger.info("sub process instance is not found,parent task:{},parent instance:{}", (Object)parentTask.getId(), (Object)parentProcessInstance.getId());
        return null;
    }

    public void createSubWorkProcess(ProcessInstance parentProcessInstance, TaskInstance task) {
        if (!task.isSubProcess()) {
            return;
        }
        ProcessInstanceMap instanceMap = this.findWorkProcessMapByParent(parentProcessInstance.getId(), task.getId());
        if (null != instanceMap && CommandType.RECOVER_TOLERANCE_FAULT_PROCESS == parentProcessInstance.getCommandType()) {
            return;
        }
        instanceMap = this.setProcessInstanceMap(parentProcessInstance, task);
        ProcessInstance childInstance = null;
        if (instanceMap.getProcessInstanceId() != 0) {
            childInstance = this.findProcessInstanceById(instanceMap.getProcessInstanceId());
        }
        Command subProcessCommand = this.createSubProcessCommand(parentProcessInstance, childInstance, instanceMap, task);
        this.updateSubProcessDefinitionByParent(parentProcessInstance, subProcessCommand.getProcessDefinitionCode());
        this.initSubInstanceState(childInstance);
        this.createCommand(subProcessCommand);
        this.logger.info("sub process command created: {} ", (Object)subProcessCommand);
    }

    private String getSubWorkFlowParam(ProcessInstanceMap instanceMap, ProcessInstance parentProcessInstance, Map<String, String> fatherParams) {
        String processMapStr = JSONUtils.toJsonString((Object)instanceMap);
        Map cmdParam = JSONUtils.toMap((String)processMapStr);
        if (parentProcessInstance.isComplementData()) {
            Map parentParam = JSONUtils.toMap((String)parentProcessInstance.getCommandParam());
            String endTime = (String)parentParam.get("complementEndDate");
            String startTime = (String)parentParam.get("complementStartDate");
            cmdParam.put("complementEndDate", endTime);
            cmdParam.put("complementStartDate", startTime);
            processMapStr = JSONUtils.toJsonString((Object)cmdParam);
        }
        if (fatherParams.size() != 0) {
            cmdParam.put("fatherParams", JSONUtils.toJsonString(fatherParams));
            processMapStr = JSONUtils.toJsonString((Object)cmdParam);
        }
        return processMapStr;
    }

    public Map<String, String> getGlobalParamMap(String globalParams) {
        Map<String, String> globalParamMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)globalParams)) {
            List propList = JSONUtils.toList((String)globalParams, Property.class);
            globalParamMap = propList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        }
        return globalParamMap;
    }

    public Command createSubProcessCommand(ProcessInstance parentProcessInstance, ProcessInstance childInstance, ProcessInstanceMap instanceMap, TaskInstance task) {
        CommandType commandType = this.getSubCommandType(parentProcessInstance, childInstance);
        Map subProcessParam = JSONUtils.toMap((String)task.getTaskParams());
        long childDefineCode = 0L;
        if (subProcessParam.containsKey("processDefinitionCode")) {
            childDefineCode = Long.parseLong((String)subProcessParam.get("processDefinitionCode"));
        }
        ProcessDefinition subProcessDefinition = this.processDefineMapper.queryByCode(childDefineCode);
        Object localParams = subProcessParam.get("localParams");
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        Map<String, String> globalMap = this.getGlobalParamMap(parentProcessInstance.getGlobalParams());
        HashMap<String, String> fatherParams = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)allParam)) {
            for (Property info : allParam) {
                fatherParams.put(info.getProp(), globalMap.get(info.getProp()));
            }
        }
        String processParam = this.getSubWorkFlowParam(instanceMap, parentProcessInstance, fatherParams);
        int subProcessInstanceId = childInstance == null ? 0 : childInstance.getId();
        return new Command(commandType, TaskDependType.TASK_POST, parentProcessInstance.getFailureStrategy(), parentProcessInstance.getExecutorId(), subProcessDefinition.getCode(), processParam, parentProcessInstance.getWarningType(), parentProcessInstance.getWarningGroupId().intValue(), parentProcessInstance.getScheduleTime(), task.getWorkerGroup(), task.getEnvironmentCode(), parentProcessInstance.getProcessInstancePriority(), parentProcessInstance.getDryRun(), subProcessInstanceId, subProcessDefinition.getVersion());
    }

    private void initSubInstanceState(ProcessInstance childInstance) {
        if (childInstance != null) {
            childInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
            this.updateProcessInstance(childInstance);
        }
    }

    private CommandType getSubCommandType(ProcessInstance parentProcessInstance, ProcessInstance childInstance) {
        CommandType commandType = parentProcessInstance.getCommandType();
        if (childInstance == null) {
            String fatherHistoryCommand = parentProcessInstance.getHistoryCmd();
            commandType = CommandType.valueOf((String)fatherHistoryCommand.split(",")[0]);
        }
        return commandType;
    }

    private void updateSubProcessDefinitionByParent(ProcessInstance parentProcessInstance, long childDefinitionCode) {
        ProcessDefinition fatherDefinition = this.findProcessDefinition(parentProcessInstance.getProcessDefinitionCode(), parentProcessInstance.getProcessDefinitionVersion());
        ProcessDefinition childDefinition = this.findProcessDefinitionByCode(childDefinitionCode);
        if (childDefinition != null && fatherDefinition != null) {
            childDefinition.setWarningGroupId(fatherDefinition.getWarningGroupId());
            this.processDefineMapper.updateById((Object)childDefinition);
        }
    }

    public TaskInstance submitTaskInstanceToDB(TaskInstance taskInstance, ProcessInstance processInstance) {
        boolean saveResult;
        ExecutionStatus processInstanceState = processInstance.getState();
        if (taskInstance.getState().typeIsFailure()) {
            if (taskInstance.isSubProcess()) {
                taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
            } else if (processInstanceState != ExecutionStatus.READY_STOP && processInstanceState != ExecutionStatus.READY_PAUSE) {
                taskInstance.setFlag(Flag.NO);
                this.updateTaskInstance(taskInstance);
                if (taskInstance.getState() != ExecutionStatus.NEED_FAULT_TOLERANCE) {
                    taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
                }
                taskInstance.setSubmitTime(null);
                taskInstance.setLogPath(null);
                taskInstance.setExecutePath(null);
                taskInstance.setStartTime(null);
                taskInstance.setEndTime(null);
                taskInstance.setFlag(Flag.YES);
                taskInstance.setHost(null);
                taskInstance.setId(0);
            }
        }
        taskInstance.setExecutorId(processInstance.getExecutorId());
        taskInstance.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        taskInstance.setState(this.getSubmitTaskState(taskInstance, processInstanceState));
        if (taskInstance.getSubmitTime() == null) {
            taskInstance.setSubmitTime(new Date());
        }
        if (taskInstance.getFirstSubmitTime() == null) {
            taskInstance.setFirstSubmitTime(taskInstance.getSubmitTime());
        }
        if (!(saveResult = this.saveTaskInstance(taskInstance))) {
            return null;
        }
        return taskInstance;
    }

    public ExecutionStatus getSubmitTaskState(TaskInstance taskInstance, ExecutionStatus processInstanceState) {
        ExecutionStatus state = taskInstance.getState();
        if (state == ExecutionStatus.RUNNING_EXECUTION || state == ExecutionStatus.DELAY_EXECUTION || state == ExecutionStatus.KILL) {
            return state;
        }
        state = processInstanceState == ExecutionStatus.READY_PAUSE ? ExecutionStatus.PAUSE : (processInstanceState == ExecutionStatus.READY_STOP || !this.checkProcessStrategy(taskInstance) ? ExecutionStatus.KILL : ExecutionStatus.SUBMITTED_SUCCESS);
        return state;
    }

    private boolean checkProcessStrategy(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        FailureStrategy failureStrategy = processInstance.getFailureStrategy();
        if (failureStrategy == FailureStrategy.CONTINUE) {
            return true;
        }
        List<TaskInstance> taskInstances = this.findValidTaskListByProcessId(taskInstance.getProcessInstanceId());
        for (TaskInstance task : taskInstances) {
            if (task.getState() != ExecutionStatus.FAILURE || task.getRetryTimes() < task.getMaxRetryTimes()) continue;
            return false;
        }
        return true;
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        if (processInstance == null) {
            this.logger.error("save error, process instance is null!");
            return;
        }
        if (processInstance.getId() != 0) {
            this.processInstanceMapper.updateById((Object)processInstance);
        } else {
            this.processInstanceMapper.insert((Object)processInstance);
        }
    }

    public int saveCommand(Command command) {
        if (command.getId() != 0) {
            return this.commandMapper.updateById((Object)command);
        }
        return this.commandMapper.insert((Object)command);
    }

    public boolean saveTaskInstance(TaskInstance taskInstance) {
        if (taskInstance.getId() != 0) {
            return this.updateTaskInstance(taskInstance);
        }
        return this.createTaskInstance(taskInstance);
    }

    public boolean createTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.insert((Object)taskInstance);
        return count > 0;
    }

    public boolean updateTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.updateById((Object)taskInstance);
        return count > 0;
    }

    public TaskInstance findTaskInstanceById(Integer taskId) {
        return (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskId);
    }

    public TaskInstance getTaskInstanceDetailByTaskId(int taskInstId) {
        TaskInstance taskInstance = this.findTaskInstanceById(taskInstId);
        if (taskInstance == null) {
            return null;
        }
        this.setTaskInstanceDetail(taskInstance);
        return taskInstance;
    }

    public void setTaskInstanceDetail(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceDetailById(taskInstance.getProcessInstanceId());
        ProcessDefinition processDefine = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        taskInstance.setProcessInstance(processInstance);
        taskInstance.setProcessDefine(processDefine);
        TaskDefinitionLog taskDefinition = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
        this.updateTaskDefinitionResources((TaskDefinition)taskDefinition);
        taskInstance.setTaskDefine((TaskDefinition)taskDefinition);
    }

    private void updateTaskDefinitionResources(TaskDefinition taskDefinition) {
        Map taskParameters = (Map)JSONUtils.parseObject((String)taskDefinition.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (taskParameters != null) {
            Object mainJarObj;
            ResourceInfo mainJar;
            ResourceInfo resourceInfo;
            if (taskParameters.containsKey("mainJar") && (resourceInfo = this.updateResourceInfo(mainJar = (ResourceInfo)JSONUtils.parseObject((String)JSONUtils.toJsonString(mainJarObj = taskParameters.get("mainJar")), ResourceInfo.class))) != null) {
                taskParameters.put("mainJar", resourceInfo);
            }
            if (taskParameters.containsKey("resourceList")) {
                String resourceListStr = JSONUtils.toJsonString(taskParameters.get("resourceList"));
                List resourceInfos = JSONUtils.toList((String)resourceListStr, ResourceInfo.class);
                List updatedResourceInfos = resourceInfos.stream().map(this::updateResourceInfo).filter(Objects::nonNull).collect(Collectors.toList());
                taskParameters.put("resourceList", updatedResourceInfos);
            }
            taskDefinition.setTaskParams(JSONUtils.toJsonString((Object)taskParameters));
        }
    }

    private ResourceInfo updateResourceInfo(ResourceInfo res) {
        ResourceInfo resourceInfo = null;
        if (res != null) {
            int resourceId = res.getId();
            if (resourceId <= 0) {
                this.logger.error("invalid resourceId, {}", (Object)resourceId);
                return null;
            }
            resourceInfo = new ResourceInfo();
            Resource resource = this.getResourceById(resourceId);
            resourceInfo.setId(resourceId);
            resourceInfo.setRes(resource.getFileName());
            resourceInfo.setResourceName(resource.getFullName());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("updated resource info {}", (Object)JSONUtils.toJsonString((Object)resourceInfo));
            }
        }
        return resourceInfo;
    }

    public List<Integer> findTaskIdByInstanceState(int instanceId, ExecutionStatus state) {
        return this.taskInstanceMapper.queryTaskByProcessIdAndState(Integer.valueOf(instanceId), Integer.valueOf(state.ordinal()));
    }

    public List<TaskInstance> findValidTaskListByProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.YES);
    }

    public List<TaskInstance> findPreviousTaskListByWorkProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.NO);
    }

    public int updateWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        return this.processInstanceMapMapper.updateById((Object)processInstanceMap);
    }

    public int createWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        int count = 0;
        if (processInstanceMap != null) {
            return this.processInstanceMapMapper.insert((Object)processInstanceMap);
        }
        return count;
    }

    public ProcessInstanceMap findWorkProcessMapByParent(Integer parentWorkProcessId, Integer parentTaskId) {
        return this.processInstanceMapMapper.queryByParentId(parentWorkProcessId.intValue(), parentTaskId.intValue());
    }

    public int deleteWorkProcessMapByParentId(int parentWorkProcessId) {
        return this.processInstanceMapMapper.deleteByParentProcessId(parentWorkProcessId);
    }

    public ProcessInstance findSubProcessInstance(Integer parentProcessId, Integer parentTaskId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryByParentId(parentProcessId.intValue(), parentTaskId.intValue());
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getProcessInstanceId());
        return processInstance;
    }

    public ProcessInstance findParentProcessInstance(Integer subProcessId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(subProcessId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        return processInstance;
    }

    public void changeTaskState(TaskInstance taskInstance, ExecutionStatus state, Date startTime, String host, String executePath, String logPath, int taskInstId) {
        taskInstance.setState(state);
        taskInstance.setStartTime(startTime);
        taskInstance.setHost(host);
        taskInstance.setExecutePath(executePath);
        taskInstance.setLogPath(logPath);
        this.saveTaskInstance(taskInstance);
    }

    public int updateProcessInstance(ProcessInstance processInstance) {
        return this.processInstanceMapper.updateById((Object)processInstance);
    }

    public void changeTaskState(TaskInstance taskInstance, ExecutionStatus state, Date endTime, int processId, String appIds, int taskInstId, String varPool) {
        taskInstance.setPid(processId);
        taskInstance.setAppLink(appIds);
        taskInstance.setState(state);
        taskInstance.setEndTime(endTime);
        taskInstance.setVarPool(varPool);
        this.changeOutParam(taskInstance);
        this.saveTaskInstance(taskInstance);
    }

    public void changeOutParam(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((String)taskInstance.getVarPool())) {
            return;
        }
        List properties = JSONUtils.toList((String)taskInstance.getVarPool(), Property.class);
        if (CollectionUtils.isEmpty((Collection)properties)) {
            return;
        }
        Map taskParams = (Map)JSONUtils.parseObject((String)taskInstance.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object localParams = taskParams.get("localParams");
        if (localParams == null) {
            return;
        }
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        HashMap<String, String> outProperty = new HashMap<String, String>();
        for (Property info : properties) {
            if (info.getDirect() != Direct.OUT) continue;
            outProperty.put(info.getProp(), info.getValue());
        }
        for (Property info : allParam) {
            if (info.getDirect() != Direct.OUT) continue;
            String paramName = info.getProp();
            info.setValue((String)outProperty.get(paramName));
        }
        taskParams.put("localParams", allParam);
        taskInstance.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
    }

    public List<String> convertIntListToString(List<Integer> intList) {
        if (intList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(intList.size());
        for (Integer intVar : intList) {
            result.add(String.valueOf(intVar));
        }
        return result;
    }

    public Schedule querySchedule(int id) {
        return (Schedule)this.scheduleMapper.selectById((Serializable)Integer.valueOf(id));
    }

    public List<Schedule> queryReleaseSchedulerListByProcessDefinitionCode(long processDefinitionCode) {
        return this.scheduleMapper.queryReleaseSchedulerListByProcessDefinitionCode(processDefinitionCode);
    }

    public List<ProcessInstance> queryNeedFailoverProcessInstances(String host) {
        return this.processInstanceMapper.queryByHostAndStatus(host, this.stateArray);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void processNeedFailoverProcessInstances(ProcessInstance processInstance) {
        processInstance.setHost("NULL");
        this.processInstanceMapper.updateById((Object)processInstance);
        ProcessDefinition processDefinition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        Command cmd = new Command();
        cmd.setProcessDefinitionCode(processDefinition.getCode());
        cmd.setProcessDefinitionVersion(processDefinition.getVersion());
        cmd.setProcessInstanceId(processInstance.getId());
        cmd.setCommandParam(String.format("{\"%s\":%d}", "ProcessInstanceId", processInstance.getId()));
        cmd.setExecutorId(processInstance.getExecutorId());
        cmd.setCommandType(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS);
        this.createCommand(cmd);
    }

    public List<TaskInstance> queryNeedFailoverTaskInstances(String host) {
        return this.taskInstanceMapper.queryByHostAndStatus(host, this.stateArray);
    }

    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    public int updateProcessInstanceState(Integer processInstanceId, ExecutionStatus executionStatus) {
        ProcessInstance instance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)processInstanceId);
        instance.setState(executionStatus);
        return this.processInstanceMapper.updateById((Object)instance);
    }

    public ProcessInstance findProcessInstanceByTaskId(int taskId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskId));
        if (taskInstance != null) {
            return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstance.getProcessInstanceId()));
        }
        return null;
    }

    public List<UdfFunc> queryUdfFunListByIds(int[] ids) {
        return this.udfFuncMapper.queryUdfByIdStr(ids, null);
    }

    public String queryTenantCodeByResName(String resName, ResourceType resourceType) {
        String fullName = resName.startsWith("/") ? resName : String.format("/%s", resName);
        List resourceList = this.resourceMapper.queryResource(fullName, resourceType.ordinal());
        if (CollectionUtils.isEmpty((Collection)resourceList)) {
            return "";
        }
        int userId = ((Resource)resourceList.get(0)).getUserId();
        User user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
        if (Objects.isNull(user)) {
            return "";
        }
        Tenant tenant = (Tenant)this.tenantMapper.selectById((Serializable)Integer.valueOf(user.getTenantId()));
        if (Objects.isNull(tenant)) {
            return "";
        }
        return tenant.getTenantCode();
    }

    public List<Schedule> selectAllByProcessDefineCode(long[] codes) {
        return this.scheduleMapper.selectAllByProcessDefineArray(codes);
    }

    public ProcessInstance findLastSchedulerProcessInterval(Long definitionCode, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastSchedulerProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    public ProcessInstance findLastManualProcessInterval(Long definitionCode, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastManualProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    public ProcessInstance findLastRunningProcess(Long definitionCode, Date startTime, Date endTime) {
        return this.processInstanceMapper.queryLastRunningProcess(definitionCode, startTime, endTime, this.stateArray);
    }

    public String queryUserQueueByProcessInstanceId(int processInstanceId) {
        String queue = "";
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(processInstanceId));
        if (processInstance == null) {
            return queue;
        }
        User executor = (User)this.userMapper.selectById((Serializable)Integer.valueOf(processInstance.getExecutorId()));
        if (executor != null) {
            queue = executor.getQueue();
        }
        return queue;
    }

    public ProjectUser queryProjectWithUserByProcessInstanceId(int processInstanceId) {
        return this.projectMapper.queryProjectWithUserByProcessInstanceId(processInstanceId);
    }

    public String getTaskWorkerGroup(TaskInstance taskInstance) {
        String workerGroup = taskInstance.getWorkerGroup();
        if (StringUtils.isNotBlank((String)workerGroup)) {
            return workerGroup;
        }
        int processInstanceId = taskInstance.getProcessInstanceId();
        ProcessInstance processInstance = this.findProcessInstanceById(processInstanceId);
        if (processInstance != null) {
            return processInstance.getWorkerGroup();
        }
        this.logger.info("task : {} will use default worker group", (Object)taskInstance.getId());
        return "default";
    }

    public List<Project> getProjectListHavePerm(int userId) {
        ArrayList<Project> createProjects = this.projectMapper.queryProjectCreatedByUser(userId);
        List authedProjects = this.projectMapper.queryAuthedProjectListByUserId(userId);
        if (createProjects == null) {
            createProjects = new ArrayList<Project>();
        }
        if (authedProjects != null) {
            createProjects.addAll(authedProjects);
        }
        return createProjects;
    }

    public <T> List<T> listUnauthorized(int userId, T[] needChecks, AuthorizationType authorizationType) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (Objects.nonNull(needChecks) && needChecks.length > 0) {
            HashSet<T> originResSet = new HashSet<T>(Arrays.asList(needChecks));
            switch (authorizationType) {
                case RESOURCE_FILE_ID: 
                case UDF_FILE: {
                    List ownUdfResources = this.resourceMapper.listAuthorizedResourceById(userId, (Object[])needChecks);
                    this.addAuthorizedResources(ownUdfResources, userId);
                    Set authorizedResourceFiles = ownUdfResources.stream().map(Resource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResourceFiles);
                    break;
                }
                case RESOURCE_FILE_NAME: {
                    List ownResources = this.resourceMapper.listAuthorizedResource(userId, (Object[])needChecks);
                    this.addAuthorizedResources(ownResources, userId);
                    Set authorizedResources = ownResources.stream().map(Resource::getFullName).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResources);
                    break;
                }
                case DATASOURCE: {
                    Set authorizedDatasources = this.dataSourceMapper.listAuthorizedDataSource(userId, (Object[])needChecks).stream().map(DataSource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedDatasources);
                    break;
                }
                case UDF: {
                    Set authorizedUdfs = this.udfFuncMapper.listAuthorizedUdfFunc(userId, (Object[])needChecks).stream().map(UdfFunc::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedUdfs);
                    break;
                }
            }
            resultList.addAll(originResSet);
        }
        return resultList;
    }

    public User getUserById(int userId) {
        return (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
    }

    public Resource getResourceById(int resourceId) {
        return (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
    }

    public List<Resource> listResourceByIds(Integer[] resIds) {
        return this.resourceMapper.listResourceByIds(resIds);
    }

    public String formatTaskAppId(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        if (processInstance == null) {
            return "";
        }
        ProcessDefinition definition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (definition == null) {
            return "";
        }
        return String.format("%s_%s_%s", definition.getId(), processInstance.getId(), taskInstance.getId());
    }

    public int switchVersion(ProcessDefinition processDefinition, ProcessDefinitionLog processDefinitionLog) {
        if (null == processDefinition || null == processDefinitionLog) {
            return -1;
        }
        processDefinitionLog.setId(processDefinition.getId());
        processDefinitionLog.setReleaseState(ReleaseState.OFFLINE);
        processDefinitionLog.setFlag(Flag.YES);
        int result = this.processDefineMapper.updateById((Object)processDefinitionLog);
        if (result > 0 && (result = this.switchProcessTaskRelationVersion((ProcessDefinition)processDefinitionLog)) <= 0) {
            return -1;
        }
        return result;
    }

    public int switchProcessTaskRelationVersion(ProcessDefinition processDefinition) {
        List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode());
        if (!processTaskRelationList.isEmpty()) {
            this.processTaskRelationMapper.deleteByCode(processDefinition.getProjectCode(), processDefinition.getCode());
        }
        List processTaskRelationLogList = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinition.getCode(), processDefinition.getVersion());
        return this.processTaskRelationMapper.batchInsert(processTaskRelationLogList);
    }

    public String getResourceIds(TaskDefinition taskDefinition) {
        Set resourceIds = null;
        AbstractParameters params = TaskParametersUtils.getParameters((String)taskDefinition.getTaskType(), (String)taskDefinition.getTaskParams());
        if (params != null && CollectionUtils.isNotEmpty((Collection)params.getResourceFilesList())) {
            resourceIds = params.getResourceFilesList().stream().filter(t -> t.getId() != 0).map(ResourceInfo::getId).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(resourceIds)) {
            return "";
        }
        return StringUtils.join(resourceIds, (String)",");
    }

    public int saveTaskDefine(User operator, long projectCode, List<TaskDefinitionLog> taskDefinitionLogs) {
        Date now = new Date();
        ArrayList<TaskDefinitionLog> newTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        ArrayList<TaskDefinitionLog> updateTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            TaskDefinitionLog definitionCodeAndVersion;
            taskDefinitionLog.setProjectCode(projectCode);
            taskDefinitionLog.setUpdateTime(now);
            taskDefinitionLog.setOperateTime(now);
            taskDefinitionLog.setOperator(operator.getId());
            taskDefinitionLog.setResourceIds(this.getResourceIds((TaskDefinition)taskDefinitionLog));
            if (taskDefinitionLog.getCode() > 0L && taskDefinitionLog.getVersion() > 0 && (definitionCodeAndVersion = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskDefinitionLog.getCode(), taskDefinitionLog.getVersion())) != null) {
                if (taskDefinitionLog.equals((Object)definitionCodeAndVersion)) continue;
                taskDefinitionLog.setUserId(definitionCodeAndVersion.getUserId());
                Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionLog.getCode());
                taskDefinitionLog.setVersion(version + 1);
                taskDefinitionLog.setCreateTime(definitionCodeAndVersion.getCreateTime());
                updateTaskDefinitionLogs.add(taskDefinitionLog);
                continue;
            }
            taskDefinitionLog.setUserId(operator.getId());
            taskDefinitionLog.setVersion(1);
            taskDefinitionLog.setCreateTime(now);
            if (taskDefinitionLog.getCode() == 0L) {
                try {
                    taskDefinitionLog.setCode(CodeGenerateUtils.getInstance().genCode());
                }
                catch (CodeGenerateUtils.CodeGenerateException e) {
                    this.logger.error("Task code get error, ", (Throwable)e);
                    return -1;
                }
            }
            newTaskDefinitionLogs.add(taskDefinitionLog);
        }
        int insertResult = 0;
        int updateResult = 0;
        for (TaskDefinitionLog taskDefinitionToUpdate : updateTaskDefinitionLogs) {
            TaskDefinition task = this.taskDefinitionMapper.queryByCode(taskDefinitionToUpdate.getCode());
            if (task == null) {
                newTaskDefinitionLogs.add(taskDefinitionToUpdate);
                continue;
            }
            insertResult += this.taskDefinitionLogMapper.insert((Object)taskDefinitionToUpdate);
            taskDefinitionToUpdate.setId(task.getId());
            updateResult += this.taskDefinitionMapper.updateById((Object)taskDefinitionToUpdate);
        }
        if (!newTaskDefinitionLogs.isEmpty()) {
            updateResult += this.taskDefinitionMapper.batchInsert(newTaskDefinitionLogs);
            insertResult += this.taskDefinitionLogMapper.batchInsert(newTaskDefinitionLogs);
        }
        return (insertResult & updateResult) > 0 ? 1 : 0;
    }

    public int saveProcessDefine(User operator, ProcessDefinition processDefinition, Boolean isFromProcessDefine) {
        int result;
        ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition);
        Integer version = this.processDefineLogMapper.queryMaxVersionForDefinition(processDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        processDefinitionLog.setVersion(insertVersion);
        processDefinitionLog.setReleaseState(isFromProcessDefine != false ? ReleaseState.OFFLINE : ReleaseState.ONLINE);
        processDefinitionLog.setOperator(operator.getId());
        processDefinitionLog.setOperateTime(processDefinition.getUpdateTime());
        int insertLog = this.processDefineLogMapper.insert((Object)processDefinitionLog);
        if (0 == processDefinition.getId()) {
            result = this.processDefineMapper.insert((Object)processDefinitionLog);
        } else {
            processDefinitionLog.setId(processDefinition.getId());
            result = this.processDefineMapper.updateById((Object)processDefinitionLog);
        }
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    public int saveTaskRelation(User operator, long projectCode, long processDefinitionCode, int processDefinitionVersion, List<ProcessTaskRelationLog> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        int resultLog;
        int result;
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (ProcessTaskRelationLog processTaskRelationLog : taskRelationList) {
            processTaskRelationLog.setProjectCode(projectCode);
            processTaskRelationLog.setProcessDefinitionCode(processDefinitionCode);
            processTaskRelationLog.setProcessDefinitionVersion(processDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog taskDefinitionLog2 = taskDefinitionLogMap.get(processTaskRelationLog.getPreTaskCode());
                if (taskDefinitionLog2 != null) {
                    processTaskRelationLog.setPreTaskVersion(taskDefinitionLog2.getVersion());
                }
                processTaskRelationLog.setPostTaskVersion(taskDefinitionLogMap.get(processTaskRelationLog.getPostTaskCode()).getVersion());
            }
            processTaskRelationLog.setCreateTime(now);
            processTaskRelationLog.setUpdateTime(now);
            processTaskRelationLog.setOperator(operator.getId());
            processTaskRelationLog.setOperateTime(now);
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
        if (!processTaskRelationList.isEmpty()) {
            Set taskRelationSet;
            Set processTaskRelationSet = processTaskRelationList.stream().map(ProcessTaskRelation::hashCode).collect(Collectors.toSet());
            boolean result2 = CollectionUtils.isEqualCollection(processTaskRelationSet, taskRelationSet = taskRelationList.stream().map(ProcessTaskRelationLog::hashCode).collect(Collectors.toSet()));
            if (result2) {
                return 0;
            }
            this.processTaskRelationMapper.deleteByCode(projectCode, processDefinitionCode);
        }
        return ((result = this.processTaskRelationMapper.batchInsert(taskRelationList)) & (resultLog = this.processTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    public boolean isTaskOnline(long taskCode) {
        List processTaskRelationList = this.processTaskRelationMapper.queryByTaskCode(taskCode);
        if (!processTaskRelationList.isEmpty()) {
            Set processDefinitionCodes = processTaskRelationList.stream().map(ProcessTaskRelation::getProcessDefinitionCode).collect(Collectors.toSet());
            List processDefinitionList = this.processDefineMapper.queryByCodes(processDefinitionCodes);
            for (ProcessDefinition processDefinition : processDefinitionList) {
                if (processDefinition.getReleaseState() != ReleaseState.ONLINE) continue;
                return true;
            }
        }
        return false;
    }

    public DAG<String, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition processDefinition) {
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode());
        List<TaskNode> taskNodeList = this.transformTask(processTaskRelations, Lists.newArrayList());
        ProcessDag processDag = DagHelper.getProcessDag(taskNodeList, new ArrayList(processTaskRelations));
        return DagHelper.buildDagGraph((ProcessDag)processDag);
    }

    public DagData genDagData(ProcessDefinition processDefinition) {
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode());
        List<TaskDefinitionLog> taskDefinitionLogList = this.genTaskDefineList(processTaskRelations);
        List taskDefinitions = taskDefinitionLogList.stream().map(taskDefinitionLog -> (TaskDefinition)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)taskDefinitionLog), TaskDefinition.class)).collect(Collectors.toList());
        return new DagData(processDefinition, processTaskRelations, taskDefinitions);
    }

    public List<TaskDefinitionLog> genTaskDefineList(List<ProcessTaskRelation> processTaskRelations) {
        HashSet<TaskDefinition> taskDefinitionSet = new HashSet<TaskDefinition>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPreTaskCode() > 0L) {
                taskDefinitionSet.add(new TaskDefinition(processTaskRelation.getPreTaskCode(), processTaskRelation.getPreTaskVersion()));
            }
            if (processTaskRelation.getPostTaskCode() <= 0L) continue;
            taskDefinitionSet.add(new TaskDefinition(processTaskRelation.getPostTaskCode(), processTaskRelation.getPostTaskVersion()));
        }
        if (taskDefinitionSet.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitionSet);
    }

    public TaskDefinition findTaskDefinition(long taskCode, int taskDefinitionVersion) {
        return this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskDefinitionVersion);
    }

    public List<ProcessTaskRelation> findRelationByCode(long projectCode, long processDefinitionCode) {
        return this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
    }

    private void addAuthorizedResources(List<Resource> ownResources, int userId) {
        List relationResourceIds = this.resourceUserMapper.queryResourcesIdListByUserIdAndPerm(userId, 7);
        List relationResources = CollectionUtils.isNotEmpty((Collection)relationResourceIds) ? this.resourceMapper.queryResourceListById(relationResourceIds) : new ArrayList();
        ownResources.addAll(relationResources);
    }

    public List<TaskNode> transformTask(List<ProcessTaskRelation> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<Long, List> taskCodeMap = new HashMap<Long, List>();
        for (ProcessTaskRelation processTaskRelation : taskRelationList) {
            taskCodeMap.compute(processTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Long>();
                }
                if (processTaskRelation.getPreTaskCode() != 0L) {
                    v.add(processTaskRelation.getPreTaskCode());
                }
                return v;
            });
        }
        if (CollectionUtils.isEmpty(taskDefinitionLogs)) {
            taskDefinitionLogs = this.genTaskDefineList(taskRelationList);
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        ArrayList<TaskNode> taskNodeList = new ArrayList<TaskNode>();
        for (Map.Entry code : taskCodeMap.entrySet()) {
            TaskDefinitionLog taskDefinitionLog2 = taskDefinitionLogMap.get(code.getKey());
            if (taskDefinitionLog2 == null) continue;
            TaskNode taskNode = new TaskNode();
            taskNode.setCode(taskDefinitionLog2.getCode());
            taskNode.setVersion(taskDefinitionLog2.getVersion());
            taskNode.setName(taskDefinitionLog2.getName());
            taskNode.setDesc(taskDefinitionLog2.getDescription());
            taskNode.setType(taskDefinitionLog2.getTaskType().toUpperCase());
            taskNode.setRunFlag(taskDefinitionLog2.getFlag() == Flag.YES ? "NORMAL" : "FORBIDDEN");
            taskNode.setMaxRetryTimes(taskDefinitionLog2.getFailRetryTimes());
            taskNode.setRetryInterval(taskDefinitionLog2.getFailRetryInterval());
            Map taskParamsMap = taskNode.taskParamsToJsonObj(taskDefinitionLog2.getTaskParams());
            taskNode.setConditionResult(JSONUtils.toJsonString(taskParamsMap.get("conditionResult")));
            taskNode.setSwitchResult(JSONUtils.toJsonString(taskParamsMap.get("switchResult")));
            taskNode.setDependence(JSONUtils.toJsonString(taskParamsMap.get("dependence")));
            taskParamsMap.remove("conditionResult");
            taskParamsMap.remove("dependence");
            taskNode.setParams(JSONUtils.toJsonString((Object)taskParamsMap));
            taskNode.setTaskInstancePriority(taskDefinitionLog2.getTaskPriority());
            taskNode.setWorkerGroup(taskDefinitionLog2.getWorkerGroup());
            taskNode.setEnvironmentCode(Long.valueOf(taskDefinitionLog2.getEnvironmentCode()));
            taskNode.setTimeout(JSONUtils.toJsonString((Object)new TaskTimeoutParameter(taskDefinitionLog2.getTimeoutFlag() == TimeoutFlag.OPEN, taskDefinitionLog2.getTimeoutNotifyStrategy(), taskDefinitionLog2.getTimeout())));
            taskNode.setDelayTime(taskDefinitionLog2.getDelayTime());
            taskNode.setPreTasks(JSONUtils.toJsonString(((List)code.getValue()).stream().map(taskDefinitionLogMap::get).map(TaskDefinition::getCode).collect(Collectors.toList())));
            taskNodeList.add(taskNode);
        }
        return taskNodeList;
    }

    public Map<ProcessInstance, TaskInstance> notifyProcessList(int processId, int taskId) {
        HashMap<ProcessInstance, TaskInstance> processTaskMap = new HashMap<ProcessInstance, TaskInstance>();
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(Integer.valueOf(processId));
        if (processInstanceMap == null) {
            return processTaskMap;
        }
        ProcessInstance fatherProcess = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        TaskInstance fatherTask = this.findTaskInstanceById(processInstanceMap.getParentTaskInstanceId());
        if (fatherProcess != null) {
            processTaskMap.put(fatherProcess, fatherTask);
        }
        return processTaskMap;
    }

    private void deleteCommandWithCheck(int commandId) {
        int delete = this.commandMapper.deleteById((Serializable)Integer.valueOf(commandId));
        if (delete != 1) {
            throw new ServiceException("delete command fail, id:" + commandId);
        }
    }
}

