/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.task;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannelFactory;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class TaskPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskPluginManager.class);
    private final Map<String, TaskChannel> taskChannelMap = new ConcurrentHashMap<String, TaskChannel>();
    private final PluginDao pluginDao;

    public TaskPluginManager(PluginDao pluginDao) {
        this.pluginDao = pluginDao;
    }

    private void loadTaskChannel(TaskChannelFactory taskChannelFactory) {
        TaskChannel taskChannel = taskChannelFactory.create();
        this.taskChannelMap.put(taskChannelFactory.getName(), taskChannel);
    }

    public Map<String, TaskChannel> getTaskChannelMap() {
        return Collections.unmodifiableMap(this.taskChannelMap);
    }

    public TaskChannel getTaskChannel(String type) {
        return this.getTaskChannelMap().get(type);
    }

    public boolean checkTaskParameters(ParametersNode parametersNode) {
        AbstractParameters abstractParameters = this.getParameters(parametersNode);
        return abstractParameters != null && abstractParameters.checkParameters();
    }

    public AbstractParameters getParameters(ParametersNode parametersNode) {
        String taskType = parametersNode.getTaskType();
        if (Objects.isNull(taskType)) {
            return null;
        }
        TaskChannel taskChannel = this.getTaskChannelMap().get(taskType);
        if (Objects.isNull(taskChannel)) {
            return null;
        }
        return taskChannel.parseParameters(parametersNode);
    }

    @EventListener
    public void installPlugin(ApplicationReadyEvent readyEvent) {
        HashSet names = new HashSet();
        ServiceLoader.load(TaskChannelFactory.class).forEach(factory -> {
            String name = factory.getName();
            logger.info("Registering task plugin: {}", (Object)name);
            if (!names.add(name)) {
                throw new IllegalStateException(String.format("Duplicate task plugins named '%s'", name));
            }
            this.loadTaskChannel((TaskChannelFactory)factory);
            logger.info("Registered task plugin: {}", (Object)name);
            List params = factory.getParams();
            String paramsJson = PluginParamsTransfer.transferParamsToJson((List)params);
            PluginDefine pluginDefine = new PluginDefine(name, PluginType.TASK.getDesc(), paramsJson);
            int count = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            if (count <= 0) {
                throw new RuntimeException("Failed to update task plugin: " + name);
            }
        });
    }
}

