/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.k8s;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.dao.entity.K8s;
import org.apache.dolphinscheduler.dao.mapper.K8sMapper;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class K8sManager {
    private static final Logger logger = LoggerFactory.getLogger(K8sManager.class);
    private static Map<String, KubernetesClient> clientMap = new Hashtable<String, KubernetesClient>();
    @Autowired
    private K8sMapper k8sMapper;

    public KubernetesClient getK8sClient(String k8sName) {
        if (null == k8sName) {
            return null;
        }
        return clientMap.get(k8sName);
    }

    @EventListener
    public void buildApiClientAll(ApplicationReadyEvent readyEvent) throws RemotingException {
        QueryWrapper nodeWrapper = new QueryWrapper();
        List k8sList = this.k8sMapper.selectList((Wrapper)nodeWrapper);
        if (k8sList != null) {
            for (K8s k8s : k8sList) {
                DefaultKubernetesClient client = this.getClient(k8s.getK8sConfig());
                clientMap.put(k8s.getK8sName(), (KubernetesClient)client);
            }
        }
    }

    private DefaultKubernetesClient getClient(String configYaml) throws RemotingException {
        try {
            Config config = Config.fromKubeconfig((String)configYaml);
            return new DefaultKubernetesClient(config);
        }
        catch (Exception e) {
            logger.error("fail to get k8s ApiClient", (Throwable)e);
            throw new RemotingException("fail to get k8s ApiClient:" + e.getMessage());
        }
    }
}

