/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.log;

import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogClientService
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LogClientService.class);
    private final NettyClientConfig clientConfig = new NettyClientConfig();
    private final NettyRemotingClient client;
    private volatile boolean isRunning;
    private static final long LOG_REQUEST_TIMEOUT = 10000L;

    public LogClientService() {
        this.clientConfig.setWorkerThreads(4);
        this.client = new NettyRemotingClient(this.clientConfig);
        this.isRunning = true;
    }

    @Override
    public void close() {
        this.client.close();
        this.isRunning = false;
        logger.info("logger client closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rollViewLog(String host, int port, String path, int skipLineNum, int limit) {
        logger.info("roll view log, host : {}, port : {}, path {}, skipLineNum {} ,limit {}", new Object[]{host, port, path, skipLineNum, limit});
        RollViewLogRequestCommand request = new RollViewLogRequestCommand(path, skipLineNum, limit);
        String result = "";
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                RollViewLogResponseCommand rollReviewLog = (RollViewLogResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), RollViewLogResponseCommand.class);
                String string = rollReviewLog.getMsg();
                return string;
            }
        }
        catch (Exception e) {
            logger.error("roll view log error", (Throwable)e);
        }
        finally {
            this.client.closeChannel(address);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String viewLog(String host, int port, String path) {
        logger.info("view log path {}", (Object)path);
        ViewLogRequestCommand request = new ViewLogRequestCommand(path);
        String result = "";
        Host address = new Host(host, port);
        try {
            if (NetUtils.getHost().equals(host)) {
                result = LoggerUtils.readWholeFileContent((String)request.getPath());
            } else {
                Command command = request.convert2Command();
                Command response = this.client.sendSync(address, command, 10000L);
                if (response != null) {
                    ViewLogResponseCommand viewLog = (ViewLogResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), ViewLogResponseCommand.class);
                    result = viewLog.getMsg();
                }
            }
        }
        catch (Exception e) {
            logger.error("view log error", (Throwable)e);
        }
        finally {
            this.client.closeChannel(address);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLogBytes(String host, int port, String path) {
        logger.info("log path {}", (Object)path);
        GetLogBytesRequestCommand request = new GetLogBytesRequestCommand(path);
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                GetLogBytesResponseCommand getLog = (GetLogBytesResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), GetLogBytesResponseCommand.class);
                byte[] byArray = getLog.getData() == null ? new byte[]{} : getLog.getData();
                return byArray;
            }
        }
        catch (Exception e) {
            logger.error("get log size error", (Throwable)e);
        }
        finally {
            this.client.closeChannel(address);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeTaskLog(String host, int port, String path) {
        logger.info("log path {}", (Object)path);
        RemoveTaskLogRequestCommand request = new RemoveTaskLogRequestCommand(path);
        Boolean result = false;
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                RemoveTaskLogResponseCommand taskLogResponse = (RemoveTaskLogResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), RemoveTaskLogResponseCommand.class);
                Boolean bl = taskLogResponse.getStatus();
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("remove task log error", (Throwable)e);
        }
        finally {
            this.client.closeChannel(address);
        }
        return result;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

