/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.log;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class LogPromise {
    private static final ConcurrentHashMap<Long, LogPromise> PROMISES = new ConcurrentHashMap();
    private long opaque;
    private final long start;
    private final long timeout;
    private final CountDownLatch latch;
    private Object result;

    public LogPromise(long opaque, long timeout) {
        this.opaque = opaque;
        this.timeout = timeout;
        this.start = System.currentTimeMillis();
        this.latch = new CountDownLatch(1);
        PROMISES.put(opaque, this);
    }

    public static void notify(long opaque, Object result) {
        LogPromise promise = PROMISES.remove(opaque);
        if (promise != null) {
            promise.doCountDown(result);
        }
    }

    private void doCountDown(Object result) {
        this.result = result;
        this.latch.countDown();
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.start > this.timeout;
    }

    public Object getResult() {
        try {
            this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        PROMISES.remove(this.opaque);
        return this.result;
    }
}

