/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutor;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.StringUtils;

public class ProcessScheduleJob
extends QuartzJobBean {
    private static final Logger logger = LoggerFactory.getLogger(ProcessScheduleJob.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private QuartzExecutor quartzExecutor;

    @Counted(value="quartz_job_executed")
    @Timed(value="quartz_job_execution", percentiles={0.5, 0.75, 0.95, 0.99}, histogram=true)
    protected void executeInternal(JobExecutionContext context) {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        int projectId = dataMap.getInt("projectId");
        int scheduleId = dataMap.getInt("scheduleId");
        Date scheduledFireTime = context.getScheduledFireTime();
        Date fireTime = context.getFireTime();
        logger.info("scheduled fire time :{}, fire time :{}, process id :{}", new Object[]{scheduledFireTime, fireTime, scheduleId});
        Schedule schedule = this.processService.querySchedule(scheduleId);
        if (schedule == null || ReleaseState.OFFLINE == schedule.getReleaseState()) {
            logger.warn("process schedule does not exist in db or process schedule offline\uff0cdelete schedule job in quartz, projectId:{}, scheduleId:{}", (Object)projectId, (Object)scheduleId);
            this.deleteJob(context, projectId, scheduleId);
            return;
        }
        ProcessDefinition processDefinition = this.processService.findProcessDefinitionByCode(schedule.getProcessDefinitionCode());
        ReleaseState releaseState = processDefinition.getReleaseState();
        if (releaseState == ReleaseState.OFFLINE) {
            logger.warn("process definition does not exist in db or offline\uff0cneed not to create command, projectId:{}, processId:{}", (Object)projectId, (Object)processDefinition.getId());
            return;
        }
        Command command = new Command();
        command.setCommandType(CommandType.SCHEDULER);
        command.setExecutorId(schedule.getUserId());
        command.setFailureStrategy(schedule.getFailureStrategy());
        command.setProcessDefinitionCode(schedule.getProcessDefinitionCode());
        command.setScheduleTime(scheduledFireTime);
        command.setStartTime(fireTime);
        command.setWarningGroupId(Integer.valueOf(schedule.getWarningGroupId()));
        String workerGroup = StringUtils.isEmpty((Object)schedule.getWorkerGroup()) ? "default" : schedule.getWorkerGroup();
        command.setWorkerGroup(workerGroup);
        command.setWarningType(schedule.getWarningType());
        command.setProcessInstancePriority(schedule.getProcessInstancePriority());
        command.setProcessDefinitionVersion(processDefinition.getVersion());
        this.processService.createCommand(command);
    }

    private void deleteJob(JobExecutionContext context, int projectId, int scheduleId) {
        Scheduler scheduler = context.getScheduler();
        String jobName = this.quartzExecutor.buildJobName(scheduleId);
        String jobGroupName = this.quartzExecutor.buildJobGroupName(projectId);
        JobKey jobKey = new JobKey(jobName, jobGroupName);
        try {
            if (scheduler.checkExists(jobKey)) {
                logger.info("Try to delete job: {}, group name: {},", (Object)jobName, (Object)jobGroupName);
                scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete job: {}", (Object)jobKey);
        }
    }
}

