/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.alert;

import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendRequestCommand;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendResponseCommand;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.remote.utils.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertClientService
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AlertClientService.class);
    private final NettyClientConfig clientConfig = new NettyClientConfig();
    private final NettyRemotingClient client = new NettyRemotingClient(this.clientConfig);
    private volatile boolean isRunning = true;
    private String host;
    private int port;
    private static final long ALERT_REQUEST_TIMEOUT = 10000L;

    public AlertClientService() {
    }

    public AlertClientService(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void close() {
        this.client.close();
        this.isRunning = false;
        logger.info("alter client closed");
    }

    public AlertSendResponseCommand sendAlert(int groupId, String title, String content, int strategy) {
        return this.sendAlert(this.host, this.port, groupId, title, content, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertSendResponseCommand sendAlert(String host, int port, int groupId, String title, String content, int strategy) {
        logger.info("sync alert send, host : {}, port : {}, groupId : {}, title : {} , strategy : {} ", new Object[]{host, port, groupId, title, strategy});
        AlertSendRequestCommand request = new AlertSendRequestCommand(groupId, title, content, strategy);
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                AlertSendResponseCommand alertSendResponseCommand = (AlertSendResponseCommand)JsonSerializer.deserialize((byte[])response.getBody(), AlertSendResponseCommand.class);
                return alertSendResponseCommand;
            }
        }
        catch (Exception e) {
            logger.error("sync alert send error", (Throwable)e);
        }
        finally {
            this.client.closeChannel(address);
        }
        return null;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

