/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DependentProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResult;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.springframework.transaction.annotation.Transactional;

public interface ProcessService {
    @Transactional
    public ProcessInstance handleCommand(String var1, Command var2);

    public void moveToErrorCommand(Command var1, String var2);

    public int createCommand(Command var1);

    public List<Command> findCommandPage(int var1, int var2);

    public List<Command> findCommandPageBySlot(int var1, int var2, int var3, int var4);

    public boolean verifyIsNeedCreateCommand(Command var1);

    public ProcessInstance findProcessInstanceDetailById(int var1);

    public List<TaskDefinition> getTaskNodeListByDefinition(long var1);

    public ProcessInstance findProcessInstanceById(int var1);

    public ProcessDefinition findProcessDefineById(int var1);

    public ProcessDefinition findProcessDefinition(Long var1, int var2);

    public ProcessDefinition findProcessDefinitionByCode(Long var1);

    public int deleteWorkProcessInstanceById(int var1);

    public int deleteAllSubWorkProcessByParentId(int var1);

    public void removeTaskLogFile(Integer var1);

    public void deleteWorkTaskInstanceByProcessInstanceId(int var1);

    public void recurseFindSubProcess(long var1, List<Long> var3);

    public void createRecoveryWaitingThreadCommand(Command var1, ProcessInstance var2);

    public Tenant getTenantForProcess(int var1, int var2);

    public Environment findEnvironmentByCode(Long var1);

    public void setSubProcessParam(ProcessInstance var1);

    public TaskInstance submitTaskWithRetry(ProcessInstance var1, TaskInstance var2, int var3, long var4);

    @Transactional
    public TaskInstance submitTask(ProcessInstance var1, TaskInstance var2);

    public void createSubWorkProcess(ProcessInstance var1, TaskInstance var2);

    public Map<String, String> getGlobalParamMap(String var1);

    public Command createSubProcessCommand(ProcessInstance var1, ProcessInstance var2, ProcessInstanceMap var3, TaskInstance var4);

    public TaskInstance submitTaskInstanceToDB(TaskInstance var1, ProcessInstance var2);

    public ExecutionStatus getSubmitTaskState(TaskInstance var1, ProcessInstance var2);

    public void saveProcessInstance(ProcessInstance var1);

    public int saveCommand(Command var1);

    public boolean saveTaskInstance(TaskInstance var1);

    public boolean createTaskInstance(TaskInstance var1);

    public boolean updateTaskInstance(TaskInstance var1);

    public TaskInstance findTaskInstanceById(Integer var1);

    public List<TaskInstance> findTaskInstanceByIdList(List<Integer> var1);

    public void packageTaskInstance(TaskInstance var1, ProcessInstance var2);

    public void updateTaskDefinitionResources(TaskDefinition var1);

    public List<Integer> findTaskIdByInstanceState(int var1, ExecutionStatus var2);

    public List<TaskInstance> findValidTaskListByProcessId(Integer var1);

    public List<TaskInstance> findPreviousTaskListByWorkProcessId(Integer var1);

    public int updateWorkProcessInstanceMap(ProcessInstanceMap var1);

    public int createWorkProcessInstanceMap(ProcessInstanceMap var1);

    public ProcessInstanceMap findWorkProcessMapByParent(Integer var1, Integer var2);

    public int deleteWorkProcessMapByParentId(int var1);

    public ProcessInstance findSubProcessInstance(Integer var1, Integer var2);

    public ProcessInstance findParentProcessInstance(Integer var1);

    public int updateProcessInstance(ProcessInstance var1);

    public void changeOutParam(TaskInstance var1);

    public Schedule querySchedule(int var1);

    public List<Schedule> queryReleaseSchedulerListByProcessDefinitionCode(long var1);

    public Map<Long, String> queryWorkerGroupByProcessDefinitionCodes(List<Long> var1);

    public List<DependentProcessDefinition> queryDependentProcessDefinitionByProcessDefinitionCode(long var1);

    public List<ProcessInstance> queryNeedFailoverProcessInstances(String var1);

    public List<String> queryNeedFailoverProcessInstanceHost();

    @Transactional
    public void processNeedFailoverProcessInstances(ProcessInstance var1);

    public List<TaskInstance> queryNeedFailoverTaskInstances(String var1);

    public DataSource findDataSourceById(int var1);

    public int updateProcessInstanceState(Integer var1, ExecutionStatus var2);

    public ProcessInstance findProcessInstanceByTaskId(int var1);

    public List<UdfFunc> queryUdfFunListByIds(Integer[] var1);

    public String queryTenantCodeByResName(String var1, ResourceType var2);

    public List<Schedule> selectAllByProcessDefineCode(long[] var1);

    public ProcessInstance findLastSchedulerProcessInterval(Long var1, DateInterval var2);

    public ProcessInstance findLastManualProcessInterval(Long var1, DateInterval var2);

    public ProcessInstance findLastRunningProcess(Long var1, Date var2, Date var3);

    public String queryUserQueueByProcessInstance(ProcessInstance var1);

    public ProjectUser queryProjectWithUserByProcessInstanceId(int var1);

    public String getTaskWorkerGroup(TaskInstance var1);

    public List<Project> getProjectListHavePerm(int var1);

    public <T> List<T> listUnauthorized(int var1, T[] var2, AuthorizationType var3);

    public User getUserById(int var1);

    public Resource getResourceById(int var1);

    public List<Resource> listResourceByIds(Integer[] var1);

    public String formatTaskAppId(TaskInstance var1);

    public int switchVersion(ProcessDefinition var1, ProcessDefinitionLog var2);

    public int switchProcessTaskRelationVersion(ProcessDefinition var1);

    public int switchTaskDefinitionVersion(long var1, int var3);

    public String getResourceIds(TaskDefinition var1);

    public int saveTaskDefine(User var1, long var2, List<TaskDefinitionLog> var4, Boolean var5);

    public int saveProcessDefine(User var1, ProcessDefinition var2, Boolean var3, Boolean var4);

    public int saveTaskRelation(User var1, long var2, long var4, int var6, List<ProcessTaskRelationLog> var7, List<TaskDefinitionLog> var8, Boolean var9);

    public boolean isTaskOnline(long var1);

    public DAG<String, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition var1);

    public DagData genDagData(ProcessDefinition var1);

    public List<TaskDefinitionLog> genTaskDefineList(List<ProcessTaskRelation> var1);

    public List<TaskDefinitionLog> getTaskDefineLogListByRelation(List<ProcessTaskRelation> var1);

    public TaskDefinition findTaskDefinition(long var1, int var3);

    public List<ProcessTaskRelation> findRelationByCode(long var1, int var3);

    public List<TaskNode> transformTask(List<ProcessTaskRelation> var1, List<TaskDefinitionLog> var2);

    public Map<ProcessInstance, TaskInstance> notifyProcessList(int var1);

    public DqExecuteResult getDqExecuteResultByTaskInstanceId(int var1);

    public int updateDqExecuteResultUserId(int var1);

    public int updateDqExecuteResultState(DqExecuteResult var1);

    public int deleteDqExecuteResultByTaskInstanceId(int var1);

    public int deleteTaskStatisticsValueByTaskInstanceId(int var1);

    public DqRule getDqRule(int var1);

    public List<DqRuleInputEntry> getRuleInputEntry(int var1);

    public List<DqRuleExecuteSql> getDqExecuteSql(int var1);

    public DqComparisonType getComparisonTypeById(int var1);

    public boolean acquireTaskGroup(int var1, String var2, int var3, int var4, int var5);

    public boolean robTaskGroupResource(TaskGroupQueue var1);

    public void releaseAllTaskGroup(int var1);

    public TaskInstance releaseTaskGroup(TaskInstance var1);

    public void changeTaskGroupQueueStatus(int var1, TaskGroupQueueStatus var2);

    public TaskGroupQueue insertIntoTaskGroupQueue(Integer var1, String var2, Integer var3, Integer var4, Integer var5, TaskGroupQueueStatus var6);

    public int updateTaskGroupQueueStatus(Integer var1, int var2);

    public int updateTaskGroupQueue(TaskGroupQueue var1);

    public TaskGroupQueue loadTaskGroupQueue(int var1);

    public void sendStartTask2Master(ProcessInstance var1, int var2, CommandType var3);

    public ProcessInstance loadNextProcess4Serial(long var1, int var3, int var4);

    public void forceProcessInstanceSuccessByTaskInstanceId(Integer var1);
}

