/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import io.micrometer.core.annotation.Counted;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DependentProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResult;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskGroup;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DqComparisonTypeMapper;
import org.apache.dolphinscheduler.dao.mapper.DqExecuteResultMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleExecuteSqlMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleInputEntryMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleMapper;
import org.apache.dolphinscheduler.dao.mapper.DqTaskStatisticsValueMapper;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupQueueMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkFlowLineageMapper;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.dao.utils.DqRuleUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.DqTaskState;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SubProcessParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.TaskTimeoutParameter;
import org.apache.dolphinscheduler.remote.command.StateEventChangeCommand;
import org.apache.dolphinscheduler.remote.command.TaskEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.StateEventCallbackService;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.exceptions.ServiceException;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessServiceImpl
implements ProcessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessDefinitionLogMapper processDefineLogMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private ProcessInstanceMapMapper processInstanceMapMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private DqExecuteResultMapper dqExecuteResultMapper;
    @Autowired
    private DqRuleMapper dqRuleMapper;
    @Autowired
    private DqRuleInputEntryMapper dqRuleInputEntryMapper;
    @Autowired
    private DqRuleExecuteSqlMapper dqRuleExecuteSqlMapper;
    @Autowired
    private DqComparisonTypeMapper dqComparisonTypeMapper;
    @Autowired
    private DqTaskStatisticsValueMapper dqTaskStatisticsValueMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;
    @Autowired
    StateEventCallbackService stateEventCallbackService;
    @Autowired
    private EnvironmentMapper environmentMapper;
    @Autowired
    private TaskGroupQueueMapper taskGroupQueueMapper;
    @Autowired
    private TaskGroupMapper taskGroupMapper;
    @Autowired
    private WorkFlowLineageMapper workFlowLineageMapper;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private ProcessService processService;

    @Override
    @Transactional
    public ProcessInstance handleCommand(String host, Command command) {
        ProcessInstance processInstance = this.constructProcessInstance(command, host);
        if (processInstance == null) {
            this.logger.error("scan command, command parameter is error: {}", (Object)command);
            this.moveToErrorCommand(command, "process instance is null");
            return null;
        }
        processInstance.setCommandType(command.getCommandType());
        processInstance.addHistoryCmd(command.getCommandType());
        ProcessDefinition processDefinition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (processDefinition.getExecutionType().typeIsSerial()) {
            this.saveSerialProcess(processInstance, processDefinition);
            if (processInstance.getState() != ExecutionStatus.SUBMITTED_SUCCESS) {
                this.setSubProcessParam(processInstance);
                this.deleteCommandWithCheck(command.getId());
                return null;
            }
        } else {
            this.saveProcessInstance(processInstance);
        }
        this.setSubProcessParam(processInstance);
        this.deleteCommandWithCheck(command.getId());
        return processInstance;
    }

    protected void saveSerialProcess(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        List runningProcessInstances;
        processInstance.setState(ExecutionStatus.SERIAL_WAIT);
        this.saveProcessInstance(processInstance);
        if (processDefinition.getExecutionType().typeIsSerialWait()) {
            List runningProcessInstances2 = this.processInstanceMapper.queryByProcessDefineCodeAndProcessDefinitionVersionAndStatusAndNextId(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), Constants.RUNNING_PROCESS_STATE, processInstance.getId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)runningProcessInstances2)) {
                processInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
                this.saveProcessInstance(processInstance);
            }
        } else if (processDefinition.getExecutionType().typeIsSerialDiscard()) {
            List runningProcessInstances3 = this.processInstanceMapper.queryByProcessDefineCodeAndProcessDefinitionVersionAndStatusAndNextId(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), Constants.RUNNING_PROCESS_STATE, processInstance.getId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)runningProcessInstances3)) {
                processInstance.setState(ExecutionStatus.STOP);
                this.saveProcessInstance(processInstance);
            }
        } else if (processDefinition.getExecutionType().typeIsSerialPriority() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(runningProcessInstances = this.processInstanceMapper.queryByProcessDefineCodeAndProcessDefinitionVersionAndStatusAndNextId(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), Constants.RUNNING_PROCESS_STATE, processInstance.getId())))) {
            for (ProcessInstance info : runningProcessInstances) {
                info.setCommandType(CommandType.STOP);
                info.addHistoryCmd(CommandType.STOP);
                info.setState(ExecutionStatus.READY_STOP);
                int update = this.updateProcessInstance(info);
                if (update <= 0) continue;
                Host host = new Host(info.getHost());
                StateEventChangeCommand stateEventChangeCommand = new StateEventChangeCommand(info.getId(), 0, info.getState(), info.getId(), 0);
                try {
                    this.stateEventCallbackService.sendResult(host, stateEventChangeCommand.convert2Command());
                }
                catch (Exception e) {
                    this.logger.error("sendResultError");
                }
            }
        }
    }

    @Override
    public void moveToErrorCommand(Command command, String message) {
        ErrorCommand errorCommand = new ErrorCommand(command, message);
        this.errorCommandMapper.insert((Object)errorCommand);
        this.commandMapper.deleteById((Serializable)Integer.valueOf(command.getId()));
    }

    private ProcessInstance setWaitingThreadProcess(Command command, ProcessInstance processInstance) {
        processInstance.setState(ExecutionStatus.WAITING_THREAD);
        if (command.getCommandType() != CommandType.RECOVER_WAITING_THREAD) {
            processInstance.addHistoryCmd(command.getCommandType());
        }
        this.saveProcessInstance(processInstance);
        this.setSubProcessParam(processInstance);
        this.createRecoveryWaitingThreadCommand(command, processInstance);
        return null;
    }

    @Override
    @Counted(value="dolphinscheduler_create_command_count")
    public int createCommand(Command command) {
        int result = 0;
        if (command != null) {
            Schedule schedule = this.scheduleMapper.queryByProcessDefinitionCode(command.getProcessDefinitionCode());
            Map commandParams = JSONUtils.toMap((String)command.getCommandParam());
            if (commandParams != null && schedule != null) {
                commandParams.put("schedule_timezone", schedule.getTimezoneId());
                command.setCommandParam(JSONUtils.toJsonString((Object)commandParams));
            }
            result = this.commandMapper.insert((Object)command);
        }
        return result;
    }

    @Override
    public List<Command> findCommandPage(int pageSize, int pageNumber) {
        return this.commandMapper.queryCommandPage(pageSize, pageNumber * pageSize);
    }

    @Override
    public List<Command> findCommandPageBySlot(int pageSize, int pageNumber, int masterCount, int thisMasterSlot) {
        if (masterCount <= 0) {
            return Lists.newArrayList();
        }
        return this.commandMapper.queryCommandPageBySlot(pageSize, pageNumber * pageSize, masterCount, thisMasterSlot);
    }

    @Override
    public boolean verifyIsNeedCreateCommand(Command command) {
        boolean isNeedCreate = true;
        EnumMap<CommandType, Integer> cmdTypeMap = new EnumMap<CommandType, Integer>(CommandType.class);
        cmdTypeMap.put(CommandType.REPEAT_RUNNING, 1);
        cmdTypeMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, 1);
        cmdTypeMap.put(CommandType.START_FAILURE_TASK_PROCESS, 1);
        CommandType commandType = command.getCommandType();
        if (cmdTypeMap.containsKey(commandType)) {
            ObjectNode cmdParamObj = JSONUtils.parseObject((String)command.getCommandParam());
            int processInstanceId = cmdParamObj.path("ProcessInstanceId").asInt();
            List commands = this.commandMapper.selectList(null);
            for (Command tmpCommand : commands) {
                ObjectNode tempObj;
                if (!cmdTypeMap.containsKey(tmpCommand.getCommandType()) || (tempObj = JSONUtils.parseObject((String)tmpCommand.getCommandParam())) == null || processInstanceId != tempObj.path("ProcessInstanceId").asInt()) continue;
                isNeedCreate = false;
                break;
            }
        }
        return isNeedCreate;
    }

    @Override
    public ProcessInstance findProcessInstanceDetailById(int processId) {
        return this.processInstanceMapper.queryDetailById(processId);
    }

    @Override
    public List<TaskDefinition> getTaskNodeListByDefinition(long defineCode) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(defineCode);
        if (processDefinition == null) {
            this.logger.error("process define not exists");
            return Lists.newArrayList();
        }
        List processTaskRelations = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinition.getCode(), processDefinition.getVersion());
        HashSet<TaskDefinition> taskDefinitionSet = new HashSet<TaskDefinition>();
        for (ProcessTaskRelationLog processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPostTaskCode() <= 0L) continue;
            taskDefinitionSet.add(new TaskDefinition(processTaskRelation.getPostTaskCode(), processTaskRelation.getPostTaskVersion()));
        }
        if (taskDefinitionSet.isEmpty()) {
            return Lists.newArrayList();
        }
        List taskDefinitionLogs = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitionSet);
        return Lists.newArrayList((Iterable)taskDefinitionLogs);
    }

    @Override
    public ProcessInstance findProcessInstanceById(int processId) {
        return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(processId));
    }

    @Override
    public ProcessDefinition findProcessDefineById(int processDefinitionId) {
        return (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(processDefinitionId));
    }

    @Override
    public ProcessDefinition findProcessDefinition(Long processDefinitionCode, int version) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processDefinitionCode.longValue());
        if ((processDefinition == null || processDefinition.getVersion() != version) && (processDefinition = this.processDefineLogMapper.queryByDefinitionCodeAndVersion(processDefinitionCode.longValue(), version)) != null) {
            processDefinition.setId(0);
        }
        return processDefinition;
    }

    @Override
    public ProcessDefinition findProcessDefinitionByCode(Long processDefinitionCode) {
        return this.processDefineMapper.queryByCode(processDefinitionCode.longValue());
    }

    @Override
    public int deleteWorkProcessInstanceById(int processInstanceId) {
        return this.processInstanceMapper.deleteById((Serializable)Integer.valueOf(processInstanceId));
    }

    @Override
    public int deleteAllSubWorkProcessByParentId(int processInstanceId) {
        List subProcessIdList = this.processInstanceMapMapper.querySubIdListByParentId(processInstanceId);
        for (Integer subId : subProcessIdList) {
            this.deleteAllSubWorkProcessByParentId(subId);
            this.deleteWorkProcessMapByParentId(subId);
            this.removeTaskLogFile(subId);
            this.deleteWorkProcessInstanceById(subId);
        }
        return 1;
    }

    @Override
    public void removeTaskLogFile(Integer processInstanceId) {
        List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstanceId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(taskInstanceList)) {
            return;
        }
        try (LogClientService logClient = new LogClientService();){
            for (TaskInstance taskInstance : taskInstanceList) {
                String taskLogPath = taskInstance.getLogPath();
                if (StringUtils.isEmpty((String)taskInstance.getHost())) continue;
                Host host = Host.of((String)taskInstance.getHost());
                logClient.removeTaskLog(host.getIp(), host.getPort(), taskLogPath);
            }
        }
    }

    @Override
    public void deleteWorkTaskInstanceByProcessInstanceId(int processInstanceId) {
        List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstanceId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(taskInstanceList)) {
            return;
        }
        ArrayList<Integer> taskInstanceIdList = new ArrayList<Integer>();
        for (TaskInstance taskInstance : taskInstanceList) {
            taskInstanceIdList.add(taskInstance.getId());
        }
        this.taskInstanceMapper.deleteBatchIds(taskInstanceIdList);
    }

    @Override
    public void recurseFindSubProcess(long parentCode, List<Long> ids) {
        List<TaskDefinition> taskNodeList = this.getTaskNodeListByDefinition(parentCode);
        if (taskNodeList != null && !taskNodeList.isEmpty()) {
            for (TaskDefinition taskNode : taskNodeList) {
                String parameter = taskNode.getTaskParams();
                ObjectNode parameterJson = JSONUtils.parseObject((String)parameter);
                if (parameterJson.get("processDefinitionCode") == null) continue;
                SubProcessParameters subProcessParam = (SubProcessParameters)JSONUtils.parseObject((String)parameter, SubProcessParameters.class);
                ids.add(subProcessParam.getProcessDefinitionCode());
                this.recurseFindSubProcess(subProcessParam.getProcessDefinitionCode(), ids);
            }
        }
    }

    @Override
    public void createRecoveryWaitingThreadCommand(Command originCommand, ProcessInstance processInstance) {
        if (processInstance.getIsSubProcess() == Flag.YES) {
            if (originCommand != null) {
                this.commandMapper.deleteById((Serializable)Integer.valueOf(originCommand.getId()));
            }
            return;
        }
        HashMap<String, String> cmdParam = new HashMap<String, String>();
        cmdParam.put("WaitingThreadInstanceId", String.valueOf(processInstance.getId()));
        if (originCommand == null) {
            Command command = new Command(CommandType.RECOVER_WAITING_THREAD, processInstance.getTaskDependType(), processInstance.getFailureStrategy(), processInstance.getExecutorId(), processInstance.getProcessDefinition().getCode(), JSONUtils.toJsonString(cmdParam), processInstance.getWarningType(), processInstance.getWarningGroupId().intValue(), processInstance.getScheduleTime(), processInstance.getWorkerGroup(), processInstance.getEnvironmentCode(), processInstance.getProcessInstancePriority(), processInstance.getDryRun(), processInstance.getId(), processInstance.getProcessDefinitionVersion());
            this.saveCommand(command);
            return;
        }
        if (originCommand.getCommandType() == CommandType.RECOVER_WAITING_THREAD) {
            originCommand.setUpdateTime(new Date());
            this.saveCommand(originCommand);
        } else {
            this.commandMapper.deleteById((Serializable)Integer.valueOf(originCommand.getId()));
            originCommand.setId(0);
            originCommand.setCommandType(CommandType.RECOVER_WAITING_THREAD);
            originCommand.setUpdateTime(new Date());
            originCommand.setCommandParam(JSONUtils.toJsonString(cmdParam));
            originCommand.setProcessInstancePriority(processInstance.getProcessInstancePriority());
            this.saveCommand(originCommand);
        }
    }

    private Date getScheduleTime(Command command, Map<String, String> cmdParam) {
        Date scheduleTime = command.getScheduleTime();
        if (scheduleTime == null && cmdParam != null && cmdParam.containsKey("complementStartDate")) {
            List<Schedule> schedules;
            Date end;
            Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
            List<Date> complementDateList = CronUtils.getSelfFireDateList(start, end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate")), schedules = this.queryReleaseSchedulerListByProcessDefinitionCode(command.getProcessDefinitionCode()));
            if (complementDateList.size() > 0) {
                scheduleTime = complementDateList.get(0);
            } else {
                this.logger.error("set scheduler time error: complement date list is empty, command: {}", (Object)command.toString());
            }
        }
        return scheduleTime;
    }

    private ProcessInstance generateNewProcessInstance(ProcessDefinition processDefinition, Command command, Map<String, String> cmdParam) {
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        processInstance.setProcessDefinitionCode(Long.valueOf(processDefinition.getCode()));
        processInstance.setProcessDefinitionVersion(processDefinition.getVersion());
        processInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        processInstance.setRecovery(Flag.NO);
        processInstance.setStartTime(new Date());
        processInstance.setRestartTime(null);
        processInstance.setRunTimes(1);
        processInstance.setMaxTryTimes(0);
        processInstance.setCommandParam(command.getCommandParam());
        processInstance.setCommandType(command.getCommandType());
        processInstance.setIsSubProcess(Flag.NO);
        processInstance.setTaskDependType(command.getTaskDependType());
        processInstance.setFailureStrategy(command.getFailureStrategy());
        processInstance.setExecutorId(command.getExecutorId());
        WarningType warningType = command.getWarningType() == null ? WarningType.NONE : command.getWarningType();
        processInstance.setWarningType(warningType);
        Integer warningGroupId = command.getWarningGroupId() == null ? 0 : command.getWarningGroupId();
        processInstance.setWarningGroupId(warningGroupId);
        processInstance.setDryRun(command.getDryRun());
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setCommandStartTime(command.getStartTime());
        processInstance.setLocations(processDefinition.getLocations());
        this.setGlobalParamIfCommanded(processDefinition, cmdParam);
        Map commandParamMap = JSONUtils.toMap((String)command.getCommandParam());
        String timezoneId = null;
        if (commandParamMap != null) {
            timezoneId = (String)commandParamMap.get("schedule_timezone");
        }
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)this.getCommandTypeIfComplement(processInstance, command), (Date)processInstance.getScheduleTime(), (String)timezoneId));
        processInstance.setProcessInstancePriority(command.getProcessInstancePriority());
        String workerGroup = StringUtils.isBlank((String)command.getWorkerGroup()) ? "default" : command.getWorkerGroup();
        processInstance.setWorkerGroup(workerGroup);
        processInstance.setEnvironmentCode(Long.valueOf(Objects.isNull(command.getEnvironmentCode()) ? -1L : command.getEnvironmentCode()));
        processInstance.setTimeout(processDefinition.getTimeout());
        processInstance.setTenantId(processDefinition.getTenantId());
        return processInstance;
    }

    private void setGlobalParamIfCommanded(ProcessDefinition processDefinition, Map<String, String> cmdParam) {
        Map startParamMap = new HashMap();
        if (cmdParam != null && cmdParam.containsKey("StartParams")) {
            String startParamJson = cmdParam.get("StartParams");
            startParamMap = JSONUtils.toMap((String)startParamJson);
        }
        Map fatherParamMap = new HashMap();
        if (cmdParam != null && cmdParam.containsKey("fatherParams")) {
            String fatherParamJson = cmdParam.get("fatherParams");
            fatherParamMap = JSONUtils.toMap((String)fatherParamJson);
        }
        startParamMap.putAll(fatherParamMap);
        Map globalMap = processDefinition.getGlobalParamMap();
        List globalParamList = processDefinition.getGlobalParamList();
        if (startParamMap.size() > 0 && globalMap != null) {
            for (Map.Entry entry : globalMap.entrySet()) {
                String val = (String)startParamMap.get(entry.getKey());
                if (val == null) continue;
                entry.setValue(val);
            }
            for (Map.Entry entry : startParamMap.entrySet()) {
                if (globalMap.containsKey(entry.getKey())) continue;
                globalMap.put((String)entry.getKey(), (String)entry.getValue());
                globalParamList.add(new Property((String)entry.getKey(), Direct.IN, DataType.VARCHAR, (String)entry.getValue()));
            }
        }
    }

    @Override
    public Tenant getTenantForProcess(int tenantId, int userId) {
        Tenant tenant = null;
        if (tenantId >= 0) {
            tenant = this.tenantMapper.queryById(tenantId);
        }
        if (userId == 0) {
            return null;
        }
        if (tenant == null) {
            User user = this.userMapper.selectById(userId);
            tenant = this.tenantMapper.queryById(user.getTenantId());
        }
        return tenant;
    }

    @Override
    public Environment findEnvironmentByCode(Long environmentCode) {
        Environment environment = null;
        if (environmentCode >= 0L) {
            environment = this.environmentMapper.queryByEnvironmentCode(environmentCode);
        }
        return environment;
    }

    private Boolean checkCmdParam(Command command, Map<String, String> cmdParam) {
        if (!(command.getTaskDependType() != TaskDependType.TASK_ONLY && command.getTaskDependType() != TaskDependType.TASK_PRE || cmdParam != null && cmdParam.containsKey("StartNodeList") && !cmdParam.get("StartNodeList").isEmpty())) {
            this.logger.error("command node depend type is {}, but start nodes is null ", (Object)command.getTaskDependType());
            return false;
        }
        return true;
    }

    protected ProcessInstance constructProcessInstance(Command command, String host) {
        ProcessInstance processInstance;
        CommandType commandType = command.getCommandType();
        ProcessDefinition processDefinition = this.findProcessDefinition(command.getProcessDefinitionCode(), command.getProcessDefinitionVersion());
        if (processDefinition == null) {
            this.logger.error("cannot find the work process define! define code : {}", (Object)command.getProcessDefinitionCode());
            throw new IllegalArgumentException("Cannot find the process definition for this workflowInstance");
        }
        Map cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        int processInstanceId = command.getProcessInstanceId();
        if (processInstanceId == 0) {
            processInstance = this.generateNewProcessInstance(processDefinition, command, cmdParam);
        } else {
            processInstance = this.findProcessInstanceDetailById(processInstanceId);
            if (processInstance == null) {
                return null;
            }
        }
        if (cmdParam != null) {
            CommandType commandTypeIfComplement = this.getCommandTypeIfComplement(processInstance, command);
            if (commandTypeIfComplement == CommandType.REPEAT_RUNNING) {
                this.setGlobalParamIfCommanded(processDefinition, cmdParam);
            }
            String timezoneId = (String)cmdParam.get("schedule_timezone");
            processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)commandTypeIfComplement, (Date)processInstance.getScheduleTime(), (String)timezoneId));
            processInstance.setProcessDefinition(processDefinition);
        }
        if (processInstance.getCommandParam() != null) {
            Map processCmdParam = JSONUtils.toMap((String)processInstance.getCommandParam());
            processCmdParam.forEach((key, value) -> {
                if (!cmdParam.containsKey(key)) {
                    cmdParam.put(key, value);
                }
            });
        }
        if (cmdParam != null && cmdParam.containsKey("processInstanceId")) {
            processInstance.setCommandParam(command.getCommandParam());
        }
        if (Boolean.FALSE.equals(this.checkCmdParam(command, cmdParam))) {
            this.logger.error("command parameter check failed!");
            return null;
        }
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setHost(host);
        processInstance.setRestartTime(new Date());
        ExecutionStatus runStatus = ExecutionStatus.RUNNING_EXECUTION;
        int runTime = processInstance.getRunTimes();
        switch (commandType) {
            case START_PROCESS: {
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                List<Integer> failedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.FAILURE);
                List<Integer> toleranceList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.NEED_FAULT_TOLERANCE);
                List<Integer> killedList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                cmdParam.remove("StartNodeIdList");
                failedList.addAll(killedList);
                failedList.addAll(toleranceList);
                for (Integer taskId : failedList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(failedList)));
                processInstance.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case START_CURRENT_TASK_PROCESS: {
                break;
            }
            case RECOVER_WAITING_THREAD: {
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                cmdParam.remove("StartNodeIdList");
                List<Integer> suspendedNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.PAUSE);
                List<Integer> stopNodeList = this.findTaskIdByInstanceState(processInstance.getId(), ExecutionStatus.KILL);
                suspendedNodeList.addAll(stopNodeList);
                for (Integer taskId : suspendedNodeList) {
                    this.initTaskInstance(this.findTaskInstanceById(taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(suspendedNodeList)));
                processInstance.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                processInstance.setRecovery(Flag.YES);
                processInstance.setRunTimes(runTime + 1);
                runStatus = processInstance.getState();
                break;
            }
            case COMPLEMENT_DATA: {
                if (processInstance.getId() == 0) break;
                List<TaskInstance> taskInstanceList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : taskInstanceList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                break;
            }
            case REPEAT_RUNNING: {
                if (cmdParam.containsKey("StartNodeIdList")) {
                    cmdParam.remove("StartNodeIdList");
                    processInstance.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
                }
                List<TaskInstance> validTaskList = this.findValidTaskListByProcessId(processInstance.getId());
                for (TaskInstance taskInstance : validTaskList) {
                    taskInstance.setFlag(Flag.NO);
                    this.updateTaskInstance(taskInstance);
                }
                processInstance.setStartTime(new Date());
                processInstance.setRestartTime(processInstance.getStartTime());
                processInstance.setEndTime(null);
                processInstance.setRunTimes(runTime + 1);
                this.initComplementDataParam(processDefinition, processInstance, cmdParam);
                break;
            }
            case SCHEDULER: {
                break;
            }
        }
        processInstance.setState(runStatus);
        return processInstance;
    }

    private ProcessDefinition getProcessDefinitionByCommand(long processDefinitionCode, Map<String, String> cmdParam) {
        if (cmdParam != null) {
            int processInstanceId = 0;
            if (cmdParam.containsKey("ProcessInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("ProcessInstanceId"));
            } else if (cmdParam.containsKey("processInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("processInstanceId"));
            } else if (cmdParam.containsKey("WaitingThreadInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("WaitingThreadInstanceId"));
            }
            if (processInstanceId != 0) {
                ProcessInstance processInstance = this.findProcessInstanceDetailById(processInstanceId);
                if (processInstance == null) {
                    return null;
                }
                return this.processDefineLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
            }
        }
        return this.processDefineMapper.queryByCode(processDefinitionCode);
    }

    private CommandType getCommandTypeIfComplement(ProcessInstance processInstance, Command command) {
        if (CommandType.COMPLEMENT_DATA == processInstance.getCmdTypeIfComplement()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return command.getCommandType();
    }

    private void initComplementDataParam(ProcessDefinition processDefinition, ProcessInstance processInstance, Map<String, String> cmdParam) {
        List<Schedule> listSchedules;
        Date end;
        if (!processInstance.isComplementData()) {
            return;
        }
        Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
        List<Date> complementDate = CronUtils.getSelfFireDateList(start, end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate")), listSchedules = this.queryReleaseSchedulerListByProcessDefinitionCode(processInstance.getProcessDefinitionCode()));
        if (complementDate.size() > 0 && Flag.NO == processInstance.getIsSubProcess()) {
            processInstance.setScheduleTime(complementDate.get(0));
        }
        String timezoneId = cmdParam.get("schedule_timezone");
        processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)processDefinition.getGlobalParamMap(), (List)processDefinition.getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)processInstance.getScheduleTime(), (String)timezoneId));
    }

    @Override
    public void setSubProcessParam(ProcessInstance subProcessInstance) {
        ProcessInstanceMap processInstanceMap;
        String parentInstanceId;
        String cmdParam = subProcessInstance.getCommandParam();
        if (StringUtils.isEmpty((String)cmdParam)) {
            return;
        }
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap.containsKey("processInstanceId") && "0".equals(paramMap.get("processInstanceId"))) {
            paramMap.remove("processInstanceId");
            paramMap.put("processInstanceId", String.valueOf(subProcessInstance.getId()));
            subProcessInstance.setCommandParam(JSONUtils.toJsonString((Object)paramMap));
            subProcessInstance.setIsSubProcess(Flag.YES);
            this.saveProcessInstance(subProcessInstance);
        }
        if (StringUtils.isNotEmpty((String)(parentInstanceId = (String)paramMap.get("parentProcessInstanceId")))) {
            ProcessInstance parentInstance = this.findProcessInstanceDetailById(Integer.parseInt(parentInstanceId));
            if (parentInstance != null) {
                subProcessInstance.setGlobalParams(this.joinGlobalParams(parentInstance.getGlobalParams(), subProcessInstance.getGlobalParams()));
                subProcessInstance.setVarPool(this.joinVarPool(parentInstance.getVarPool(), subProcessInstance.getVarPool()));
                this.saveProcessInstance(subProcessInstance);
            } else {
                this.logger.error("sub process command params error, cannot find parent instance: {} ", (Object)cmdParam);
            }
        }
        if ((processInstanceMap = (ProcessInstanceMap)JSONUtils.parseObject((String)cmdParam, ProcessInstanceMap.class)) == null || processInstanceMap.getParentProcessInstanceId() == 0) {
            return;
        }
        processInstanceMap.setProcessInstanceId(subProcessInstance.getId());
        this.updateWorkProcessInstanceMap(processInstanceMap);
    }

    private String joinGlobalParams(String parentGlobalParams, String subGlobalParams) {
        ArrayList parentParams = Lists.newArrayList((Iterable)JSONUtils.toList((String)parentGlobalParams, Property.class));
        List subParams = JSONUtils.toList((String)subGlobalParams, Property.class);
        Set parentParamKeys = parentParams.stream().map(Property::getProp).collect(Collectors.toSet());
        List extraSubParams = subParams.stream().filter(subProp -> !parentParamKeys.contains(subProp.getProp())).collect(Collectors.toList());
        parentParams.addAll(extraSubParams);
        return JSONUtils.toJsonString((Object)parentParams);
    }

    private String joinVarPool(String parentValPool, String subValPool) {
        List<Object> parentValPools = Lists.newArrayList((Iterable)JSONUtils.toList((String)parentValPool, Property.class));
        parentValPools = parentValPools.stream().filter(valPool -> valPool.getDirect() == Direct.OUT).collect(Collectors.toList());
        ArrayList subValPools = Lists.newArrayList((Iterable)JSONUtils.toList((String)subValPool, Property.class));
        Set parentValPoolKeys = parentValPools.stream().map(Property::getProp).collect(Collectors.toSet());
        List extraSubValPools = subValPools.stream().filter(sub -> !parentValPoolKeys.contains(sub.getProp())).collect(Collectors.toList());
        parentValPools.addAll(extraSubValPools);
        return JSONUtils.toJsonString(parentValPools);
    }

    private void initTaskInstance(TaskInstance taskInstance) {
        if (!taskInstance.isSubProcess() && (taskInstance.getState().typeIsCancel() || taskInstance.getState().typeIsFailure())) {
            taskInstance.setFlag(Flag.NO);
            this.updateTaskInstance(taskInstance);
            return;
        }
        taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
        this.updateTaskInstance(taskInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInstance submitTaskWithRetry(ProcessInstance processInstance, TaskInstance taskInstance, int commitRetryTimes, long commitInterval) {
        int retryTimes = 1;
        TaskInstance task = null;
        while (retryTimes <= commitRetryTimes) {
            try {
                task = this.processService.submitTask(processInstance, taskInstance);
                if (task != null && task.getId() != 0) break;
                this.logger.error("task commit to db failed , taskCode: {} has already retry {} times, please check the database", (Object)taskInstance.getTaskCode(), (Object)retryTimes);
                Thread.sleep(commitInterval);
            }
            catch (Exception e) {
                this.logger.error("task commit to db failed", (Throwable)e);
            }
            finally {
                ++retryTimes;
            }
        }
        return task;
    }

    @Override
    @Transactional
    public TaskInstance submitTask(ProcessInstance processInstance, TaskInstance taskInstance) {
        this.logger.info("Start save taskInstance to database : {}, processInstance id:{}, state: {}", new Object[]{taskInstance.getName(), taskInstance.getProcessInstanceId(), processInstance.getState()});
        TaskInstance task = this.submitTaskInstanceToDB(taskInstance, processInstance);
        if (task == null) {
            this.logger.error("Save taskInstance to db error, task name:{}, process id:{} state: {} ", new Object[]{taskInstance.getName(), taskInstance.getProcessInstance().getId(), processInstance.getState()});
            return null;
        }
        if (!task.getState().typeIsFinished()) {
            this.createSubWorkProcess(processInstance, task);
        }
        this.logger.info("End save taskInstance to db successfully:{}, taskInstanceName: {}, taskInstance state:{}, processInstanceId:{}, processInstanceState: {}", new Object[]{task.getId(), task.getName(), task.getState(), processInstance.getId(), processInstance.getState()});
        return task;
    }

    private ProcessInstanceMap setProcessInstanceMap(ProcessInstance parentInstance, TaskInstance parentTask, ProcessInstanceMap processMap) {
        if (processMap != null) {
            return processMap;
        }
        if (parentInstance.getCommandType() == CommandType.REPEAT_RUNNING && (processMap = this.findPreviousTaskProcessMap(parentInstance, parentTask)) != null) {
            processMap.setParentTaskInstanceId(parentTask.getId());
            this.updateWorkProcessInstanceMap(processMap);
            return processMap;
        }
        processMap = new ProcessInstanceMap();
        processMap.setParentProcessInstanceId(parentInstance.getId());
        processMap.setParentTaskInstanceId(parentTask.getId());
        this.createWorkProcessInstanceMap(processMap);
        return processMap;
    }

    private ProcessInstanceMap findPreviousTaskProcessMap(ProcessInstance parentProcessInstance, TaskInstance parentTask) {
        Integer preTaskId = 0;
        List<TaskInstance> preTaskList = this.findPreviousTaskListByWorkProcessId(parentProcessInstance.getId());
        for (TaskInstance task : preTaskList) {
            if (!task.getName().equals(parentTask.getName())) continue;
            preTaskId = task.getId();
            ProcessInstanceMap map = this.findWorkProcessMapByParent(parentProcessInstance.getId(), preTaskId);
            if (map == null) continue;
            return map;
        }
        this.logger.info("sub process instance is not found,parent task:{},parent instance:{}", (Object)parentTask.getId(), (Object)parentProcessInstance.getId());
        return null;
    }

    @Override
    public void createSubWorkProcess(ProcessInstance parentProcessInstance, TaskInstance task) {
        if (!task.isSubProcess()) {
            return;
        }
        ProcessInstanceMap instanceMap = this.findWorkProcessMapByParent(parentProcessInstance.getId(), task.getId());
        if (null != instanceMap && CommandType.RECOVER_TOLERANCE_FAULT_PROCESS == parentProcessInstance.getCommandType()) {
            return;
        }
        instanceMap = this.setProcessInstanceMap(parentProcessInstance, task, instanceMap);
        ProcessInstance childInstance = null;
        if (instanceMap.getProcessInstanceId() != 0) {
            childInstance = this.findProcessInstanceById(instanceMap.getProcessInstanceId());
        }
        if (childInstance != null && childInstance.getState() == ExecutionStatus.SUCCESS && CommandType.START_FAILURE_TASK_PROCESS == parentProcessInstance.getCommandType()) {
            this.logger.info("sub process instance {} status is success, so skip creating command", (Object)childInstance.getId());
            return;
        }
        Command subProcessCommand = this.createSubProcessCommand(parentProcessInstance, childInstance, instanceMap, task);
        this.updateSubProcessDefinitionByParent(parentProcessInstance, subProcessCommand.getProcessDefinitionCode());
        this.initSubInstanceState(childInstance);
        this.createCommand(subProcessCommand);
        this.logger.info("sub process command created: {} ", (Object)subProcessCommand);
    }

    protected String getSubWorkFlowParam(ProcessInstanceMap instanceMap, ProcessInstance parentProcessInstance, Map<String, String> fatherParams) {
        String processMapStr = JSONUtils.toJsonString((Object)instanceMap);
        Map cmdParam = JSONUtils.toMap((String)processMapStr);
        if (parentProcessInstance.isComplementData()) {
            Map parentParam = JSONUtils.toMap((String)parentProcessInstance.getCommandParam());
            String endTime = (String)parentParam.get("complementEndDate");
            String startTime = (String)parentParam.get("complementStartDate");
            cmdParam.put("complementEndDate", endTime);
            cmdParam.put("complementStartDate", startTime);
            processMapStr = JSONUtils.toJsonString((Object)cmdParam);
        }
        if (fatherParams.size() != 0) {
            cmdParam.put("fatherParams", JSONUtils.toJsonString(fatherParams));
            processMapStr = JSONUtils.toJsonString((Object)cmdParam);
        }
        return processMapStr;
    }

    @Override
    public Map<String, String> getGlobalParamMap(String globalParams) {
        Map<String, String> globalParamMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)globalParams)) {
            List propList = JSONUtils.toList((String)globalParams, Property.class);
            globalParamMap = propList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        }
        return globalParamMap;
    }

    @Override
    public Command createSubProcessCommand(ProcessInstance parentProcessInstance, ProcessInstance childInstance, ProcessInstanceMap instanceMap, TaskInstance task) {
        CommandType commandType = this.getSubCommandType(parentProcessInstance, childInstance);
        Map subProcessParam = JSONUtils.toMap((String)task.getTaskParams(), String.class, Object.class);
        long childDefineCode = 0L;
        if (subProcessParam.containsKey("processDefinitionCode")) {
            childDefineCode = NumberUtils.toLong((String)String.valueOf(subProcessParam.get("processDefinitionCode")));
        }
        ProcessDefinition subProcessDefinition = this.processDefineMapper.queryByCode(childDefineCode);
        Object localParams = subProcessParam.get("localParams");
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        Map<String, String> globalMap = this.getGlobalParamMap(task.getVarPool());
        HashMap<String, String> fatherParams = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)allParam)) {
            for (Property info : allParam) {
                if (Direct.OUT == info.getDirect()) continue;
                fatherParams.put(info.getProp(), globalMap.get(info.getProp()));
            }
        }
        String processParam = this.getSubWorkFlowParam(instanceMap, parentProcessInstance, fatherParams);
        int subProcessInstanceId = childInstance == null ? 0 : childInstance.getId();
        return new Command(commandType, TaskDependType.TASK_POST, parentProcessInstance.getFailureStrategy(), parentProcessInstance.getExecutorId(), subProcessDefinition.getCode(), processParam, parentProcessInstance.getWarningType(), parentProcessInstance.getWarningGroupId().intValue(), parentProcessInstance.getScheduleTime(), task.getWorkerGroup(), task.getEnvironmentCode(), parentProcessInstance.getProcessInstancePriority(), parentProcessInstance.getDryRun(), subProcessInstanceId, subProcessDefinition.getVersion());
    }

    private void initSubInstanceState(ProcessInstance childInstance) {
        if (childInstance != null) {
            childInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
            this.updateProcessInstance(childInstance);
        }
    }

    private CommandType getSubCommandType(ProcessInstance parentProcessInstance, ProcessInstance childInstance) {
        CommandType commandType = parentProcessInstance.getCommandType();
        if (childInstance == null) {
            String fatherHistoryCommand = parentProcessInstance.getHistoryCmd();
            commandType = CommandType.valueOf((String)fatherHistoryCommand.split(",")[0]);
        }
        return commandType;
    }

    private void updateSubProcessDefinitionByParent(ProcessInstance parentProcessInstance, long childDefinitionCode) {
        ProcessDefinition fatherDefinition = this.findProcessDefinition(parentProcessInstance.getProcessDefinitionCode(), parentProcessInstance.getProcessDefinitionVersion());
        ProcessDefinition childDefinition = this.findProcessDefinitionByCode(childDefinitionCode);
        if (childDefinition != null && fatherDefinition != null) {
            childDefinition.setWarningGroupId(fatherDefinition.getWarningGroupId());
            this.processDefineMapper.updateById(childDefinition);
        }
    }

    @Override
    public TaskInstance submitTaskInstanceToDB(TaskInstance taskInstance, ProcessInstance processInstance) {
        boolean saveResult;
        ExecutionStatus processInstanceState = processInstance.getState();
        if (processInstanceState.typeIsFinished() || processInstanceState == ExecutionStatus.READY_STOP) {
            this.logger.warn("processInstance: {} state was: {}, skip submit this task, taskCode: {}", new Object[]{processInstance.getId(), processInstanceState, taskInstance.getTaskCode()});
            return null;
        }
        if (processInstanceState == ExecutionStatus.READY_PAUSE) {
            taskInstance.setState(ExecutionStatus.PAUSE);
        }
        taskInstance.setExecutorId(processInstance.getExecutorId());
        taskInstance.setState(this.getSubmitTaskState(taskInstance, processInstance));
        if (taskInstance.getSubmitTime() == null) {
            taskInstance.setSubmitTime(new Date());
        }
        if (taskInstance.getFirstSubmitTime() == null) {
            taskInstance.setFirstSubmitTime(taskInstance.getSubmitTime());
        }
        if (!(saveResult = this.saveTaskInstance(taskInstance))) {
            return null;
        }
        return taskInstance;
    }

    @Override
    public ExecutionStatus getSubmitTaskState(TaskInstance taskInstance, ProcessInstance processInstance) {
        ExecutionStatus state = taskInstance.getState();
        if (state == ExecutionStatus.RUNNING_EXECUTION || state == ExecutionStatus.DELAY_EXECUTION || state == ExecutionStatus.KILL || state == ExecutionStatus.DISPATCH) {
            return state;
        }
        state = processInstance.getState() == ExecutionStatus.READY_PAUSE ? ExecutionStatus.PAUSE : (processInstance.getState() == ExecutionStatus.READY_STOP || !this.checkProcessStrategy(taskInstance, processInstance) ? ExecutionStatus.KILL : ExecutionStatus.SUBMITTED_SUCCESS);
        return state;
    }

    private boolean checkProcessStrategy(TaskInstance taskInstance, ProcessInstance processInstance) {
        FailureStrategy failureStrategy = processInstance.getFailureStrategy();
        if (failureStrategy == FailureStrategy.CONTINUE) {
            return true;
        }
        List<TaskInstance> taskInstances = this.findValidTaskListByProcessId(taskInstance.getProcessInstanceId());
        for (TaskInstance task : taskInstances) {
            if (task.getState() != ExecutionStatus.FAILURE || task.getRetryTimes() < task.getMaxRetryTimes()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void saveProcessInstance(ProcessInstance processInstance) {
        if (processInstance == null) {
            this.logger.error("save error, process instance is null!");
            return;
        }
        if (processInstance.getId() != 0) {
            this.processInstanceMapper.updateById((Object)processInstance);
        } else {
            this.processInstanceMapper.insert((Object)processInstance);
        }
    }

    @Override
    public int saveCommand(Command command) {
        if (command.getId() != 0) {
            return this.commandMapper.updateById((Object)command);
        }
        return this.commandMapper.insert((Object)command);
    }

    @Override
    public boolean saveTaskInstance(TaskInstance taskInstance) {
        if (taskInstance.getId() != 0) {
            return this.updateTaskInstance(taskInstance);
        }
        return this.createTaskInstance(taskInstance);
    }

    @Override
    public boolean createTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.insert((Object)taskInstance);
        return count > 0;
    }

    @Override
    public boolean updateTaskInstance(TaskInstance taskInstance) {
        int count = this.taskInstanceMapper.updateById((Object)taskInstance);
        return count > 0;
    }

    @Override
    public TaskInstance findTaskInstanceById(Integer taskId) {
        return (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskId);
    }

    @Override
    public List<TaskInstance> findTaskInstanceByIdList(List<Integer> idList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(idList)) {
            return new ArrayList<TaskInstance>();
        }
        return this.taskInstanceMapper.selectBatchIds(idList);
    }

    @Override
    public void packageTaskInstance(TaskInstance taskInstance, ProcessInstance processInstance) {
        taskInstance.setProcessInstance(processInstance);
        taskInstance.setProcessDefine(processInstance.getProcessDefinition());
        taskInstance.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        TaskDefinition taskDefinition = this.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
        this.updateTaskDefinitionResources(taskDefinition);
        taskInstance.setTaskDefine(taskDefinition);
    }

    @Override
    public void updateTaskDefinitionResources(TaskDefinition taskDefinition) {
        Map taskParameters = (Map)JSONUtils.parseObject((String)taskDefinition.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (taskParameters != null) {
            Object mainJarObj;
            ResourceInfo mainJar;
            ResourceInfo resourceInfo;
            if (taskParameters.containsKey("mainJar") && (resourceInfo = this.updateResourceInfo(mainJar = (ResourceInfo)JSONUtils.parseObject((String)JSONUtils.toJsonString(mainJarObj = taskParameters.get("mainJar")), ResourceInfo.class))) != null) {
                taskParameters.put("mainJar", resourceInfo);
            }
            if (taskParameters.containsKey("resourceList")) {
                String resourceListStr = JSONUtils.toJsonString(taskParameters.get("resourceList"));
                List resourceInfos = JSONUtils.toList((String)resourceListStr, ResourceInfo.class);
                List updatedResourceInfos = resourceInfos.stream().map(this::updateResourceInfo).filter(Objects::nonNull).collect(Collectors.toList());
                taskParameters.put("resourceList", updatedResourceInfos);
            }
            taskDefinition.setTaskParams(JSONUtils.toJsonString((Object)taskParameters));
        }
    }

    private ResourceInfo updateResourceInfo(ResourceInfo res) {
        ResourceInfo resourceInfo = null;
        if (res != null) {
            int resourceId = res.getId();
            if (resourceId <= 0) {
                this.logger.error("invalid resourceId, {}", (Object)resourceId);
                return null;
            }
            resourceInfo = new ResourceInfo();
            Resource resource = this.getResourceById(resourceId);
            resourceInfo.setId(resourceId);
            resourceInfo.setRes(resource.getFileName());
            resourceInfo.setResourceName(resource.getFullName());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("updated resource info {}", (Object)JSONUtils.toJsonString((Object)resourceInfo));
            }
        }
        return resourceInfo;
    }

    @Override
    public List<Integer> findTaskIdByInstanceState(int instanceId, ExecutionStatus state) {
        return this.taskInstanceMapper.queryTaskByProcessIdAndState(Integer.valueOf(instanceId), Integer.valueOf(state.ordinal()));
    }

    @Override
    public List<TaskInstance> findValidTaskListByProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.YES);
    }

    @Override
    public List<TaskInstance> findPreviousTaskListByWorkProcessId(Integer processInstanceId) {
        return this.taskInstanceMapper.findValidTaskListByProcessId(processInstanceId, Flag.NO);
    }

    @Override
    public int updateWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        return this.processInstanceMapMapper.updateById((Object)processInstanceMap);
    }

    @Override
    public int createWorkProcessInstanceMap(ProcessInstanceMap processInstanceMap) {
        int count = 0;
        if (processInstanceMap != null) {
            return this.processInstanceMapMapper.insert((Object)processInstanceMap);
        }
        return count;
    }

    @Override
    public ProcessInstanceMap findWorkProcessMapByParent(Integer parentWorkProcessId, Integer parentTaskId) {
        return this.processInstanceMapMapper.queryByParentId(parentWorkProcessId.intValue(), parentTaskId.intValue());
    }

    @Override
    public int deleteWorkProcessMapByParentId(int parentWorkProcessId) {
        return this.processInstanceMapMapper.deleteByParentProcessId(parentWorkProcessId);
    }

    @Override
    public ProcessInstance findSubProcessInstance(Integer parentProcessId, Integer parentTaskId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryByParentId(parentProcessId.intValue(), parentTaskId.intValue());
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getProcessInstanceId());
        return processInstance;
    }

    @Override
    public ProcessInstance findParentProcessInstance(Integer subProcessId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(subProcessId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        return processInstance;
    }

    @Override
    public int updateProcessInstance(ProcessInstance processInstance) {
        return this.processInstanceMapper.updateById((Object)processInstance);
    }

    @Override
    public void changeOutParam(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((String)taskInstance.getVarPool())) {
            return;
        }
        List properties = JSONUtils.toList((String)taskInstance.getVarPool(), Property.class);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)properties)) {
            return;
        }
        Map taskParams = (Map)JSONUtils.parseObject((String)taskInstance.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object localParams = taskParams.get("localParams");
        if (localParams == null) {
            return;
        }
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        HashMap<String, String> outProperty = new HashMap<String, String>();
        for (Property info : properties) {
            if (info.getDirect() != Direct.OUT) continue;
            outProperty.put(info.getProp(), info.getValue());
        }
        for (Property info : allParam) {
            if (info.getDirect() != Direct.OUT) continue;
            String paramName = info.getProp();
            info.setValue((String)outProperty.get(paramName));
        }
        taskParams.put("localParams", allParam);
        taskInstance.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
    }

    private List<String> convertIntListToString(List<Integer> intList) {
        if (intList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(intList.size());
        for (Integer intVar : intList) {
            result.add(String.valueOf(intVar));
        }
        return result;
    }

    @Override
    public Schedule querySchedule(int id) {
        return (Schedule)this.scheduleMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public List<Schedule> queryReleaseSchedulerListByProcessDefinitionCode(long processDefinitionCode) {
        return this.scheduleMapper.queryReleaseSchedulerListByProcessDefinitionCode(processDefinitionCode);
    }

    @Override
    public Map<Long, String> queryWorkerGroupByProcessDefinitionCodes(List<Long> processDefinitionCodeList) {
        List processDefinitionScheduleList = this.scheduleMapper.querySchedulesByProcessDefinitionCodes(processDefinitionCodeList);
        return processDefinitionScheduleList.stream().collect(Collectors.toMap(Schedule::getProcessDefinitionCode, Schedule::getWorkerGroup));
    }

    @Override
    public List<DependentProcessDefinition> queryDependentProcessDefinitionByProcessDefinitionCode(long processDefinitionCode) {
        return this.workFlowLineageMapper.queryDependentProcessDefinitionByProcessDefinitionCode(processDefinitionCode);
    }

    @Override
    public List<ProcessInstance> queryNeedFailoverProcessInstances(String host) {
        return this.processInstanceMapper.queryByHostAndStatus(host, ExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    public List<String> queryNeedFailoverProcessInstanceHost() {
        return this.processInstanceMapper.queryNeedFailoverProcessInstanceHost(ExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    @Transactional
    public void processNeedFailoverProcessInstances(ProcessInstance processInstance) {
        processInstance.setHost("NULL");
        this.processInstanceMapper.updateById((Object)processInstance);
        ProcessDefinition processDefinition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        Command cmd = new Command();
        cmd.setProcessDefinitionCode(processDefinition.getCode());
        cmd.setProcessDefinitionVersion(processDefinition.getVersion());
        cmd.setProcessInstanceId(processInstance.getId());
        cmd.setCommandParam(String.format("{\"%s\":%d}", "ProcessInstanceId", processInstance.getId()));
        cmd.setExecutorId(processInstance.getExecutorId());
        cmd.setCommandType(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS);
        this.createCommand(cmd);
    }

    @Override
    public List<TaskInstance> queryNeedFailoverTaskInstances(String host) {
        return this.taskInstanceMapper.queryByHostAndStatus(host, ExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public int updateProcessInstanceState(Integer processInstanceId, ExecutionStatus executionStatus) {
        ProcessInstance instance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)processInstanceId);
        instance.setState(executionStatus);
        return this.processInstanceMapper.updateById((Object)instance);
    }

    @Override
    public ProcessInstance findProcessInstanceByTaskId(int taskId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskId));
        if (taskInstance != null) {
            return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstance.getProcessInstanceId()));
        }
        return null;
    }

    @Override
    public List<UdfFunc> queryUdfFunListByIds(Integer[] ids) {
        return this.udfFuncMapper.queryUdfByIdStr(ids, null);
    }

    @Override
    public String queryTenantCodeByResName(String resName, ResourceType resourceType) {
        String fullName = resName.startsWith("/") ? resName : String.format("/%s", resName);
        List resourceList = this.resourceMapper.queryResource(fullName, resourceType.ordinal());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)resourceList)) {
            return "";
        }
        int userId = ((Resource)resourceList.get(0)).getUserId();
        User user = this.userMapper.selectById(userId);
        if (Objects.isNull(user)) {
            return "";
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (Objects.isNull(tenant)) {
            return "";
        }
        return tenant.getTenantCode();
    }

    @Override
    public List<Schedule> selectAllByProcessDefineCode(long[] codes) {
        return this.scheduleMapper.selectAllByProcessDefineArray(codes);
    }

    @Override
    public ProcessInstance findLastSchedulerProcessInterval(Long definitionCode, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastSchedulerProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    @Override
    public ProcessInstance findLastManualProcessInterval(Long definitionCode, DateInterval dateInterval) {
        return this.processInstanceMapper.queryLastManualProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    @Override
    public ProcessInstance findLastRunningProcess(Long definitionCode, Date startTime, Date endTime) {
        return this.processInstanceMapper.queryLastRunningProcess(definitionCode, startTime, endTime, ExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    public String queryUserQueueByProcessInstance(ProcessInstance processInstance) {
        String queue = "";
        if (processInstance == null) {
            return queue;
        }
        User executor = this.userMapper.selectById(processInstance.getExecutorId());
        if (executor != null) {
            queue = executor.getQueue();
        }
        return queue;
    }

    @Override
    public ProjectUser queryProjectWithUserByProcessInstanceId(int processInstanceId) {
        return this.projectMapper.queryProjectWithUserByProcessInstanceId(processInstanceId);
    }

    @Override
    public String getTaskWorkerGroup(TaskInstance taskInstance) {
        String workerGroup = taskInstance.getWorkerGroup();
        if (StringUtils.isNotBlank((String)workerGroup)) {
            return workerGroup;
        }
        int processInstanceId = taskInstance.getProcessInstanceId();
        ProcessInstance processInstance = this.findProcessInstanceById(processInstanceId);
        if (processInstance != null) {
            return processInstance.getWorkerGroup();
        }
        this.logger.info("task : {} will use default worker group", (Object)taskInstance.getId());
        return "default";
    }

    @Override
    public List<Project> getProjectListHavePerm(int userId) {
        ArrayList<Project> createProjects = this.projectMapper.queryProjectCreatedByUser(userId);
        List authedProjects = this.projectMapper.queryAuthedProjectListByUserId(userId);
        if (createProjects == null) {
            createProjects = new ArrayList<Project>();
        }
        if (authedProjects != null) {
            createProjects.addAll(authedProjects);
        }
        return createProjects;
    }

    @Override
    public <T> List<T> listUnauthorized(int userId, T[] needChecks, AuthorizationType authorizationType) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (Objects.nonNull(needChecks) && needChecks.length > 0) {
            HashSet<T> originResSet = new HashSet<T>(Arrays.asList(needChecks));
            switch (authorizationType) {
                case RESOURCE_FILE_ID: 
                case UDF_FILE: {
                    List ownUdfResources = this.resourceMapper.listAuthorizedResourceById(userId, (Object[])needChecks);
                    this.addAuthorizedResources(ownUdfResources, userId);
                    Set authorizedResourceFiles = ownUdfResources.stream().map(Resource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResourceFiles);
                    break;
                }
                case RESOURCE_FILE_NAME: {
                    List ownResources = this.resourceMapper.listAuthorizedResource(userId, (Object[])needChecks);
                    this.addAuthorizedResources(ownResources, userId);
                    Set authorizedResources = ownResources.stream().map(Resource::getFullName).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResources);
                    break;
                }
                case DATASOURCE: {
                    Set authorizedDatasources = this.dataSourceMapper.listAuthorizedDataSource(userId, (Object[])needChecks).stream().map(DataSource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedDatasources);
                    break;
                }
                case UDF: {
                    Set authorizedUdfs = this.udfFuncMapper.listAuthorizedUdfFunc(userId, (Object[])needChecks).stream().map(UdfFunc::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedUdfs);
                    break;
                }
            }
            resultList.addAll(originResSet);
        }
        return resultList;
    }

    @Override
    public User getUserById(int userId) {
        return this.userMapper.selectById(userId);
    }

    @Override
    public Resource getResourceById(int resourceId) {
        return (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
    }

    @Override
    public List<Resource> listResourceByIds(Integer[] resIds) {
        return this.resourceMapper.listResourceByIds(resIds);
    }

    @Override
    public String formatTaskAppId(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        if (processInstance == null) {
            return "";
        }
        ProcessDefinition definition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (definition == null) {
            return "";
        }
        return String.format("%s_%s_%s", definition.getId(), processInstance.getId(), taskInstance.getId());
    }

    @Override
    public int switchVersion(ProcessDefinition processDefinition, ProcessDefinitionLog processDefinitionLog) {
        if (null == processDefinition || null == processDefinitionLog) {
            return -1;
        }
        processDefinitionLog.setId(processDefinition.getId());
        processDefinitionLog.setReleaseState(ReleaseState.OFFLINE);
        processDefinitionLog.setFlag(Flag.YES);
        int result = this.processDefineMapper.updateById((ProcessDefinition)processDefinitionLog);
        if (result > 0 && (result = this.switchProcessTaskRelationVersion((ProcessDefinition)processDefinitionLog)) <= 0) {
            return -1;
        }
        return result;
    }

    @Override
    public int switchProcessTaskRelationVersion(ProcessDefinition processDefinition) {
        List processTaskRelationLogList;
        int batchInsert;
        List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode());
        if (!processTaskRelationList.isEmpty()) {
            this.processTaskRelationMapper.deleteByCode(processDefinition.getProjectCode(), processDefinition.getCode());
        }
        if ((batchInsert = this.processTaskRelationMapper.batchInsert(processTaskRelationLogList = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinition.getCode(), processDefinition.getVersion()))) == 0) {
            return -1;
        }
        int result = 0;
        for (ProcessTaskRelationLog taskRelationLog : processTaskRelationLogList) {
            int switchResult = this.switchTaskDefinitionVersion(taskRelationLog.getPostTaskCode(), taskRelationLog.getPostTaskVersion());
            if (switchResult == -1) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int switchTaskDefinitionVersion(long taskCode, int taskVersion) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            return -1;
        }
        if (taskDefinition.getVersion() == taskVersion) {
            return 0;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskVersion);
        if (taskDefinitionUpdate == null) {
            return -1;
        }
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        return this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
    }

    @Override
    public String getResourceIds(TaskDefinition taskDefinition) {
        Set resourceIds = null;
        AbstractParameters params = this.taskPluginManager.getParameters(ParametersNode.builder().taskType(taskDefinition.getTaskType()).taskParams(taskDefinition.getTaskParams()).build());
        if (params != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)params.getResourceFilesList())) {
            resourceIds = params.getResourceFilesList().stream().filter(t -> t.getId() != 0).map(ResourceInfo::getId).collect(Collectors.toSet());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(resourceIds)) {
            return "";
        }
        return StringUtils.join(resourceIds, (String)",");
    }

    @Override
    public int saveTaskDefine(User operator, long projectCode, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        Date now = new Date();
        ArrayList<TaskDefinitionLog> newTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        ArrayList<TaskDefinitionLog> updateTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            TaskDefinitionLog definitionCodeAndVersion;
            taskDefinitionLog.setProjectCode(projectCode);
            taskDefinitionLog.setUpdateTime(now);
            taskDefinitionLog.setOperateTime(now);
            taskDefinitionLog.setOperator(operator.getId());
            taskDefinitionLog.setResourceIds(this.getResourceIds((TaskDefinition)taskDefinitionLog));
            if (taskDefinitionLog.getCode() == 0L) {
                try {
                    taskDefinitionLog.setCode(CodeGenerateUtils.getInstance().genCode());
                }
                catch (CodeGenerateUtils.CodeGenerateException e) {
                    this.logger.error("Task code get error, ", (Throwable)e);
                    return -1;
                }
            }
            if (taskDefinitionLog.getVersion() == 0) {
                taskDefinitionLog.setVersion(1);
            }
            if ((definitionCodeAndVersion = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskDefinitionLog.getCode(), taskDefinitionLog.getVersion())) == null) {
                taskDefinitionLog.setUserId(operator.getId());
                taskDefinitionLog.setCreateTime(now);
                newTaskDefinitionLogs.add(taskDefinitionLog);
                continue;
            }
            if (taskDefinitionLog.equals((Object)definitionCodeAndVersion)) continue;
            taskDefinitionLog.setUserId(definitionCodeAndVersion.getUserId());
            Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionLog.getCode());
            taskDefinitionLog.setVersion(version + 1);
            taskDefinitionLog.setCreateTime(definitionCodeAndVersion.getCreateTime());
            updateTaskDefinitionLogs.add(taskDefinitionLog);
        }
        int insertResult = 0;
        int updateResult = 0;
        for (TaskDefinitionLog taskDefinitionToUpdate : updateTaskDefinitionLogs) {
            TaskDefinition task = this.taskDefinitionMapper.queryByCode(taskDefinitionToUpdate.getCode());
            if (task == null) {
                newTaskDefinitionLogs.add(taskDefinitionToUpdate);
                continue;
            }
            insertResult += this.taskDefinitionLogMapper.insert((Object)taskDefinitionToUpdate);
            if (Boolean.TRUE.equals(syncDefine)) {
                taskDefinitionToUpdate.setId(task.getId());
                updateResult += this.taskDefinitionMapper.updateById((Object)taskDefinitionToUpdate);
                continue;
            }
            ++updateResult;
        }
        if (!newTaskDefinitionLogs.isEmpty()) {
            insertResult += this.taskDefinitionLogMapper.batchInsert(newTaskDefinitionLogs);
            updateResult = Boolean.TRUE.equals(syncDefine) ? (updateResult += this.taskDefinitionMapper.batchInsert(newTaskDefinitionLogs)) : (updateResult += newTaskDefinitionLogs.size());
        }
        return (insertResult & updateResult) > 0 ? 1 : 0;
    }

    @Override
    public int saveProcessDefine(User operator, ProcessDefinition processDefinition, Boolean syncDefine, Boolean isFromProcessDefine) {
        ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition);
        Integer version = this.processDefineLogMapper.queryMaxVersionForDefinition(processDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        processDefinitionLog.setVersion(insertVersion);
        processDefinitionLog.setReleaseState(isFromProcessDefine == false || processDefinitionLog.getReleaseState() == ReleaseState.ONLINE ? ReleaseState.ONLINE : ReleaseState.OFFLINE);
        processDefinitionLog.setOperator(operator.getId());
        processDefinitionLog.setOperateTime(processDefinition.getUpdateTime());
        int insertLog = this.processDefineLogMapper.insert((Object)processDefinitionLog);
        int result = 1;
        if (Boolean.TRUE.equals(syncDefine)) {
            if (0 == processDefinition.getId()) {
                result = this.processDefineMapper.insert((Object)processDefinitionLog);
            } else {
                processDefinitionLog.setId(processDefinition.getId());
                result = this.processDefineMapper.updateById((ProcessDefinition)processDefinitionLog);
            }
        }
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    @Override
    public int saveTaskRelation(User operator, long projectCode, long processDefinitionCode, int processDefinitionVersion, List<ProcessTaskRelationLog> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        int resultLog;
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (ProcessTaskRelationLog processTaskRelationLog : taskRelationList) {
            processTaskRelationLog.setProjectCode(projectCode);
            processTaskRelationLog.setProcessDefinitionCode(processDefinitionCode);
            processTaskRelationLog.setProcessDefinitionVersion(processDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(processTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    processTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(processTaskRelationLog.getPostTaskCode())) != null) {
                    processTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            processTaskRelationLog.setCreateTime(now);
            processTaskRelationLog.setUpdateTime(now);
            processTaskRelationLog.setOperator(operator.getId());
            processTaskRelationLog.setOperateTime(now);
        }
        int insert = taskRelationList.size();
        if (Boolean.TRUE.equals(syncDefine)) {
            List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
            if (!processTaskRelationList.isEmpty()) {
                Set taskRelationSet;
                Set processTaskRelationSet = processTaskRelationList.stream().map(ProcessTaskRelation::hashCode).collect(Collectors.toSet());
                boolean result = org.apache.commons.collections.CollectionUtils.isEqualCollection(processTaskRelationSet, taskRelationSet = taskRelationList.stream().map(ProcessTaskRelationLog::hashCode).collect(Collectors.toSet()));
                if (result) {
                    return 0;
                }
                this.processTaskRelationMapper.deleteByCode(projectCode, processDefinitionCode);
            }
            insert = this.processTaskRelationMapper.batchInsert(taskRelationList);
        }
        return (insert & (resultLog = this.processTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    @Override
    public boolean isTaskOnline(long taskCode) {
        List processTaskRelationList = this.processTaskRelationMapper.queryByTaskCode(taskCode);
        if (!processTaskRelationList.isEmpty()) {
            Set processDefinitionCodes = processTaskRelationList.stream().map(ProcessTaskRelation::getProcessDefinitionCode).collect(Collectors.toSet());
            List processDefinitionList = this.processDefineMapper.queryByCodes(processDefinitionCodes);
            for (ProcessDefinition processDefinition : processDefinitionList) {
                if (processDefinition.getReleaseState() != ReleaseState.ONLINE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DAG<String, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition processDefinition) {
        List<ProcessTaskRelation> taskRelations = this.findRelationByCode(processDefinition.getCode(), processDefinition.getVersion());
        List<TaskNode> taskNodeList = this.transformTask(taskRelations, Lists.newArrayList());
        ProcessDag processDag = DagHelper.getProcessDag(taskNodeList, new ArrayList<ProcessTaskRelation>(taskRelations));
        return DagHelper.buildDagGraph((ProcessDag)processDag);
    }

    @Override
    public DagData genDagData(ProcessDefinition processDefinition) {
        List<ProcessTaskRelation> taskRelations = this.findRelationByCode(processDefinition.getCode(), processDefinition.getVersion());
        List<TaskDefinitionLog> taskDefinitionLogList = this.genTaskDefineList(taskRelations);
        List taskDefinitions = taskDefinitionLogList.stream().map(t -> t).collect(Collectors.toList());
        return new DagData(processDefinition, taskRelations, taskDefinitions);
    }

    @Override
    public List<TaskDefinitionLog> genTaskDefineList(List<ProcessTaskRelation> processTaskRelations) {
        HashSet<TaskDefinition> taskDefinitionSet = new HashSet<TaskDefinition>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPreTaskCode() > 0L) {
                taskDefinitionSet.add(new TaskDefinition(processTaskRelation.getPreTaskCode(), processTaskRelation.getPreTaskVersion()));
            }
            if (processTaskRelation.getPostTaskCode() <= 0L) continue;
            taskDefinitionSet.add(new TaskDefinition(processTaskRelation.getPostTaskCode(), processTaskRelation.getPostTaskVersion()));
        }
        if (taskDefinitionSet.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitionSet);
    }

    @Override
    public List<TaskDefinitionLog> getTaskDefineLogListByRelation(List<ProcessTaskRelation> processTaskRelations) {
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        HashMap<Long, Integer> taskCodeVersionMap = new HashMap<Long, Integer>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPreTaskCode() > 0L) {
                taskCodeVersionMap.put(processTaskRelation.getPreTaskCode(), processTaskRelation.getPreTaskVersion());
            }
            if (processTaskRelation.getPostTaskCode() <= 0L) continue;
            taskCodeVersionMap.put(processTaskRelation.getPostTaskCode(), processTaskRelation.getPostTaskVersion());
        }
        taskCodeVersionMap.forEach((code, version) -> taskDefinitionLogs.add((TaskDefinitionLog)this.findTaskDefinition((long)code, (int)version)));
        return taskDefinitionLogs;
    }

    @Override
    public TaskDefinition findTaskDefinition(long taskCode, int taskDefinitionVersion) {
        return this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskDefinitionVersion);
    }

    @Override
    public List<ProcessTaskRelation> findRelationByCode(long processDefinitionCode, int processDefinitionVersion) {
        List processTaskRelationLogList = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinitionCode, processDefinitionVersion);
        return processTaskRelationLogList.stream().map(r -> r).collect(Collectors.toList());
    }

    private void addAuthorizedResources(List<Resource> ownResources, int userId) {
        List relationResourceIds = this.resourceUserMapper.queryResourcesIdListByUserIdAndPerm(userId, 7);
        List relationResources = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relationResourceIds) ? this.resourceMapper.queryResourceListById(relationResourceIds) : new ArrayList();
        ownResources.addAll(relationResources);
    }

    @Override
    public List<TaskNode> transformTask(List<ProcessTaskRelation> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<Long, List> taskCodeMap = new HashMap<Long, List>();
        for (ProcessTaskRelation processTaskRelation : taskRelationList) {
            taskCodeMap.compute(processTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Long>();
                }
                if (processTaskRelation.getPreTaskCode() != 0L) {
                    v.add(processTaskRelation.getPreTaskCode());
                }
                return v;
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(taskDefinitionLogs)) {
            taskDefinitionLogs = this.genTaskDefineList(taskRelationList);
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        ArrayList<TaskNode> taskNodeList = new ArrayList<TaskNode>();
        for (Map.Entry code : taskCodeMap.entrySet()) {
            TaskDefinitionLog taskDefinitionLog2 = taskDefinitionLogMap.get(code.getKey());
            if (taskDefinitionLog2 == null) continue;
            TaskNode taskNode = new TaskNode();
            taskNode.setCode(taskDefinitionLog2.getCode());
            taskNode.setVersion(taskDefinitionLog2.getVersion());
            taskNode.setName(taskDefinitionLog2.getName());
            taskNode.setDesc(taskDefinitionLog2.getDescription());
            taskNode.setType(taskDefinitionLog2.getTaskType().toUpperCase());
            taskNode.setRunFlag(taskDefinitionLog2.getFlag() == Flag.YES ? "NORMAL" : "FORBIDDEN");
            taskNode.setMaxRetryTimes(taskDefinitionLog2.getFailRetryTimes());
            taskNode.setRetryInterval(taskDefinitionLog2.getFailRetryInterval());
            Map taskParamsMap = taskNode.taskParamsToJsonObj(taskDefinitionLog2.getTaskParams());
            taskNode.setConditionResult(JSONUtils.toJsonString(taskParamsMap.get("conditionResult")));
            taskNode.setSwitchResult(JSONUtils.toJsonString(taskParamsMap.get("switchResult")));
            taskNode.setDependence(JSONUtils.toJsonString(taskParamsMap.get("dependence")));
            taskParamsMap.remove("conditionResult");
            taskParamsMap.remove("dependence");
            taskNode.setParams(JSONUtils.toJsonString((Object)taskParamsMap));
            taskNode.setTaskInstancePriority(taskDefinitionLog2.getTaskPriority());
            taskNode.setWorkerGroup(taskDefinitionLog2.getWorkerGroup());
            taskNode.setEnvironmentCode(Long.valueOf(taskDefinitionLog2.getEnvironmentCode()));
            taskNode.setTimeout(JSONUtils.toJsonString((Object)new TaskTimeoutParameter(taskDefinitionLog2.getTimeoutFlag() == TimeoutFlag.OPEN, taskDefinitionLog2.getTimeoutNotifyStrategy(), taskDefinitionLog2.getTimeout())));
            taskNode.setDelayTime(taskDefinitionLog2.getDelayTime());
            taskNode.setPreTasks(JSONUtils.toJsonString(((List)code.getValue()).stream().map(taskDefinitionLogMap::get).map(TaskDefinition::getCode).collect(Collectors.toList())));
            taskNode.setTaskGroupId(taskDefinitionLog2.getTaskGroupId());
            taskNode.setTaskGroupPriority(taskDefinitionLog2.getTaskGroupPriority());
            taskNodeList.add(taskNode);
        }
        return taskNodeList;
    }

    @Override
    public Map<ProcessInstance, TaskInstance> notifyProcessList(int processId) {
        HashMap<ProcessInstance, TaskInstance> processTaskMap = new HashMap<ProcessInstance, TaskInstance>();
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(Integer.valueOf(processId));
        if (processInstanceMap == null) {
            return processTaskMap;
        }
        ProcessInstance fatherProcess = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        TaskInstance fatherTask = this.findTaskInstanceById(processInstanceMap.getParentTaskInstanceId());
        if (fatherProcess != null) {
            processTaskMap.put(fatherProcess, fatherTask);
        }
        return processTaskMap;
    }

    @Override
    public DqExecuteResult getDqExecuteResultByTaskInstanceId(int taskInstanceId) {
        return this.dqExecuteResultMapper.getExecuteResultById(taskInstanceId);
    }

    @Override
    public int updateDqExecuteResultUserId(int taskInstanceId) {
        DqExecuteResult dqExecuteResult = (DqExecuteResult)this.dqExecuteResultMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"task_instance_id", (Object)taskInstanceId));
        if (dqExecuteResult == null) {
            return -1;
        }
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Long.valueOf(dqExecuteResult.getProcessInstanceId()));
        if (processInstance == null) {
            return -1;
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition == null) {
            return -1;
        }
        dqExecuteResult.setProcessDefinitionId((long)processDefinition.getId());
        dqExecuteResult.setUserId(processDefinition.getUserId());
        dqExecuteResult.setState(DqTaskState.DEFAULT.getCode());
        return this.dqExecuteResultMapper.updateById((Object)dqExecuteResult);
    }

    @Override
    public int updateDqExecuteResultState(DqExecuteResult dqExecuteResult) {
        return this.dqExecuteResultMapper.updateById((Object)dqExecuteResult);
    }

    @Override
    public int deleteDqExecuteResultByTaskInstanceId(int taskInstanceId) {
        return this.dqExecuteResultMapper.delete((Wrapper)new QueryWrapper().eq((Object)"task_instance_id", (Object)taskInstanceId));
    }

    @Override
    public int deleteTaskStatisticsValueByTaskInstanceId(int taskInstanceId) {
        return this.dqTaskStatisticsValueMapper.delete((Wrapper)new QueryWrapper().eq((Object)"task_instance_id", (Object)taskInstanceId));
    }

    @Override
    public DqRule getDqRule(int ruleId) {
        return (DqRule)this.dqRuleMapper.selectById((Serializable)Integer.valueOf(ruleId));
    }

    @Override
    public List<DqRuleInputEntry> getRuleInputEntry(int ruleId) {
        return DqRuleUtils.transformInputEntry((List)this.dqRuleInputEntryMapper.getRuleInputEntryList(Integer.valueOf(ruleId)));
    }

    @Override
    public List<DqRuleExecuteSql> getDqExecuteSql(int ruleId) {
        return this.dqRuleExecuteSqlMapper.getExecuteSqlList(Integer.valueOf(ruleId));
    }

    @Override
    public DqComparisonType getComparisonTypeById(int id) {
        return (DqComparisonType)this.dqComparisonTypeMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public boolean acquireTaskGroup(int taskId, String taskName, int groupId, int processId, int priority) {
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(groupId));
        if (taskGroup == null) {
            return true;
        }
        if (taskGroup.getStatus() == Flag.NO.getCode()) {
            return true;
        }
        TaskGroupQueue taskGroupQueue = this.taskGroupQueueMapper.queryByTaskId(taskId);
        if (taskGroupQueue == null) {
            taskGroupQueue = this.insertIntoTaskGroupQueue(taskId, taskName, groupId, processId, priority, TaskGroupQueueStatus.WAIT_QUEUE);
        } else {
            this.logger.info("The task queue is already exist, taskId: {}", (Object)taskId);
            if (taskGroupQueue.getStatus() == TaskGroupQueueStatus.ACQUIRE_SUCCESS) {
                return true;
            }
            taskGroupQueue.setInQueue(Flag.NO.getCode());
            taskGroupQueue.setStatus(TaskGroupQueueStatus.WAIT_QUEUE);
            this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
        }
        List highPriorityTasks = this.taskGroupQueueMapper.queryHighPriorityTasks(groupId, priority, TaskGroupQueueStatus.WAIT_QUEUE.getCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)highPriorityTasks)) {
            return false;
        }
        int count = this.taskGroupMapper.selectAvailableCountById(groupId);
        if (count == 1 && this.robTaskGroupResource(taskGroupQueue)) {
            return true;
        }
        this.taskGroupQueueMapper.updateInQueue(Flag.NO.getCode(), taskGroupQueue.getId());
        return false;
    }

    @Override
    public boolean robTaskGroupResource(TaskGroupQueue taskGroupQueue) {
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(taskGroupQueue.getGroupId()));
        int affectedCount = this.taskGroupMapper.updateTaskGroupResource(taskGroup.getId(), taskGroupQueue.getId(), TaskGroupQueueStatus.WAIT_QUEUE.getCode());
        if (affectedCount > 0) {
            taskGroupQueue.setStatus(TaskGroupQueueStatus.ACQUIRE_SUCCESS);
            this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
            this.taskGroupQueueMapper.updateInQueue(Flag.NO.getCode(), taskGroupQueue.getId());
            return true;
        }
        return false;
    }

    @Override
    public void releaseAllTaskGroup(int processInstanceId) {
        List taskInstances = this.taskInstanceMapper.loadAllInfosNoRelease(processInstanceId, TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode());
        for (TaskInstance info : taskInstances) {
            this.releaseTaskGroup(info);
        }
    }

    @Override
    public TaskInstance releaseTaskGroup(TaskInstance taskInstance) {
        TaskGroupQueue taskGroupQueue;
        TaskGroup taskGroup;
        try {
            TaskGroupQueue thisTaskGroupQueue;
            do {
                if ((taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(taskInstance.getTaskGroupId()))) == null) {
                    return null;
                }
                thisTaskGroupQueue = this.taskGroupQueueMapper.queryByTaskId(taskInstance.getId());
                if (thisTaskGroupQueue.getStatus() != TaskGroupQueueStatus.RELEASE) continue;
                return null;
            } while (thisTaskGroupQueue.getForceStart() == Flag.NO.getCode() && this.taskGroupMapper.releaseTaskGroupResource(taskGroup.getId(), taskGroup.getUseSize(), thisTaskGroupQueue.getId(), TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode()) != 1);
        }
        catch (Exception e) {
            this.logger.error("release the task group error", (Throwable)e);
            return null;
        }
        this.logger.info("updateTask:{}", (Object)taskInstance.getName());
        this.changeTaskGroupQueueStatus(taskInstance.getId(), TaskGroupQueueStatus.RELEASE);
        do {
            if ((taskGroupQueue = this.taskGroupQueueMapper.queryTheHighestPriorityTasks(taskGroup.getId(), TaskGroupQueueStatus.WAIT_QUEUE.getCode(), Flag.NO.getCode(), Flag.NO.getCode())) != null) continue;
            return null;
        } while (this.taskGroupQueueMapper.updateInQueueCAS(Flag.NO.getCode(), Flag.YES.getCode(), taskGroupQueue.getId()) != 1);
        return (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskGroupQueue.getTaskId()));
    }

    @Override
    public void changeTaskGroupQueueStatus(int taskId, TaskGroupQueueStatus status) {
        TaskGroupQueue taskGroupQueue = this.taskGroupQueueMapper.queryByTaskId(taskId);
        taskGroupQueue.setStatus(status);
        taskGroupQueue.setUpdateTime(new Date(System.currentTimeMillis()));
        this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
    }

    @Override
    public TaskGroupQueue insertIntoTaskGroupQueue(Integer taskId, String taskName, Integer groupId, Integer processId, Integer priority, TaskGroupQueueStatus status) {
        TaskGroupQueue taskGroupQueue = new TaskGroupQueue(taskId.intValue(), taskName, groupId.intValue(), processId.intValue(), priority.intValue(), status);
        taskGroupQueue.setCreateTime(new Date());
        taskGroupQueue.setUpdateTime(new Date());
        this.taskGroupQueueMapper.insert((Object)taskGroupQueue);
        return taskGroupQueue;
    }

    @Override
    public int updateTaskGroupQueueStatus(Integer taskId, int status) {
        return this.taskGroupQueueMapper.updateStatusByTaskId(taskId.intValue(), status);
    }

    @Override
    public int updateTaskGroupQueue(TaskGroupQueue taskGroupQueue) {
        return this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
    }

    @Override
    public TaskGroupQueue loadTaskGroupQueue(int taskId) {
        return this.taskGroupQueueMapper.queryByTaskId(taskId);
    }

    @Override
    public void sendStartTask2Master(ProcessInstance processInstance, int taskId, org.apache.dolphinscheduler.remote.command.CommandType taskType) {
        Host host = new Host(processInstance.getHost());
        TaskEventChangeCommand taskEventChangeCommand = new TaskEventChangeCommand(processInstance.getId(), taskId);
        this.stateEventCallbackService.sendResult(host, taskEventChangeCommand.convert2Command(taskType));
    }

    @Override
    public ProcessInstance loadNextProcess4Serial(long code, int state, int id) {
        return this.processInstanceMapper.loadNextProcess4Serial(Long.valueOf(code), state, id);
    }

    protected void deleteCommandWithCheck(int commandId) {
        int delete = this.commandMapper.deleteById((Serializable)Integer.valueOf(commandId));
        if (delete != 1) {
            throw new ServiceException("delete command fail, id:" + commandId);
        }
    }

    @Override
    public void forceProcessInstanceSuccessByTaskInstanceId(Integer taskInstanceId) {
        List failTaskList;
        List<ProcessTaskRelation> taskRelations;
        List<TaskDefinitionLog> taskDefinitionLogs;
        List definiteTaskCodeList;
        List<TaskInstance> validTaskList;
        List instanceTaskCodeList;
        TaskInstance task = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (task == null) {
            return;
        }
        ProcessInstance processInstance = this.findProcessInstanceDetailById(task.getProcessInstanceId());
        if (processInstance != null && (processInstance.getState().typeIsFailure() || processInstance.getState().typeIsCancel()) && CollectionUtils.equalLists(instanceTaskCodeList = (validTaskList = this.findValidTaskListByProcessId(processInstance.getId())).stream().map(TaskInstance::getTaskCode).collect(Collectors.toList()), definiteTaskCodeList = (taskDefinitionLogs = this.genTaskDefineList(taskRelations = this.findRelationByCode(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion()))).stream().filter(definitionLog -> definitionLog.getFlag() == Flag.YES).map(TaskDefinition::getCode).collect(Collectors.toList())) && (failTaskList = validTaskList.stream().filter(instance -> instance.getState().typeIsFailure() || instance.getState().typeIsCancel()).map(TaskInstance::getId).collect(Collectors.toList())).size() == 1 && failTaskList.contains(taskInstanceId)) {
            processInstance.setState(ExecutionStatus.SUCCESS);
            this.updateProcessInstance(processInstance);
        }
    }
}

