/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.service.exceptions.ServiceException;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutor;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzExecutorImpl
implements QuartzExecutor {
    private static final Logger logger = LoggerFactory.getLogger(QuartzExecutorImpl.class);
    @Autowired
    private Scheduler scheduler;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public void addJob(Class<? extends Job> clazz, int projectId, Schedule schedule) {
        String jobName = this.buildJobName(schedule.getId());
        String jobGroupName = this.buildJobGroupName(projectId);
        Map<String, Object> jobDataMap = this.buildDataMap(projectId, schedule);
        String cronExpression = schedule.getCrontab();
        String timezoneId = schedule.getTimezoneId();
        Date startDate = DateUtils.transformTimezoneDate((Date)schedule.getStartTime(), (String)timezoneId);
        Date endDate = DateUtils.transformTimezoneDate((Date)schedule.getEndTime(), (String)timezoneId);
        Date now = new Date();
        if (startDate.before(now)) {
            startDate = now;
        }
        this.lock.writeLock().lock();
        try {
            JobDetail jobDetail;
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (this.scheduler.checkExists(jobKey)) {
                jobDetail = this.scheduler.getJobDetail(jobKey);
                jobDetail.getJobDataMap().putAll(jobDataMap);
            } else {
                jobDetail = JobBuilder.newJob(clazz).withIdentity(jobKey).build();
                jobDetail.getJobDataMap().putAll(jobDataMap);
                this.scheduler.addJob(jobDetail, false, true);
                logger.info("Add job, job name: {}, group name: {}", (Object)jobName, (Object)jobGroupName);
            }
            TriggerKey triggerKey = new TriggerKey(jobName, jobGroupName);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(startDate).endAt(endDate).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionIgnoreMisfires().inTimeZone(DateUtils.getTimezone((String)timezoneId))).forJob(jobDetail).build();
            if (this.scheduler.checkExists(triggerKey)) {
                CronTrigger oldCronTrigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
                String oldCronExpression = oldCronTrigger.getCronExpression();
                if (!StringUtils.equalsIgnoreCase((String)cronExpression, (String)oldCronExpression)) {
                    this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
                    logger.info("reschedule job trigger, triggerName: {}, triggerGroupName: {}, cronExpression: {}, startDate: {}, endDate: {}", new Object[]{jobName, jobGroupName, cronExpression, startDate, endDate});
                }
            } else {
                this.scheduler.scheduleJob((Trigger)cronTrigger);
                logger.info("schedule job trigger, triggerName: {}, triggerGroupName: {}, cronExpression: {}, startDate: {}, endDate: {}", new Object[]{jobName, jobGroupName, cronExpression, startDate, endDate});
            }
        }
        catch (Exception e) {
            throw new ServiceException("add job failed", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String buildJobName(int processId) {
        return "job_" + processId;
    }

    @Override
    public String buildJobGroupName(int projectId) {
        return "jobgroup_" + projectId;
    }

    @Override
    public Map<String, Object> buildDataMap(int projectId, Schedule schedule) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        dataMap.put("projectId", projectId);
        dataMap.put("scheduleId", schedule.getId());
        dataMap.put("schedule", JSONUtils.toJsonString((Object)schedule));
        return dataMap;
    }
}

