/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.expand;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.expand.TimePlaceholderResolverExpandService;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CuringGlobalParams
implements CuringParamsService {
    @Autowired
    private TimePlaceholderResolverExpandService timePlaceholderResolverExpandService;

    @Override
    public String convertParameterPlaceholders(String val, Map<String, String> allParamMap) {
        return ParameterUtils.convertParameterPlaceholders((String)val, allParamMap);
    }

    @Override
    public boolean timeFunctionNeedExpand(String placeholderName) {
        return this.timePlaceholderResolverExpandService.timeFunctionNeedExpand(placeholderName);
    }

    @Override
    public String timeFunctionExtension(Integer processInstanceId, String timezone, String placeholderName) {
        return this.timePlaceholderResolverExpandService.timeFunctionExtension(processInstanceId, timezone, placeholderName);
    }

    @Override
    public String curingGlobalParams(Integer processInstanceId, Map<String, String> globalParamMap, List<Property> globalParamList, CommandType commandType, Date scheduleTime, String timezone) {
        String val;
        if (globalParamList == null || globalParamList.isEmpty()) {
            return null;
        }
        HashMap<String, String> globalMap = new HashMap<String, String>();
        if (globalParamMap != null) {
            globalMap.putAll(globalParamMap);
        }
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime, (String)timezone);
        if (timeParams != null) {
            allParamMap.putAll(timeParams);
        }
        allParamMap.putAll(globalMap);
        Set entries = allParamMap.entrySet();
        HashMap resolveMap = new HashMap();
        for (Map.Entry entry : entries) {
            val = (String)entry.getValue();
            if (!val.startsWith("$")) continue;
            String str = "";
            str = this.timeFunctionNeedExpand(val) ? this.timeFunctionExtension(processInstanceId, timezone, val) : this.convertParameterPlaceholders(val, allParamMap);
            resolveMap.put(entry.getKey(), str);
        }
        globalMap.putAll(resolveMap);
        for (Property property : globalParamList) {
            val = (String)globalMap.get(property.getProp());
            if (val == null) continue;
            property.setValue(val);
        }
        return JSONUtils.toJsonString(globalParamList);
    }

    @Override
    public Map<String, Property> paramParsingPreparation(@NonNull TaskInstance taskInstance, @NonNull AbstractParameters parameters, @NonNull ProcessInstance processInstance) {
        Map<String, Property> paramsMap;
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        Map<String, String> globalParamsMap = this.setGlobalParamsMap(processInstance);
        HashMap<String, Property> globalParams = ParamUtils.getUserDefParamsMap(globalParamsMap);
        CommandType commandType = processInstance.getCmdTypeIfComplement();
        Date scheduleTime = processInstance.getScheduleTime();
        Map localParams = parameters.getInputLocalParametersMap();
        parameters.setVarPool(taskInstance.getVarPool());
        Map varParams = parameters.getVarPoolMap();
        if (globalParams.isEmpty() && localParams.isEmpty() && varParams.isEmpty()) {
            return null;
        }
        Map cmdParam = JSONUtils.toMap((String)processInstance.getCommandParam());
        String timeZone = (String)cmdParam.get("schedule_timezone");
        Map params = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime, (String)timeZone);
        if (globalParamsMap != null) {
            params.putAll(globalParamsMap);
        }
        if (StringUtils.isNotBlank((CharSequence)taskInstance.getExecutePath())) {
            params.put("system.task.execute.path", taskInstance.getExecutePath());
        }
        params.put("system.task.instance.id", Integer.toString(taskInstance.getId()));
        if (varParams.size() != 0) {
            globalParams.putAll(varParams);
        }
        if (localParams.size() != 0) {
            globalParams.putAll(localParams);
        }
        for (Map.Entry en : globalParams.entrySet()) {
            Property property = (Property)en.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)property.getValue()) || !property.getValue().startsWith("$")) continue;
            String val = property.getValue();
            val = this.timeFunctionNeedExpand(val) ? this.timeFunctionExtension(taskInstance.getProcessInstanceId(), timeZone, val) : this.convertParameterPlaceholders(val, params);
            property.setValue(val);
        }
        if (MapUtils.isEmpty((Map)globalParams)) {
            globalParams = new HashMap<String, Property>();
        }
        if (MapUtils.isNotEmpty(paramsMap = this.preBuildBusinessParams(processInstance))) {
            globalParams.putAll(paramsMap);
        }
        return globalParams;
    }

    private Map<String, String> setGlobalParamsMap(ProcessInstance processInstance) {
        HashMap<String, String> globalParamsMap = new HashMap<String, String>(16);
        String globalParamsStr = processInstance.getGlobalParams();
        if (globalParamsStr != null) {
            List globalParamsList = JSONUtils.toList((String)globalParamsStr, Property.class);
            globalParamsMap.putAll(globalParamsList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue)));
        }
        return globalParamsMap;
    }

    @Override
    public Map<String, Property> preBuildBusinessParams(ProcessInstance processInstance) {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (processInstance.getScheduleTime() != null) {
            Date date = processInstance.getScheduleTime();
            String dateTime = DateUtils.format((Date)date, (String)"yyyyMMddHHmmss", null);
            Property p = new Property();
            p.setValue(dateTime);
            p.setProp("system.datetime");
            paramsMap.put("system.datetime", p);
        }
        return paramsMap;
    }
}

