/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannelFactory;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskPluginManager.class);
    private final Map<String, TaskChannelFactory> taskChannelFactoryMap = new HashMap<String, TaskChannelFactory>();
    private final Map<String, TaskChannel> taskChannelMap = new HashMap<String, TaskChannel>();
    private final AtomicBoolean loadedFlag = new AtomicBoolean(false);

    public void loadPlugin() {
        if (!this.loadedFlag.compareAndSet(false, true)) {
            logger.warn("The task plugin has already been loaded");
            return;
        }
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(TaskChannelFactory.class);
        for (Map.Entry entry : prioritySPIFactory.getSPIMap().entrySet()) {
            String factoryName = (String)entry.getKey();
            TaskChannelFactory factory = (TaskChannelFactory)entry.getValue();
            logger.info("Registering task plugin: {} - {}", (Object)factoryName, factory.getClass());
            this.taskChannelFactoryMap.put(factoryName, factory);
            this.taskChannelMap.put(factoryName, factory.create());
            logger.info("Registered task plugin: {} - {}", (Object)factoryName, factory.getClass());
        }
    }

    public Map<String, TaskChannel> getTaskChannelMap() {
        return Collections.unmodifiableMap(this.taskChannelMap);
    }

    public Map<String, TaskChannelFactory> getTaskChannelFactoryMap() {
        return Collections.unmodifiableMap(this.taskChannelFactoryMap);
    }

    public TaskChannel getTaskChannel(String type) {
        return this.getTaskChannelMap().get(type);
    }

    public boolean checkTaskParameters(ParametersNode parametersNode) {
        AbstractParameters abstractParameters = this.getParameters(parametersNode);
        return abstractParameters != null && abstractParameters.checkParameters();
    }

    public AbstractParameters getParameters(ParametersNode parametersNode) {
        String taskType = parametersNode.getTaskType();
        if (Objects.isNull(taskType)) {
            return null;
        }
        TaskChannel taskChannel = this.getTaskChannelMap().get(taskType);
        if (Objects.isNull(taskChannel)) {
            return null;
        }
        return taskChannel.parseParameters(parametersNode);
    }
}

