/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Optional;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.service.log.TaskLogDiscriminator;
import org.slf4j.LoggerFactory;

public class LogUtils {
    public static final String LOG_TAILFIX = ".log";

    private LogUtils() throws IllegalStateException {
        throw new IllegalStateException("Utility class");
    }

    public static String getTaskLogPath(Date firstSubmitTime, Long processDefineCode, int processDefineVersion, int processInstanceId, int taskInstanceId) {
        String taskLogFileName = String.valueOf(processDefineCode) + "_" + processDefineVersion + '-' + processInstanceId + '-' + taskInstanceId + LOG_TAILFIX;
        return Optional.of(LoggerFactory.getILoggerFactory()).map(e -> (AppenderAttachable)e.getLogger("ROOT")).map(e -> (SiftingAppender)e.getAppender("TASKLOGFILE")).map(e -> (TaskLogDiscriminator)e.getDiscriminator()).map(TaskLogDiscriminator::getLogBase).map(e -> Paths.get(e, new String[0]).toAbsolutePath().resolve(DateUtils.format((Date)firstSubmitTime, (String)"yyyyMMdd", null)).resolve(taskLogFileName)).map(Path::toString).orElse("");
    }

    public static String getTaskLogPath(TaskExecutionContext taskExecutionContext) {
        return LogUtils.getTaskLogPath(taskExecutionContext.getFirstSubmitTime(), taskExecutionContext.getProcessDefineCode(), taskExecutionContext.getProcessDefineVersion(), taskExecutionContext.getProcessInstanceId(), taskExecutionContext.getTaskInstanceId());
    }
}

