/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.service.cron.CycleFactory;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtils {
    private static final Logger logger = LoggerFactory.getLogger(CronUtils.class);
    private static final CronParser QUARTZ_CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));

    private CronUtils() {
        throw new IllegalStateException("CronUtils class");
    }

    public static Cron parse2Cron(String cronExpression) throws CronParseException {
        try {
            return QUARTZ_CRON_PARSER.parse(cronExpression);
        }
        catch (IllegalArgumentException ex) {
            throw new CronParseException(String.format("Parse corn expression: [%s] error", cronExpression), ex);
        }
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            CronUtils.parse2Cron(cronExpression);
        }
        catch (CronParseException e) {
            return false;
        }
        return true;
    }

    public static CycleEnum getMaxCycle(Cron cron) {
        return CycleFactory.min(cron).addCycle(CycleFactory.hour(cron)).addCycle(CycleFactory.day(cron)).addCycle(CycleFactory.week(cron)).addCycle(CycleFactory.month(cron)).addCycle(CycleFactory.year(cron)).getCycle();
    }

    public static CycleEnum getMiniCycle(Cron cron) {
        return CycleFactory.min(cron).addCycle(CycleFactory.hour(cron)).addCycle(CycleFactory.day(cron)).addCycle(CycleFactory.week(cron)).addCycle(CycleFactory.month(cron)).addCycle(CycleFactory.year(cron)).getMiniCycle();
    }

    public static CycleEnum getMaxCycle(String crontab) {
        try {
            return CronUtils.getMaxCycle(CronUtils.parse2Cron(crontab));
        }
        catch (CronParseException ex) {
            throw new RuntimeException("Get max cycle error", ex);
        }
    }

    public static List<ZonedDateTime> getFireDateList(@NonNull ZonedDateTime startTime, @NonNull ZonedDateTime endTime, @NonNull String cron) throws CronParseException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (cron == null) {
            throw new NullPointerException("cron is marked non-null but is null");
        }
        return CronUtils.getFireDateList(startTime, endTime, CronUtils.parse2Cron(cron));
    }

    public static List<ZonedDateTime> getFireDateList(@NonNull ZonedDateTime startTime, @NonNull ZonedDateTime endTime, @NonNull Cron cron) {
        Optional nextExecutionTimeOptional;
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (cron == null) {
            throw new NullPointerException("cron is marked non-null but is null");
        }
        ArrayList<ZonedDateTime> dateList = new ArrayList<ZonedDateTime>();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        while (!ServerLifeCycleManager.isStopped() && (nextExecutionTimeOptional = executionTime.nextExecution(startTime)).isPresent() && !(startTime = (ZonedDateTime)nextExecutionTimeOptional.get()).isAfter(endTime)) {
            dateList.add(startTime);
        }
        return dateList;
    }

    public static List<ZonedDateTime> getSelfFireDateList(@NonNull ZonedDateTime startTime, @NonNull ZonedDateTime endTime, @NonNull Cron cron, int fireTimes) {
        Optional nextTime;
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (cron == null) {
            throw new NullPointerException("cron is marked non-null but is null");
        }
        ArrayList<ZonedDateTime> executeTimes = new ArrayList<ZonedDateTime>();
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        while (fireTimes > 0 && (nextTime = executionTime.nextExecution(startTime)).isPresent() && !(startTime = (ZonedDateTime)nextTime.get()).isAfter(endTime)) {
            executeTimes.add(startTime);
            --fireTimes;
        }
        return executeTimes;
    }

    public static List<Date> getSelfFireDateList(@NonNull Date startTime, @NonNull Date endTime, @NonNull List<Schedule> schedules) throws CronParseException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (schedules == null) {
            throw new NullPointerException("schedules is marked non-null but is null");
        }
        ZonedDateTime zonedDateTimeStart = ZonedDateTime.ofInstant(startTime.toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTimeEnd = ZonedDateTime.ofInstant(endTime.toInstant(), ZoneId.systemDefault());
        return CronUtils.getSelfFireDateList(zonedDateTimeStart, zonedDateTimeEnd, schedules).stream().map(zonedDateTime -> new Date(zonedDateTime.toInstant().toEpochMilli())).collect(Collectors.toList());
    }

    public static List<ZonedDateTime> getSelfFireDateList(@NonNull ZonedDateTime startTime, @NonNull ZonedDateTime endTime, @NonNull List<Schedule> schedules) throws CronParseException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (schedules == null) {
            throw new NullPointerException("schedules is marked non-null but is null");
        }
        ArrayList<ZonedDateTime> result = new ArrayList<ZonedDateTime>();
        if (startTime.equals(endTime)) {
            result.add(startTime);
            return result;
        }
        ZonedDateTime from = startTime.minusSeconds(1L);
        ZonedDateTime to = endTime.plusSeconds(1L);
        ArrayList<Schedule> listSchedule = new ArrayList<Schedule>();
        listSchedule.addAll(schedules);
        if (CollectionUtils.isEmpty(listSchedule)) {
            Schedule schedule = new Schedule();
            schedule.setCrontab("0 0 0 * * ? *");
            listSchedule.add(schedule);
        }
        for (Schedule schedule : listSchedule) {
            result.addAll(CronUtils.getFireDateList(from, to, schedule.getCrontab()));
        }
        return result;
    }

    public static Date getExpirationTime(Date startTime, CycleEnum cycleEnum) {
        Date maxExpirationTime = null;
        Date startTimeMax = null;
        try {
            startTimeMax = CronUtils.getEndTime(startTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            switch (cycleEnum) {
                case HOUR: {
                    calendar.add(10, 1);
                    break;
                }
                case DAY: {
                    calendar.add(5, 1);
                    break;
                }
                case WEEK: {
                    calendar.add(5, 1);
                    break;
                }
                case MONTH: {
                    calendar.add(5, 1);
                    break;
                }
                default: {
                    logger.error("Dependent process definition's  cycleEnum is {},not support!!", (Object)cycleEnum);
                }
            }
            maxExpirationTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return DateUtils.compare((Date)startTimeMax, maxExpirationTime) ? maxExpirationTime : startTimeMax;
    }

    private static Date getEndTime(Date date) {
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(date);
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        end.set(14, 999);
        return end.getTime();
    }

    public static List<Date> getSelfScheduleDateList(Map<String, String> param) {
        ArrayList<Date> result = new ArrayList<Date>();
        String scheduleDates = param.get("complementScheduleDateList");
        if (StringUtils.isNotEmpty((CharSequence)scheduleDates)) {
            for (String stringDate : scheduleDates.split(",")) {
                result.add(DateUtils.stringToDate((String)stringDate.trim()));
            }
            return result;
        }
        return null;
    }
}

