/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.storage.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.factory.OssClientFactory;
import org.apache.dolphinscheduler.common.model.OssConnection;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.service.storage.StorageOperate;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssOperator
implements Closeable,
StorageOperate {
    private static final Logger logger = LoggerFactory.getLogger(OssOperator.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String region;
    private String bucketName;
    private String endPoint;
    private OssConnection ossConnection;
    private OSS ossClient;

    public void init() {
        this.accessKeyId = this.readOssAccessKeyID();
        this.accessKeySecret = this.readOssAccessKeySecret();
        this.endPoint = this.readOssEndPoint();
        this.region = this.readOssRegion();
        this.bucketName = this.readOssBucketName();
        this.ossConnection = this.buildOssConnection();
        this.ossClient = this.buildOssClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    public void init(OssConnection ossConnection) {
        this.accessKeyId = this.readOssAccessKeyID();
        this.accessKeySecret = this.readOssAccessKeySecret();
        this.endPoint = this.readOssEndPoint();
        this.region = this.readOssRegion();
        this.bucketName = this.readOssBucketName();
        this.ossConnection = ossConnection;
        this.ossClient = this.getOssClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    protected String readOssAccessKeyID() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.access.key.id");
    }

    protected String readOssAccessKeySecret() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.access.key.secret");
    }

    protected String readOssRegion() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.region");
    }

    protected String readOssBucketName() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.oss.bucket.name");
    }

    protected String readOssEndPoint() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.oss.endpoint");
    }

    protected OssConnection buildOssConnection() {
        return new OssConnection(this.accessKeyId, this.accessKeySecret, this.endPoint);
    }

    @Override
    public void close() throws IOException {
        this.ossClient.shutdown();
    }

    @Override
    public void createTenantDirIfNotExists(String tenantCode) throws Exception {
        this.mkdir(tenantCode, this.getOssResDir(tenantCode));
        this.mkdir(tenantCode, this.getOssUdfDir(tenantCode));
    }

    @Override
    public String getResDir(String tenantCode) {
        return this.getOssResDir(tenantCode) + "/";
    }

    @Override
    public String getUdfDir(String tenantCode) {
        return this.getOssUdfDir(tenantCode) + "/";
    }

    @Override
    public boolean mkdir(String tenantCode, String path) throws IOException {
        String key = path + "/";
        if (!this.ossClient.doesObjectExist(this.bucketName, key)) {
            this.createOssPrefix(this.bucketName, key);
        }
        return true;
    }

    protected void createOssPrefix(String bucketName, String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, (InputStream)emptyContent, metadata);
        this.ossClient.putObject(putObjectRequest);
    }

    @Override
    public String getResourceFileName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", this.getOssResDir(tenantCode), fileName);
    }

    @Override
    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return this.getDir(resourceType, tenantCode) + fileName;
    }

    @Override
    public void download(String tenantCode, String srcFilePath, String dstFilePath, boolean deleteSource, boolean overwrite) throws IOException {
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            Files.createDirectories(dstFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, srcFilePath);
        try (InputStream ossInputStream = ossObject.getObjectContent();
             FileOutputStream fos = new FileOutputStream(dstFilePath);){
            int readLen;
            byte[] readBuf = new byte[1024];
            while ((readLen = ossInputStream.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
        catch (OSSException e) {
            throw new IOException(e);
        }
        catch (FileNotFoundException e) {
            logger.error("cannot fin the destination file {}", (Object)dstFilePath);
            throw e;
        }
    }

    @Override
    public boolean exists(String tenantCode, String fileName) throws IOException {
        return this.ossClient.doesObjectExist(this.bucketName, fileName);
    }

    @Override
    public boolean delete(String tenantCode, String filePath, boolean recursive) throws IOException {
        try {
            this.ossClient.deleteObject(this.bucketName, filePath);
            return true;
        }
        catch (OSSException e) {
            logger.error("fail to delete the object, the resource path is {}", (Object)filePath, (Object)e);
            return false;
        }
    }

    @Override
    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        this.ossClient.copyObject(this.bucketName, srcPath, this.bucketName, dstPath);
        this.ossClient.deleteObject(this.bucketName, srcPath);
        return true;
    }

    @Override
    public String getDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return this.getUdfDir(tenantCode);
            }
            case FILE: {
                return this.getResDir(tenantCode);
            }
        }
        return "";
    }

    @Override
    public boolean upload(String tenantCode, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        try {
            this.ossClient.putObject(this.bucketName, dstPath, new File(srcFile));
            return true;
        }
        catch (OSSException e) {
            logger.error("upload failed, the bucketName is {}, the filePath is {}", new Object[]{this.bucketName, dstPath, e});
            return false;
        }
    }

    @Override
    public List<String> vimFile(String tenantCode, String filePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            logger.error("file path:{} is empty", (Object)filePath);
            return Collections.emptyList();
        }
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public ResUploadType returnStorageType() {
        return ResUploadType.OSS;
    }

    @Override
    public void deleteTenant(String tenantCode) throws Exception {
        this.deleteTenantCode(tenantCode);
    }

    public String getOssResDir(String tenantCode) {
        return String.format("%s/resources", this.getOssTenantDir(tenantCode));
    }

    public String getOssUdfDir(String tenantCode) {
        return String.format("%s/udfs", this.getOssTenantDir(tenantCode));
    }

    public String getOssTenantDir(String tenantCode) {
        return String.format("%s/%s", this.getOssDataBasePath(), tenantCode);
    }

    public String getOssDataBasePath() {
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return "";
        }
        return RESOURCE_UPLOAD_PATH.replaceFirst("/", "");
    }

    protected void deleteTenantCode(String tenantCode) {
        this.deleteDir(this.getResDir(tenantCode));
        this.deleteDir(this.getUdfDir(tenantCode));
    }

    public void ensureBucketSuccessfullyCreated(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.alibaba.cloud.oss.bucket.name is empty");
        }
        Bucket existsBucket = this.ossClient.listBuckets().stream().filter(bucket -> bucket.getName().equals(bucketName)).findFirst().orElseThrow(() -> new IllegalArgumentException("bucketName: " + bucketName + " does not exist, you need to create them by yourself"));
        logger.info("bucketName: {} has been found, the current regionName is {}", (Object)existsBucket.getName(), (Object)this.region);
    }

    protected void deleteDir(String directoryName) {
        if (this.ossClient.doesObjectExist(this.bucketName, directoryName)) {
            this.ossClient.deleteObject(this.bucketName, directoryName);
        }
    }

    protected OSS buildOssClient() {
        return OssClientFactory.buildOssClient((OssConnection)this.ossConnection);
    }

    @Generated
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public OssConnection getOssConnection() {
        return this.ossConnection;
    }

    @Generated
    public OSS getOssClient() {
        return this.ossClient;
    }

    @Generated
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Generated
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setOssConnection(OssConnection ossConnection) {
        this.ossConnection = ossConnection;
    }

    @Generated
    public void setOssClient(OSS ossClient) {
        this.ossClient = ossClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssOperator)) {
            return false;
        }
        OssOperator other = (OssOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        OssConnection this$ossConnection = this.getOssConnection();
        OssConnection other$ossConnection = other.getOssConnection();
        if (this$ossConnection == null ? other$ossConnection != null : !this$ossConnection.equals(other$ossConnection)) {
            return false;
        }
        OSS this$ossClient = this.getOssClient();
        OSS other$ossClient = other.getOssClient();
        return !(this$ossClient == null ? other$ossClient != null : !this$ossClient.equals(other$ossClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OssOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        OssConnection $ossConnection = this.getOssConnection();
        result = result * 59 + ($ossConnection == null ? 43 : $ossConnection.hashCode());
        OSS $ossClient = this.getOssClient();
        result = result * 59 + ($ossClient == null ? 43 : $ossClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OssOperator(accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", region=" + this.getRegion() + ", bucketName=" + this.getBucketName() + ", endPoint=" + this.getEndPoint() + ", ossConnection=" + this.getOssConnection() + ", ossClient=" + this.getOssClient() + ")";
    }
}

