/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.alert;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendRequest;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendResponse;
import org.apache.dolphinscheduler.remote.factory.NettyRemotingClientFactory;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.remote.utils.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertClientService
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertClientService.class);
    private final NettyRemotingClient client = NettyRemotingClientFactory.buildNettyRemotingClient();
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private String host;
    private int port;
    private static final long ALERT_REQUEST_TIMEOUT = 10000L;

    @Override
    public void close() {
        if (this.isRunning.compareAndSet(true, false)) {
            log.warn("Alert client is already closed");
            return;
        }
        log.info("Alter client closing");
        this.client.close();
        log.info("Alter client closed");
    }

    public AlertSendResponse sendAlert(int groupId, String title, String content, int strategy) {
        return this.sendAlert(this.host, this.port, groupId, title, content, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertSendResponse sendAlert(String host, int port, int groupId, String title, String content, int strategy) {
        log.info("sync alert send, host : {}, port : {}, groupId : {}, title : {} , strategy : {} ", new Object[]{host, port, groupId, title, strategy});
        AlertSendRequest request = new AlertSendRequest(groupId, title, content, strategy);
        Host address = new Host(host, port);
        try {
            Message message = request.convert2Command();
            Message response = this.client.sendSync(address, message, 10000L);
            if (response != null) {
                AlertSendResponse alertSendResponse = (AlertSendResponse)JsonSerializer.deserialize((byte[])response.getBody(), AlertSendResponse.class);
                return alertSendResponse;
            }
        }
        catch (Exception e) {
            log.error("sync alert send error", (Throwable)e);
        }
        finally {
            this.client.closeChannel(address);
        }
        return null;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }
}

