/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.cache.impl;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRemoteChannel;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.cache.CacheNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheNotifyServiceImpl
implements CacheNotifyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheNotifyServiceImpl.class);
    @Autowired
    private RegistryClient registryClient;
    private static final ConcurrentHashMap<Host, NettyRemoteChannel> REMOTE_CHANNELS = new ConcurrentHashMap();
    private final NettyRemotingClient nettyRemotingClient;

    public CacheNotifyServiceImpl() {
        NettyClientConfig clientConfig = new NettyClientConfig();
        this.nettyRemotingClient = new NettyRemotingClient(clientConfig);
    }

    private void cache(Host host, NettyRemoteChannel channel) {
        REMOTE_CHANNELS.put(host, channel);
    }

    private void remove(Host host) {
        REMOTE_CHANNELS.remove(host);
    }

    private NettyRemoteChannel getRemoteChannel(Host host) {
        Channel channel;
        NettyRemoteChannel nettyRemoteChannel = REMOTE_CHANNELS.get(host);
        if (nettyRemoteChannel != null) {
            if (nettyRemoteChannel.isActive()) {
                return nettyRemoteChannel;
            }
            this.remove(host);
        }
        if ((channel = this.nettyRemotingClient.getChannel(host)) == null) {
            return null;
        }
        NettyRemoteChannel remoteChannel = new NettyRemoteChannel(channel);
        this.cache(host, remoteChannel);
        return remoteChannel;
    }

    @Override
    public void notifyMaster(Message message) {
        log.info("send result, command:{}", (Object)message.toString());
        try {
            List serverList = this.registryClient.getServerList(RegistryNodeType.MASTER);
            if (CollectionUtils.isEmpty((Collection)serverList)) {
                return;
            }
            for (Server server : serverList) {
                Host host = new Host(server.getHost(), server.getPort());
                NettyRemoteChannel nettyRemoteChannel = this.getRemoteChannel(host);
                if (nettyRemoteChannel == null) continue;
                nettyRemoteChannel.writeAndFlush(message);
            }
        }
        catch (Exception e) {
            log.error("notify master error", (Throwable)e);
        }
    }
}

