/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.log;

import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LogUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.command.log.GetAppIdRequest;
import org.apache.dolphinscheduler.remote.command.log.GetAppIdResponse;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequest;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponse;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequest;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponse;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogRequest;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogResponse;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequest;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseResponse;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.factory.NettyRemotingClientFactory;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogClient.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final NettyRemotingClient client = NettyRemotingClientFactory.buildNettyRemotingClient();
    private static final long LOG_REQUEST_TIMEOUT = 10000L;

    public String rollViewLog(String host, int port, String path, int skipLineNum, int limit) {
        log.info("Roll view log from host : {}, port : {}, path {}, skipLineNum {} ,limit {}", new Object[]{host, port, path, skipLineNum, limit});
        RollViewLogRequest request = new RollViewLogRequest(path, skipLineNum, limit);
        Host address = new Host(host, port);
        try {
            Message message = request.convert2Command();
            Message response = this.client.sendSync(address, message, 10000L);
            if (response != null) {
                RollViewLogResponse rollReviewLog = (RollViewLogResponse)JSONUtils.parseObject((byte[])response.getBody(), RollViewLogResponse.class);
                return rollReviewLog.getMsg();
            }
            return "Roll view log response is null";
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.error("Roll view log from host : {}, port : {}, path {}, skipLineNum {} ,limit {} error, the current thread has been interrupted", new Object[]{host, port, path, skipLineNum, limit, ex});
            return "Roll view log error: " + ex.getMessage();
        }
        catch (Exception e) {
            log.error("Roll view log from host : {}, port : {}, path {}, skipLineNum {} ,limit {} error", new Object[]{host, port, path, skipLineNum, limit, e});
            return "Roll view log error: " + e.getMessage();
        }
    }

    public String viewLog(String host, int port, String path) {
        log.info("View log from host: {}, port: {}, logPath: {}", new Object[]{host, port, path});
        ViewLogRequest request = new ViewLogRequest(path);
        Host address = new Host(host, port);
        try {
            if (NetUtils.getHost().equals(host)) {
                return LogUtils.readWholeFileContentFromLocal((String)request.getPath());
            }
            Message message = request.convert2Command();
            Message response = this.client.sendSync(address, message, 10000L);
            if (response != null) {
                ViewLogResponseResponse viewLog = (ViewLogResponseResponse)JSONUtils.parseObject((byte[])response.getBody(), ViewLogResponseResponse.class);
                return viewLog.getMsg();
            }
            return "View log response is null";
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.error("View log from host: {}, port: {}, logPath: {} error, the current thread has been interrupted", new Object[]{host, port, path, ex});
            return "View log error: " + ex.getMessage();
        }
        catch (Exception e) {
            log.error("View log from host: {}, port: {}, logPath: {} error", new Object[]{host, port, path, e});
            return "View log error: " + e.getMessage();
        }
    }

    public byte[] getLogBytes(String host, int port, String path) {
        log.info("Get log bytes from host: {}, port: {}, logPath {}", new Object[]{host, port, path});
        GetLogBytesRequest request = new GetLogBytesRequest(path);
        Host address = new Host(host, port);
        try {
            Message message = request.convert2Command();
            Message response = this.client.sendSync(address, message, 10000L);
            if (response != null) {
                GetLogBytesResponse getLog = (GetLogBytesResponse)JSONUtils.parseObject((byte[])response.getBody(), GetLogBytesResponse.class);
                return getLog.getData() == null ? EMPTY_BYTE_ARRAY : getLog.getData();
            }
            return EMPTY_BYTE_ARRAY;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.error("Get logSize from host: {}, port: {}, logPath: {} error, the current thread has been interrupted", new Object[]{host, port, path, ex});
            return EMPTY_BYTE_ARRAY;
        }
        catch (Exception e) {
            log.error("Get logSize from host: {}, port: {}, logPath: {} error", new Object[]{host, port, path, e});
            return EMPTY_BYTE_ARRAY;
        }
    }

    public void removeTaskLog(@NonNull Host host, String path) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        log.info("Begin remove task log from host: {} logPath {}", (Object)host, (Object)path);
        RemoveTaskLogRequest request = new RemoveTaskLogRequest(path);
        try {
            Message message = request.convert2Command();
            this.client.sendAsync(host, message, 10000L, responseFuture -> {
                if (responseFuture.getCause() != null) {
                    log.error("Remove task log from host: {} logPath {} error, meet an unknown exception", new Object[]{host, path, responseFuture.getCause()});
                    return;
                }
                Message response = responseFuture.getResponseCommand();
                if (response == null) {
                    log.error("Remove task log from host: {} logPath {} error, response is null", (Object)host, (Object)path);
                    return;
                }
                RemoveTaskLogResponse removeTaskLogResponse = (RemoveTaskLogResponse)JSONUtils.parseObject((byte[])response.getBody(), RemoveTaskLogResponse.class);
                if (removeTaskLogResponse.getStatus().booleanValue()) {
                    log.info("Success remove task log from host: {} logPath {}", (Object)host, (Object)path);
                } else {
                    log.error("Remove task log from host: {} logPath {} error", (Object)host, (Object)path);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.error("Remove task log from host: {} logPath {} error, the current thread has been interrupted", new Object[]{host, path, interruptedException});
        }
        catch (Exception e) {
            log.error("Remove task log from host: {},  logPath: {} error", new Object[]{host, path, e});
        }
    }

    @Nullable
    public List<String> getAppIds(@NonNull String host, int port, String taskLogFilePath, String taskAppInfoPath, int taskInstanceId) throws RemotingException, InterruptedException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        log.info("Begin to get appIds from worker: {}:{} taskLogPath: {}, taskAppInfoPath: {}", new Object[]{host, port, taskLogFilePath, taskAppInfoPath});
        Host workerAddress = new Host(host, port);
        List appIds = null;
        if (NetUtils.getHost().equals(host)) {
            appIds = org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils.getAppIds((String)taskLogFilePath, (String)taskAppInfoPath, (String)PropertyUtils.getString((String)"appId.collect", (String)"log"));
        } else {
            Message message = new GetAppIdRequest(taskInstanceId, taskLogFilePath).convert2Command();
            Message response = this.client.sendSync(workerAddress, message, 10000L);
            if (response != null) {
                GetAppIdResponse responseCommand = (GetAppIdResponse)JSONUtils.parseObject((byte[])response.getBody(), GetAppIdResponse.class);
                appIds = responseCommand.getAppIds();
            }
        }
        log.info("Get appIds: {} from worker: {}:{} taskLogPath: {}, taskAppInfoPath: {}", new Object[]{appIds, host, port, taskLogFilePath, taskAppInfoPath});
        return appIds;
    }

    @Override
    public void close() {
        this.client.close();
        log.info("LogClientService closed");
    }
}

