/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DependentProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResult;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskGroup;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DqComparisonTypeMapper;
import org.apache.dolphinscheduler.dao.mapper.DqExecuteResultMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleExecuteSqlMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleInputEntryMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleMapper;
import org.apache.dolphinscheduler.dao.mapper.DqTaskStatisticsValueMapper;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupQueueMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkFlowLineageMapper;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceMapDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.DqRuleUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.DqTaskState;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SubProcessParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.TaskTimeoutParameter;
import org.apache.dolphinscheduler.remote.command.workflow.WorkflowStateEventChangeRequest;
import org.apache.dolphinscheduler.remote.processor.StateEventCallbackService;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.apache.dolphinscheduler.service.cron.CronUtils;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.apache.dolphinscheduler.service.exceptions.ServiceException;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.log.LogClient;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessDag;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.process.TriggerRelationService;
import org.apache.dolphinscheduler.service.utils.ClusterConfUtils;
import org.apache.dolphinscheduler.service.utils.Constants;
import org.apache.dolphinscheduler.service.utils.DagHelper;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessServiceImpl
implements ProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;
    @Autowired
    private ProcessDefinitionLogMapper processDefineLogMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ProcessInstanceDao processInstanceDao;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;
    @Autowired
    private ProcessInstanceMapDao processInstanceMapDao;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private ProcessInstanceMapMapper processInstanceMapMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private DqExecuteResultMapper dqExecuteResultMapper;
    @Autowired
    private DqRuleMapper dqRuleMapper;
    @Autowired
    private DqRuleInputEntryMapper dqRuleInputEntryMapper;
    @Autowired
    private DqRuleExecuteSqlMapper dqRuleExecuteSqlMapper;
    @Autowired
    private DqComparisonTypeMapper dqComparisonTypeMapper;
    @Autowired
    private DqTaskStatisticsValueMapper dqTaskStatisticsValueMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;
    @Autowired
    StateEventCallbackService stateEventCallbackService;
    @Autowired
    private EnvironmentMapper environmentMapper;
    @Autowired
    private TaskGroupQueueMapper taskGroupQueueMapper;
    @Autowired
    private TaskGroupMapper taskGroupMapper;
    @Autowired
    private WorkFlowLineageMapper workFlowLineageMapper;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private ClusterMapper clusterMapper;
    @Autowired
    private CuringParamsService curingGlobalParamsService;
    @Autowired
    private LogClient logClient;
    @Autowired
    private CommandService commandService;
    @Autowired
    private TriggerRelationService triggerRelationService;

    @Override
    @Transactional
    @Nullable
    public ProcessInstance handleCommand(String host, Command command) throws CronParseException, CodeGenerateUtils.CodeGenerateException {
        ProcessInstance processInstance = this.constructProcessInstance(command, host);
        if (processInstance == null) {
            log.error("scan command, command parameter is error: {}", (Object)command);
            this.commandService.moveToErrorCommand(command, "process instance is null");
            return null;
        }
        processInstance.setCommandType(command.getCommandType());
        processInstance.addHistoryCmd(command.getCommandType());
        processInstance.setTestFlag(command.getTestFlag());
        ProcessDefinition processDefinition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (processDefinition.getExecutionType().typeIsSerial()) {
            this.saveSerialProcess(processInstance, processDefinition);
            if (processInstance.getState() != WorkflowExecutionStatus.RUNNING_EXECUTION) {
                this.setSubProcessParam(processInstance);
                this.triggerRelationService.saveProcessInstanceTrigger(command.getId(), processInstance.getId());
                this.deleteCommandWithCheck(command.getId());
                return null;
            }
        } else {
            this.processInstanceDao.upsertProcessInstance(processInstance);
        }
        this.triggerRelationService.saveProcessInstanceTrigger(command.getId(), processInstance.getId());
        this.setSubProcessParam(processInstance);
        this.deleteCommandWithCheck(command.getId());
        return processInstance;
    }

    protected void saveSerialProcess(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        processInstance.setStateWithDesc(WorkflowExecutionStatus.SERIAL_WAIT, "wait by serial_wait strategy");
        this.processInstanceDao.upsertProcessInstance(processInstance);
        if (processDefinition.getExecutionType().typeIsSerialWait()) {
            List runningProcessInstances = this.processInstanceMapper.queryByProcessDefineCodeAndProcessDefinitionVersionAndStatusAndNextId(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), Constants.RUNNING_PROCESS_STATE, processInstance.getId());
            if (CollectionUtils.isEmpty((Collection)runningProcessInstances)) {
                processInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, "submit from serial_wait strategy");
                this.processInstanceDao.upsertProcessInstance(processInstance);
            }
        } else if (processDefinition.getExecutionType().typeIsSerialDiscard()) {
            List runningProcessInstances = this.processInstanceMapper.queryByProcessDefineCodeAndProcessDefinitionVersionAndStatusAndNextId(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), Constants.RUNNING_PROCESS_STATE, processInstance.getId());
            if (CollectionUtils.isNotEmpty((Collection)runningProcessInstances)) {
                processInstance.setStateWithDesc(WorkflowExecutionStatus.STOP, "stop by serial_discard strategy");
                this.processInstanceDao.upsertProcessInstance(processInstance);
                return;
            }
            processInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, "submit from serial_discard strategy");
            this.processInstanceDao.upsertProcessInstance(processInstance);
        } else if (processDefinition.getExecutionType().typeIsSerialPriority()) {
            List runningProcessInstances = this.processInstanceMapper.queryByProcessDefineCodeAndProcessDefinitionVersionAndStatusAndNextId(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion(), Constants.RUNNING_PROCESS_STATE, processInstance.getId());
            for (ProcessInstance info : runningProcessInstances) {
                info.setCommandType(CommandType.STOP);
                info.addHistoryCmd(CommandType.STOP);
                info.setStateWithDesc(WorkflowExecutionStatus.READY_STOP, "ready stop by serial_priority strategy");
                boolean update = this.processInstanceDao.updateById((Object)info);
                if (!update) continue;
                WorkflowStateEventChangeRequest workflowStateEventChangeRequest = new WorkflowStateEventChangeRequest(info.getId().intValue(), 0, info.getState(), info.getId().intValue(), 0);
                try {
                    Host host = new Host(info.getHost());
                    this.stateEventCallbackService.sendResult(host, workflowStateEventChangeRequest.convert2Command());
                }
                catch (Exception e) {
                    log.error("sendResultError", (Throwable)e);
                }
            }
            processInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, "submit by serial_priority strategy");
            this.processInstanceDao.upsertProcessInstance(processInstance);
        }
    }

    @Override
    public Optional<ProcessInstance> findProcessInstanceDetailById(int processId) {
        return Optional.ofNullable(this.processInstanceMapper.queryDetailById(processId));
    }

    @Override
    public ProcessInstance findProcessInstanceById(int processId) {
        return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(processId));
    }

    @Override
    public ProcessDefinition findProcessDefineById(int processDefinitionId) {
        return (ProcessDefinition)this.processDefineMapper.selectById((Serializable)Integer.valueOf(processDefinitionId));
    }

    @Override
    public ProcessDefinition findProcessDefinition(Long processDefinitionCode, int version) {
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processDefinitionCode.longValue());
        if ((processDefinition == null || processDefinition.getVersion() != version) && (processDefinition = this.processDefineLogMapper.queryByDefinitionCodeAndVersion(processDefinitionCode.longValue(), version)) != null) {
            processDefinition.setId(Integer.valueOf(0));
        }
        return processDefinition;
    }

    @Override
    public ProcessDefinition findProcessDefinitionByCode(Long processDefinitionCode) {
        return this.processDefineMapper.queryByCode(processDefinitionCode.longValue());
    }

    @Override
    public int deleteWorkProcessInstanceById(int processInstanceId) {
        return this.processInstanceMapper.deleteById((Serializable)Integer.valueOf(processInstanceId));
    }

    @Override
    public int deleteAllSubWorkProcessByParentId(int processInstanceId) {
        List subProcessIdList = this.processInstanceMapMapper.querySubIdListByParentId(processInstanceId);
        for (Integer subId : subProcessIdList) {
            this.deleteAllSubWorkProcessByParentId(subId);
            this.deleteWorkProcessMapByParentId(subId);
            this.removeTaskLogFile(subId);
            this.deleteWorkProcessInstanceById(subId);
        }
        return 1;
    }

    @Override
    public void removeTaskLogFile(Integer processInstanceId) {
        List taskInstanceList = this.taskInstanceDao.queryByWorkflowInstanceId(processInstanceId);
        if (CollectionUtils.isEmpty((Collection)taskInstanceList)) {
            return;
        }
        for (TaskInstance taskInstance : taskInstanceList) {
            String taskLogPath = taskInstance.getLogPath();
            if (StringUtils.isEmpty((CharSequence)taskInstance.getHost()) || StringUtils.isEmpty((CharSequence)taskLogPath)) continue;
            this.logClient.removeTaskLog(Host.of((String)taskInstance.getHost()), taskLogPath);
        }
    }

    @Override
    public void recurseFindSubProcess(long parentCode, List<Long> ids) {
        List taskNodeList = this.taskDefinitionDao.getTaskDefinitionListByDefinition(parentCode);
        if (taskNodeList != null && !taskNodeList.isEmpty()) {
            for (TaskDefinition taskNode : taskNodeList) {
                String parameter = taskNode.getTaskParams();
                ObjectNode parameterJson = JSONUtils.parseObject((String)parameter);
                if (parameterJson.get("processDefinitionCode") == null) continue;
                SubProcessParameters subProcessParam = (SubProcessParameters)JSONUtils.parseObject((String)parameter, SubProcessParameters.class);
                ids.add(subProcessParam.getProcessDefinitionCode());
                this.recurseFindSubProcess(subProcessParam.getProcessDefinitionCode(), ids);
            }
        }
    }

    private Date getScheduleTime(Command command, Map<String, String> cmdParam) throws CronParseException {
        Date scheduleTime = command.getScheduleTime();
        if (scheduleTime == null && cmdParam != null && cmdParam.containsKey("complementStartDate")) {
            List<Schedule> schedules;
            Date end;
            Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
            List<Date> complementDateList = CronUtils.getSelfFireDateList(start, end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate")), schedules = this.queryReleaseSchedulerListByProcessDefinitionCode(command.getProcessDefinitionCode()));
            if (CollectionUtils.isNotEmpty(complementDateList)) {
                scheduleTime = complementDateList.get(0);
            } else {
                log.error("set scheduler time error: complement date list is empty, command: {}", (Object)command.toString());
            }
        }
        return scheduleTime;
    }

    private ProcessInstance generateNewProcessInstance(ProcessDefinition processDefinition, Command command, Map<String, String> cmdParam) {
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        processInstance.setProcessDefinitionCode(Long.valueOf(processDefinition.getCode()));
        processInstance.setProcessDefinitionVersion(processDefinition.getVersion());
        processInstance.setProjectCode(Long.valueOf(processDefinition.getProjectCode()));
        processInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, "init running");
        processInstance.setRecovery(Flag.NO);
        processInstance.setStartTime(new Date());
        processInstance.setRestartTime(null);
        processInstance.setRunTimes(1);
        processInstance.setMaxTryTimes(0);
        processInstance.setCommandParam(command.getCommandParam());
        processInstance.setCommandType(command.getCommandType());
        processInstance.setIsSubProcess(Flag.NO);
        processInstance.setTaskDependType(command.getTaskDependType());
        processInstance.setFailureStrategy(command.getFailureStrategy());
        processInstance.setExecutorId(command.getExecutorId());
        processInstance.setExecutorName((String)Optional.ofNullable(this.userMapper.selectById(command.getExecutorId())).map(User::getUserName).orElse(null));
        WarningType warningType = command.getWarningType() == null ? WarningType.NONE : command.getWarningType();
        processInstance.setWarningType(warningType);
        Integer warningGroupId = command.getWarningGroupId() == null ? 0 : command.getWarningGroupId();
        processInstance.setWarningGroupId(warningGroupId);
        processInstance.setDryRun(command.getDryRun());
        processInstance.setTestFlag(command.getTestFlag());
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setCommandStartTime(command.getStartTime());
        processInstance.setLocations(processDefinition.getLocations());
        this.setGlobalParamIfCommanded(processDefinition, cmdParam);
        Map commandParamMap = JSONUtils.toMap((String)command.getCommandParam());
        String timezoneId = null;
        if (commandParamMap != null) {
            timezoneId = (String)commandParamMap.get("schedule_timezone");
        }
        String globalParams = this.curingGlobalParamsService.curingGlobalParams(processInstance.getId(), processDefinition.getGlobalParamMap(), processDefinition.getGlobalParamList(), this.getCommandTypeIfComplement(processInstance, command), processInstance.getScheduleTime(), timezoneId);
        processInstance.setGlobalParams(globalParams);
        processInstance.setProcessInstancePriority(command.getProcessInstancePriority());
        String workerGroup = (String)StringUtils.defaultIfEmpty((CharSequence)command.getWorkerGroup(), (CharSequence)"default");
        processInstance.setWorkerGroup(workerGroup);
        processInstance.setEnvironmentCode(Long.valueOf(Objects.isNull(command.getEnvironmentCode()) ? -1L : command.getEnvironmentCode()));
        processInstance.setTimeout(processDefinition.getTimeout());
        processInstance.setTenantCode(command.getTenantCode());
        return processInstance;
    }

    private void setGlobalParamIfCommanded(ProcessDefinition processDefinition, Map<String, String> cmdParam) {
        Map startParamMap = new HashMap();
        if (cmdParam != null && cmdParam.containsKey("StartParams")) {
            String startParamJson = cmdParam.get("StartParams");
            startParamMap = JSONUtils.toMap((String)startParamJson);
        }
        Map fatherParamMap = new HashMap();
        if (cmdParam != null && cmdParam.containsKey("fatherParams")) {
            String fatherParamJson = cmdParam.get("fatherParams");
            fatherParamMap = JSONUtils.toMap((String)fatherParamJson);
        }
        startParamMap.putAll(fatherParamMap);
        Map globalMap = processDefinition.getGlobalParamMap();
        List globalParamList = processDefinition.getGlobalParamList();
        if (MapUtils.isNotEmpty(startParamMap) && globalMap != null) {
            for (Map.Entry entry : globalMap.entrySet()) {
                String val = (String)startParamMap.get(entry.getKey());
                if (val == null) continue;
                entry.setValue(val);
            }
            for (Map.Entry entry : startParamMap.entrySet()) {
                if (globalMap.containsKey(entry.getKey())) continue;
                globalMap.put(entry.getKey(), entry.getValue());
                globalParamList.add(new Property((String)entry.getKey(), Direct.IN, DataType.VARCHAR, (String)entry.getValue()));
            }
        }
    }

    @Override
    public String getTenantForProcess(String tenantCode, int userId) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tenantCode}) && !"default".equals(tenantCode)) {
            return tenantCode;
        }
        if (userId == 0) {
            return null;
        }
        User user = this.userMapper.selectById(userId);
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        return tenant.getTenantCode();
    }

    @Override
    public Environment findEnvironmentByCode(Long environmentCode) {
        Environment environment = null;
        if (environmentCode >= 0L) {
            environment = this.environmentMapper.queryByEnvironmentCode(environmentCode);
        }
        return environment;
    }

    private Boolean checkCmdParam(Command command, Map<String, String> cmdParam) {
        if (!(command.getTaskDependType() != TaskDependType.TASK_ONLY && command.getTaskDependType() != TaskDependType.TASK_PRE || cmdParam != null && cmdParam.containsKey("StartNodeList") && !cmdParam.get("StartNodeList").isEmpty())) {
            log.error("command node depend type is {}, but start nodes is null ", (Object)command.getTaskDependType());
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public ProcessInstance constructProcessInstance(Command command, String host) throws CronParseException, CodeGenerateUtils.CodeGenerateException {
        ProcessInstance processInstance;
        int processInstanceId;
        CommandType commandType = command.getCommandType();
        ProcessDefinition processDefinition = this.findProcessDefinition(command.getProcessDefinitionCode(), command.getProcessDefinitionVersion());
        if (processDefinition == null) {
            log.error("cannot find the work process define! define code : {}", (Object)command.getProcessDefinitionCode());
            throw new IllegalArgumentException("Cannot find the process definition for this workflowInstance");
        }
        HashMap<String, String> cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        if (cmdParam == null) {
            cmdParam = new HashMap<String, String>();
        }
        if ((processInstanceId = command.getProcessInstanceId()) == 0) {
            processInstance = this.generateNewProcessInstance(processDefinition, command, cmdParam);
        } else {
            processInstance = this.findProcessInstanceDetailById(processInstanceId).orElse(null);
            this.setGlobalParamIfCommanded(processDefinition, cmdParam);
            if (processInstance == null) {
                return null;
            }
        }
        CommandType commandTypeIfComplement = this.getCommandTypeIfComplement(processInstance, command);
        if (commandTypeIfComplement == CommandType.REPEAT_RUNNING || commandTypeIfComplement == CommandType.RECOVER_TOLERANCE_FAULT_PROCESS || commandTypeIfComplement == CommandType.RECOVER_SERIAL_WAIT) {
            this.setGlobalParamIfCommanded(processDefinition, cmdParam);
        }
        String timezoneId = (String)cmdParam.get("schedule_timezone");
        String globalParams = this.curingGlobalParamsService.curingGlobalParams(processInstance.getId(), processDefinition.getGlobalParamMap(), processDefinition.getGlobalParamList(), commandTypeIfComplement, processInstance.getScheduleTime(), timezoneId);
        processInstance.setGlobalParams(globalParams);
        processInstance.setProcessDefinition(processDefinition);
        if (processInstance.getCommandParam() != null) {
            Map processCmdParam = JSONUtils.toMap((String)processInstance.getCommandParam());
            HashMap<String, String> finalCmdParam = cmdParam;
            processCmdParam.forEach((key, value) -> {
                if (!finalCmdParam.containsKey(key)) {
                    finalCmdParam.put((String)key, (String)value);
                }
            });
        }
        if (cmdParam.containsKey("processInstanceId")) {
            processInstance.setCommandParam(command.getCommandParam());
        }
        if (Boolean.FALSE.equals(this.checkCmdParam(command, cmdParam))) {
            log.error("command parameter check failed!");
            return null;
        }
        if (command.getScheduleTime() != null) {
            processInstance.setScheduleTime(command.getScheduleTime());
        }
        processInstance.setHost(host);
        processInstance.setRestartTime(new Date());
        WorkflowExecutionStatus runStatus = WorkflowExecutionStatus.RUNNING_EXECUTION;
        int runTime = processInstance.getRunTimes();
        switch (commandType) {
            case START_PROCESS: 
            case DYNAMIC_GENERATION: {
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                List<Integer> failedList = this.findTaskIdByInstanceState(processInstance.getId(), TaskExecutionStatus.FAILURE);
                List<Integer> toleranceList = this.findTaskIdByInstanceState(processInstance.getId(), TaskExecutionStatus.NEED_FAULT_TOLERANCE);
                List<Integer> killedList = this.findTaskIdByInstanceState(processInstance.getId(), TaskExecutionStatus.KILL);
                cmdParam.remove("StartNodeIdList");
                failedList.addAll(killedList);
                failedList.addAll(toleranceList);
                for (Integer taskId : failedList) {
                    this.initTaskInstance((TaskInstance)this.taskInstanceDao.queryById((Serializable)taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(failedList)));
                processInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case START_CURRENT_TASK_PROCESS: {
                break;
            }
            case RECOVER_WAITING_THREAD: {
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                cmdParam.remove("StartNodeIdList");
                List<Integer> stopNodeList = this.findTaskIdByInstanceState(processInstance.getId(), TaskExecutionStatus.KILL);
                for (Integer taskId : stopNodeList) {
                    this.initTaskInstance((TaskInstance)this.taskInstanceDao.queryById((Serializable)taskId));
                }
                cmdParam.put("StartNodeIdList", String.join((CharSequence)",", this.convertIntListToString(stopNodeList)));
                processInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                processInstance.setRunTimes(runTime + 1);
                break;
            }
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                processInstance.setRecovery(Flag.YES);
                processInstance.setRunTimes(runTime + 1);
                runStatus = processInstance.getState();
                break;
            }
            case COMPLEMENT_DATA: {
                if (processInstance.getId() == null) break;
                List taskInstanceList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(processInstance.getId(), processInstance.getTestFlag());
                for (TaskInstance taskInstance : taskInstanceList) {
                    taskInstance.setFlag(Flag.NO);
                    this.taskInstanceDao.updateById((Object)taskInstance);
                }
                break;
            }
            case REPEAT_RUNNING: {
                if (cmdParam.containsKey("StartNodeIdList")) {
                    cmdParam.remove("StartNodeIdList");
                    processInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                }
                if (processInstance.getCommandType().equals((Object)CommandType.EXECUTE_TASK)) {
                    cmdParam.remove("StartNodeList");
                    processInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                    processInstance.setTaskDependType(command.getTaskDependType());
                }
                List validTaskList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(processInstance.getId(), processInstance.getTestFlag());
                for (TaskInstance taskInstance : validTaskList) {
                    taskInstance.setFlag(Flag.NO);
                    this.taskInstanceDao.updateById((Object)taskInstance);
                }
                processInstance.setStartTime(new Date());
                processInstance.setRestartTime(processInstance.getStartTime());
                processInstance.setEndTime(null);
                processInstance.setRunTimes(runTime + 1);
                this.initComplementDataParam(processDefinition, processInstance, cmdParam);
                break;
            }
            case SCHEDULER: {
                break;
            }
            case EXECUTE_TASK: {
                processInstance.setRunTimes(runTime + 1);
                processInstance.setTaskDependType(command.getTaskDependType());
                processInstance.setCommandParam(JSONUtils.toJsonString(cmdParam));
                break;
            }
        }
        processInstance.setStateWithDesc(runStatus, commandType.getDescp());
        return processInstance;
    }

    @Nullable
    private ProcessDefinition getProcessDefinitionByCommand(long processDefinitionCode, Map<String, String> cmdParam) {
        if (cmdParam != null) {
            int processInstanceId = 0;
            if (cmdParam.containsKey("ProcessInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("ProcessInstanceId"));
            } else if (cmdParam.containsKey("processInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("processInstanceId"));
            } else if (cmdParam.containsKey("WaitingThreadInstanceId")) {
                processInstanceId = Integer.parseInt(cmdParam.get("WaitingThreadInstanceId"));
            }
            if (processInstanceId != 0) {
                ProcessInstance processInstance = this.findProcessInstanceDetailById(processInstanceId).orElse(null);
                if (processInstance == null) {
                    return null;
                }
                return this.processDefineLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
            }
        }
        return this.processDefineMapper.queryByCode(processDefinitionCode);
    }

    private CommandType getCommandTypeIfComplement(ProcessInstance processInstance, Command command) {
        if (CommandType.COMPLEMENT_DATA == processInstance.getCmdTypeIfComplement()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return command.getCommandType();
    }

    private void initComplementDataParam(ProcessDefinition processDefinition, ProcessInstance processInstance, Map<String, String> cmdParam) throws CronParseException {
        if (!processInstance.isComplementData()) {
            return;
        }
        Date start = DateUtils.stringToDate((String)cmdParam.get("complementStartDate"));
        Date end = DateUtils.stringToDate((String)cmdParam.get("complementEndDate"));
        List<Object> complementDate = Lists.newLinkedList();
        if (start != null && end != null) {
            List<Schedule> listSchedules = this.queryReleaseSchedulerListByProcessDefinitionCode(processInstance.getProcessDefinitionCode());
            complementDate = CronUtils.getSelfFireDateList(start, end, listSchedules);
        }
        if (cmdParam.containsKey("complementScheduleDateList")) {
            complementDate = CronUtils.getSelfScheduleDateList(cmdParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)complementDate) && Flag.NO == processInstance.getIsSubProcess()) {
            processInstance.setScheduleTime((Date)complementDate.get(0));
        }
        String timezoneId = cmdParam.get("schedule_timezone");
        String globalParams = this.curingGlobalParamsService.curingGlobalParams(processInstance.getId(), processDefinition.getGlobalParamMap(), processDefinition.getGlobalParamList(), CommandType.COMPLEMENT_DATA, processInstance.getScheduleTime(), timezoneId);
        processInstance.setGlobalParams(globalParams);
    }

    @Override
    public void setSubProcessParam(ProcessInstance subProcessInstance) {
        ProcessInstanceMap processInstanceMap;
        String parentInstanceId;
        String cmdParam = subProcessInstance.getCommandParam();
        if (Strings.isNullOrEmpty((String)cmdParam)) {
            return;
        }
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap.containsKey("processInstanceId") && "0".equals(paramMap.get("processInstanceId"))) {
            paramMap.remove("processInstanceId");
            paramMap.put("processInstanceId", String.valueOf(subProcessInstance.getId()));
            subProcessInstance.setCommandParam(JSONUtils.toJsonString((Object)paramMap));
            subProcessInstance.setIsSubProcess(Flag.YES);
            this.processInstanceDao.upsertProcessInstance(subProcessInstance);
        }
        if (!Strings.isNullOrEmpty((String)(parentInstanceId = (String)paramMap.get("parentProcessInstanceId")))) {
            ProcessInstance parentInstance = this.findProcessInstanceDetailById(Integer.parseInt(parentInstanceId)).orElse(null);
            if (parentInstance != null) {
                subProcessInstance.setGlobalParams(this.joinGlobalParams(parentInstance.getGlobalParams(), subProcessInstance.getGlobalParams()));
                subProcessInstance.setVarPool(this.joinVarPool(parentInstance.getVarPool(), subProcessInstance.getVarPool()));
                this.processInstanceDao.upsertProcessInstance(subProcessInstance);
            } else {
                log.error("sub process command params error, cannot find parent instance: {} ", (Object)cmdParam);
            }
        }
        if ((processInstanceMap = (ProcessInstanceMap)JSONUtils.parseObject((String)cmdParam, ProcessInstanceMap.class)) == null || processInstanceMap.getParentProcessInstanceId() == 0) {
            return;
        }
        processInstanceMap.setProcessInstanceId(subProcessInstance.getId().intValue());
        this.processInstanceMapDao.updateById((Object)processInstanceMap);
    }

    private String joinGlobalParams(String parentGlobalParams, String subGlobalParams) {
        ArrayList parentParams = Lists.newArrayList((Iterable)JSONUtils.toList((String)parentGlobalParams, Property.class));
        List subParams = JSONUtils.toList((String)subGlobalParams, Property.class);
        Set parentParamKeys = parentParams.stream().map(Property::getProp).collect(Collectors.toSet());
        List extraSubParams = subParams.stream().filter(subProp -> !parentParamKeys.contains(subProp.getProp())).collect(Collectors.toList());
        parentParams.addAll(extraSubParams);
        return JSONUtils.toJsonString((Object)parentParams);
    }

    private String joinVarPool(String parentValPool, String subValPool) {
        List<Object> parentValPools = Lists.newArrayList((Iterable)JSONUtils.toList((String)parentValPool, Property.class));
        parentValPools = parentValPools.stream().filter(valPool -> valPool.getDirect() == Direct.OUT).collect(Collectors.toList());
        ArrayList subValPools = Lists.newArrayList((Iterable)JSONUtils.toList((String)subValPool, Property.class));
        Set parentValPoolKeys = parentValPools.stream().map(Property::getProp).collect(Collectors.toSet());
        List extraSubValPools = subValPools.stream().filter(sub -> !parentValPoolKeys.contains(sub.getProp())).collect(Collectors.toList());
        parentValPools.addAll(extraSubValPools);
        return JSONUtils.toJsonString(parentValPools);
    }

    private void initTaskInstance(TaskInstance taskInstance) {
        if (!taskInstance.isSubProcess() && (taskInstance.getState().isKill() || taskInstance.getState().isFailure())) {
            taskInstance.setFlag(Flag.NO);
            this.taskInstanceDao.updateById((Object)taskInstance);
            return;
        }
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitTaskWithRetry(ProcessInstance processInstance, TaskInstance taskInstance, int commitRetryTimes, long commitInterval) {
        int retryTimes = 1;
        while (retryTimes <= commitRetryTimes) {
            try {
                if (this.submitTask(processInstance, taskInstance)) {
                    boolean bl = true;
                    return bl;
                }
                log.error("task commit to db failed , taskCode: {} has already retry {} times, please check the database", (Object)taskInstance.getTaskCode(), (Object)retryTimes);
                Thread.sleep(commitInterval);
            }
            catch (Exception e) {
                log.error("task commit to db failed", (Throwable)e);
            }
            finally {
                ++retryTimes;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public boolean submitTask(ProcessInstance processInstance, TaskInstance taskInstance) {
        log.info("Start save taskInstance to database : {}, processInstance id:{}, state: {}", new Object[]{taskInstance.getName(), taskInstance.getProcessInstanceId(), processInstance.getState()});
        if (!this.taskInstanceDao.submitTaskInstanceToDB(taskInstance, processInstance)) {
            log.error("Save taskInstance to db error, task name:{}, process id:{} state: {} ", new Object[]{taskInstance.getName(), taskInstance.getProcessInstance().getId(), processInstance.getState()});
            return false;
        }
        if (!taskInstance.getState().isFinished()) {
            this.createSubWorkProcess(processInstance, taskInstance);
        }
        log.info("End save taskInstance to db successfully:{}, taskInstanceName: {}, taskInstance state:{}, processInstanceId:{}, processInstanceState: {}", new Object[]{taskInstance.getId(), taskInstance.getName(), taskInstance.getState(), processInstance.getId(), processInstance.getState()});
        return true;
    }

    private ProcessInstanceMap setProcessInstanceMap(ProcessInstance parentInstance, TaskInstance parentTask, ProcessInstanceMap processMap) {
        if (processMap != null) {
            return processMap;
        }
        if (parentInstance.getCommandType() == CommandType.REPEAT_RUNNING && (processMap = this.findPreviousTaskProcessMap(parentInstance, parentTask)) != null) {
            processMap.setParentTaskInstanceId(parentTask.getId().intValue());
            this.processInstanceMapDao.updateById((Object)processMap);
            return processMap;
        }
        processMap = new ProcessInstanceMap();
        processMap.setParentProcessInstanceId(parentInstance.getId().intValue());
        processMap.setParentTaskInstanceId(parentTask.getId().intValue());
        this.processInstanceMapDao.insert((Object)processMap);
        return processMap;
    }

    private ProcessInstanceMap findPreviousTaskProcessMap(ProcessInstance parentProcessInstance, TaskInstance parentTask) {
        Integer preTaskId = 0;
        List preTaskList = this.taskInstanceDao.queryPreviousTaskListByWorkflowInstanceId(parentProcessInstance.getId());
        for (TaskInstance task : preTaskList) {
            if (!task.getName().equals(parentTask.getName())) continue;
            preTaskId = task.getId();
            ProcessInstanceMap map = this.processInstanceMapDao.queryWorkProcessMapByParent(parentProcessInstance.getId(), preTaskId);
            if (map == null) continue;
            return map;
        }
        log.info("sub process instance is not found,parent task:{},parent instance:{}", (Object)parentTask.getId(), (Object)parentProcessInstance.getId());
        return null;
    }

    @Override
    public void createSubWorkProcess(ProcessInstance parentProcessInstance, TaskInstance task) {
        if (!task.isSubProcess()) {
            return;
        }
        ProcessInstanceMap instanceMap = this.processInstanceMapDao.queryWorkProcessMapByParent(parentProcessInstance.getId(), task.getId());
        if (null != instanceMap && CommandType.RECOVER_TOLERANCE_FAULT_PROCESS == parentProcessInstance.getCommandType()) {
            return;
        }
        instanceMap = this.setProcessInstanceMap(parentProcessInstance, task, instanceMap);
        ProcessInstance childInstance = null;
        if (instanceMap.getProcessInstanceId() != 0) {
            childInstance = this.findProcessInstanceById(instanceMap.getProcessInstanceId());
        }
        if (childInstance != null && childInstance.getState() == WorkflowExecutionStatus.SUCCESS && CommandType.START_FAILURE_TASK_PROCESS == parentProcessInstance.getCommandType()) {
            log.info("sub process instance {} status is success, so skip creating command", (Object)childInstance.getId());
            return;
        }
        Command subProcessCommand = this.commandService.createSubProcessCommand(parentProcessInstance, childInstance, instanceMap, task);
        if (subProcessCommand == null) {
            log.error("create sub process command failed, so skip creating command");
            return;
        }
        this.updateSubProcessDefinitionByParent(parentProcessInstance, subProcessCommand.getProcessDefinitionCode());
        this.initSubInstanceState(childInstance);
        this.commandService.createCommand(subProcessCommand);
        log.info("sub process command created: {} ", (Object)subProcessCommand);
    }

    private void initSubInstanceState(ProcessInstance childInstance) {
        if (childInstance != null) {
            childInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, "init sub workflow instance");
            this.processInstanceDao.updateById((Object)childInstance);
        }
    }

    private CommandType getSubCommandType(ProcessInstance parentProcessInstance, ProcessInstance childInstance) {
        CommandType commandType = parentProcessInstance.getCommandType();
        if (childInstance == null) {
            String fatherHistoryCommand = parentProcessInstance.getHistoryCmd();
            commandType = CommandType.valueOf((String)fatherHistoryCommand.split(",")[0]);
        }
        return commandType;
    }

    private void updateSubProcessDefinitionByParent(ProcessInstance parentProcessInstance, long childDefinitionCode) {
        ProcessDefinition fatherDefinition = this.findProcessDefinition(parentProcessInstance.getProcessDefinitionCode(), parentProcessInstance.getProcessDefinitionVersion());
        ProcessDefinition childDefinition = this.findProcessDefinitionByCode(childDefinitionCode);
        if (childDefinition != null && fatherDefinition != null) {
            childDefinition.setWarningGroupId(fatherDefinition.getWarningGroupId());
            this.processDefineMapper.updateById(childDefinition);
        }
    }

    @Override
    public void packageTaskInstance(TaskInstance taskInstance, ProcessInstance processInstance) {
        taskInstance.setProcessInstance(processInstance);
        taskInstance.setProcessDefine(processInstance.getProcessDefinition());
        taskInstance.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        TaskDefinition taskDefinition = this.taskDefinitionDao.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
        this.updateTaskDefinitionResources(taskDefinition);
        taskInstance.setTaskDefine(taskDefinition);
        taskInstance.setTestFlag(processInstance.getTestFlag());
    }

    @Override
    public void updateTaskDefinitionResources(TaskDefinition taskDefinition) {
        Map taskParameters = (Map)JSONUtils.parseObject((String)taskDefinition.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (taskParameters != null) {
            if (taskParameters.containsKey("mainJar")) {
                Object mainJarObj = taskParameters.get("mainJar");
                ResourceInfo mainJar = (ResourceInfo)JSONUtils.parseObject((String)JSONUtils.toJsonString(mainJarObj), ResourceInfo.class);
                ResourceInfo resourceInfo2 = this.updateResourceInfo(this.taskDefinitionMapper.queryByCode(taskDefinition.getCode()).getId(), mainJar);
                if (resourceInfo2 != null) {
                    taskParameters.put("mainJar", resourceInfo2);
                }
            }
            if (taskParameters.containsKey("resourceList")) {
                String resourceListStr = JSONUtils.toJsonString(taskParameters.get("resourceList"));
                List resourceInfos = JSONUtils.toList((String)resourceListStr, ResourceInfo.class);
                List updatedResourceInfos = resourceInfos.stream().map(resourceInfo -> this.updateResourceInfo(this.taskDefinitionMapper.queryByCode(taskDefinition.getCode()).getId(), (ResourceInfo)resourceInfo)).filter(Objects::nonNull).collect(Collectors.toList());
                taskParameters.put("resourceList", updatedResourceInfos);
            }
            taskDefinition.setTaskParams(JSONUtils.toJsonString((Object)taskParameters));
        }
    }

    protected ResourceInfo updateResourceInfo(int task_id, ResourceInfo res) {
        ResourceInfo resourceInfo = null;
        if (res != null) {
            String resourceFullName = res.getResourceName();
            if (StringUtils.isBlank((CharSequence)resourceFullName)) {
                log.error("invalid resource full name, {}", (Object)resourceFullName);
                return new ResourceInfo();
            }
            resourceInfo = new ResourceInfo();
            resourceInfo.setId(Integer.valueOf(-1));
            resourceInfo.setResourceName(resourceFullName);
            log.info("updated resource info {}", (Object)JSONUtils.toJsonString((Object)resourceInfo));
        }
        return resourceInfo;
    }

    @Override
    public List<Integer> findTaskIdByInstanceState(int instanceId, TaskExecutionStatus state) {
        return this.taskInstanceMapper.queryTaskByProcessIdAndState(Integer.valueOf(instanceId), Integer.valueOf(state.getCode()));
    }

    @Override
    public int deleteWorkProcessMapByParentId(int parentWorkProcessId) {
        return this.processInstanceMapMapper.deleteByParentProcessId(parentWorkProcessId);
    }

    @Override
    public ProcessInstance findSubProcessInstance(Integer parentProcessId, Integer parentTaskId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryByParentId(parentProcessId.intValue(), parentTaskId.intValue());
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getProcessInstanceId());
        return processInstance;
    }

    @Override
    public ProcessInstance findParentProcessInstance(Integer subProcessId) {
        ProcessInstance processInstance = null;
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(subProcessId);
        if (processInstanceMap == null || processInstanceMap.getProcessInstanceId() == 0) {
            return processInstance;
        }
        processInstance = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        return processInstance;
    }

    @Override
    public void changeOutParam(TaskInstance taskInstance) {
        if (Strings.isNullOrEmpty((String)taskInstance.getVarPool())) {
            return;
        }
        List properties = JSONUtils.toList((String)taskInstance.getVarPool(), Property.class);
        if (CollectionUtils.isEmpty((Collection)properties)) {
            return;
        }
        Map taskParams = (Map)JSONUtils.parseObject((String)taskInstance.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object localParams = taskParams.get("localParams");
        if (localParams == null) {
            return;
        }
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        HashMap<String, String> outProperty = new HashMap<String, String>();
        for (Property info : properties) {
            if (info.getDirect() != Direct.OUT) continue;
            outProperty.put(info.getProp(), info.getValue());
        }
        for (Property info : allParam) {
            if (info.getDirect() != Direct.OUT) continue;
            String paramName = info.getProp();
            info.setValue((String)outProperty.get(paramName));
        }
        taskParams.put("localParams", allParam);
        taskInstance.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
    }

    private List<String> convertIntListToString(List<Integer> intList) {
        if (intList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(intList.size());
        for (Integer intVar : intList) {
            result.add(String.valueOf(intVar));
        }
        return result;
    }

    @Override
    public Schedule querySchedule(int id) {
        return (Schedule)this.scheduleMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public List<Schedule> queryReleaseSchedulerListByProcessDefinitionCode(long processDefinitionCode) {
        return this.scheduleMapper.queryReleaseSchedulerListByProcessDefinitionCode(processDefinitionCode);
    }

    @Override
    public List<DependentProcessDefinition> queryDependentProcessDefinitionByProcessDefinitionCode(long processDefinitionCode) {
        return this.workFlowLineageMapper.queryDependentProcessDefinitionByProcessDefinitionCode(processDefinitionCode);
    }

    @Override
    public List<ProcessInstance> queryNeedFailoverProcessInstances(String host) {
        return this.processInstanceMapper.queryByHostAndStatus(host, WorkflowExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    public List<String> queryNeedFailoverProcessInstanceHost() {
        return this.processInstanceMapper.queryNeedFailoverProcessInstanceHost(WorkflowExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    @Transactional
    public void processNeedFailoverProcessInstances(ProcessInstance processInstance) {
        processInstance.setHost("NULL");
        this.processInstanceMapper.updateById((Object)processInstance);
        Command cmd = new Command();
        cmd.setProcessDefinitionCode(processInstance.getProcessDefinitionCode().longValue());
        cmd.setProcessDefinitionVersion(processInstance.getProcessDefinitionVersion());
        cmd.setProcessInstanceId(processInstance.getId().intValue());
        cmd.setCommandParam(JSONUtils.toJsonString(this.createCommandParams(processInstance)));
        cmd.setExecutorId(processInstance.getExecutorId());
        cmd.setCommandType(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS);
        cmd.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        cmd.setTestFlag(processInstance.getTestFlag());
        this.commandService.createCommand(cmd);
    }

    @Override
    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public ProcessInstance findProcessInstanceByTaskId(int taskId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskId));
        if (taskInstance != null) {
            return (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Integer.valueOf(taskInstance.getProcessInstanceId()));
        }
        return null;
    }

    @Override
    public List<UdfFunc> queryUdfFunListByIds(Integer[] ids) {
        return this.udfFuncMapper.queryUdfByIdStr(ids, null);
    }

    @Override
    public String queryTenantCodeByResName(String resName, ResourceType resourceType) {
        String fullName = resName.startsWith("/") ? resName : String.format("/%s", resName);
        List resourceList = this.resourceMapper.queryResource(fullName, resourceType.ordinal());
        if (CollectionUtils.isEmpty((Collection)resourceList)) {
            return "";
        }
        int userId = ((Resource)resourceList.get(0)).getUserId();
        User user = this.userMapper.selectById(userId);
        if (Objects.isNull(user)) {
            return "";
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (Objects.isNull(tenant)) {
            return "";
        }
        return tenant.getTenantCode();
    }

    @Override
    public List<Schedule> selectAllByProcessDefineCode(long[] codes) {
        return this.scheduleMapper.selectAllByProcessDefineArray(codes);
    }

    @Override
    public String queryUserQueueByProcessInstance(ProcessInstance processInstance) {
        String queue = "";
        if (processInstance == null) {
            return queue;
        }
        User executor = this.userMapper.selectById(processInstance.getExecutorId());
        if (executor != null) {
            queue = executor.getQueue();
        }
        return queue;
    }

    @Override
    public ProjectUser queryProjectWithUserByProcessInstanceId(int processInstanceId) {
        return this.projectMapper.queryProjectWithUserByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Project> getProjectListHavePerm(int userId) {
        ArrayList<Project> createProjects = this.projectMapper.queryProjectCreatedByUser(userId);
        List authedProjects = this.projectMapper.queryAuthedProjectListByUserId(userId);
        if (createProjects == null) {
            createProjects = new ArrayList<Project>();
        }
        if (authedProjects != null) {
            createProjects.addAll(authedProjects);
        }
        return createProjects;
    }

    @Override
    public <T> List<T> listUnauthorized(int userId, T[] needChecks, AuthorizationType authorizationType) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (Objects.nonNull(needChecks) && needChecks.length > 0) {
            HashSet<T> originResSet = new HashSet<T>(Arrays.asList(needChecks));
            switch (authorizationType) {
                case RESOURCE_FILE_ID: 
                case UDF_FILE: {
                    List ownUdfResources = this.resourceMapper.listAuthorizedResourceById(userId, (Object[])needChecks);
                    this.addAuthorizedResources(ownUdfResources, userId);
                    Set authorizedResourceFiles = ownUdfResources.stream().map(Resource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResourceFiles);
                    break;
                }
                case RESOURCE_FILE_NAME: {
                    List ownResources = this.resourceMapper.listAuthorizedResource(userId, (Object[])needChecks);
                    this.addAuthorizedResources(ownResources, userId);
                    Set authorizedResources = ownResources.stream().map(Resource::getFullName).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedResources);
                    break;
                }
                case DATASOURCE: {
                    Set authorizedDatasources = this.dataSourceMapper.listAuthorizedDataSource(userId, (Object[])needChecks).stream().map(DataSource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedDatasources);
                    break;
                }
                case UDF: {
                    Set authorizedUdfs = this.udfFuncMapper.listAuthorizedUdfFunc(userId, (Object[])needChecks).stream().map(UdfFunc::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedUdfs);
                    break;
                }
            }
            resultList.addAll(originResSet);
        }
        return resultList;
    }

    @Override
    public User getUserById(int userId) {
        return this.userMapper.selectById(userId);
    }

    @Override
    public Resource getResourceById(int resourceId) {
        return (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
    }

    @Override
    public List<Resource> listResourceByIds(Integer[] resIds) {
        return this.resourceMapper.listResourceByIds(resIds);
    }

    @Override
    public String formatTaskAppId(TaskInstance taskInstance) {
        ProcessInstance processInstance = this.findProcessInstanceById(taskInstance.getProcessInstanceId());
        if (processInstance == null) {
            return "";
        }
        ProcessDefinition definition = this.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (definition == null) {
            return "";
        }
        return String.format("%s_%s_%s", definition.getId(), processInstance.getId(), taskInstance.getId());
    }

    @Override
    public int switchVersion(ProcessDefinition processDefinition, ProcessDefinitionLog processDefinitionLog) {
        if (null == processDefinition || null == processDefinitionLog) {
            return -1;
        }
        processDefinitionLog.setId(processDefinition.getId());
        processDefinitionLog.setReleaseState(ReleaseState.OFFLINE);
        processDefinitionLog.setFlag(Flag.YES);
        int result = this.processDefineMapper.updateById((ProcessDefinition)processDefinitionLog);
        if (result > 0 && (result = this.switchProcessTaskRelationVersion((ProcessDefinition)processDefinitionLog)) <= 0) {
            return -1;
        }
        return result;
    }

    @Override
    public int switchProcessTaskRelationVersion(ProcessDefinition processDefinition) {
        List processTaskRelationListFromLog;
        int batchInsert;
        List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode());
        if (!processTaskRelationList.isEmpty()) {
            this.processTaskRelationMapper.deleteByCode(processDefinition.getProjectCode(), processDefinition.getCode());
        }
        if ((batchInsert = this.processTaskRelationMapper.batchInsert(processTaskRelationListFromLog = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinition.getCode(), processDefinition.getVersion()).stream().map(ProcessTaskRelation::new).collect(Collectors.toList()))) == 0) {
            return -1;
        }
        int result = 0;
        for (ProcessTaskRelation taskRelation : processTaskRelationListFromLog) {
            int switchResult = this.switchTaskDefinitionVersion(taskRelation.getPostTaskCode(), taskRelation.getPostTaskVersion());
            if (switchResult == -1) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int switchTaskDefinitionVersion(long taskCode, int taskVersion) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            return -1;
        }
        if (taskDefinition.getVersion() == taskVersion) {
            return 0;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskVersion);
        if (taskDefinitionUpdate == null) {
            return -1;
        }
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        return this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
    }

    @Override
    public String getResourceIds(TaskDefinition taskDefinition) {
        Set resourceIds = null;
        AbstractParameters params = this.taskPluginManager.getParameters(ParametersNode.builder().taskType(taskDefinition.getTaskType()).taskParams(taskDefinition.getTaskParams()).build());
        if (params != null && CollectionUtils.isNotEmpty((Collection)params.getResourceFilesList())) {
            resourceIds = params.getResourceFilesList().stream().map(ResourceInfo::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(resourceIds)) {
            return "";
        }
        return Joiner.on((String)",").join(resourceIds);
    }

    @Override
    public int saveTaskDefine(User operator, long projectCode, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        Date now = new Date();
        ArrayList<TaskDefinitionLog> newTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        ArrayList<TaskDefinitionLog> updateTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinitionLog taskDefinitionLog2 : taskDefinitionLogs) {
            TaskDefinitionLog definitionCodeAndVersion;
            taskDefinitionLog2.setProjectCode(projectCode);
            taskDefinitionLog2.setUpdateTime(now);
            taskDefinitionLog2.setOperateTime(now);
            taskDefinitionLog2.setOperator(operator.getId().intValue());
            if (taskDefinitionLog2.getCode() == 0L) {
                taskDefinitionLog2.setCode(CodeGenerateUtils.getInstance().genCode());
            }
            if (taskDefinitionLog2.getVersion() == 0) {
                taskDefinitionLog2.setVersion(1);
            }
            if ((definitionCodeAndVersion = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskDefinitionLog2.getCode(), taskDefinitionLog2.getVersion())) == null) {
                taskDefinitionLog2.setUserId(operator.getId().intValue());
                taskDefinitionLog2.setCreateTime(now);
                newTaskDefinitionLogs.add(taskDefinitionLog2);
                continue;
            }
            if (taskDefinitionLog2.equals((Object)definitionCodeAndVersion)) continue;
            taskDefinitionLog2.setUserId(definitionCodeAndVersion.getUserId());
            Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionLog2.getCode());
            taskDefinitionLog2.setVersion(version + 1);
            taskDefinitionLog2.setCreateTime(definitionCodeAndVersion.getCreateTime());
            updateTaskDefinitionLogs.add(taskDefinitionLog2);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs)) {
            List taskDefinitionCodes = updateTaskDefinitionLogs.stream().map(TaskDefinition::getCode).distinct().collect(Collectors.toList());
            Map taskDefinitionMap = this.taskDefinitionMapper.queryByCodeList(taskDefinitionCodes).stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
            for (TaskDefinitionLog taskDefinitionToUpdate : updateTaskDefinitionLogs) {
                TaskDefinition task = (TaskDefinition)taskDefinitionMap.get(taskDefinitionToUpdate.getCode());
                if (task == null) {
                    newTaskDefinitionLogs.add(taskDefinitionToUpdate);
                    continue;
                }
                taskDefinitionToUpdate.setId(task.getId());
            }
        }
        int updateResult = 0;
        int insertResult = 0;
        List newInsertTaskDefinitionLogs = newTaskDefinitionLogs.stream().filter(taskDefinitionLog -> !updateTaskDefinitionLogs.contains(taskDefinitionLog)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newInsertTaskDefinitionLogs)) {
            insertResult = this.taskDefinitionLogMapper.batchInsert(newInsertTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs)) {
            insertResult += this.taskDefinitionLogMapper.batchInsert(updateTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(newTaskDefinitionLogs) && Boolean.TRUE.equals(syncDefine)) {
            updateResult += this.taskDefinitionMapper.batchInsert(newTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs) && Boolean.TRUE.equals(syncDefine)) {
            for (TaskDefinitionLog taskDefinitionLog3 : updateTaskDefinitionLogs) {
                updateResult += this.taskDefinitionMapper.updateById((Object)taskDefinitionLog3);
            }
        }
        return (insertResult & updateResult) > 0 ? 1 : 0;
    }

    @Override
    public int saveProcessDefine(User operator, ProcessDefinition processDefinition, Boolean syncDefine, Boolean isFromProcessDefine) {
        ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition);
        Integer version = this.processDefineLogMapper.queryMaxVersionForDefinition(processDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        processDefinitionLog.setVersion(insertVersion);
        processDefinitionLog.setReleaseState(isFromProcessDefine == false || processDefinitionLog.getReleaseState() == ReleaseState.ONLINE ? ReleaseState.ONLINE : ReleaseState.OFFLINE);
        processDefinitionLog.setOperator(operator.getId().intValue());
        processDefinitionLog.setOperateTime(processDefinition.getUpdateTime());
        processDefinitionLog.setId(null);
        int insertLog = this.processDefineLogMapper.insert((Object)processDefinitionLog);
        int result = 1;
        if (Boolean.TRUE.equals(syncDefine)) {
            if (processDefinition.getId() == null) {
                result = this.processDefineMapper.insert((Object)processDefinitionLog);
            } else {
                processDefinitionLog.setId(processDefinition.getId());
                result = this.processDefineMapper.updateById((ProcessDefinition)processDefinitionLog);
            }
        }
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    @Override
    public int saveTaskRelation(User operator, long projectCode, long processDefinitionCode, int processDefinitionVersion, List<ProcessTaskRelationLog> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        int resultLog;
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (ProcessTaskRelationLog processTaskRelationLog : taskRelationList) {
            processTaskRelationLog.setProjectCode(projectCode);
            processTaskRelationLog.setProcessDefinitionCode(processDefinitionCode);
            processTaskRelationLog.setProcessDefinitionVersion(processDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(processTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    processTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(processTaskRelationLog.getPostTaskCode())) != null) {
                    processTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            processTaskRelationLog.setCreateTime(now);
            processTaskRelationLog.setUpdateTime(now);
            processTaskRelationLog.setOperator(operator.getId().intValue());
            processTaskRelationLog.setOperateTime(now);
        }
        int insert = taskRelationList.size();
        if (Boolean.TRUE.equals(syncDefine)) {
            List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
            if (!processTaskRelationList.isEmpty()) {
                Set taskRelationSet;
                Set processTaskRelationSet = processTaskRelationList.stream().map(ProcessTaskRelation::hashCode).collect(Collectors.toSet());
                boolean result = CollectionUtils.isEqualCollection(processTaskRelationSet, taskRelationSet = taskRelationList.stream().map(ProcessTaskRelationLog::hashCode).collect(Collectors.toSet()));
                if (result) {
                    return 0;
                }
                this.processTaskRelationMapper.deleteByCode(projectCode, processDefinitionCode);
            }
            List processTaskRelations = taskRelationList.stream().map(ProcessTaskRelation::new).collect(Collectors.toList());
            insert = this.processTaskRelationMapper.batchInsert(processTaskRelations);
        }
        return (insert & (resultLog = this.processTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    @Override
    public boolean isTaskOnline(long taskCode) {
        List processTaskRelationList = this.processTaskRelationMapper.queryByTaskCode(taskCode);
        if (!processTaskRelationList.isEmpty()) {
            Set processDefinitionCodes = processTaskRelationList.stream().map(ProcessTaskRelation::getProcessDefinitionCode).collect(Collectors.toSet());
            List processDefinitionList = this.processDefineMapper.queryByCodes(processDefinitionCodes);
            for (ProcessDefinition processDefinition : processDefinitionList) {
                if (processDefinition.getReleaseState() != ReleaseState.ONLINE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DAG<Long, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition processDefinition) {
        List<ProcessTaskRelation> taskRelations = this.findRelationByCode(processDefinition.getCode(), processDefinition.getVersion());
        List<TaskNode> taskNodeList = this.transformTask(taskRelations, Lists.newArrayList());
        ProcessDag processDag = DagHelper.getProcessDag(taskNodeList, new ArrayList<ProcessTaskRelation>(taskRelations));
        return DagHelper.buildDagGraph(processDag);
    }

    @Override
    public DagData genDagData(ProcessDefinition processDefinition) {
        List<ProcessTaskRelation> taskRelations = this.findRelationByCode(processDefinition.getCode(), processDefinition.getVersion());
        List taskDefinitions = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelations).stream().map(t -> t).collect(Collectors.toList());
        return new DagData(processDefinition, taskRelations, taskDefinitions);
    }

    @Override
    public List<ProcessTaskRelation> findRelationByCode(long processDefinitionCode, int processDefinitionVersion) {
        List processTaskRelationLogList = this.processTaskRelationLogMapper.queryByProcessCodeAndVersion(processDefinitionCode, processDefinitionVersion);
        return processTaskRelationLogList.stream().map(r -> r).collect(Collectors.toList());
    }

    private void addAuthorizedResources(List<Resource> ownResources, int userId) {
        List relationResourceIds = this.resourceUserMapper.queryResourcesIdListByUserIdAndPerm(userId, 7);
        List relationResources = CollectionUtils.isNotEmpty((Collection)relationResourceIds) ? this.resourceMapper.queryResourceListById(relationResourceIds) : new ArrayList();
        ownResources.addAll(relationResources);
    }

    @Override
    public List<TaskNode> transformTask(List<ProcessTaskRelation> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<Long, List> taskCodeMap = new HashMap<Long, List>();
        for (ProcessTaskRelation processTaskRelation : taskRelationList) {
            taskCodeMap.compute(processTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Long>();
                }
                if (processTaskRelation.getPreTaskCode() != 0L) {
                    v.add(processTaskRelation.getPreTaskCode());
                }
                return v;
            });
        }
        if (CollectionUtils.isEmpty(taskDefinitionLogs)) {
            taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelationList);
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        ArrayList<TaskNode> taskNodeList = new ArrayList<TaskNode>();
        for (Map.Entry code : taskCodeMap.entrySet()) {
            TaskDefinitionLog taskDefinitionLog2 = taskDefinitionLogMap.get(code.getKey());
            if (taskDefinitionLog2 == null) continue;
            TaskNode taskNode = new TaskNode();
            taskNode.setCode(taskDefinitionLog2.getCode());
            taskNode.setVersion(taskDefinitionLog2.getVersion());
            taskNode.setName(taskDefinitionLog2.getName());
            taskNode.setDesc(taskDefinitionLog2.getDescription());
            taskNode.setType(taskDefinitionLog2.getTaskType().toUpperCase());
            taskNode.setRunFlag(taskDefinitionLog2.getFlag() == Flag.YES ? "NORMAL" : "FORBIDDEN");
            taskNode.setMaxRetryTimes(taskDefinitionLog2.getFailRetryTimes());
            taskNode.setRetryInterval(taskDefinitionLog2.getFailRetryInterval());
            Map<String, Object> taskParamsMap = taskNode.taskParamsToJsonObj(taskDefinitionLog2.getTaskParams());
            taskNode.setConditionResult(JSONUtils.toJsonString((Object)taskParamsMap.get("conditionResult")));
            taskNode.setSwitchResult(JSONUtils.toJsonString((Object)taskParamsMap.get("switchResult")));
            taskNode.setDependence(JSONUtils.toJsonString((Object)taskParamsMap.get("dependence")));
            taskParamsMap.remove("conditionResult");
            taskParamsMap.remove("dependence");
            taskNode.setParams(JSONUtils.toJsonString(taskParamsMap));
            taskNode.setTaskInstancePriority(taskDefinitionLog2.getTaskPriority());
            taskNode.setWorkerGroup(taskDefinitionLog2.getWorkerGroup());
            taskNode.setEnvironmentCode(taskDefinitionLog2.getEnvironmentCode());
            taskNode.setTimeout(JSONUtils.toJsonString((Object)new TaskTimeoutParameter(taskDefinitionLog2.getTimeoutFlag() == TimeoutFlag.OPEN, taskDefinitionLog2.getTimeoutNotifyStrategy(), taskDefinitionLog2.getTimeout())));
            taskNode.setDelayTime(taskDefinitionLog2.getDelayTime());
            taskNode.setPreTasks(JSONUtils.toJsonString(((List)code.getValue()).stream().map(taskDefinitionLogMap::get).map(TaskDefinition::getCode).collect(Collectors.toList())));
            taskNode.setTaskGroupId(taskDefinitionLog2.getTaskGroupId());
            taskNode.setTaskGroupPriority(taskDefinitionLog2.getTaskGroupPriority());
            taskNode.setCpuQuota(taskDefinitionLog2.getCpuQuota());
            taskNode.setMemoryMax(taskDefinitionLog2.getMemoryMax());
            taskNode.setTaskExecuteType(taskDefinitionLog2.getTaskExecuteType());
            taskNode.setIsCache(taskDefinitionLog2.getIsCache().getCode());
            taskNodeList.add(taskNode);
        }
        return taskNodeList;
    }

    @Override
    public Map<ProcessInstance, TaskInstance> notifyProcessList(int processId) {
        HashMap<ProcessInstance, TaskInstance> processTaskMap = new HashMap<ProcessInstance, TaskInstance>();
        ProcessInstanceMap processInstanceMap = this.processInstanceMapMapper.queryBySubProcessId(Integer.valueOf(processId));
        if (processInstanceMap == null) {
            return processTaskMap;
        }
        ProcessInstance fatherProcess = this.findProcessInstanceById(processInstanceMap.getParentProcessInstanceId());
        TaskInstance fatherTask = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(processInstanceMap.getParentTaskInstanceId()));
        if (fatherProcess != null) {
            processTaskMap.put(fatherProcess, fatherTask);
        }
        return processTaskMap;
    }

    @Override
    public DqExecuteResult getDqExecuteResultByTaskInstanceId(int taskInstanceId) {
        return this.dqExecuteResultMapper.getExecuteResultById(taskInstanceId);
    }

    @Override
    public int updateDqExecuteResultUserId(int taskInstanceId) {
        DqExecuteResult dqExecuteResult = (DqExecuteResult)this.dqExecuteResultMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"task_instance_id", (Object)taskInstanceId));
        if (dqExecuteResult == null) {
            return -1;
        }
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)Long.valueOf(dqExecuteResult.getProcessInstanceId()));
        if (processInstance == null) {
            return -1;
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition == null) {
            return -1;
        }
        dqExecuteResult.setProcessDefinitionId((long)processDefinition.getId().intValue());
        dqExecuteResult.setUserId(processDefinition.getUserId());
        dqExecuteResult.setState(DqTaskState.DEFAULT.getCode());
        return this.dqExecuteResultMapper.updateById((Object)dqExecuteResult);
    }

    @Override
    public int updateDqExecuteResultState(DqExecuteResult dqExecuteResult) {
        return this.dqExecuteResultMapper.updateById((Object)dqExecuteResult);
    }

    @Override
    public int deleteDqExecuteResultByTaskInstanceId(int taskInstanceId) {
        return this.dqExecuteResultMapper.delete((Wrapper)new QueryWrapper().eq((Object)"task_instance_id", (Object)taskInstanceId));
    }

    @Override
    public int deleteTaskStatisticsValueByTaskInstanceId(int taskInstanceId) {
        return this.dqTaskStatisticsValueMapper.delete((Wrapper)new QueryWrapper().eq((Object)"task_instance_id", (Object)taskInstanceId));
    }

    @Override
    public DqRule getDqRule(int ruleId) {
        return (DqRule)this.dqRuleMapper.selectById((Serializable)Integer.valueOf(ruleId));
    }

    @Override
    public List<DqRuleInputEntry> getRuleInputEntry(int ruleId) {
        return DqRuleUtils.transformInputEntry((List)this.dqRuleInputEntryMapper.getRuleInputEntryList(Integer.valueOf(ruleId)));
    }

    @Override
    public List<DqRuleExecuteSql> getDqExecuteSql(int ruleId) {
        return this.dqRuleExecuteSqlMapper.getExecuteSqlList(Integer.valueOf(ruleId));
    }

    @Override
    public DqComparisonType getComparisonTypeById(int id) {
        return (DqComparisonType)this.dqComparisonTypeMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public boolean acquireTaskGroup(int taskInstanceId, String taskName, int taskGroupId, int workflowInstanceId, int taskGroupPriority) {
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(taskGroupId));
        if (taskGroup == null) {
            log.warn("The taskGroup is not exist no need to acquire taskGroup, taskGroupId: {}", (Object)taskGroupId);
            return true;
        }
        if (taskGroup.getStatus().intValue() == Flag.NO.getCode()) {
            log.warn("The taskGroup status is {}, no need to acquire taskGroup, taskGroupId: {}", (Object)taskGroup.getStatus(), (Object)taskGroupId);
            return true;
        }
        TaskGroupQueue taskGroupQueue = this.taskGroupQueueMapper.queryByTaskId(taskInstanceId);
        if (taskGroupQueue == null) {
            taskGroupQueue = this.insertIntoTaskGroupQueue(taskInstanceId, taskName, taskGroupId, workflowInstanceId, taskGroupPriority, TaskGroupQueueStatus.WAIT_QUEUE);
            log.info("Insert TaskGroupQueue: {} successfully", (Object)taskGroupQueue.getId());
        } else {
            log.info("The task queue is already exist, taskId: {}", (Object)taskInstanceId);
            if (taskGroupQueue.getStatus() == TaskGroupQueueStatus.ACQUIRE_SUCCESS) {
                return true;
            }
        }
        List highPriorityTasks = this.taskGroupQueueMapper.queryHighPriorityTasks(taskGroupId, taskGroupPriority, TaskGroupQueueStatus.WAIT_QUEUE.getCode());
        if (CollectionUtils.isNotEmpty((Collection)highPriorityTasks)) {
            return false;
        }
        int availableTaskGroupCount = this.taskGroupMapper.selectAvailableCountById(taskGroupId);
        if (availableTaskGroupCount < 1) {
            log.info("Failed to acquire taskGroup, there is no avaliable taskGroup, taskInstanceId: {}, taskGroupId: {}", (Object)taskInstanceId, (Object)taskGroupId);
            this.taskGroupQueueMapper.updateInQueue(Flag.NO.getCode(), taskGroupQueue.getId().intValue());
            return false;
        }
        return this.robTaskGroupResource(taskGroupQueue);
    }

    @Override
    public boolean robTaskGroupResource(TaskGroupQueue taskGroupQueue) {
        for (int i = 0; i < 10; ++i) {
            TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(taskGroupQueue.getGroupId()));
            if (taskGroup.getGroupSize() <= taskGroup.getUseSize()) {
                this.taskGroupQueueMapper.updateInQueue(Flag.NO.getCode(), taskGroupQueue.getId().intValue());
                log.info("The current task Group is full, taskGroup: {}", (Object)taskGroup);
                return false;
            }
            int affectedCount = this.taskGroupMapper.robTaskGroupResource(taskGroup.getId().intValue(), taskGroup.getUseSize(), taskGroupQueue.getId().intValue(), TaskGroupQueueStatus.WAIT_QUEUE.getCode());
            if (affectedCount <= 0) continue;
            log.info("Success rob taskGroup, taskInstanceId: {}, taskGroupId: {}", (Object)taskGroupQueue.getTaskId(), (Object)taskGroupQueue.getId());
            taskGroupQueue.setStatus(TaskGroupQueueStatus.ACQUIRE_SUCCESS);
            this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
            this.taskGroupQueueMapper.updateInQueue(Flag.NO.getCode(), taskGroupQueue.getId().intValue());
            return true;
        }
        log.info("Failed to rob taskGroup, taskGroupQueue: {}", (Object)taskGroupQueue);
        this.taskGroupQueueMapper.updateInQueue(Flag.NO.getCode(), taskGroupQueue.getId().intValue());
        return false;
    }

    @Override
    public void releaseAllTaskGroup(int processInstanceId) {
        List taskInstances = this.taskInstanceMapper.loadAllInfosNoRelease(processInstanceId, TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode());
        for (TaskInstance info : taskInstances) {
            this.releaseTaskGroup(info);
        }
    }

    @Override
    public TaskInstance releaseTaskGroup(TaskInstance taskInstance) {
        TaskGroupQueue taskGroupQueue;
        TaskGroup taskGroup;
        log.info("Begin to release task group: {}", (Object)taskInstance.getTaskGroupId());
        try {
            TaskGroupQueue thisTaskGroupQueue;
            do {
                if ((taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(taskInstance.getTaskGroupId()))) == null) {
                    log.error("The taskGroup is not exist no need to release taskGroup, taskGroupId: {}", (Object)taskInstance.getTaskGroupId());
                    return null;
                }
                thisTaskGroupQueue = this.taskGroupQueueMapper.queryByTaskId(taskInstance.getId().intValue());
                if (thisTaskGroupQueue.getStatus() == TaskGroupQueueStatus.RELEASE) {
                    log.info("The taskGroupQueue's status is release, taskInstanceId: {}", (Object)taskInstance.getId());
                    return null;
                }
                if (thisTaskGroupQueue.getStatus() != TaskGroupQueueStatus.WAIT_QUEUE) continue;
                log.info("The taskGroupQueue's status is in waiting, will not need to release task group");
                break;
            } while (thisTaskGroupQueue.getForceStart() == Flag.NO.getCode() && this.taskGroupMapper.releaseTaskGroupResource(taskGroup.getId().intValue(), taskGroup.getUseSize(), thisTaskGroupQueue.getId().intValue(), TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode()) != 1);
        }
        catch (Exception e) {
            log.error("release the task group error", (Throwable)e);
            return null;
        }
        log.info("Finished to release task group, taskGroupId: {}", (Object)taskInstance.getTaskGroupId());
        log.info("Begin to release task group queue, taskGroupId: {}", (Object)taskInstance.getTaskGroupId());
        this.changeTaskGroupQueueStatus(taskInstance.getId(), TaskGroupQueueStatus.RELEASE);
        do {
            if ((taskGroupQueue = this.taskGroupQueueMapper.queryTheHighestPriorityTasks(taskGroup.getId().intValue(), TaskGroupQueueStatus.WAIT_QUEUE.getCode(), Flag.NO.getCode(), Flag.NO.getCode())) != null) continue;
            log.info("There is no taskGroupQueue need to be wakeup taskGroup: {}", (Object)taskGroup.getId());
            return null;
        } while (this.taskGroupQueueMapper.updateInQueueCAS(Flag.NO.getCode(), Flag.YES.getCode(), taskGroupQueue.getId().intValue()) != 1);
        log.info("Finished to release task group queue: taskGroupId: {}, taskGroupQueueId: {}", (Object)taskInstance.getTaskGroupId(), (Object)taskGroupQueue.getId());
        return (TaskInstance)this.taskInstanceMapper.selectById((Serializable)Integer.valueOf(taskGroupQueue.getTaskId()));
    }

    @Override
    public void changeTaskGroupQueueStatus(int taskId, TaskGroupQueueStatus status) {
        TaskGroupQueue taskGroupQueue = this.taskGroupQueueMapper.queryByTaskId(taskId);
        taskGroupQueue.setInQueue(Flag.NO.getCode());
        taskGroupQueue.setStatus(status);
        taskGroupQueue.setUpdateTime(new Date(System.currentTimeMillis()));
        this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
    }

    @Override
    public TaskGroupQueue insertIntoTaskGroupQueue(Integer taskInstanceId, String taskName, Integer taskGroupId, Integer workflowInstanceId, Integer taskGroupPriority, TaskGroupQueueStatus status) {
        Date now = new Date();
        TaskGroupQueue taskGroupQueue = TaskGroupQueue.builder().taskId(taskInstanceId.intValue()).taskName(taskName).groupId(taskGroupId.intValue()).processId(workflowInstanceId.intValue()).priority(taskGroupPriority.intValue()).status(status).forceStart(Flag.NO.getCode()).inQueue(Flag.NO.getCode()).createTime(now).updateTime(now).build();
        this.taskGroupQueueMapper.insert((Object)taskGroupQueue);
        return taskGroupQueue;
    }

    @Override
    public int updateTaskGroupQueueStatus(Integer taskId, int status) {
        return this.taskGroupQueueMapper.updateStatusByTaskId(taskId.intValue(), status);
    }

    @Override
    public int updateTaskGroupQueue(TaskGroupQueue taskGroupQueue) {
        return this.taskGroupQueueMapper.updateById((Object)taskGroupQueue);
    }

    @Override
    public TaskGroupQueue loadTaskGroupQueue(int taskId) {
        return this.taskGroupQueueMapper.queryByTaskId(taskId);
    }

    @Override
    public ProcessInstance loadNextProcess4Serial(long code, int state, int id) {
        return this.processInstanceMapper.loadNextProcess4Serial(Long.valueOf(code), state, id);
    }

    protected void deleteCommandWithCheck(int commandId) {
        int delete = this.commandMapper.deleteById((Serializable)Integer.valueOf(commandId));
        if (delete != 1) {
            throw new ServiceException("delete command fail, id:" + commandId);
        }
    }

    @Override
    public String findConfigYamlByName(String clusterName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            return null;
        }
        QueryWrapper nodeWrapper = new QueryWrapper();
        nodeWrapper.eq((Object)"name", (Object)clusterName);
        Cluster cluster = (Cluster)this.clusterMapper.selectOne((Wrapper)nodeWrapper);
        return cluster == null ? null : ClusterConfUtils.getK8sConfig(cluster.getConfig());
    }

    @Override
    public void forceProcessInstanceSuccessByTaskInstanceId(Integer taskInstanceId) {
        List failTaskList;
        List<ProcessTaskRelation> taskRelations;
        List taskDefinitionLogs;
        List definiteTaskCodeList;
        List validTaskList;
        List instanceTaskCodeList;
        TaskInstance task = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (task == null) {
            return;
        }
        ProcessInstance processInstance = this.findProcessInstanceDetailById(task.getProcessInstanceId()).orElse(null);
        if (processInstance != null && (processInstance.getState().isFailure() || processInstance.getState().isStop()) && CollectionUtils.isEqualCollection(instanceTaskCodeList = (validTaskList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(processInstance.getId(), processInstance.getTestFlag())).stream().map(TaskInstance::getTaskCode).collect(Collectors.toList()), definiteTaskCodeList = (taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelations = this.findRelationByCode(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion()))).stream().filter(definitionLog -> definitionLog.getFlag() == Flag.YES).map(TaskDefinition::getCode).collect(Collectors.toList())) && (failTaskList = validTaskList.stream().filter(instance -> instance.getState().isFailure() || instance.getState().isKill()).map(TaskInstance::getId).collect(Collectors.toList())).size() == 1 && failTaskList.contains(taskInstanceId)) {
            processInstance.setStateWithDesc(WorkflowExecutionStatus.SUCCESS, "success by task force success");
            this.processInstanceDao.updateById((Object)processInstance);
        }
    }

    @Override
    public void saveCommandTrigger(Integer commandId, Integer processInstanceId) {
        this.triggerRelationService.saveCommandTrigger(commandId, processInstanceId);
    }

    private Map<String, Object> createCommandParams(ProcessInstance processInstance) {
        Map commandMap = (Map)JSONUtils.parseObject((String)processInstance.getCommandParam(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        HashMap<String, Object> recoverFailoverCommandParams = new HashMap<String, Object>();
        Optional.ofNullable(MapUtils.getObject((Map)commandMap, (Object)"StartParams")).ifPresent(startParams -> recoverFailoverCommandParams.put("StartParams", startParams));
        recoverFailoverCommandParams.put("ProcessInstanceId", processInstance.getId());
        return recoverFailoverCommandParams;
    }
}

