/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;

public class ParamUtils {
    public static Map<String, String> getGlobalParamMap(String globalParams) {
        Map<String, String> globalParamMap = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)globalParams)) {
            List propList = JSONUtils.toList((String)globalParams, Property.class);
            globalParamMap = propList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        }
        return globalParamMap;
    }

    public static String getSubWorkFlowParam(ProcessInstanceMap instanceMap, ProcessInstance parentProcessInstance, Map<String, String> fatherParams) {
        String processMapStr = JSONUtils.toJsonString((Object)instanceMap);
        Map cmdParam = JSONUtils.toMap((String)processMapStr);
        if (parentProcessInstance.isComplementData()) {
            Map parentParam = JSONUtils.toMap((String)parentProcessInstance.getCommandParam());
            String endTime = (String)parentParam.get("complementEndDate");
            String startTime = (String)parentParam.get("complementStartDate");
            String scheduleTime = (String)parentParam.get("complementScheduleDateList");
            if (StringUtils.isNotEmpty((CharSequence)startTime) && StringUtils.isNotEmpty((CharSequence)endTime)) {
                cmdParam.put("complementEndDate", endTime);
                cmdParam.put("complementStartDate", startTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)scheduleTime)) {
                cmdParam.put("complementScheduleDateList", scheduleTime);
            }
            processMapStr = JSONUtils.toJsonString((Object)cmdParam);
        }
        if (MapUtils.isNotEmpty(fatherParams)) {
            cmdParam.put("fatherParams", JSONUtils.toJsonString(fatherParams));
            processMapStr = JSONUtils.toJsonString((Object)cmdParam);
        }
        return processMapStr;
    }
}

